/*
 * Decompiled with CFR 0.152.
 */
package com.hmoney;

import java.text.SimpleDateFormat;
import java.util.Date;

public class Logger {
    private static final String TAG = Logger.class.getSimpleName();
    public static final int VERBOSE = 0;
    public static final int DEBUG = 1;
    public static final int INFO = 2;
    public static final int WARN = 3;
    public static final int ERROR = 4;
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd-HH:mm:ss.SSS");
    static int level = 2;

    public static String getLevelLabel() {
        switch (level) {
            case 0: {
                return "VERBOSE";
            }
            case 1: {
                return "DEBUG";
            }
            case 2: {
                return "INFO";
            }
            case 3: {
                return "WARN";
            }
            case 4: {
                return "ERROR";
            }
        }
        return "unknown level";
    }

    private static String getLevelVisual(int level) {
        switch (level) {
            case 0: {
                return "verbose- ";
            }
            case 1: {
                return "Debug--- ";
            }
            case 2: {
                return "INFO---- ";
            }
            case 3: {
                return "! WAR--- ";
            }
            case 4: {
                return "***ERR** ";
            }
        }
        return "unknown level";
    }

    public static void setLevel(int level) {
        Logger.level = level;
        Logger.info(TAG, "setLevel: new log level=" + Logger.getLevelLabel());
    }

    public static void verbose(String tag, String message) {
        Logger.log(0, tag, message);
    }

    public static void debug(String tag, String message) {
        Logger.log(1, tag, message);
    }

    public static void info(String tag, String message) {
        Logger.log(2, tag, message);
    }

    public static void warn(String tag, String message) {
        Logger.log(3, tag, message);
    }

    public static void error(String tag, String message) {
        Logger.log(4, tag, message);
    }

    private static void log(int l, String tag, String message) {
        if (level <= l) {
            System.out.println(String.valueOf(sdf.format(new Date())) + " " + Logger.getLevelVisual(l) + tag + ": " + message);
        }
    }

    public static void printStackTrace(int level) {
        StackTraceElement[] l_steArr = Thread.currentThread().getStackTrace();
        int i = 2;
        while (i < l_steArr.length) {
            Logger.log(level, "STACKTRACE", "" + l_steArr[i]);
            ++i;
        }
    }
}

