/*
 * Decompiled with CFR 0.152.
 */
package com.hmoney.gui;

import com.hmoney.Logger;
import com.hmoney.data.AItem;
import com.hmoney.data.Account;
import com.hmoney.data.Util;
import com.hmoney.gui.DisplayedAccount;
import com.hmoney.gui.GuiUtil;
import com.hmoney.gui.IKeyboardListener;
import com.hmoney.gui.MainWindow;
import com.hmoney.messages.Messages;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Date;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class AItemTable
extends JTable
implements ComponentListener,
IKeyboardListener {
    private static final String TAG = AItemTable.class.getSimpleName();
    private static final long serialVersionUID = 1969L;
    private static AbstractTableModel tableModel = null;
    public static final int COLUMN_INDEX_NUM = 0;
    public static final int COLUMN_INDEX_CR = 1;
    public static final int COLUMN_INDEX_DATE = 2;
    public static final int COLUMN_INDEX_CATEGORY = 3;
    public static final int COLUMN_INDEX_PAYEE = 4;
    public static final int COLUMN_INDEX_MEMO = 5;
    public static final int COLUMN_INDEX_AMOUNT = 6;
    public static final int COLUMN_INDEX_BALANCE = 7;
    public static final int ROW_HEIGHT = 28;
    int lastRow = -1;
    int lastColumn = -1;
    static String[] columnNames = new String[8];
    boolean[] columnSortOrder = new boolean[]{true, true, true, true, true, true, true, true};
    int[] columnWidth = new int[]{5, 2, 7, 18, 34, 18, 8, 8};
    int selectedColumn = 2;

    static {
        AItemTable.columnNames[0] = Messages.getString("columnNamesAccount_1");
        AItemTable.columnNames[1] = Messages.getString("columnNamesAccount_2");
        AItemTable.columnNames[2] = Messages.getString("columnNamesAccount_3");
        AItemTable.columnNames[3] = Messages.getString("columnNamesAccount_4");
        AItemTable.columnNames[4] = Messages.getString("columnNamesAccount_5");
        AItemTable.columnNames[5] = Messages.getString("columnNamesAccount_6");
        AItemTable.columnNames[6] = Messages.getString("columnNamesAccount_7");
        AItemTable.columnNames[7] = Messages.getString("columnNamesAccount_8");
    }

    public AItemTable() {
        this.setRowHeight(28);
    }

    @Override
    public void escapeKeyTyped() {
        if (this.isEditing()) {
            this.getCellEditor().cancelCellEditing();
        }
    }

    @Override
    public void enterKeyTyped() {
        if (this.isEditing()) {
            this.getCellEditor().stopCellEditing();
        }
    }

    @Override
    public void deleteKeyTyped() {
        int l_row = MainWindow.aItemTable.getSelectedRow();
        if (l_row < 0 || this.isEditing()) {
            return;
        }
        this.removeRow(l_row, true);
    }

    public boolean removeRow(int row, boolean confirmRemove) {
        int l_res;
        if (confirmRemove && (l_res = JOptionPane.showConfirmDialog(null, "SVP confirmez la suppression de l'operation s\u00e9lectionn\u00e9e", "", 2)) != 0) {
            return false;
        }
        DisplayedAccount.getDisplayedAccount().removeItem(row);
        DisplayedAccount.getDisplayedAccount().calculateBalance();
        MainWindow.aItemTable.getTableModel().fireTableRowsDeleted(row, row);
        MainWindow.itemsMainPanel.updateGraph();
        this.lastRow = -1;
        this.lastColumn = -1;
        return true;
    }

    public AbstractTableModel getTableModel() {
        return tableModel;
    }

    public void resetColumnSortOrder() {
        int i = 0;
        while (i < this.columnSortOrder.length) {
            this.columnSortOrder[i] = true;
            ++i;
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        boolean l_res = false;
        switch (col) {
            case 4: {
                if (!DisplayedAccount.getDisplayedAccount().getItem(row).isUserValidated()) {
                    l_res = true;
                    break;
                }
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                if (this.lastRow == row && this.lastColumn == col) {
                    l_res = true;
                    break;
                }
            }
            default: {
                l_res = false;
            }
        }
        this.lastRow = row;
        this.lastColumn = col;
        Logger.debug(TAG, "isCellEditable: returns " + l_res);
        return l_res;
    }

    @Override
    public void setModel(TableModel tableModel) {
        super.setModel(tableModel);
        this.lastRow = -1;
        this.lastColumn = -1;
    }

    public AbstractTableModel getNewCustomTableModel() {
        tableModel = new AbstractTableModel(){

            @Override
            public Object getValueAt(int row, int col) {
                AItem l_rowAItem = DisplayedAccount.getDisplayedAccount().getItem(row);
                switch (col) {
                    case 0: {
                        return l_rowAItem.getNum();
                    }
                    case 1: {
                        return l_rowAItem.isReconciled() ? Messages.getString("OperationReconciledValue") : (l_rowAItem.isCleared() ? Messages.getString("OperationClearedValue") : "");
                    }
                    case 2: {
                        return Util.getSimpleDateFormatter().format(l_rowAItem.getDate());
                    }
                    case 3: {
                        return Util.getUserFriendlyCategoryString(l_rowAItem.getCategory());
                    }
                    case 4: {
                        return l_rowAItem.getPayee();
                    }
                    case 5: {
                        return l_rowAItem.getMemo();
                    }
                    case 6: {
                        return l_rowAItem.getAmountString();
                    }
                    case 7: {
                        if (!DisplayedAccount.getDisplayedAccount().balanceEnabled) {
                            return "N/A";
                        }
                        return l_rowAItem.getBalanceString();
                    }
                }
                return "";
            }

            @Override
            public int getRowCount() {
                if (DisplayedAccount.getDisplayedAccount() == null) {
                    return 0;
                }
                return DisplayedAccount.getDisplayedAccount().getItemListSize();
            }

            @Override
            public int getColumnCount() {
                return columnNames.length;
            }

            @Override
            public String getColumnName(int col) {
                return columnNames[col];
            }

            public Class getColumnClass(int col) {
                return String.class;
            }

            @Override
            public void setValueAt(Object value, int row, int col) {
                Logger.debug(TAG, "TableModel.setValueAt: row=" + row + ", col=" + col + ", value=" + value);
                String l_oldValue = (String)this.getValueAt(row, col);
                if (Util.safeEquals(l_oldValue, value)) {
                    Logger.verbose(TAG, "TableModel.setValueAt: row=" + row + ", col=" + col + ", value=" + value + "  !! SAME INPUT VALUE AS MODEL DETECTED !! ");
                    return;
                }
                AItem l_rowAItem = DisplayedAccount.getDisplayedAccount().getItem(row);
                switch (col) {
                    case 0: {
                        DisplayedAccount.getDisplayedAccount().getItem(row).setNum((String)value);
                        break;
                    }
                    case 1: {
                        if (value == null) {
                            l_rowAItem.setCleared(false);
                            l_rowAItem.setReconciled(false);
                            break;
                        }
                        if (value.equals(Messages.getString("OperationClearedValue"))) {
                            l_rowAItem.setCleared(true);
                            l_rowAItem.setReconciled(false);
                            break;
                        }
                        if (value != Messages.getString("OperationReconciledValue")) break;
                        l_rowAItem.setCleared(false);
                        l_rowAItem.setReconciled(true);
                        break;
                    }
                    case 2: {
                        try {
                            Date l_nd = Util.parseDate((String)value, Util.getDateDayFirst());
                            l_rowAItem.setDate(l_nd);
                        }
                        catch (Exception l_nd) {}
                        break;
                    }
                    case 3: {
                        l_rowAItem.setCategory((String)value, DisplayedAccount.getDisplayedAccount());
                        break;
                    }
                    case 4: {
                        l_rowAItem.setPayee((String)value);
                        break;
                    }
                    case 5: {
                        l_rowAItem.setMemo((String)value);
                        break;
                    }
                    case 6: {
                        try {
                            long l_amount = Util.stringAmountToLong((String)value);
                            l_rowAItem.setLongAmount(l_amount);
                            DisplayedAccount.getDisplayedAccount().calculateBalance();
                            break;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                AItemTable.this.updateViewPort(l_rowAItem, col);
                MainWindow.itemsMainPanel.updateGraph();
            }
        };
        return tableModel;
    }

    public void updateViewPort(AItem aItem, int col) {
        this.lastRow = this.getSelectedRow();
        this.lastColumn = this.getSelectedColumn();
        if (col == this.selectedColumn || col == 6) {
            this.clickOnColumnHeader(this.selectedColumn, DisplayedAccount.getDisplayedAccount(), false);
        }
        int l_rowSel = DisplayedAccount.getDisplayedAccount().indexOf(aItem);
        GuiUtil.showTableElementInViewPort(this, l_rowSel, col);
    }

    public void clickOnColumnHeader(int col, Account account, boolean invertOrder) {
        Logger.verbose(TAG, "clickOnColumnHeader: col=" + col);
        if (invertOrder && this.selectedColumn == col) {
            this.columnSortOrder[this.selectedColumn] = !this.columnSortOrder[this.selectedColumn];
        }
        this.selectedColumn = col;
        account.calculateBalance();
        switch (this.selectedColumn) {
            case 0: {
                account.sort(4, this.columnSortOrder[this.selectedColumn]);
                break;
            }
            case 1: {
                account.sort(7, this.columnSortOrder[this.selectedColumn]);
                break;
            }
            case 2: {
                account.sort(0, this.columnSortOrder[this.selectedColumn]);
                break;
            }
            case 3: {
                account.sort(2, this.columnSortOrder[this.selectedColumn]);
                break;
            }
            case 4: {
                account.sort(1, this.columnSortOrder[this.selectedColumn]);
                break;
            }
            case 5: {
                account.sort(6, this.columnSortOrder[this.selectedColumn]);
                break;
            }
            case 6: {
                account.sort(3, this.columnSortOrder[this.selectedColumn]);
                break;
            }
            case 7: {
                account.sort(5, this.columnSortOrder[this.selectedColumn]);
            }
        }
        JTableHeader th = this.getTableHeader();
        TableColumnModel tcm = th.getColumnModel();
        int i = 0;
        while (i < columnNames.length) {
            TableColumn tc = tcm.getColumn(i);
            if (this.selectedColumn == i) {
                tc.setHeaderValue(String.valueOf(columnNames[i]) + (this.columnSortOrder[this.selectedColumn] ? " \u25bc" : " \u25b2"));
            } else {
                tc.setHeaderValue(columnNames[i]);
            }
            ++i;
        }
        th.repaint();
        this.getTableModel().fireTableDataChanged();
    }

    public void setColWidth(int availableWidth) {
        TableColumn column = null;
        int i = 0;
        while (i < columnNames.length) {
            column = this.getColumnModel().getColumn(i);
            column.setPreferredWidth(availableWidth * this.columnWidth[i] / 100);
            ++i;
        }
        MainWindow.adjustColumnWidth();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.setColWidth(this.getWidth());
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }
}

