/*
 * Decompiled with CFR 0.152.
 */
package com.hmoney.gui;

import com.hmoney.Logger;
import com.hmoney.data.AItem;
import com.hmoney.data.APlannedItem;
import com.hmoney.data.Util;
import com.hmoney.gui.Constants;
import com.hmoney.gui.DisplayedAccount;
import com.hmoney.gui.MainWindow;
import com.hmoney.messages.Messages;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public class AItemTableCellRenderer
extends JLabel
implements TableCellRenderer {
    private static final String TAG = AItemTableCellRenderer.class.getSimpleName();
    private static final long serialVersionUID = 1969L;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        Color theForeground = Constants.tableFontColor;
        Color theBackground = Color.white;
        if (row % 2 > 0) {
            theBackground = Constants.oddRowColor;
        }
        AItem l_rowAItem = DisplayedAccount.getDisplayedAccount().getItem(row);
        if (isSelected) {
            theBackground = Constants.selectedRowBgColor;
            this.setFont(Constants.tableFontBold);
        } else {
            this.setFont(l_rowAItem.isUserValidated() && l_rowAItem.dup == null ? Constants.tableFont : Constants.tableFontBold);
        }
        this.setOpaque(true);
        this.setBackground(theBackground);
        this.setForeground(theForeground);
        if (hasFocus) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        } else {
            this.setBorder(new EmptyBorder(1, 2, 1, 2));
        }
        if (l_rowAItem.dup != null && MainWindow.aItemTable.getRowHeight(row) != 100) {
            Logger.debug(TAG, "getTableCellRendererComponent() : setting row height to 100");
            MainWindow.aItemTable.setRowHeight(row, 100);
        } else if (!l_rowAItem.isUserValidated() && MainWindow.aItemTable.getRowHeight(row) != 70) {
            Logger.debug(TAG, "getTableCellRendererComponent() : setting row height to 70");
            MainWindow.aItemTable.setRowHeight(row, 70);
        } else if (l_rowAItem.isUserValidated() && l_rowAItem.dup == null && MainWindow.aItemTable.getRowHeight(row) != 28) {
            Logger.debug(TAG, "getTableCellRendererComponent() : setting row height to 22");
            MainWindow.aItemTable.setRowHeight(row, 28);
        }
        String l_toolTipText = "";
        this.setVerticalAlignment(1);
        switch (col) {
            case 0: {
                String l_text = Util.stringNotNull(l_rowAItem.getNum());
                if (l_rowAItem.dup != null) {
                    l_text = "<html>" + l_text + "<br><br><font color=\"blue\">" + Util.stringNotNull(l_rowAItem.dup.getNum()) + "</font></html>";
                }
                this.setText(l_text);
                this.setHorizontalAlignment(2);
                if (!hasFocus) break;
                this.setBackground(Constants.selectedCellBgColor);
                l_toolTipText = l_rowAItem.getNum();
                break;
            }
            case 1: {
                if (l_rowAItem.isReconciled()) {
                    this.setBackground(Constants.reconciledBgColor);
                    this.setText("<html><b>" + Messages.getString("OperationReconciledValue") + "</b></html>");
                    l_toolTipText = "Op\u00e9ration rapproch\u00e9e";
                } else if (l_rowAItem.isCleared()) {
                    this.setBackground(Constants.clearedBgColor);
                    this.setText(Messages.getString("OperationClearedValue"));
                    l_toolTipText = "Op\u00e9ration point\u00e9e";
                } else if (l_rowAItem.isEImport()) {
                    this.setBackground(Constants.noCRBgColor);
                    this.setText(Messages.getString("OperationEImportedValue"));
                    l_toolTipText = "Op\u00e9ration import\u00e9e";
                } else {
                    this.setBackground(Constants.noCRBgColor);
                    this.setText("");
                    l_toolTipText = "Op\u00e9ration non rapproch\u00e9e";
                }
                this.setHorizontalAlignment(0);
                if (!hasFocus) break;
                this.setBackground(Constants.selectedCellBgColor);
                break;
            }
            case 2: {
                String l_text = Util.getSimpleDateFormatter().format(l_rowAItem.getDate());
                if (l_rowAItem.dup != null) {
                    l_text = "<html>" + l_text + "<br><br><font color=\"blue\">" + Util.getSimpleDateFormatter().format(l_rowAItem.dup.getDate()) + "</font></html>";
                }
                this.setText(l_text);
                this.setHorizontalAlignment(0);
                if (hasFocus) {
                    this.setBackground(Constants.selectedCellBgColor);
                }
                l_toolTipText = "<html>Click gauche pour \u00e9diter<br><b>Click droit pour le menu</b></html>";
                break;
            }
            case 3: {
                String l_text = Util.stringNotNull(Util.getUserFriendlyCategoryString(l_rowAItem.getCategory()));
                if (l_rowAItem.dup != null) {
                    l_text = "<html>" + l_text + "<br><br><font color=\"blue\">" + Util.stringNotNull(Util.getUserFriendlyCategoryString(l_rowAItem.dup.getCategory())) + "</font></html>";
                } else if (!l_rowAItem.isUserValidated()) {
                    this.setForeground(Color.blue);
                }
                this.setText(l_text);
                this.setHorizontalAlignment(2);
                if (hasFocus) {
                    this.setBackground(Constants.selectedCellBgColor);
                }
                l_toolTipText = "<html>Click gauche pour \u00e9diter<br><b>Click droit pour le menu</b></html>";
                break;
            }
            case 4: {
                List<APlannedItem> l_pil;
                String l_text = Util.stringNotNull(l_rowAItem.getPayee());
                if (l_rowAItem.dup != null) {
                    l_text = "<html>" + l_text + "<br><br>";
                    l_text = String.valueOf(l_text) + "<font color=\"blue\">" + Util.stringNotNull(l_rowAItem.dup.getPayee()) + "</font>";
                    l_text = String.valueOf(l_text) + "<br><br>Probablement <font color=\"blue\">un doublon</font> d'une op\u00e9ration existante <br>&#9658; </font>&nbsp;&nbsp;&nbsp; <font color=\"#666666\">Garder existant / Garder t\u00e9l\u00e9chargement / Ne pas fusionner </font></html>";
                } else if (!l_rowAItem.isUserValidated()) {
                    l_text = "<html>" + l_text + "<br><br>";
                    l_text = String.valueOf(l_text) + "<font color=\"blue\">Op\u00e9ration t\u00e9l\u00e9charg\u00e9e &#9658; </font>&nbsp;&nbsp;&nbsp; <font color=\"#666666\">Accepter / Supprimer </font></html>";
                }
                if (!l_rowAItem.isReconciliatedWithPlanned() && (l_pil = APlannedItem.getNextOccurencesOnAccount(DisplayedAccount.getDisplayedAccount().accountName, l_rowAItem.getLongAmount(), l_rowAItem.getDate())).size() > 0) {
                    this.setForeground(Constants.plannedTableFontColor);
                }
                this.setText(l_text);
                this.setHorizontalAlignment(2);
                if (hasFocus) {
                    this.setBackground(Constants.selectedCellBgColor);
                }
                l_toolTipText = "<html>Click gauche pour \u00e9diter<br><b>Click droit pour le menu</b></html>";
                break;
            }
            case 5: {
                String l_text = Util.stringNotNull(l_rowAItem.getMemo());
                if (l_rowAItem.dup != null) {
                    l_text = "<html>" + l_text + "<br><br><font color=\"blue\">" + Util.stringNotNull(l_rowAItem.dup.getMemo()) + "</font></html>";
                }
                this.setText(l_text);
                this.setHorizontalAlignment(2);
                if (!hasFocus) break;
                this.setBackground(Constants.selectedCellBgColor);
                l_toolTipText = "Click gauche pour \u00e9diter";
                break;
            }
            case 6: {
                if (l_rowAItem.isNegativeAmount()) {
                    this.setForeground(Constants.darkRedColor);
                } else {
                    this.setForeground(Constants.darkGreenColor);
                }
                String l_text = l_rowAItem.getAmountString();
                if (l_rowAItem.dup != null) {
                    l_text = "<html>" + l_text + "<br><br><font color=\"blue\">" + l_rowAItem.dup.getAmountString() + "</font></html>";
                }
                this.setText(l_text);
                this.setHorizontalAlignment(4);
                if (!hasFocus) break;
                this.setBackground(Constants.selectedCellBgColor);
                l_toolTipText = "Click gauche pour \u00e9diter";
                break;
            }
            case 7: {
                if (!DisplayedAccount.getDisplayedAccount().balanceEnabled) {
                    this.setText("N/A");
                } else {
                    if (l_rowAItem.isNegativeBalance()) {
                        this.setForeground(Constants.darkRedColor);
                    } else {
                        this.setForeground(Constants.darkGreenColor);
                    }
                    String l_text = l_rowAItem.getBalanceString();
                    if (l_rowAItem.dup != null) {
                        l_text = "<html>" + l_text + "<br><br><font color=\"blue\">" + Util.longAmountToString(l_rowAItem.getLongBalance() + l_rowAItem.dup.getLongAmount() - l_rowAItem.getLongAmount()) + "</font></html>";
                    }
                    this.setText(l_text);
                }
                this.setHorizontalAlignment(4);
                if (!hasFocus) break;
                this.setBackground(Constants.selectedCellBgColor);
            }
        }
        this.setToolTipText(l_toolTipText);
        return this;
    }
}

