/*
 * Decompiled with CFR 0.152.
 */
package com.hmoney.gui;

import com.hmoney.data.APlannedItem;
import com.hmoney.data.Util;
import com.hmoney.gui.Constants;
import com.hmoney.gui.MainWindow;
import java.awt.Color;
import java.awt.Component;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public class APlannedItemTableCellRenderer
extends JLabel
implements TableCellRenderer {
    private static final String TAG = APlannedItemTableCellRenderer.class.getSimpleName();
    private static final long serialVersionUID = 1969L;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        Color theForeground = Constants.plannedTableFontColor;
        Color theBackground = Color.white;
        if (row % 2 > 0) {
            theBackground = Constants.plannedOddRowColor;
        }
        APlannedItem l_rowAPlannedItem = APlannedItem.getItem(row);
        Date l_nowDate = new Date();
        if (isSelected) {
            theBackground = Constants.selectedRowBgColor;
            this.setFont(Constants.tableFontBold);
        } else {
            this.setFont(l_rowAPlannedItem.isUserValidated() ? Constants.tableFont : Constants.tableFontBold);
        }
        this.setOpaque(true);
        this.setBackground(theBackground);
        this.setForeground(theForeground);
        if (hasFocus) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        } else {
            this.setBorder(new EmptyBorder(1, 2, 1, 2));
        }
        int l_LateOccurencesCountAtDate = l_rowAPlannedItem.getLateOccurencesCountAtDate(l_nowDate);
        if (l_LateOccurencesCountAtDate > 0 && MainWindow.aPlannedItemTable.getRowHeight(row) != 34) {
            MainWindow.aPlannedItemTable.setRowHeight(row, 34);
        } else if (l_LateOccurencesCountAtDate <= 0 && MainWindow.aPlannedItemTable.getRowHeight(row) != 22) {
            MainWindow.aPlannedItemTable.setRowHeight(row, 22);
        }
        String l_toolTipText = "";
        this.setVerticalAlignment(1);
        switch (col) {
            case 0: {
                if (l_LateOccurencesCountAtDate > 0) {
                    String l_text = "<html>" + Util.stringNotNull(l_rowAPlannedItem.getPayee()) + "<br>";
                    String l_j = "jour" + (l_rowAPlannedItem.getAtDateLatenessInDays(l_nowDate) > 1 ? "s" : "");
                    String l_o = "occurence" + (l_LateOccurencesCountAtDate > 1 ? "s" : "");
                    l_text = String.valueOf(l_text) + "<font color=\"red\">Cette op\u00e9ration a " + l_rowAPlannedItem.getAtDateLatenessInDays(l_nowDate) + " " + l_j + " de retard (" + l_LateOccurencesCountAtDate + " " + l_o + ")</font></html>";
                    this.setText(l_text);
                } else {
                    this.setText(Util.stringNotNull(l_rowAPlannedItem.getPayee()));
                }
                this.setHorizontalAlignment(2);
                if (hasFocus) {
                    this.setBackground(Constants.selectedCellBgColor);
                }
                l_toolTipText = "<html>Click gauche pour \u00e9diter<br><b>Click droit pour le menu</b></html>";
                break;
            }
            case 1: {
                String l_text = Util.stringNotNull(l_rowAPlannedItem.getAccountName());
                this.setText(l_text);
                this.setHorizontalAlignment(2);
                if (!hasFocus) break;
                this.setBackground(Constants.selectedCellBgColor);
                l_toolTipText = l_rowAPlannedItem.getNum();
                break;
            }
            case 2: {
                String l_text = Util.getSimpleDateFormatter().format(l_rowAPlannedItem.getDate());
                this.setText(l_text);
                this.setHorizontalAlignment(0);
                if (hasFocus) {
                    this.setBackground(Constants.selectedCellBgColor);
                }
                l_toolTipText = "<html>Click gauche pour \u00e9diter<br><b>Click droit pour le menu</b></html>";
                break;
            }
            case 3: {
                String l_text = APlannedItem.getPeriodicityLabel(l_rowAPlannedItem.getPeriodicity());
                this.setText(l_text);
                this.setHorizontalAlignment(0);
                if (hasFocus) {
                    this.setBackground(Constants.selectedCellBgColor);
                }
                l_toolTipText = "<html>Click gauche pour \u00e9diter<br><b>Click droit pour le menu</b></html>";
                break;
            }
            case 4: {
                String l_text = Util.stringNotNull(Util.getUserFriendlyCategoryString(l_rowAPlannedItem.getCategory()));
                this.setText(l_text);
                this.setHorizontalAlignment(2);
                if (hasFocus) {
                    this.setBackground(Constants.selectedCellBgColor);
                }
                l_toolTipText = "<html>Click gauche pour \u00e9diter<br><b>Click droit pour le menu</b></html>";
                break;
            }
            case 5: {
                String l_text = Util.stringNotNull(l_rowAPlannedItem.getMemo());
                this.setText(l_text);
                this.setHorizontalAlignment(2);
                if (!hasFocus) break;
                this.setBackground(Constants.selectedCellBgColor);
                l_toolTipText = "Click gauche pour \u00e9diter";
                break;
            }
            case 6: {
                if (l_rowAPlannedItem.isNegativeAmount()) {
                    this.setForeground(Constants.darkRedColor);
                } else {
                    this.setForeground(Constants.darkGreenColor);
                }
                String l_text = l_rowAPlannedItem.getAmountString();
                this.setText(l_text);
                this.setHorizontalAlignment(4);
                if (!hasFocus) break;
                this.setBackground(Constants.selectedCellBgColor);
                l_toolTipText = "Click gauche pour \u00e9diter";
            }
        }
        this.setToolTipText(l_toolTipText);
        return this;
    }
}

