/*
 * Decompiled with CFR 0.152.
 */
package com.hmoney.gui;

import com.hmoney.Logger;
import com.hmoney.data.ACategory;
import com.hmoney.data.AItem;
import com.hmoney.data.APlannedItem;
import com.hmoney.data.Account;
import com.hmoney.data.DayAndMonthInvertedException;
import com.hmoney.data.OfxImport;
import com.hmoney.data.OfxSaxImporter;
import com.hmoney.data.QifImportExport;
import com.hmoney.data.Util;
import com.hmoney.gui.AItemTable;
import com.hmoney.gui.AItemTableCellEditor;
import com.hmoney.gui.AItemTableCellRenderer;
import com.hmoney.gui.APlannedItemTable;
import com.hmoney.gui.APlannedItemTableCellEditor;
import com.hmoney.gui.APlannedItemTableCellRenderer;
import com.hmoney.gui.AccountDialog;
import com.hmoney.gui.CategoriesDialog;
import com.hmoney.gui.Constants;
import com.hmoney.gui.DisplayedAccount;
import com.hmoney.gui.GuiUtil;
import com.hmoney.gui.HMFrameListener;
import com.hmoney.gui.ItemTablePopupListener;
import com.hmoney.gui.ItemsPanel;
import com.hmoney.gui.MenuManager;
import com.hmoney.gui.PlannedItemTablePopupListener;
import com.hmoney.gui.PlannedItemsPanel;
import com.hmoney.gui.SummaryHtmlPanel;
import com.hmoney.gui.custom.DateFormatCheckboxAccessory;
import com.hmoney.gui.custom.KeyboardMainListener;
import com.hmoney.gui.custom.Splash;
import com.hmoney.messages.Messages;
import com.hmoney.properties.HMProperties;
import com.hmoney.zip.Unzip;
import com.hmoney.zip.ZipMaker;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.ColorUIResource;

public class MainWindow {
    private static final String TAG = MainWindow.class.getSimpleName();
    private static JFrame frame;
    public static JPanel contentPanel;
    static SummaryHtmlPanel summaryHtmlPanel;
    static ItemsPanel itemsMainPanel;
    static PlannedItemsPanel plannedItemsMainPanel;
    protected static AItemTable aItemTable;
    protected static APlannedItemTable aPlannedItemTable;
    private static final Cursor waitCursor;
    private static final Cursor defaultCursor;
    private static final Font tableHeaderFont;
    static List<JMenuItem> accountMenuItems;
    protected static JMenuBar menuBar;
    protected static JMenu mnAccountsMenu;
    protected static JMenu mnAccountPropertiesMenu;
    protected static JMenu mnBillsGraphAccountsMenu;
    protected static int mnBillsGraphAccountsMenuAccountsIndexGap;
    protected static JCheckBoxMenuItem mn30DaysGraphMenu;
    protected static JCheckBoxMenuItem mn90DaysGraphMenu;
    protected static JCheckBoxMenuItem mn6MonthsGraphMenu;
    protected static JCheckBoxMenuItem mn1YearGraphMenu;
    protected static JMenu mnOptionsMenu;
    protected static JMenu selectStateLocationMenu;
    protected static JMenuItem newAccountMenuItem;
    protected static JMenuItem deleteAccountMenuItem;
    protected static JMenuItem qifFileImportMenuItem;
    protected static JMenuItem ofxFileImportMenuItem;
    protected static JMenuItem saveArchiveFileMenuItem;
    protected static JMenuItem loadArchiveFileMenuItem;
    protected static JMenu msMoneyMenu;
    protected static JMenuItem msMoneyImportMenuItem;
    protected static JMenuItem mnSave;
    protected static JMenuItem mntmExit;
    protected static JMenuItem mntmExitWithoutSaving;
    protected static JMenuItem mntmAdjustColWidth;
    protected static JMenuItem categoryDlgMenuItem;
    protected static JMenuItem markAllClearedMenuItem;
    protected static JMenuItem markAllValidatedMenuItem;
    protected static JMenuItem aboutMenuItem;
    protected static JMenuItem mntmSearchFull;
    protected static JMenuItem mntmClearSearch;
    protected static JMenuItem mntmCalc;
    protected static JMenuItem mntmPlannedItems;
    private static final int GRAPH_DAYS_30 = 30;
    private static final int GRAPH_DAYS_90 = 90;
    private static final int GRAPH_DAYS_182 = 182;
    private static final int GRAPH_DAYS_365 = 365;
    private static long lastAdjustColumnWidthTS;

    static {
        summaryHtmlPanel = null;
        plannedItemsMainPanel = null;
        waitCursor = new Cursor(3);
        defaultCursor = new Cursor(0);
        tableHeaderFont = new Font("Sans Serif", 1, 14);
        accountMenuItems = new ArrayList<JMenuItem>();
        mnBillsGraphAccountsMenuAccountsIndexGap = -100;
        lastAdjustColumnWidthTS = 0L;
    }

    public static void main(String[] args) {
        Logger.setLevel(1);
        try {
            Image image = GuiUtil.getImageIcon("splash.png").getImage();
            final Splash splash = new Splash(null, image);
            splash.setVisible(true);
            Timer timer = new Timer(2500, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    splash.setVisible(false);
                    splash.dispose();
                }
            });
            timer.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    MainWindow l_mainWindow = new MainWindow();
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static JFrame getFrame() {
        return frame;
    }

    public MainWindow() {
        HMProperties.loadProperties();
        Messages.init();
        try {
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
            int n = lookAndFeelInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
                if ("Nimbus".equals(info.getName())) {
                    UIManager.setLookAndFeel(info.getClassName());
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initialize();
    }

    private void initialize() {
        KeyboardMainListener.init();
        UIManager.put("ComboBox.selectionBackground", new ColorUIResource(Constants.selectedCellBgColor));
        UIManager.put("ComboBox.background", new ColorUIResource(Constants.oddRowColor));
        frame = new JFrame();
        frame.setBounds(HMProperties.getIntProperty("frame.left"), HMProperties.getIntProperty("frame.top"), HMProperties.getIntProperty("frame.width"), HMProperties.getIntProperty("frame.height"));
        frame.setDefaultCloseOperation(2);
        frame.getContentPane().setLayout(new BorderLayout(0, 0));
        frame.setIconImage(GuiUtil.getImageIcon("hmicon.png").getImage());
        frame.setTitle("HMoney - Gestion de comptes personnels - v. 1.1.3");
        frame.setExtendedState(HMProperties.getIntProperty("frame.state"));
        HMFrameListener l_frameListener = new HMFrameListener();
        frame.addWindowListener(l_frameListener);
        frame.addWindowStateListener(l_frameListener);
        frame.addComponentListener(l_frameListener);
        summaryHtmlPanel = new SummaryHtmlPanel(this);
        contentPanel = new JPanel();
        frame.getContentPane().add(contentPanel);
        contentPanel.setLayout(new BorderLayout(0, 0));
        contentPanel.add(summaryHtmlPanel);
        aItemTable = new AItemTable();
        aItemTable.setShowGrid(false);
        aItemTable.setModel(aItemTable.getNewCustomTableModel());
        AItemTableCellRenderer l_aitcr = new AItemTableCellRenderer();
        aItemTable.setDefaultRenderer(Integer.class, l_aitcr);
        aItemTable.setDefaultRenderer(String.class, l_aitcr);
        AItemTableCellEditor l_aitce = new AItemTableCellEditor();
        aItemTable.setDefaultEditor(String.class, l_aitce);
        aItemTable.setSelectionMode(0);
        aItemTable.setBackground(Color.white);
        aItemTable.getTableHeader().setReorderingAllowed(false);
        aItemTable.getTableHeader().setFont(tableHeaderFont);
        aItemTable.getTableHeader().setBackground(Constants.tableHeaderBgColor);
        aItemTable.getTableHeader().setForeground(Constants.tableFontColor);
        aItemTable.getTableHeader().setToolTipText("Click to sort; Click again to sort in reverse order");
        aItemTable.addComponentListener(aItemTable);
        aItemTable.addMouseListener(new ItemTablePopupListener());
        aItemTable.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int col = aItemTable.columnAtPoint(e.getPoint());
                String name = aItemTable.getColumnName(col);
                aItemTable.clickOnColumnHeader(col, DisplayedAccount.getDisplayedAccount(), true);
                MainWindow.refreshTableViewPort();
            }
        });
        itemsMainPanel = new ItemsPanel(aItemTable);
        APlannedItem.loadItems();
        aPlannedItemTable = new APlannedItemTable();
        aPlannedItemTable.setShowGrid(false);
        aPlannedItemTable.setModel(aPlannedItemTable.getNewCustomTableModel());
        APlannedItemTableCellRenderer l_apitcr = new APlannedItemTableCellRenderer();
        aPlannedItemTable.setDefaultRenderer(Integer.class, l_apitcr);
        aPlannedItemTable.setDefaultRenderer(String.class, l_apitcr);
        APlannedItemTableCellEditor l_apitce = new APlannedItemTableCellEditor();
        aPlannedItemTable.setDefaultEditor(String.class, l_apitce);
        aPlannedItemTable.setSelectionMode(0);
        aPlannedItemTable.setBackground(Color.white);
        aPlannedItemTable.getTableHeader().setReorderingAllowed(false);
        aPlannedItemTable.getTableHeader().setFont(tableHeaderFont);
        aPlannedItemTable.getTableHeader().setBackground(Constants.plannedTableHeaderBgColor);
        aPlannedItemTable.getTableHeader().setForeground(Constants.tableFontColor);
        aPlannedItemTable.addComponentListener(aPlannedItemTable);
        aPlannedItemTable.addMouseListener(new PlannedItemTablePopupListener());
        plannedItemsMainPanel = new PlannedItemsPanel(aPlannedItemTable);
        menuBar = new JMenuBar();
        menuBar.setAlignmentX(0.0f);
        frame.getContentPane().add((Component)menuBar, "North");
        JMenu mnFileMenu = new JMenu("Fichier");
        menuBar.add(mnFileMenu);
        mnFileMenu.setHorizontalAlignment(2);
        newAccountMenuItem = new JMenuItem("Nouveau compte");
        newAccountMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AccountDialog l_naDlg = new AccountDialog((Frame)frame, "Nouveau compte", null);
                l_naDlg.setVisible(true);
                if (l_naDlg.okSelected) {
                    try {
                        MainWindow.this.addAccount(true, l_naDlg.accountName.getText().trim(), Account.getAccountTypeFromLabel(l_naDlg.accountTypeChoice.getSelectedItem().toString()), l_naDlg.initialAmount.getText(), l_naDlg.txtOpeningDate.getText());
                        summaryHtmlPanel.displayAccounts();
                    }
                    catch (Exception e2) {
                        Logger.error(TAG, "newAccountMenuItem: actionPerformed: " + e2);
                    }
                }
            }
        });
        mnFileMenu.add(newAccountMenuItem);
        deleteAccountMenuItem = new JMenuItem("Supprimer un compte");
        deleteAccountMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] l_choiceValues = new String[Account.openAccounts.size()];
                int i1 = 0;
                for (Account l_a : Account.openAccounts) {
                    l_choiceValues[i1++] = l_a.accountName;
                }
                String l_delAccount = (String)JOptionPane.showInputDialog(null, "SVP s\u00e9lectionnez le compte \u00e0 renommer.", "S\u00e9lection", 3, null, l_choiceValues, l_choiceValues[0]);
                if (l_delAccount == null) {
                    return;
                }
                int l_res = JOptionPane.showConfirmDialog(null, "SVP confirmez que vous souhaitez supprimer le compte '" + l_delAccount + "'", "", 2);
                if (l_res != 0) {
                    return;
                }
                Account.removeAccount(l_delAccount);
                HMProperties.updateAccountList();
                int i = 0;
                while (i < accountMenuItems.size()) {
                    JMenuItem l_mi = accountMenuItems.get(i);
                    if (l_mi.getText().equals(l_delAccount)) {
                        accountMenuItems.remove(l_mi);
                        mnAccountsMenu.remove(l_mi);
                        mnBillsGraphAccountsMenu.remove(i + mnBillsGraphAccountsMenuAccountsIndexGap);
                        mnAccountPropertiesMenu.remove(i);
                        break;
                    }
                    ++i;
                }
                summaryHtmlPanel.displayAccounts();
                if (DisplayedAccount.getDisplayedAccount() != null && DisplayedAccount.getDisplayedAccount().accountName.equals(l_delAccount)) {
                    MainWindow.itemsMainPanel.homepageButton.doClick();
                }
            }
        });
        mnFileMenu.add(deleteAccountMenuItem);
        mnAccountPropertiesMenu = new JMenu("Propri\u00e9t\u00e9s des comptes");
        mnFileMenu.add(mnAccountPropertiesMenu);
        mnFileMenu.addSeparator();
        qifFileImportMenuItem = new JMenuItem("Importer fichier QIF");
        qifFileImportMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser l_jfc = new JFileChooser();
                l_jfc.setFileSelectionMode(0);
                l_jfc.setCurrentDirectory(new File(HMProperties.getOpenDirLocation()));
                l_jfc.setAccessory(new DateFormatCheckboxAccessory(l_jfc));
                l_jfc.setFileFilter(new FileFilter(){

                    @Override
                    public String getDescription() {
                        return "QIF files";
                    }

                    @Override
                    public boolean accept(File f) {
                        return f.isDirectory() || f.getName().toLowerCase().endsWith(".qif");
                    }
                });
                int l_jfRes = l_jfc.showDialog(frame, "S\u00e9lectionnez un fichier QIF");
                if (l_jfRes == 0) {
                    boolean l_invertDayAndMonthDateReadFormat = ((DateFormatCheckboxAccessory)l_jfc.getAccessory()).isSelected();
                    File file = l_jfc.getSelectedFile();
                    String sfilename = file.getPath();
                    HMProperties.setOpenDirLocation(file.getParent());
                    Logger.debug(TAG, "initialize: mnfileChooseFolder.actionPerformed: chosen file is: " + sfilename + " ,  l_invertDayAndMonthDateReadFormat=" + l_invertDayAndMonthDateReadFormat);
                    Object[] l_choiceValues = new String[Account.openAccounts.size()];
                    int i1 = 0;
                    for (Account l_a : Account.openAccounts) {
                        l_choiceValues[i1++] = l_a.accountName;
                    }
                    String l_importAccount = (String)JOptionPane.showInputDialog(null, "SVP s\u00e9lectionnez le compte d'importation.", "S\u00e9lection", 3, null, l_choiceValues, l_choiceValues[0]);
                    if (l_importAccount == null) {
                        JOptionPane.showMessageDialog(null, "Op\u00e9ration annul\u00e9e.", "Information", 1, null);
                        return;
                    }
                    MainWindow.this.importFile(true, l_importAccount, sfilename, l_invertDayAndMonthDateReadFormat, false);
                }
            }
        });
        mnFileMenu.add(qifFileImportMenuItem);
        ofxFileImportMenuItem = new JMenuItem("Importer fichier OFX");
        ofxFileImportMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser l_jfc = new JFileChooser();
                l_jfc.setFileSelectionMode(0);
                l_jfc.setCurrentDirectory(new File(HMProperties.getOpenDirLocation()));
                l_jfc.setFileFilter(new FileFilter(){

                    @Override
                    public String getDescription() {
                        return "OFX files";
                    }

                    @Override
                    public boolean accept(File f) {
                        return f.isDirectory() || f.getName().toLowerCase().endsWith(".ofx");
                    }
                });
                int l_jfRes = l_jfc.showDialog(frame, "S\u00e9lectionnez un fichier OFX");
                if (l_jfRes == 0) {
                    File file = l_jfc.getSelectedFile();
                    String sfilename = file.getPath();
                    HMProperties.setOpenDirLocation(file.getParent());
                    Logger.debug(TAG, "initialize: mnfileChooseFolder.actionPerformed: chosen file is: " + sfilename);
                    Object[] l_choiceValues = new String[Account.openAccounts.size()];
                    int i1 = 0;
                    for (Account l_a : Account.openAccounts) {
                        l_choiceValues[i1++] = l_a.accountName;
                    }
                    String l_importAccount = (String)JOptionPane.showInputDialog(null, "SVP s\u00e9lectionnez le compte d'importation.", "S\u00e9lection", 3, null, l_choiceValues, l_choiceValues[0]);
                    if (l_importAccount == null) {
                        JOptionPane.showMessageDialog(null, "Op\u00e9ration annul\u00e9e.", "Information", 1, null);
                        return;
                    }
                    MainWindow.this.importFile(false, l_importAccount, sfilename, false, false);
                }
            }
        });
        mnFileMenu.add(ofxFileImportMenuItem);
        mnFileMenu.addSeparator();
        msMoneyMenu = new JMenu("MS Money");
        msMoneyImportMenuItem = new JMenuItem("Importer un fichier QIF export\u00e9 de MS Money");
        msMoneyImportMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int l_res = JOptionPane.showConfirmDialog(MainWindow.getFrame(), "<html>Cette fonctionnalit\u00e9 permet l'import d'un historique MS Money.<br>Depuis MS Money, faire un export au format QIF. Importer ensuite ce fichier QIF par cet import sp\u00e9cifique MS Money.<br>L'import des op\u00e9rations ajoute alors automatiquement les <b>cat\u00e9gories des op\u00e9rations</b>.<br><br>Cela fait, pour le compte nouvellement import\u00e9, s\u00e9lectionner \"Edition > Marquer toutes les op\u00e9rations comme consult\u00e9es\"<br>afin de valider toutes les op\u00e9rations nouvellement import\u00e9es.</html>", "Information sur la proc\u00e9dure - A lire", 2);
                if (l_res != 0) {
                    return;
                }
                JFileChooser l_jfc = new JFileChooser();
                l_jfc.setFileSelectionMode(0);
                l_jfc.setCurrentDirectory(new File(HMProperties.getOpenDirLocation()));
                l_jfc.setAccessory(new DateFormatCheckboxAccessory(l_jfc));
                l_jfc.setFileFilter(new FileFilter(){

                    @Override
                    public String getDescription() {
                        return "QIF files";
                    }

                    @Override
                    public boolean accept(File f) {
                        return f.isDirectory() || f.getName().toLowerCase().endsWith(".qif");
                    }
                });
                int l_jfRes = l_jfc.showDialog(frame, "S\u00e9lectionnez un fichier QIF");
                if (l_jfRes == 0) {
                    boolean l_invertDayAndMonthDateReadFormat = ((DateFormatCheckboxAccessory)l_jfc.getAccessory()).isSelected();
                    File file = l_jfc.getSelectedFile();
                    String sfilename = file.getPath();
                    HMProperties.setOpenDirLocation(file.getParent());
                    Logger.debug(TAG, "initialize: mnfileChooseFolder.actionPerformed: chosen file is: " + sfilename + " ,  l_invertDayAndMonthDateReadFormat=" + l_invertDayAndMonthDateReadFormat);
                    Object[] l_choiceValues = new String[Account.openAccounts.size()];
                    int i1 = 0;
                    for (Account l_a : Account.openAccounts) {
                        l_choiceValues[i1++] = l_a.accountName;
                    }
                    String l_importAccount = (String)JOptionPane.showInputDialog(null, "SVP s\u00e9lectionnez le compte d'importation.", "S\u00e9lection", 3, null, l_choiceValues, l_choiceValues[0]);
                    if (l_importAccount == null) {
                        JOptionPane.showMessageDialog(null, "Op\u00e9ration annul\u00e9e.", "Information", 1, null);
                        return;
                    }
                    MainWindow.this.importFile(true, l_importAccount, sfilename, l_invertDayAndMonthDateReadFormat, true);
                }
            }
        });
        msMoneyMenu.add(msMoneyImportMenuItem);
        mnFileMenu.add(msMoneyMenu);
        mnFileMenu.addSeparator();
        mntmExitWithoutSaving = new JMenuItem("Quitter sans sauvegarder");
        mntmExitWithoutSaving.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int l_res = JOptionPane.showConfirmDialog(null, "Attention, \u00eates vous s\u00fbr de vouloir quitter SANS sauvegarder ?", "Risque de pertes de donn\u00e9es", 2);
                if (l_res != 0) {
                    return;
                }
                System.exit(0);
            }
        });
        mnFileMenu.add(mntmExitWithoutSaving);
        mnFileMenu.addSeparator();
        saveArchiveFileMenuItem = new JMenuItem("Exporter un ZIP de sauvegarde");
        saveArchiveFileMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser l_jfc = new JFileChooser();
                l_jfc.setCurrentDirectory(new File(HMProperties.getOpenDirLocation()));
                SimpleDateFormat l_sdf = new SimpleDateFormat("yyyyMMdd-HHmm");
                Date l_date = new Date();
                l_jfc.setSelectedFile(new File(String.valueOf(HMProperties.getOpenDirLocation()) + File.separator + "HMoney_archive_" + l_sdf.format(l_date) + "-hmy.zip"));
                int l_jfRes = l_jfc.showSaveDialog(frame);
                if (l_jfRes == 0) {
                    try {
                        int l_res;
                        File l_file = l_jfc.getSelectedFile();
                        if (l_file.exists() && (l_res = JOptionPane.showConfirmDialog(null, "Attention, \u00eates vous s\u00fbr de vouloir \u00e9craser l'archive existante ?", "Le fichier existe d\u00e9j\u00e0", 2)) != 0) {
                            return;
                        }
                        String l_archiveFileName = l_file.getAbsoluteFile().toString();
                        if (l_archiveFileName != null && !l_archiveFileName.endsWith(".zip")) {
                            l_archiveFileName = String.valueOf(l_archiveFileName) + ".zip";
                        }
                        frame.setCursor(waitCursor);
                        MainWindow.this.save(true);
                        ZipMaker l_zm = new ZipMaker();
                        l_zm.copyDirectoryToZipFile(new File(HMProperties.getSaveLocation()), new File(l_archiveFileName));
                        frame.setCursor(defaultCursor);
                    }
                    catch (Exception ex) {
                        Logger.error(TAG, "Error exporting archive : " + ex);
                    }
                }
            }
        });
        mnFileMenu.add(saveArchiveFileMenuItem);
        loadArchiveFileMenuItem = new JMenuItem("Importer un ZIP de sauvegarde");
        loadArchiveFileMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser l_jfc = new JFileChooser();
                l_jfc.setFileSelectionMode(0);
                l_jfc.setCurrentDirectory(new File(HMProperties.getOpenDirLocation()));
                l_jfc.setFileFilter(new FileFilter(){

                    @Override
                    public String getDescription() {
                        return "HMoney archive files";
                    }

                    @Override
                    public boolean accept(File f) {
                        return f.isDirectory() || f.getName().toLowerCase().endsWith(".zip");
                    }
                });
                int l_jfRes = l_jfc.showDialog(frame, "S\u00e9lectionnez un fichier Archive");
                if (l_jfRes == 0) {
                    int l_res = JOptionPane.showConfirmDialog(null, "Attention, vous allez perdre l'\u00e9tat courant pour restaurer l'\u00e9tat de l'archive ! Etes vous s\u00fbr ?", "ATTENTION", 2);
                    if (l_res != 0) {
                        return;
                    }
                    File file = l_jfc.getSelectedFile();
                    String sfilename = file.getPath();
                    HMProperties.setOpenDirLocation(file.getParent());
                    Logger.debug(TAG, "initialize: loadArchiveFileMenuItem.actionPerformed: chosen file is: " + sfilename);
                    frame.setCursor(waitCursor);
                    try {
                        Unzip.archiveToDir(new File(sfilename), new File(HMProperties.getSaveLocation()));
                        JOptionPane.showMessageDialog(MainWindow.getFrame(), "<html><center><b>L'importation de l'archive s'est bien d\u00e9roul\u00e9e.<br>L'application va maintenant \u00eatre ferm\u00e9e.</b></center><br><br><br>Veuillez relancer l'application afin de fonctionner avec les <b>donn\u00e9es nouvellement import\u00e9es </b></center></html>", "Fermeture de l'application", 2);
                        System.exit(0);
                    }
                    catch (Exception ex) {
                        Logger.error(TAG, "Error importing archive : " + ex);
                    }
                    frame.setCursor(defaultCursor);
                }
            }
        });
        mnFileMenu.add(loadArchiveFileMenuItem);
        mnFileMenu.addSeparator();
        mnSave = new JMenuItem("Sauvegarder");
        mnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.setCursor(waitCursor);
                MainWindow.this.save(true);
                frame.setCursor(defaultCursor);
            }
        });
        mnFileMenu.add(mnSave);
        mntmExit = new JMenuItem("Sauvegarder les changements et quitter");
        mntmExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Util.saveAll(false);
                frame.dispose();
            }
        });
        mnFileMenu.add(mntmExit);
        JMenu mnEditMenu = new JMenu("Edition");
        menuBar.add(mnEditMenu);
        mntmSearchFull = new JMenuItem("Recherche dans les op\u00e9rations");
        mntmSearchFull.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String l_searchString = JOptionPane.showInputDialog(null, "Entrez le texte \u00e0 rechercher : ", "Recherche dans les op\u00e9rations", 3);
                if (l_searchString == null) {
                    return;
                }
                MainWindow.searchOperations(l_searchString, 0);
                itemsMainPanel.updateGraph();
            }
        });
        mnEditMenu.add(mntmSearchFull);
        mntmClearSearch = new JMenuItem("Quitter les r\u00e9sultats de la recherche pr\u00e9c\u00e9dente");
        mntmClearSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DisplayedAccount.popAccount();
                MainWindow.refreshTableViewPort();
                itemsMainPanel.updateGraph();
            }
        });
        mnEditMenu.add(mntmClearSearch);
        mntmClearSearch.setEnabled(false);
        mnEditMenu.addSeparator();
        mntmAdjustColWidth = new JMenuItem("R\u00e9partir la largeur des colonnes");
        mntmAdjustColWidth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                aItemTable.setColWidth(aItemTable.getWidth());
            }
        });
        mnEditMenu.add(mntmAdjustColWidth);
        mnEditMenu.addSeparator();
        categoryDlgMenuItem = new JMenuItem("Gestion des cat\u00e9gories");
        categoryDlgMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CategoriesDialog l_catDlg = new CategoriesDialog((Frame)frame, "Gestion des cat\u00e9gories");
                l_catDlg.setVisible(true);
                if (!ACategory.getSaved()) {
                    Util.saveAll(false);
                }
            }
        });
        mnEditMenu.add(categoryDlgMenuItem);
        mnEditMenu.addSeparator();
        markAllClearedMenuItem = new JMenuItem("Marquer toutes les op\u00e9rations comme point\u00e9es");
        markAllClearedMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int l_res = JOptionPane.showConfirmDialog(null, "SVP confirmez que vous souhaitez marquer toutes les op\u00e9rations point\u00e9es.", "", 2);
                if (l_res != 0) {
                    return;
                }
                int i = 0;
                while (i < DisplayedAccount.getDisplayedAccount().getItemListSize()) {
                    AItem l_ai = DisplayedAccount.getDisplayedAccount().getItem(i);
                    if (!l_ai.isCleared()) {
                        l_ai.setCleared(true);
                    }
                    ++i;
                }
                MainWindow.refreshTableViewPort();
            }
        });
        mnEditMenu.add(markAllClearedMenuItem);
        markAllValidatedMenuItem = new JMenuItem("Marquer toutes les op\u00e9rations comme consult\u00e9es");
        markAllValidatedMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int l_res = JOptionPane.showConfirmDialog(null, "SVP confirmez que vous souhaitez valider toutes les op\u00e9rations marqu\u00e9es non consult\u00e9es.", "", 2);
                if (l_res != 0) {
                    return;
                }
                int i = 0;
                while (i < DisplayedAccount.getDisplayedAccount().getItemListSize()) {
                    AItem l_ai = DisplayedAccount.getDisplayedAccount().getItem(i);
                    if (!l_ai.isUserValidated()) {
                        l_ai.setUserValidated(true, DisplayedAccount.getDisplayedAccount());
                    }
                    ++i;
                }
                MainWindow.refreshTableViewPort();
            }
        });
        mnEditMenu.add(markAllValidatedMenuItem);
        mnAccountsMenu = new JMenu("Comptes");
        menuBar.add(mnAccountsMenu);
        mnBillsGraphAccountsMenu = new JMenu("Ech\u00e9ancier");
        menuBar.add(mnBillsGraphAccountsMenu);
        mntmPlannedItems = new JMenuItem("Afficher l'\u00e9ch\u00e9ancier");
        mntmPlannedItems.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.setCursor(waitCursor);
                try {
                    MenuManager.inBills();
                    contentPanel.removeAll();
                    contentPanel.setBackground(Color.red);
                    contentPanel.add(plannedItemsMainPanel);
                    KeyboardMainListener.addCurrentListener(aPlannedItemTable);
                    contentPanel.validate();
                    contentPanel.repaint();
                    plannedItemsMainPanel.updateGraph();
                }
                finally {
                    frame.setCursor(defaultCursor);
                }
            }
        });
        mnBillsGraphAccountsMenu.add(mntmPlannedItems);
        mnBillsGraphAccountsMenu.addSeparator();
        mnBillsGraphAccountsMenu.addSeparator();
        mn30DaysGraphMenu = new JCheckBoxMenuItem("30 jours");
        mn30DaysGraphMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.setGraphDays(30);
            }
        });
        mnBillsGraphAccountsMenu.add(mn30DaysGraphMenu);
        mn90DaysGraphMenu = new JCheckBoxMenuItem("90 jours");
        mn90DaysGraphMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.setGraphDays(90);
            }
        });
        mnBillsGraphAccountsMenu.add(mn90DaysGraphMenu);
        mn6MonthsGraphMenu = new JCheckBoxMenuItem("6 Mois");
        mn6MonthsGraphMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.setGraphDays(182);
            }
        });
        mnBillsGraphAccountsMenu.add(mn6MonthsGraphMenu);
        mn1YearGraphMenu = new JCheckBoxMenuItem("1 an");
        mn1YearGraphMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.setGraphDays(365);
            }
        });
        mnBillsGraphAccountsMenu.add(mn1YearGraphMenu);
        mnBillsGraphAccountsMenu.addSeparator();
        mnBillsGraphAccountsMenu.addSeparator();
        mnBillsGraphAccountsMenuAccountsIndexGap = 9;
        mnOptionsMenu = new JMenu("Options");
        menuBar.add(mnOptionsMenu);
        selectStateLocationMenu = new JMenu("R\u00e9pertoire de sauvegarde");
        mnOptionsMenu.add(selectStateLocationMenu);
        MainWindow.updateSaveLocationMenu();
        JMenu selectLanguageMenu = new JMenu("Langage");
        mnOptionsMenu.add(selectLanguageMenu);
        JCheckBoxMenuItem languageDefaultMenuItem = new JCheckBoxMenuItem("Par d\u00e9faut - " + Locale.getDefault());
        languageDefaultMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.setLanguage(Locale.getDefault().toString());
            }
        });
        selectLanguageMenu.add(languageDefaultMenuItem);
        if (HMProperties.getStringProperty("hmy.locale") == null || HMProperties.getStringProperty("hmy.locale").length() < 2) {
            languageDefaultMenuItem.setSelected(true);
        }
        languageDefaultMenuItem.setEnabled(false);
        JCheckBoxMenuItem languageFRMenuItem = new JCheckBoxMenuItem("Fran\u00e7ais - fr_FR");
        languageFRMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.setLanguage("fr_FR");
            }
        });
        selectLanguageMenu.add(languageFRMenuItem);
        if (HMProperties.getStringProperty("hmy.locale") != null && HMProperties.getStringProperty("hmy.locale").equals("fr_FR")) {
            languageFRMenuItem.setSelected(true);
        }
        JCheckBoxMenuItem languageENMenuItem = new JCheckBoxMenuItem("Anglais - en_US");
        languageENMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.setLanguage("en_US");
            }
        });
        selectLanguageMenu.add(languageENMenuItem);
        if (HMProperties.getStringProperty("hmy.locale") != null && HMProperties.getStringProperty("hmy.locale").equals("en_US")) {
            languageENMenuItem.setSelected(true);
        }
        languageENMenuItem.setEnabled(false);
        mnOptionsMenu.addSeparator();
        JMenuItem addDefaultCategoriesMenuItem = new JMenuItem("Ajouter les cat\u00e9gories par d\u00e9faut");
        addDefaultCategoriesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int l_res = JOptionPane.showConfirmDialog(null, "SVP confirmez l'ajout de cat\u00e9gories par d\u00e9faut", "Confirmation", 2);
                if (l_res != 0) {
                    return;
                }
                ACategory.addDefaultCategories();
            }
        });
        mnOptionsMenu.add(addDefaultCategoriesMenuItem);
        mnOptionsMenu.addSeparator();
        JMenuItem webSiteMenuItem = new JMenuItem("Site Web");
        webSiteMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (!Desktop.isDesktopSupported()) {
                        throw new Exception("Unsupported desktop");
                    }
                    Desktop.getDesktop().browse(new URI("http://hmoney.mooo.com"));
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, "Le navigateur web n'a pas pu \u00eatre lanc\u00e9. Ex=" + ex);
                }
            }
        });
        mnOptionsMenu.add(webSiteMenuItem);
        aboutMenuItem = new JMenuItem("A propos");
        aboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(null, "<html>HMoney v. 1.1.3<br><font color=white>running on " + System.getProperty("java.vendor") + " " + System.getProperty("java.version") + " in " + System.getProperty("java.home") + "</font>" + "<br><br>&copy; 2012 - 2014 Mickael Feledyn <br><br> All rights reserved.<br>" + "<br>Sauf indication(s) contraire(s), Ce logiciel est fourni \"dans l'\u00e9tat\", sans aucune garantie explicite ou implicite. " + "<br>En aucun cas le tenant du copyright ne peut \u00eatre tenu responsable de quelques dommages que ce soit provenant de l'utilisation " + "<br>du logiciel, de son t\u00e9l\u00e9chargement, de son installation, ou de sa mise \u00e0 disposition.<br>" + "<br>Unless otherwise stated, this software is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; " + "<br>without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. THERE IS NO WARRANTY FOR THE SOFTWARE, " + "<br>TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS PROVIDE THE SOFTWARE \"AS IS\" " + "<br>WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND " + "<br>FITNESS FOR A PARTICULAR PURPOSE. THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE SOFTWARE IS WITH YOU. SHOULD THE SOFTWARE " + "<br>PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW " + "<br>OR AGREED TO IN WRITING WILL ANY COPYRIGHT HOLDER, BE LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL " + "<br>DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE SOFTWARE (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE " + "<br>OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE OF THE SOFTWARE TO OPERATE WITH ANY OTHER PROGRAMS), EVEN IF SUCH HOLDER HAS BEEN " + "<br>ADVISED OF THE POSSIBILITY OF SUCH DAMAGES." + "</html>");
            }
        });
        mnOptionsMenu.add(aboutMenuItem);
        SwingUtilities.invokeLater(new Thread(){

            @Override
            public void run() {
                String l_accountFiles = HMProperties.getStringProperty("hmy.account_files");
                if (l_accountFiles != null && l_accountFiles.length() > 0) {
                    StringTokenizer l_st = new StringTokenizer(l_accountFiles, ",");
                    while (l_st.hasMoreTokens()) {
                        try {
                            String l_fn = l_st.nextToken();
                            MainWindow.this.addAccount(false, l_fn, null, null, null);
                        }
                        catch (Exception e) {
                            Logger.error(TAG, "SwingUtilities.invokeLater.run(): displayedAccount.loadFile(): " + e);
                        }
                    }
                }
                MenuManager.inHomePage();
                summaryHtmlPanel.displayAccounts();
                MainWindow.setGraphDays(APlannedItem.getGraphDays());
            }
        });
        MainWindow.adjustColumnWidth();
    }

    private void setLanguage(String newLocale) {
        Messages.saveLocaleSetting(newLocale);
        JOptionPane.showMessageDialog(null, "SVP red\u00e9marrez l'application pour que le changement de langue soit appliqu\u00e9.");
    }

    private void addAccount(boolean newAccount, String accountName, String accountType, String initialAmount, String openingDate) throws Exception {
        Logger.debug(TAG, "addAccount (" + newAccount + ", " + accountName + ", " + accountType + ", " + initialAmount + ")");
        Account l_a = new Account(!newAccount);
        if (newAccount) {
            l_a.accountType = accountType;
            l_a.accountName = accountName;
            AItem l_ai = new AItem(Util.parseAmount(initialAmount));
            l_ai.setMemo("Initial deposit");
            l_ai.setDate(new Date());
            if (openingDate != null) {
                l_ai.setDate(Util.parseDate(openingDate, Util.getDateDayFirst()));
            }
            l_a.addItem(l_ai);
        } else {
            l_a.loadFile(accountName);
        }
        l_a.calculateBalance();
        Logger.info(TAG, " Adding account '" + l_a.accountName + "'");
        Account.openAccounts.add(l_a);
        if (newAccount) {
            l_a.save();
        }
        HMProperties.updateAccountList();
        JMenuItem mntmAccount = new JMenuItem(accountName, new ImageIcon(GuiUtil.getAccountImageIcon(l_a.accountType).getImage().getScaledInstance(32, 32, 4)));
        accountMenuItems.add(mntmAccount);
        mntmAccount.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                contentPanel.removeAll();
                contentPanel.add(itemsMainPanel);
                KeyboardMainListener.addCurrentListener(aItemTable);
                contentPanel.repaint();
                JMenuItem l_source = (JMenuItem)e.getSource();
                String l_accountName = l_source.getText();
                Logger.info(TAG, " Displaying account '" + l_accountName + "'");
                Account l_a = Account.getAccountByName(l_accountName);
                DisplayedAccount.setDisplayedAccount(l_a);
                aItemTable.setModel(aItemTable.getNewCustomTableModel());
                DisplayedAccount.getDisplayedAccount().calculateBalance();
                aItemTable.clickOnColumnHeader(2, DisplayedAccount.getDisplayedAccount(), false);
                aItemTable.setColWidth(aItemTable.getWidth());
                MainWindow.itemsMainPanel.accountLabel.setText("  " + DisplayedAccount.getDisplayedAccount().accountName);
                MainWindow.itemsMainPanel.accountLabel.setIcon(new ImageIcon(GuiUtil.getAccountImageIcon(DisplayedAccount.getDisplayedAccount().accountType).getImage().getScaledInstance(32, 32, 4)));
                contentPanel.validate();
                contentPanel.repaint();
                GuiUtil.displayNormalCursor();
                MenuManager.inAccount(DisplayedAccount.getDisplayedAccount().accountName);
                itemsMainPanel.updateGraph();
                SwingUtilities.invokeLater(new Thread(){

                    @Override
                    public void run() {
                        aItemTable.scrollRectToVisible(aItemTable.getCellRect(DisplayedAccount.getDisplayedAccount().getItemListSize() > 0 ? DisplayedAccount.getDisplayedAccount().getItemListSize() - 1 : 0, 0, true));
                    }
                });
            }
        });
        mnAccountsMenu.add(mntmAccount);
        mnAccountsMenu.addSeparator();
        JCheckBoxMenuItem mntmGraphBillsForAccount = new JCheckBoxMenuItem(accountName);
        mntmGraphBillsForAccount.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMenuItem l_source = (JMenuItem)e.getSource();
                String l_accountName = l_source.getText();
                Logger.info(TAG, " Changing graph option for account '" + l_accountName + "'");
                Account l_a = Account.getAccountByName(l_accountName);
                l_a.setGraphBills(!l_a.isGraphBills());
                if (l_a.isGraphBills()) {
                    l_source.setForeground(Constants.plannedTableHeaderBgColor);
                } else {
                    l_source.setForeground(Color.black);
                }
                plannedItemsMainPanel.updateGraph();
            }
        });
        if (l_a.isGraphBills()) {
            mntmGraphBillsForAccount.setSelected(true);
            mntmGraphBillsForAccount.setForeground(Constants.plannedTableHeaderBgColor);
        } else {
            mntmGraphBillsForAccount.setForeground(Color.black);
        }
        mnBillsGraphAccountsMenu.add(mntmGraphBillsForAccount);
        JMenuItem mntmAccountProperties = new JMenuItem(accountName, new ImageIcon(GuiUtil.getAccountImageIcon(l_a.accountType).getImage().getScaledInstance(32, 32, 4)));
        mnAccountPropertiesMenu.add(mntmAccountProperties);
        mntmAccountProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMenuItem l_source = (JMenuItem)e.getSource();
                String l_accountName = l_source.getText();
                Logger.info(TAG, " Properties dialog for account '" + l_accountName + "'");
                Account l_a = Account.getAccountByName(l_accountName);
                AccountDialog l_naDlg = new AccountDialog((Frame)frame, "Edition du compte " + l_a.accountName, l_a);
                l_naDlg.setVisible(true);
            }
        });
        if (newAccount) {
            DisplayedAccount.setDisplayedAccount(l_a);
            aItemTable.setModel(aItemTable.getNewCustomTableModel());
            aItemTable.clickOnColumnHeader(2, DisplayedAccount.getDisplayedAccount(), false);
            aItemTable.setColWidth(aItemTable.getWidth());
        }
    }

    private void save(boolean forceSave) {
        frame.setCursor(waitCursor);
        try {
            Util.saveAll(forceSave);
        }
        catch (Exception e) {
            Logger.error(TAG, "loadFile: " + e.toString());
            e.printStackTrace();
        }
        frame.setCursor(defaultCursor);
    }

    private void importFile(boolean qifImport, String importAccount, String fileName, boolean invertDayAndMonthDateReadFormat, boolean isMoneyMigration) {
        frame.setCursor(waitCursor);
        List<AItem> l_importedItems = null;
        boolean dateDayFirst = Util.getDateDayFirst();
        if (invertDayAndMonthDateReadFormat) {
            dateDayFirst = !dateDayFirst;
        }
        try {
            if (qifImport) {
                try {
                    l_importedItems = new QifImportExport().loadFile(fileName, dateDayFirst, isMoneyMigration);
                }
                catch (DayAndMonthInvertedException damie) {
                    Logger.warn(TAG, "loadFile: " + damie.toString());
                    try {
                        l_importedItems = new QifImportExport().loadFile(fileName, !dateDayFirst, isMoneyMigration);
                    }
                    catch (Exception e) {
                        Logger.error(TAG, "loadFile: " + e.toString());
                        e.printStackTrace(System.err);
                    }
                }
            } else {
                try {
                    OfxSaxImporter l_ofxSaxImporter = new OfxSaxImporter();
                    l_importedItems = l_ofxSaxImporter.loadFile(fileName);
                }
                catch (Exception e) {
                    try {
                        OfxImport l_ofxImport = new OfxImport();
                        l_importedItems = l_ofxImport.loadFile(fileName);
                    }
                    catch (Exception e2) {
                        Logger.error(TAG, "loadFile: " + e.toString() + " , then " + e2.toString());
                        e2.printStackTrace(System.err);
                    }
                }
            }
            Logger.debug(TAG, "loadFile: Imported operations count=" + l_importedItems.size());
            if (l_importedItems.size() < 1) {
                return;
            }
            try {
                Account l_importAccount = Account.getAccountByName(importAccount);
                ArrayList<AItem> l_removeAIList = new ArrayList<AItem>();
                int i = 0;
                while (i < l_importedItems.size()) {
                    AItem l_dup = l_importAccount.findDup(l_importedItems.get(i));
                    if (l_dup != null) {
                        l_dup.dup = l_importedItems.get(i);
                        l_removeAIList.add(l_importedItems.get(i));
                    }
                    ++i;
                }
                for (AItem l_ai : l_removeAIList) {
                    l_importedItems.remove(l_ai);
                }
                i = 0;
                while (i < l_importedItems.size()) {
                    AItem l_ai = l_importedItems.get(i);
                    int l_matchIndex = Util.getAItemMatchForCategory(l_ai, l_importAccount);
                    if (l_matchIndex != -1) {
                        l_ai.setCategory(l_importAccount.getItem(l_matchIndex).getCategory(), l_importAccount);
                    }
                    ++i;
                }
                l_importAccount.addimportedOperations(l_importedItems);
                l_importAccount.calculateBalance();
                aItemTable.setModel(aItemTable.getNewCustomTableModel());
                if (DisplayedAccount.getDisplayedAccount() != null) {
                    aItemTable.clickOnColumnHeader(2, DisplayedAccount.getDisplayedAccount(), false);
                }
                summaryHtmlPanel.displayAccounts();
            }
            catch (Exception e) {
                Logger.error(TAG, "loadFile: " + e.toString());
                e.printStackTrace();
                JOptionPane.showMessageDialog(MainWindow.getFrame(), "L'importation a \u00e9chou\u00e9, le fichier semble incorrect.", "Erreur", 2);
            }
        }
        finally {
            frame.setCursor(defaultCursor);
        }
    }

    private static void refreshTableViewPort() {
        aItemTable.setVisible(false);
        aItemTable.setVisible(true);
        aItemTable.setFont(new Font("Serif", 1, 20));
    }

    public static void adjustColumnWidth() {
        if (System.currentTimeMillis() < lastAdjustColumnWidthTS + 20000L) {
            return;
        }
        lastAdjustColumnWidthTS = System.currentTimeMillis();
        SwingUtilities.invokeLater(new Thread(){

            @Override
            public void run() {
                aItemTable.setColWidth(aItemTable.getWidth());
            }
        });
    }

    public static void setGraphDays(int days) {
        mn30DaysGraphMenu.setSelected(false);
        mn30DaysGraphMenu.setForeground(Color.black);
        mn90DaysGraphMenu.setSelected(false);
        mn90DaysGraphMenu.setForeground(Color.black);
        mn6MonthsGraphMenu.setSelected(false);
        mn6MonthsGraphMenu.setForeground(Color.black);
        mn1YearGraphMenu.setSelected(false);
        mn1YearGraphMenu.setForeground(Color.black);
        switch (days) {
            case 30: {
                mn30DaysGraphMenu.setSelected(true);
                mn30DaysGraphMenu.setForeground(Constants.plannedTableHeaderBgColor);
                break;
            }
            case 90: {
                mn90DaysGraphMenu.setSelected(true);
                mn90DaysGraphMenu.setForeground(Constants.plannedTableHeaderBgColor);
                break;
            }
            case 182: {
                mn6MonthsGraphMenu.setSelected(true);
                mn6MonthsGraphMenu.setForeground(Constants.plannedTableHeaderBgColor);
                break;
            }
            case 365: {
                mn1YearGraphMenu.setSelected(true);
                mn1YearGraphMenu.setForeground(Constants.plannedTableHeaderBgColor);
            }
        }
        APlannedItem.setGraphDays(days);
        plannedItemsMainPanel.updateGraph();
    }

    public static void searchOperations(String searchString, int searchType) {
        DisplayedAccount.pushAccount(DisplayedAccount.getDisplayedAccount().searchOperations(searchString, searchType));
        MainWindow.refreshTableViewPort();
    }

    public static void updateSaveLocationMenu() {
        selectStateLocationMenu.removeAll();
        JMenuItem changeStateLocationMenuItem = new JMenuItem("S\u00e9lectionner nouvel emplacement");
        selectStateLocationMenu.add(changeStateLocationMenuItem);
        selectStateLocationMenu.addSeparator();
        changeStateLocationMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser l_jfc = new JFileChooser();
                l_jfc.setFileSelectionMode(1);
                l_jfc.setCurrentDirectory(new File(HMProperties.getOpenDirLocation()));
                int l_jfRes = l_jfc.showDialog(frame, "S\u00e9lectionnez un r\u00e9pertoire");
                if (l_jfRes == 0) {
                    File l_file = l_jfc.getSelectedFile();
                    String l_sfilename = l_file.getPath();
                    HMProperties.setOpenDirLocation(l_sfilename);
                    MainWindow.updateSaveLocationAndExit(l_sfilename);
                }
            }
        });
        for (String l_dir : HMProperties.getSaveLocationHistory()) {
            JCheckBoxMenuItem l_historyStateLocationMenuItem = new JCheckBoxMenuItem(l_dir);
            selectStateLocationMenu.add(l_historyStateLocationMenuItem);
            if (l_dir != null && l_dir.equals(HMProperties.getSaveLocation())) {
                l_historyStateLocationMenuItem.setBackground(Constants.tableHeaderBgColor);
                l_historyStateLocationMenuItem.setForeground(Color.blue);
                l_historyStateLocationMenuItem.setSelected(true);
            }
            l_historyStateLocationMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JMenuItem l_source = (JMenuItem)e.getSource();
                    String l_dirName = l_source.getText();
                    MainWindow.updateSaveLocationAndExit(l_dirName);
                }
            });
        }
    }

    public static void updateSaveLocationAndExit(String saveDir) {
        Logger.debug(TAG, "updateSaveLocationAndExit: chosen dir is: " + saveDir);
        Util.saveAll(false);
        HMProperties.setSaveLocation(saveDir);
        MainWindow.updateSaveLocationMenu();
        JOptionPane.showMessageDialog(MainWindow.getFrame(), "<html><center><b>L'application va maintenant \u00eatre ferm\u00e9e.</b></center><br>Veuillez relancer l'application afin de fonctionner avec le <u><b>nouveau r\u00e9pertoire de stockage :</b></u><br><center>" + saveDir + "</center></html>", "Fermeture de l'application", 2);
        MainWindow.getFrame().dispose();
    }
}

