/*
 * Decompiled with CFR 0.152.
 */
package com.hmoney.messages;

import com.hmoney.Logger;
import com.hmoney.data.Util;
import com.hmoney.properties.HMProperties;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;

public class Messages {
    private static final String TAG = Messages.class.getSimpleName();
    private static final String BUNDLE_NAME = "com.hmoney.messages.messages";
    private static ResourceBundle RESOURCE_BUNDLE;

    private Messages() {
    }

    public static void init() {
        if (HMProperties.getStringProperty("hmy.locale") != null) {
            Messages.init(Util.getLocaleFromString(HMProperties.getStringProperty("hmy.locale")));
            return;
        }
        Logger.info(TAG, "init() - default locale=" + Locale.getDefault());
        try {
            JComboBox<String> l_cbLocale = new JComboBox<String>();
            l_cbLocale.addItem("fr_FR");
            JOptionPane.showMessageDialog(null, l_cbLocale, "SVP choisissez votre langue.", 3);
            String l_sLocale = (String)l_cbLocale.getSelectedItem();
            if (l_sLocale != null && l_sLocale.length() == 5) {
                Messages.init(Util.getLocaleFromString(l_sLocale));
                Messages.saveLocaleSetting(l_sLocale);
            } else {
                Messages.init(Util.getLocaleFromString("fr_FR"));
                Messages.saveLocaleSetting("fr_FR");
            }
        }
        catch (Exception e) {
            Messages.init(Util.getLocaleFromString("fr_FR"));
            Messages.saveLocaleSetting("fr_FR");
        }
    }

    public static void init(Locale locale) {
        Logger.info(TAG, "init(" + locale + ")");
        RESOURCE_BUNDLE = ResourceBundle.getBundle(BUNDLE_NAME, locale);
    }

    public static String getString(String key) {
        try {
            return RESOURCE_BUNDLE.getString(key);
        }
        catch (MissingResourceException e) {
            return String.valueOf('!') + key + '!';
        }
    }

    public static void saveLocaleSetting(String locale) {
        HMProperties.putProperty("hmy.locale", locale);
        if (locale.endsWith("US")) {
            HMProperties.putProperty("date.day_first", "false");
        } else {
            HMProperties.putProperty("date.day_first", "true");
        }
    }
}

