/*
 * Decompiled with CFR 0.152.
 */
package com.hmoney.gui;

import com.hmoney.data.ACategory;
import com.hmoney.data.APlannedItem;
import com.hmoney.data.Account;
import com.hmoney.gui.Constants;
import com.hmoney.gui.DisplayedAccount;
import com.hmoney.gui.IKeyboardListener;
import com.hmoney.gui.MainWindow;
import com.hmoney.gui.custom.KeyboardMainListener;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CategoriesDialog
extends JDialog
implements IKeyboardListener {
    private static final String TAG = CategoriesDialog.class.getSimpleName();
    private JTextField catTextField;
    private DefaultListModel<String> listModel;
    private JList<String> catList = new JList();
    private JButton btnAddNewCategory;
    private JButton btnRemoveSelectedCategory;
    private JButton btnEditSelectedCategory;
    private JButton btnMigrateCategory;

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            KeyboardMainListener.addCurrentListener(this);
            final CategoriesDialog thisCategoriesDialog = this;
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    KeyboardMainListener.removeListener(thisCategoriesDialog);
                }
            });
        }
        super.setVisible(visible);
    }

    @Override
    public void escapeKeyTyped() {
    }

    @Override
    public void enterKeyTyped() {
    }

    @Override
    public void deleteKeyTyped() {
    }

    public CategoriesDialog(Frame frame, String title) {
        super(frame, title);
        this.setResizable(false);
        this.setSize(644, 562);
        this.setLocation(MainWindow.getFrame().getX() + 300, MainWindow.getFrame().getY() + 300);
        this.getContentPane().setLayout(null);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBounds(0, 0, 638, 285);
        this.getContentPane().add(scrollPane);
        this.catList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                String l_selcat = (String)CategoriesDialog.this.catList.getSelectedValue();
                boolean l_bCatOK = l_selcat != null && l_selcat.length() > 1;
                CategoriesDialog.this.btnRemoveSelectedCategory.setEnabled(l_bCatOK);
                CategoriesDialog.this.btnEditSelectedCategory.setEnabled(l_bCatOK);
                CategoriesDialog.this.btnMigrateCategory.setEnabled(l_bCatOK);
            }
        });
        scrollPane.setViewportView(this.catList);
        this.listModel = new DefaultListModel();
        this.catList.setModel(this.listModel);
        this.refillCategoryList(this.listModel);
        this.catTextField = new JTextField();
        this.catTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                String l_inText = CategoriesDialog.this.catTextField.getText();
                boolean l_bCatOK = l_inText != null && l_inText.length() > 1;
                CategoriesDialog.this.btnAddNewCategory.setEnabled(l_bCatOK);
            }
        });
        this.catTextField.setBounds(10, 386, 386, 27);
        this.getContentPane().add(this.catTextField);
        this.catTextField.setColumns(10);
        JButton btnClose = new JButton("<html>Fermer</html>");
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CategoriesDialog.this.dispose();
            }
        });
        btnClose.setBounds(251, 487, 135, 36);
        this.getContentPane().add(btnClose);
        this.btnAddNewCategory = new JButton("<html>Ajouter la cat\u00e9gorie</html>");
        this.btnAddNewCategory.setEnabled(false);
        this.btnAddNewCategory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String l_newCat = CategoriesDialog.this.catTextField.getText();
                if (!CategoriesDialog.this.checkNewCategory(l_newCat)) {
                    return;
                }
                String l_addedCat = ACategory.addIfDontExist(l_newCat);
                ACategory.sort();
                CategoriesDialog.this.refillCategoryList(CategoriesDialog.this.listModel);
                CategoriesDialog.this.catList.setSelectedValue(l_addedCat, true);
                CategoriesDialog.this.catTextField.setText("");
            }
        });
        this.btnAddNewCategory.setBounds(406, 386, 203, 27);
        this.getContentPane().add(this.btnAddNewCategory);
        JLabel lblNote = new JLabel("<html>A noter : \":\" peut \u00eatre utilis\u00e9 une fois dans le nom de cat\u00e9gorie, cela s\u00e9pare alors la <br>cat\u00e9gorie (\u00e0\u00a0gauche de \":\") de la sous-cat\u00e9gorie (\u00e0\u00a0droite de \":\").</html>");
        lblNote.setBounds(10, 420, 599, 36);
        this.getContentPane().add(lblNote);
        this.btnRemoveSelectedCategory = new JButton("<html>Supprimer la cat\u00e9gorie</html>");
        this.btnRemoveSelectedCategory.setEnabled(false);
        this.btnRemoveSelectedCategory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String l_removeCat = (String)CategoriesDialog.this.catList.getSelectedValue();
                if (l_removeCat == null || l_removeCat.length() < 1) {
                    return;
                }
                if (ACategory.contains(l_removeCat)) {
                    List<Account> l_accList = Account.checkIfCategoryIsReferenced(l_removeCat);
                    if (!l_accList.isEmpty()) {
                        String l_accountNames = "";
                        for (Account l_a : l_accList) {
                            if (l_accountNames.length() > 0) {
                                l_accountNames = String.valueOf(l_accountNames) + ", ";
                            }
                            l_accountNames = String.valueOf(l_accountNames) + l_a.accountName;
                        }
                        JOptionPane.showMessageDialog(CategoriesDialog.this.getContentPane(), "La cat\u00e9gorie ne peut \u00eatre supprim\u00e9e car elle est r\u00e9f\u00e9renc\u00e9e dans les comptes : " + l_accountNames, "Erreur", 1);
                        return;
                    }
                    if (APlannedItem.checkIfCategoryIsReferenced(l_removeCat)) {
                        JOptionPane.showMessageDialog(CategoriesDialog.this.getContentPane(), "La cat\u00e9gorie ne peut \u00eatre supprim\u00e9e car elle est r\u00e9f\u00e9renc\u00e9e dans l'\u00e9ch\u00e9ancier", "Erreur", 1);
                        return;
                    }
                    int l_res = JOptionPane.showConfirmDialog(null, "SVP confirmez la suppression de la cat\u00e9gorie '" + l_removeCat + "' (cette op\u00e9ration ne peut \u00eatre annul\u00e9e).", "", 2);
                    if (l_res != 0) {
                        return;
                    }
                    ACategory.removeIfExists(l_removeCat);
                    ACategory.sort();
                    CategoriesDialog.this.refillCategoryList(CategoriesDialog.this.listModel);
                }
            }
        });
        this.btnRemoveSelectedCategory.setBounds(433, 307, 182, 44);
        this.getContentPane().add(this.btnRemoveSelectedCategory);
        this.btnEditSelectedCategory = new JButton("<html>Modifier la cat\u00e9gorie</html>");
        this.btnEditSelectedCategory.setEnabled(false);
        this.btnEditSelectedCategory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String l_newCat = (String)JOptionPane.showInputDialog(null, "SVP entrez le nouveau nom de la cat\u00e9gorie s\u00e9lectionn\u00e9e.", "Saisie", 3, null, null, (String)CategoriesDialog.this.catList.getSelectedValue());
                if (l_newCat == null) {
                    return;
                }
                if (!CategoriesDialog.this.checkNewCategory(l_newCat = ACategory.normalizeName(l_newCat))) {
                    return;
                }
                String l_oldCat = (String)CategoriesDialog.this.catList.getSelectedValue();
                int l_res = JOptionPane.showConfirmDialog(null, "SVP confirmez le changement de nom de '" + l_oldCat + "' vers '" + l_newCat + "'", "", 2);
                if (l_res != 0) {
                    return;
                }
                Account.changeCategoryOnAllAccounts(l_oldCat, l_newCat);
                APlannedItem.changeCategoryOnPlannedItems(l_oldCat, l_newCat);
                ACategory.removeIfExists(l_oldCat);
                String l_addedCat = ACategory.addIfDontExist(l_newCat);
                ACategory.sort();
                CategoriesDialog.this.refillCategoryList(CategoriesDialog.this.listModel);
                CategoriesDialog.this.catList.setSelectedValue(l_addedCat, true);
                if (DisplayedAccount.isThereAStackedAccount()) {
                    DisplayedAccount.getDisplayedAccount().changeCategoryOnAccount(l_oldCat, l_newCat);
                }
                MainWindow.aItemTable.getTableModel().fireTableDataChanged();
                MainWindow.aPlannedItemTable.getTableModel().fireTableDataChanged();
            }
        });
        this.btnEditSelectedCategory.setBounds(23, 307, 182, 44);
        this.getContentPane().add(this.btnEditSelectedCategory);
        this.btnMigrateCategory = new JButton("<html>Remplacer la cat\u00e9gorie</html>");
        this.btnMigrateCategory.setEnabled(false);
        this.btnMigrateCategory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String l_origCat = (String)CategoriesDialog.this.catList.getSelectedValue();
                if (l_origCat == null || l_origCat.length() < 1) {
                    return;
                }
                Object[] l_choiceValues = new String[ACategory.getCategories().size()];
                int i1 = 0;
                for (String l_cat : ACategory.getCategories()) {
                    l_choiceValues[i1++] = l_cat;
                }
                String l_targetCat = (String)JOptionPane.showInputDialog(null, "SVP s\u00e9lectionnez la cat\u00e9gorie qui remplace '" + l_origCat + "'.", "S\u00e9lection", 3, null, l_choiceValues, l_choiceValues[0]);
                if (l_targetCat == null) {
                    return;
                }
                int l_res = JOptionPane.showConfirmDialog(null, "SVP confirmez le remplacement de la cat\u00e9gorie '" + l_origCat + "' par '" + l_targetCat + "'", "", 2);
                if (l_res != 0) {
                    return;
                }
                Account.changeCategoryOnAllAccounts(l_origCat, l_targetCat);
                APlannedItem.changeCategoryOnPlannedItems(l_origCat, l_targetCat);
                if (DisplayedAccount.isThereAStackedAccount()) {
                    DisplayedAccount.getDisplayedAccount().changeCategoryOnAccount(l_origCat, l_targetCat);
                }
                MainWindow.aItemTable.getTableModel().fireTableDataChanged();
                MainWindow.aPlannedItemTable.getTableModel().fireTableDataChanged();
                JOptionPane.showMessageDialog(CategoriesDialog.this.getContentPane(), "Vous pouvez maintenant supprimer la cat\u00e9gorie '" + l_origCat + "' si vous le souhaitez.", "INFO", 1);
            }
        });
        this.btnMigrateCategory.setBounds(228, 307, 182, 44);
        this.getContentPane().add(this.btnMigrateCategory);
        JSeparator separator = new JSeparator();
        separator.setBounds(10, 373, 618, 2);
        this.getContentPane().add(separator);
        JSeparator separator_1 = new JSeparator();
        separator_1.setBounds(10, 467, 618, 2);
        this.getContentPane().add(separator_1);
    }

    private void refillCategoryList(DefaultListModel<String> listModel) {
        listModel.clear();
        for (String l_cat : ACategory.getCategories()) {
            listModel.addElement(l_cat);
        }
    }

    private boolean checkNewCategory(String newCategory) {
        String[] stringArray = Constants.reservedKeywords;
        int n = Constants.reservedKeywords.length;
        int n2 = 0;
        while (n2 < n) {
            String reserved = stringArray[n2];
            if (newCategory.contains(reserved)) {
                JOptionPane.showMessageDialog(this.getContentPane(), "\"" + reserved + "\" est un nom r\u00e9serv\u00e9 par l'application. Veuillez SVP choisir un autre mot.", "INFO", 1);
                return false;
            }
            ++n2;
        }
        int l_res = ACategory.checkNewCategoryBeforeAddind(newCategory);
        switch (l_res) {
            case 0: {
                return true;
            }
            case 1: {
                JOptionPane.showMessageDialog(this.getContentPane(), "Erreur, le nom de cat\u00e9gorie existe d\u00e9j\u00e0\u00a0.", "INFO", 1);
                break;
            }
            case 2: {
                JOptionPane.showMessageDialog(this.getContentPane(), "Vous ne pouvez utiliser ':' qu'une fois dans le nom de cat\u00e9gorie.", "INFO", 1);
                break;
            }
            case 3: {
                JOptionPane.showMessageDialog(this.getContentPane(), "Les caract\u00e8res ',' '[' et ']' ne sont pas autoris\u00e9s dans les noms de cat\u00e9gories.", "INFO", 1);
                break;
            }
            case 4: {
                JOptionPane.showMessageDialog(this.getContentPane(), "Erreur, le nom de cat\u00e9gorie doit contenir au moins 2 caract\u00e8res.", "INFO", 1);
            }
        }
        return false;
    }
}

