/*
 * Decompiled with CFR 0.152.
 */
package com.hmoney.gui;

import com.hmoney.Logger;
import com.hmoney.data.AItem;
import com.hmoney.data.APlannedItem;
import com.hmoney.data.Account;
import com.hmoney.data.Util;
import com.hmoney.gui.Constants;
import com.hmoney.gui.DisplayedAccount;
import com.hmoney.gui.GuiUtil;
import com.hmoney.gui.MainWindow;
import com.hmoney.gui.NewPlannedOperationDialog;
import com.hmoney.gui.TransferOperationToAccountDialog;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

class ItemTablePopupListener
extends MouseAdapter {
    private static final String TAG = ItemTablePopupListener.class.getSimpleName();
    static JMenuItem mnuIDelete = null;
    static JMenuItem mnuIDuplicateTo = null;
    static JMenuItem mnuITransferTo = null;
    static JMenu mnuPlannedOccurenceFromItemMenu = null;
    static JMenuItem mnuIPlannedFromItem = null;
    static JMenu mnuSearch = null;
    static JMenuItem mnuSearchPayee = null;
    static JMenuItem mnuSearchSubCategory = null;
    static JMenuItem mnuSearchCategory = null;
    static JMenu mnuMarkAs = null;
    static JMenuItem mnuICR_RAZ = null;
    static JMenuItem mnuICR_C = null;
    static JMenuItem mnuICR_R = null;
    private static ActionListener popupItemMenuActionListener = new ActionListener(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            String l_action = e.getActionCommand();
            Logger.info(TAG, "popupItemMenuActionListener.actionPerformed : action=" + l_action);
            int l_row = MainWindow.aItemTable.getSelectedRow();
            if (l_row < 0) {
                return;
            }
            AItem l_ai = DisplayedAccount.getDisplayedAccount().getItem(l_row);
            try {
                if (e.getSource().equals(mnuIDelete)) {
                    MainWindow.aItemTable.removeRow(l_row, true);
                    return;
                }
                if (e.getSource().equals(mnuIDuplicateTo)) {
                    TransferOperationToAccountDialog l_tota = new TransferOperationToAccountDialog(MainWindow.getFrame(), "Dupliquer vers ...", true, l_ai);
                    l_tota.setVisible(true);
                    if (!l_tota.okSelected) {
                        return;
                    }
                    Account l_targetAccount = Account.getAccountByName(l_tota.selectedAccount);
                    if (l_targetAccount == null) return;
                    AItem l_aiSrc = l_ai;
                    AItem l_aiCopy = new AItem(l_aiSrc, false);
                    l_aiCopy.setNewUuid();
                    l_targetAccount.addItem(l_aiCopy);
                    l_aiCopy.setCategory(l_aiSrc.getCategory(), l_targetAccount);
                    return;
                }
                if (e.getSource().equals(mnuITransferTo)) {
                    TransferOperationToAccountDialog l_tota = new TransferOperationToAccountDialog(MainWindow.getFrame(), "Transf\u00e9rer vers ...", false, l_ai);
                    l_tota.setVisible(true);
                    if (!l_tota.okSelected) {
                        return;
                    }
                    Account l_targetAccount = Account.getAccountByName(l_tota.selectedAccount);
                    if (l_targetAccount == null) return;
                    String l_cat = l_ai.getCategory();
                    MainWindow.aItemTable.removeRow(l_row, false);
                    l_targetAccount.addItem(l_ai);
                    l_ai.setCategory(l_cat, l_targetAccount);
                    return;
                }
                if (e.getSource().equals(mnuIPlannedFromItem)) {
                    NewPlannedOperationDialog l_newOpDlg = new NewPlannedOperationDialog(MainWindow.getFrame(), "Rendre p\u00e9riodique une op\u00e9ration", true, l_ai, DisplayedAccount.getDisplayedAccount().accountName);
                    l_newOpDlg.setVisible(true);
                    if (!l_newOpDlg.okSelected) {
                        return;
                    }
                    APlannedItem.addItem(l_newOpDlg.aPlannedItem);
                    APlannedItem.sort(0, true);
                    MainWindow.aPlannedItemTable.getTableModel().fireTableDataChanged();
                    int l_rowSel = APlannedItem.indexOf(l_newOpDlg.aPlannedItem);
                    GuiUtil.showTableElementInViewPort(MainWindow.aPlannedItemTable, l_rowSel, 0);
                    return;
                }
                if (e.getSource().equals(mnuICR_R)) {
                    l_ai.setReconciled(true);
                    return;
                }
                if (e.getSource().equals(mnuICR_C)) {
                    l_ai.setCleared(true);
                    l_ai.setReconciled(false);
                    return;
                }
                if (e.getSource().equals(mnuICR_RAZ)) {
                    l_ai.setCleared(false);
                    l_ai.setReconciled(false);
                    return;
                }
                if (e.getSource().equals(mnuSearchPayee)) {
                    MainWindow.searchOperations(l_ai.getPayee(), 1);
                    return;
                }
                if (e.getSource().equals(mnuSearchSubCategory)) {
                    MainWindow.searchOperations(l_ai.getCategory(), 2);
                    return;
                }
                if (!e.getSource().equals(mnuSearchCategory)) return;
                MainWindow.searchOperations(GuiUtil.getParentCategory(l_ai.getCategory()), 2);
                return;
            }
            finally {
                MainWindow.aItemTable.getTableModel().fireTableRowsUpdated(l_row, l_row);
                MainWindow.aItemTable.updateViewPort(l_ai, MainWindow.aItemTable.getSelectedColumn());
                MainWindow.itemsMainPanel.updateGraph();
            }
        }
    };

    ItemTablePopupListener() {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (MainWindow.aItemTable.getSelectedRow() != -1) {
            this.maybeShowPopup(e);
        }
    }

    private void maybeShowPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            int l_row = MainWindow.aItemTable.rowAtPoint(e.getPoint());
            int l_col = MainWindow.aItemTable.columnAtPoint(e.getPoint());
            if (MainWindow.aItemTable.isRowSelected(l_row) && MainWindow.aItemTable.isColumnSelected(l_col)) {
                ItemTablePopupListener.getItemMenuPopup(l_row, l_col).show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    public static JPopupMenu getItemMenuPopup(int row, int column) {
        Logger.debug(TAG, "getItemMenuPopup()");
        final AItem l_ai = DisplayedAccount.getDisplayedAccount().getItem(row);
        final int l_row = row;
        JPopupMenu popup = new JPopupMenu();
        mnuMarkAs = new JMenu("Marquer l'op\u00e9ration comme ...");
        mnuMarkAs.addActionListener(popupItemMenuActionListener);
        popup.add(mnuMarkAs);
        mnuICR_RAZ = new JMenuItem("Non point\u00e9e / Non rapproch\u00e9e");
        mnuICR_RAZ.addActionListener(popupItemMenuActionListener);
        mnuMarkAs.add(mnuICR_RAZ);
        mnuICR_C = new JMenuItem("Point\u00e9e");
        mnuICR_C.addActionListener(popupItemMenuActionListener);
        mnuMarkAs.add(mnuICR_C);
        mnuICR_R = new JMenuItem("Rapproch\u00e9e");
        mnuICR_R.addActionListener(popupItemMenuActionListener);
        mnuMarkAs.add(mnuICR_R);
        if (l_ai != null && (l_ai.getPayee() != null || Util.isValidCategory(l_ai.getCategory()))) {
            popup.addSeparator();
            mnuSearch = new JMenu("Rechercher ...");
            mnuSearch.addActionListener(popupItemMenuActionListener);
            popup.add(mnuSearch);
            if (l_ai.getPayee() != null && l_ai.getPayee().trim().length() > 0) {
                mnuSearchPayee = new JMenuItem("Le tiers '" + l_ai.getPayee() + "'");
                mnuSearchPayee.addActionListener(popupItemMenuActionListener);
                mnuSearch.add(mnuSearchPayee);
            }
            if (Util.isValidCategory(l_ai.getCategory())) {
                mnuSearchSubCategory = new JMenuItem("La sous-cat\u00e9gorie '" + l_ai.getCategory());
                mnuSearchSubCategory.addActionListener(popupItemMenuActionListener);
                mnuSearch.add(mnuSearchSubCategory);
                mnuSearchCategory = new JMenuItem("La cat\u00e9gorie '" + GuiUtil.getParentCategory(l_ai.getCategory()));
                mnuSearchCategory.addActionListener(popupItemMenuActionListener);
                mnuSearch.add(mnuSearchCategory);
            }
        }
        popup.addSeparator();
        List<APlannedItem> l_plannedItemListForAccount = APlannedItem.getNextOccurencesOnAccount(DisplayedAccount.getDisplayedAccount().accountName, l_ai.getLongAmount(), l_ai.getDate());
        mnuPlannedOccurenceFromItemMenu = new JMenu("Ceci est une occurence planifi\u00e9e");
        mnuPlannedOccurenceFromItemMenu.setForeground(Constants.plannedTableFontColor);
        mnuPlannedOccurenceFromItemMenu.setBackground(Constants.plannedOddRowColor);
        if (l_plannedItemListForAccount.size() < 1) {
            mnuPlannedOccurenceFromItemMenu.setEnabled(false);
        } else {
            int i = 0;
            for (APlannedItem l_api : l_plannedItemListForAccount) {
                JMenuItem l_mi = new JMenuItem(l_api.getPayee() + " , " + Util.longAmountToString(l_api.getLongAmount()) + " , " + Util.getSimpleDateFormatter().format(l_api.getDate()));
                l_mi.setForeground(Constants.plannedTableFontColor);
                if (++i % 2 > 0) {
                    l_mi.setBackground(Constants.plannedOddRowColor);
                } else {
                    l_mi.setBackground(Color.white);
                }
                final APlannedItem l_finalAPlannedItem = l_api;
                l_mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            l_finalAPlannedItem.ignoreNextOccurence();
                            l_ai.setCategory(l_finalAPlannedItem.getCategory(), DisplayedAccount.getDisplayedAccount());
                            l_ai.setReconciliatedWithPlanned(true);
                        }
                        finally {
                            MainWindow.aItemTable.getTableModel().fireTableRowsUpdated(l_row, l_row);
                            MainWindow.aItemTable.updateViewPort(l_ai, MainWindow.aItemTable.getSelectedColumn());
                            MainWindow.itemsMainPanel.updateGraph();
                        }
                    }
                });
                mnuPlannedOccurenceFromItemMenu.add(l_mi);
            }
            JMenuItem l_mi = new JMenuItem("<Aucun>");
            l_mi.setForeground(Constants.plannedTableFontColor);
            if (++i % 2 > 0) {
                l_mi.setBackground(Constants.plannedOddRowColor);
            } else {
                l_mi.setBackground(Color.white);
            }
            l_mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        l_ai.setReconciliatedWithPlanned(true);
                    }
                    finally {
                        MainWindow.aItemTable.getTableModel().fireTableRowsUpdated(l_row, l_row);
                        MainWindow.aItemTable.updateViewPort(l_ai, MainWindow.aItemTable.getSelectedColumn());
                        MainWindow.itemsMainPanel.updateGraph();
                    }
                }
            });
            mnuPlannedOccurenceFromItemMenu.add(l_mi);
        }
        popup.add(mnuPlannedOccurenceFromItemMenu);
        mnuIPlannedFromItem = new JMenuItem("Rendre p\u00e9riodique");
        mnuIPlannedFromItem.addActionListener(popupItemMenuActionListener);
        popup.add(mnuIPlannedFromItem);
        popup.addSeparator();
        mnuIDuplicateTo = new JMenuItem("Dupliquer vers ...");
        mnuIDuplicateTo.addActionListener(popupItemMenuActionListener);
        mnuIDuplicateTo.setEnabled(true);
        popup.add(mnuIDuplicateTo);
        mnuITransferTo = new JMenuItem("Transf\u00e9rer vers ...");
        mnuITransferTo.addActionListener(popupItemMenuActionListener);
        mnuITransferTo.setEnabled(true);
        popup.add(mnuITransferTo);
        mnuIDelete = new JMenuItem("Supprimer");
        mnuIDelete.addActionListener(popupItemMenuActionListener);
        popup.add(mnuIDelete);
        return popup;
    }
}

