/*
 * Decompiled with CFR 0.152.
 */
package com.hmoney.gui;

import com.hmoney.data.AItem;
import com.hmoney.data.Util;
import com.hmoney.gui.Constants;
import com.hmoney.gui.DisplayedAccount;
import com.hmoney.gui.GuiUtil;
import com.hmoney.gui.IKeyboardListener;
import com.hmoney.gui.MainWindow;
import com.hmoney.gui.custom.DateChooser;
import com.hmoney.gui.custom.KeyboardMainListener;
import com.hmoney.messages.Messages;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Date;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class NewOperationDialog
extends JDialog
implements IKeyboardListener {
    private JTextField textFieldDate;
    private JTextField textFieldNum;
    private JTextField textFieldPayee;
    private JTextField textFieldMemo;
    private JTextField textFieldAmount;
    private JComboBox<String> comboBoxCategory;
    JRadioButton rdbtnDebit;
    public boolean okSelected = false;
    AItem aItem = null;

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            KeyboardMainListener.addCurrentListener(this);
            final NewOperationDialog thisNewOperationDialog = this;
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    KeyboardMainListener.removeListener(thisNewOperationDialog);
                }
            });
        }
        super.setVisible(visible);
    }

    @Override
    public void escapeKeyTyped() {
        this.dispose();
    }

    @Override
    public void enterKeyTyped() {
    }

    @Override
    public void deleteKeyTyped() {
    }

    public NewOperationDialog(JFrame frame, String title, boolean modal) {
        super(frame, title, modal);
        this.setResizable(false);
        this.setSize(579, 425);
        this.setLocation(frame.getX() + 300, frame.getY() + 300);
        this.getContentPane().setLayout(null);
        JLabel lblDate = new JLabel("Date d'op\u00e9ration");
        lblDate.setFont(new Font("Tahoma", 1, 12));
        lblDate.setBounds(334, 7, 134, 20);
        this.getContentPane().add(lblDate);
        this.textFieldDate = new JTextField();
        this.textFieldDate.setText(Util.getSimpleDateFormatter().format(new Date()));
        this.textFieldDate.setColumns(10);
        this.textFieldDate.setBounds(334, 29, 165, 27);
        this.getContentPane().add(this.textFieldDate);
        JLabel lblDdmmyyyy = new JLabel(Util.getDateUserInputTemplate());
        lblDdmmyyyy.setBounds(337, 59, 180, 16);
        this.getContentPane().add(lblDdmmyyyy);
        JLabel lblNum = new JLabel("Num");
        lblNum.setBounds(9, 258, 46, 14);
        this.getContentPane().add(lblNum);
        this.textFieldNum = new JTextField();
        this.textFieldNum.setBounds(9, 274, 195, 27);
        this.getContentPane().add(this.textFieldNum);
        this.textFieldNum.setColumns(10);
        JLabel lblPayee = new JLabel("Tiers");
        lblPayee.setBounds(9, 92, 46, 14);
        this.getContentPane().add(lblPayee);
        this.textFieldPayee = new JTextField();
        this.textFieldPayee.setBounds(9, 108, 546, 27);
        this.getContentPane().add(this.textFieldPayee);
        this.textFieldPayee.setColumns(10);
        JLabel lblCategory = new JLabel("Cat\u00e9gorie");
        lblCategory.setBounds(9, 146, 210, 14);
        this.getContentPane().add(lblCategory);
        this.comboBoxCategory = GuiUtil.getCategoriesComboBox(DisplayedAccount.getDisplayedAccount());
        this.comboBoxCategory.setBounds(9, 164, 490, 27);
        this.getContentPane().add(this.comboBoxCategory);
        JLabel lblMemo = new JLabel("Commentaire");
        lblMemo.setBounds(9, 202, 195, 14);
        this.getContentPane().add(lblMemo);
        this.textFieldMemo = new JTextField();
        this.textFieldMemo.setBounds(9, 220, 546, 27);
        this.getContentPane().add(this.textFieldMemo);
        this.textFieldMemo.setColumns(10);
        JLabel lblMontant = new JLabel("Montant");
        lblMontant.setFont(new Font("Tahoma", 1, 12));
        lblMontant.setBounds(128, 13, 180, 14);
        this.getContentPane().add(lblMontant);
        this.textFieldAmount = new JTextField();
        this.textFieldAmount.setBounds(128, 29, 165, 27);
        this.getContentPane().add(this.textFieldAmount);
        this.textFieldAmount.setColumns(10);
        JButton btnCancel = new JButton("Cancel");
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewOperationDialog.this.dispose();
            }
        });
        btnCancel.setBounds(95, 347, 143, 39);
        this.getContentPane().add(btnCancel);
        JButton btnOk = new JButton("OK");
        btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewOperationDialog.this.aItem = new AItem();
                if (NewOperationDialog.this.textFieldPayee.getText().length() > 0) {
                    NewOperationDialog.this.aItem.setPayee(NewOperationDialog.this.textFieldPayee.getText());
                }
                if (NewOperationDialog.this.textFieldMemo.getText().length() > 0) {
                    NewOperationDialog.this.aItem.setMemo(NewOperationDialog.this.textFieldMemo.getText());
                }
                if (NewOperationDialog.this.textFieldNum.getText().length() > 0) {
                    NewOperationDialog.this.aItem.setNum(NewOperationDialog.this.textFieldNum.getText());
                }
                try {
                    NewOperationDialog.this.aItem.setLongAmount(Util.parseAmount(NewOperationDialog.this.textFieldAmount.getText()));
                    if (NewOperationDialog.this.rdbtnDebit.isSelected()) {
                        NewOperationDialog.this.aItem.setLongAmount(-NewOperationDialog.this.aItem.getLongAmount());
                    }
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(NewOperationDialog.this.getContentPane(), "Le montant doit \u00eatre une valeur num\u00e9rique.", Messages.getString("WINDOW_TITLE_ERROR"), 0);
                    return;
                }
                try {
                    Date date = Util.parseDate(NewOperationDialog.this.textFieldDate.getText(), Util.getDateDayFirst());
                    NewOperationDialog.this.aItem.setDate(date);
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(NewOperationDialog.this.getContentPane(), "Date invalide", Messages.getString("WINDOW_TITLE_ERROR"), 0);
                    NewOperationDialog.this.textFieldDate.setText(Util.getDateUserInputTemplate());
                    return;
                }
                if (NewOperationDialog.this.comboBoxCategory.getSelectedIndex() > -1) {
                    NewOperationDialog.this.aItem.setCategory(NewOperationDialog.this.comboBoxCategory.getSelectedItem().toString(), DisplayedAccount.getDisplayedAccount());
                }
                NewOperationDialog.this.okSelected = true;
                NewOperationDialog.this.dispose();
            }
        });
        btnOk.setBounds(333, 347, 143, 39);
        this.getContentPane().add(btnOk);
        ButtonGroup l_bg = new ButtonGroup();
        JRadioButton rdbtnCredit = new JRadioButton("Cr\u00e9dit");
        rdbtnCredit.setForeground(Constants.darkGreenColor);
        l_bg.add(rdbtnCredit);
        rdbtnCredit.setSelected(true);
        rdbtnCredit.setFont(new Font("Tahoma", 1, 12));
        rdbtnCredit.setBounds(18, 13, 83, 23);
        this.getContentPane().add(rdbtnCredit);
        this.rdbtnDebit = new JRadioButton("D\u00e9bit");
        this.rdbtnDebit.setForeground(Constants.darkRedColor);
        l_bg.add(this.rdbtnDebit);
        this.rdbtnDebit.setFont(new Font("Tahoma", 1, 12));
        this.rdbtnDebit.setBounds(19, 39, 82, 23);
        this.getContentPane().add(this.rdbtnDebit);
        JButton l_dateButton = GuiUtil.getChooseDateButton(36, 27);
        l_dateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Date l_inDate = new Date();
                try {
                    l_inDate = Util.parseDate(NewOperationDialog.this.textFieldDate.getText(), Util.getDateDayFirst());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String l_chosenDate = new DateChooser(MainWindow.getFrame(), l_inDate).getPickedDate();
                if (l_chosenDate != null && l_chosenDate.length() > 0) {
                    NewOperationDialog.this.textFieldDate.setText(l_chosenDate);
                }
            }
        });
        l_dateButton.setBounds(500, 29, 36, 27);
        this.getContentPane().add(l_dateButton);
        JButton l_categoryButton = GuiUtil.getChooseCategoryButton(36, 27);
        l_categoryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiUtil.getCategoryPopup(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String l_cat = GuiUtil.getCategoryChosenInCategoryPopup(e);
                        NewOperationDialog.this.comboBoxCategory.setSelectedItem(l_cat);
                    }
                }, DisplayedAccount.getDisplayedAccount()).show((Component)e.getSource(), 0, 0);
            }
        });
        l_categoryButton.setBounds(500, 164, 36, 27);
        this.getContentPane().add(l_categoryButton);
    }
}

