/*
 * Decompiled with CFR 0.152.
 */
package com.hmoney.gui;

import com.hmoney.Logger;
import com.hmoney.data.APlannedItem;
import com.hmoney.gui.MainWindow;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

class PlannedItemTablePopupListener
extends MouseAdapter {
    private static final String TAG = PlannedItemTablePopupListener.class.getSimpleName();
    static JMenu mnuIgnore = null;
    static JMenuItem mnuiIgnoreOldestPassed = null;
    static JMenuItem mnuiIgnoreAllPassed = null;
    static JMenuItem mnuiIgnoreOneNotPassed = null;
    static JMenuItem mnuIDeletePlanned = null;
    private static ActionListener popupPlannedItemMenuActionListener = new ActionListener(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            String l_action = e.getActionCommand();
            Logger.info(TAG, "popupPlannedItemMenuActionListener.actionPerformed : action=" + l_action);
            int l_row = MainWindow.aPlannedItemTable.getSelectedRow();
            if (l_row < 0) {
                return;
            }
            APlannedItem l_api = APlannedItem.getItem(l_row);
            try {
                if (e.getSource().equals(mnuIDeletePlanned)) {
                    MainWindow.aPlannedItemTable.removeRow(l_row, true);
                    return;
                }
                if (e.getSource().equals(mnuiIgnoreOldestPassed) || e.getSource().equals(mnuiIgnoreOneNotPassed)) {
                    l_api.ignoreNextOccurence();
                    return;
                }
                if (!e.getSource().equals(mnuiIgnoreAllPassed)) return;
                l_api.ignoreAllPassedOccurences();
                return;
            }
            finally {
                APlannedItem.sort(0, true);
                MainWindow.aPlannedItemTable.getTableModel().fireTableRowsUpdated(l_row, l_row);
                MainWindow.aPlannedItemTable.updateViewPort(l_api, MainWindow.aPlannedItemTable.getSelectedColumn());
                MainWindow.plannedItemsMainPanel.updateGraph();
            }
        }
    };

    PlannedItemTablePopupListener() {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (MainWindow.aPlannedItemTable.getSelectedRow() != -1) {
            this.maybeShowPopup(e);
        }
    }

    private void maybeShowPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            int l_row = MainWindow.aPlannedItemTable.rowAtPoint(e.getPoint());
            int l_col = MainWindow.aPlannedItemTable.columnAtPoint(e.getPoint());
            if (MainWindow.aPlannedItemTable.isRowSelected(l_row) && MainWindow.aPlannedItemTable.isColumnSelected(l_col)) {
                PlannedItemTablePopupListener.getPlannedItemMenuPopup(l_row, l_col).show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    public static JPopupMenu getPlannedItemMenuPopup(int row, int column) {
        Logger.debug(TAG, "getPlannedItemMenuPopup()");
        int l_row = MainWindow.aPlannedItemTable.getSelectedRow();
        if (l_row < 0) {
            return null;
        }
        APlannedItem l_api = APlannedItem.getItem(l_row);
        Date l_now = new Date();
        JPopupMenu popup = new JPopupMenu();
        mnuIgnore = new JMenu("Ignorer l'op\u00e9ration");
        mnuIgnore.addActionListener(popupPlannedItemMenuActionListener);
        popup.add(mnuIgnore);
        mnuiIgnoreOldestPassed = new JMenuItem("Ignorer la plus ancienne occurence");
        mnuiIgnoreOldestPassed.addActionListener(popupPlannedItemMenuActionListener);
        mnuIgnore.add(mnuiIgnoreOldestPassed);
        mnuiIgnoreOldestPassed.setEnabled(l_api.getLateOccurencesCountAtDate(l_now) > 0);
        mnuiIgnoreAllPassed = new JMenuItem("Ignorer toutes les occurences pass\u00e9es");
        mnuiIgnoreAllPassed.addActionListener(popupPlannedItemMenuActionListener);
        mnuIgnore.add(mnuiIgnoreAllPassed);
        mnuiIgnoreAllPassed.setEnabled(l_api.getLateOccurencesCountAtDate(l_now) > 1);
        mnuiIgnoreOneNotPassed = new JMenuItem("Ignorer l'occurence suivante");
        mnuiIgnoreOneNotPassed.addActionListener(popupPlannedItemMenuActionListener);
        mnuIgnore.add(mnuiIgnoreOneNotPassed);
        mnuiIgnoreOneNotPassed.setEnabled(l_api.getLateOccurencesCountAtDate(l_now) < 1);
        mnuIDeletePlanned = new JMenuItem("Supprimer");
        mnuIDeletePlanned.addActionListener(popupPlannedItemMenuActionListener);
        popup.add(mnuIDeletePlanned);
        return popup;
    }
}

