/*
 * Decompiled with CFR 0.152.
 */
package com.hmoney.data;

import com.hmoney.Logger;
import com.hmoney.data.Util;
import com.hmoney.messages.Messages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public class ACategory {
    private static final String TAG = ACategory.class.getSimpleName();
    private static List<String> categories = new ArrayList<String>();
    private static boolean saved = true;
    private static boolean sorted = true;
    private static final String[] default_categories = new String[]{"Abonnement-factures", "Abonnement-factures : Eau", "Abonnement-factures : Electricit\u00e9", "Abonnement-factures : Gaz", "Alimentation", "Alimentation : Caf\u00e9-Bar", "Alimentation : Restaurant", "Alimentation : Restaurant d'entreprise", "Alimentation : Epicerie", "Animaux domestiques", "Animaux domestiques : Alimentation", "Animaux domestiques : Fournitures diverses", "Animaux domestiques : V\u00e9t\u00e9rinaire", "Assurance", "Assurance : Auto-moto", "Assurance : Habitation", "Auto-moto", "Auto-moto : Accessoires", "Auto-moto : Achat v\u00e9hicule", "Auto-moto : Assurance Auto-moto", "Auto-moto : Carburant", "Auto-moto : Contraventions", "Auto-moto : Controle technique", "Auto-moto : Entretien-r\u00e9parations", "Auto-moto : Frais l\u00e9gaux", "Auto-moto : Parking-p\u00e9age", "Autres revenus", "Autres revenus : Dons et cadeaux", "Autres revenus : Vente \u00e9quipements divers", "Autres revenus : Vente v\u00e9hicule", "Cadeaux", "Coiffeur-esth\u00e9ticienne", "Divers", "Divers : Cadeaux", "Divers : Frais de douanes", "Divers : Frais l\u00e9gaux", "Dons caritatifs", "Ecommerce", "Ecommerce : Frais affranchissement", "Enfants", "Enfants : Activit\u00e9 sportive ou culturelle", "Enfants : Frais de cantine", "Enfants : Frais de garde", "Enfants : Frais divers", "Enfants : Habillement-chaussures", "Enfants : M\u00e9decin - sant\u00e9", "Equipement", "Equipement : Ordinateur et accessoires", "Equipement : T\u00e9l\u00e9vision et accessoires", "Factures", "Factures : Abonnement TV-c\u00e2ble", "Factures : Eau", "Factures : Electricit\u00e9", "Factures : Frais de parution d'annonce", "Factures : Gaz", "Factures : Remboursement de pr\u00eat immobilier", "Factures : T\u00e9l\u00e9phone", "Factures : T\u00e9l\u00e9phone mobile", "Factures : T\u00e9l\u00e9service-Internet", "Frais bancaires", "Frais bancaires : Agios", "Frais bancaires : Carte de paiement - de cr\u00e9dit", "Frais bancaires : Frais de carte bancaire", "Frais bancaires : Frais divers", "Frais professionnels", "Habillement", "Habillement : Accessoires", "Habillement : Chaussures", "Habillement : Vetements", "Imp\u00f4ts", "Imp\u00f4ts : Autres imp\u00f4ts", "Imp\u00f4ts : Imp\u00f4ts sur le revenu", "Imp\u00f4ts : Imp\u00f4ts sur le revenu-Ann\u00e9e pr\u00e9c.", "Imp\u00f4ts : Redevance audiovisuelle", "Imp\u00f4ts : Taxe d'habitation", "Imp\u00f4ts : Taxe fonci\u00e8re", "Logement", "Logement : Achat r\u00e9sidence principale", "Logement : Ameublement", "Logement : Am\u00e9nagement - Bricolage", "Logement : Entretien", "Logement : Frais de d\u00e9m\u00e9nagement", "Logement : Jardin", "Logement : Jardinage", "Logement : M\u00e9nage", "Logement : Syndic", "Logement : Travaux - D\u00e9coration", "Logement : Electrom\u00e9nager", "Logement : Equipement du logement", "Loisirs-culture", "Loisirs-culture : Activit\u00e9 sportive", "Loisirs-culture : Articles de sport", "Loisirs-culture : Cin\u00e9ma-spectacle", "Loisirs-culture : Cotisations clubs", "Loisirs-culture : Disques-cassettes", "Loisirs-culture : Equipement divers", "Loisirs-culture : Jeux", "Loisirs-culture : Livres", "Loisirs-culture : Logiciels", "Loisirs-culture : Manifestations sportives", "Pr\u00eat", "Pr\u00eat : Assurance de pr\u00eat", "Pr\u00eat : Capital", "Pr\u00eat : Frais de courtier", "Pr\u00eat : Int\u00e9r\u00eats du pr\u00eat immobilier", "Pr\u00eat : Maison", "Retrait d'esp\u00e8ces", "Revenus de placement", "Revenus de placement : Caution d'un logement", "Revenus de placement : Dividendes", "Revenus de placement : Int\u00e9r\u00eats exon\u00e9r\u00e9s d'imp\u00f4ts", "Revenus de placement : Loyer", "Revenus de placement : Plus-values", "Revenus de placement : Remboursement foncier part locataire", "Sant\u00e9", "Sant\u00e9 : Analyses m\u00e9dicales", "Sant\u00e9 : Compl\u00e9ments alimentaires", "Sant\u00e9 : Dentiste", "Sant\u00e9 : Dermatologue", "Sant\u00e9 : H\u00f4pital", "Sant\u00e9 : Kin\u00e9sith\u00e9rapeute", "Sant\u00e9 : M\u00e9decin", "Sant\u00e9 : Neurologue", "Sant\u00e9 : Oculiste", "Sant\u00e9 : Osth\u00e9opathe-\u00e9thiopathe", "Sant\u00e9 : Parapharmacie", "Sant\u00e9 : Pharmacie", "Sant\u00e9 : Radiographies", "Sant\u00e9 : Remb. CPAM", "Sant\u00e9 : Remb. Mutuelle", "Sant\u00e9 : Rhumatologue", "Traitements et salaires", "Traitements et salaires : Primes diverses", "Traitements et salaires : Remb. frais professionnels", "Traitements et salaires : Salaire net", "Transports", "Transports : Metro-Bus-Train", "Vacances", "Vacances : Alimentation-restaurant", "Vacances : Commission de change", "Vacances : Contentieux", "Vacances : Divers", "Vacances : Location de voiture", "Vacances : Logement", "Vacances : Restauration", "Vacances : Retrait d'esp\u00e8ces", "Vacances : Ski", "Vacances : S\u00e9jours", "Vacances : Voyage", "Virmt vers un compte supprim\u00e9"};

    public static void sort() {
        if (sorted) {
            Logger.debug(TAG, "sort: canceled (no changes)");
            return;
        }
        Logger.debug(TAG, "sort: " + categories.size() + " elements");
        Collections.sort(categories, Util.getCollator());
        sorted = true;
    }

    public static String addIfDontExist(String category) {
        return ACategory.addIfDontExist(category, true);
    }

    public static String addIfDontExist(String category, boolean checkCategory) {
        if (checkCategory && category != null && category.equals(Messages.getString("NoCategory"))) {
            return null;
        }
        String l_addedCat = ACategory.normalizeName(category);
        if (!categories.contains(l_addedCat)) {
            categories.add(l_addedCat);
            sorted = false;
            saved = false;
        }
        return l_addedCat;
    }

    public static void cleanCategories() {
        ArrayList<String> l_toBeRemoved = new ArrayList<String>();
        for (String l_cat : categories) {
            if (!l_cat.equals(Messages.getString("NoCategory"))) continue;
            l_toBeRemoved.add(l_cat);
        }
        for (String l_cat : l_toBeRemoved) {
            categories.remove(l_cat);
        }
    }

    public static void removeIfExists(String category) {
        if (categories.contains(category)) {
            categories.remove(category);
            sorted = false;
            saved = false;
        }
    }

    public static boolean contains(String category) {
        return categories.contains(category);
    }

    public static final List<String> getCategories() {
        ArrayList<String> l_catList = new ArrayList<String>();
        for (String l_cat : categories) {
            if (l_cat.startsWith("[")) continue;
            l_catList.add(l_cat);
        }
        return l_catList;
    }

    public static void restoreFromProperties(Properties props) {
        for (Object l_o : props.keySet()) {
            String l_s = (String)l_o;
            if (!l_s.startsWith("hmy.category")) continue;
            ACategory.addIfDontExist(props.getProperty(l_s), false);
        }
        sorted = false;
        ACategory.sort();
    }

    public static void putCategoriesInProperties(Properties props) {
        if (!saved) {
            ArrayList<String> l_tbrArray = new ArrayList<String>();
            for (Object l_o : props.keySet()) {
                String l_s = (String)l_o;
                if (!l_s.startsWith("hmy.category")) continue;
                l_tbrArray.add(l_s);
            }
            for (String l_key : l_tbrArray) {
                props.remove(l_key);
            }
            int l_catCount = 0;
            for (String l_cat : categories) {
                props.put("hmy.category" + ++l_catCount, l_cat);
            }
        }
    }

    public static void setSaved(boolean saved) {
        ACategory.saved = !saved;
    }

    public static boolean getSaved() {
        return saved;
    }

    public static int checkNewCategoryBeforeAddind(String newCategory) {
        if (newCategory == null || newCategory.length() < 2) {
            return 4;
        }
        String l_newCat = ACategory.normalizeName(newCategory);
        if (categories.contains(l_newCat)) {
            return 1;
        }
        if (newCategory.indexOf(":") != newCategory.lastIndexOf(":")) {
            return 2;
        }
        if (newCategory.contains("[") || newCategory.contains("]") || newCategory.contains(",")) {
            return 3;
        }
        return 0;
    }

    public static String normalizeName(String newCategory) {
        StringTokenizer l_st = new StringTokenizer(newCategory, ":");
        String l_sleft = null;
        String l_sright = null;
        if (l_st.hasMoreTokens() && !categories.contains(l_sleft = l_st.nextToken().trim())) {
            categories.add(l_sleft);
        }
        if (l_st.hasMoreTokens()) {
            l_sright = l_st.nextToken().trim();
        }
        return String.valueOf(l_sleft) + (l_sright != null && l_sright.length() > 0 ? " : " + l_sright : "");
    }

    public static void addDefaultCategories() {
        int i = 0;
        while (i < default_categories.length) {
            ACategory.addIfDontExist(default_categories[i], false);
            ++i;
        }
    }
}

