/*
 * Decompiled with CFR 0.152.
 */
package com.hmoney.data;

import com.hmoney.Logger;
import com.hmoney.data.ACategory;
import com.hmoney.data.AItemSplit;
import com.hmoney.data.Account;
import com.hmoney.data.Util;
import com.hmoney.messages.Messages;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.UUID;

public class AItem {
    private static final String TAG = AItem.class.getSimpleName();
    protected int flags = 0;
    public static final int FLAG_RBEXPENSE = 1;
    public static final int FLAG_CLEARED = 2;
    public static final int FLAG_RECONCILED = 4;
    public static final int FLAG_E_IMPORT = 8;
    public static final int FLAG_USER_NOT_VALIDATED = 16;
    public static final int FLAG_RECONCILIATED_WITH_PLANNED = 32;
    public static final String EXT_KEY_DOCUMENTS = "attachedDocs";
    protected long amount;
    protected long balance;
    protected Date date = new Date();
    protected String memo;
    protected String payee;
    protected String category;
    protected String num;
    protected UUID uuid;
    protected String hmoneyExt = null;
    protected String[] address;
    protected List<AItemSplit> splits = null;
    public AItem dup = null;
    protected String accountName;
    protected boolean saved = true;
    protected SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
    protected AItemSplit currentSplit = null;

    public AItem() {
        this(0L);
    }

    public AItem(long amount) {
        this.amount = amount;
        this.uuid = UUID.randomUUID();
    }

    public AItem(AItem copySrc, boolean copyCategory) {
        this.amount = copySrc.amount;
        this.balance = copySrc.balance;
        this.date = new Date(copySrc.date.getTime());
        if (copySrc.memo != null) {
            this.memo = new String(copySrc.memo);
        }
        this.flags = copySrc.flags;
        if (copySrc.payee != null) {
            this.payee = new String(copySrc.payee);
        }
        if (copyCategory && copySrc.category != null) {
            this.category = new String(copySrc.category);
        }
        if (copySrc.num != null) {
            this.num = new String(copySrc.num);
        }
        this.uuid = UUID.fromString(copySrc.uuid.toString());
        if (copySrc.hmoneyExt != null) {
            this.hmoneyExt = new String(copySrc.hmoneyExt);
        }
        if (copySrc.address != null) {
            this.address = copySrc.address;
        }
        if (copySrc.splits != null) {
            this.splits = copySrc.splits;
        }
        this.saved = false;
    }

    public void setNewUuid() {
        this.uuid = UUID.randomUUID();
    }

    public String toString() {
        int i;
        StringBuilder l_sb = new StringBuilder();
        l_sb.append("[" + this.getClass().getSimpleName() + ": date=" + this.date);
        l_sb.append(", amount=" + this.amount);
        l_sb.append(", memo=" + this.memo);
        l_sb.append(", payee=" + this.payee);
        l_sb.append(", category=" + this.category);
        l_sb.append(", num=" + this.num);
        l_sb.append(", uuid=" + this.uuid);
        l_sb.append(", hmoneyExt=" + this.hmoneyExt);
        l_sb.append(", flags=" + this.flags);
        if (this.address != null) {
            i = 0;
            while (i < 6) {
                if (this.address[i] == null) break;
                l_sb.append(", A" + i + "=" + this.address[i]);
                ++i;
            }
        }
        if (this.splits != null) {
            i = 0;
            for (AItemSplit l_qis : this.splits) {
                l_sb.append(", S" + ++i + ".category=" + l_qis.category);
                l_sb.append(", S" + i + ".amount=" + l_qis.amount);
                if (l_qis.memo != null && l_qis.memo.length() > 0) {
                    l_sb.append(", S" + i + ".memo=" + l_qis.memo);
                }
                if (!(l_qis.percent > 0.0f)) continue;
                l_sb.append(", S" + i + ".percent=" + l_qis.percent);
            }
        }
        l_sb.append("]\n");
        return l_sb.toString();
    }

    public String[] getDocuments() {
        String l_docs = this.getExtAttribute(EXT_KEY_DOCUMENTS);
        if (l_docs != null) {
            return l_docs.split(",");
        }
        return null;
    }

    public void addDocument(String fileName) {
        String l_docs = this.getExtAttribute(EXT_KEY_DOCUMENTS);
        l_docs = l_docs != null ? String.valueOf(l_docs) + "," + fileName : fileName;
        this.setExtAttribute(EXT_KEY_DOCUMENTS, l_docs);
    }

    public void removeDocument(String removedDoc) {
        String[] l_docs = this.getDocuments();
        if (l_docs == null) {
            return;
        }
        String l_newDocs = null;
        int i = 0;
        while (i < l_docs.length) {
            if (!l_docs[i].equals(removedDoc)) {
                l_newDocs = String.valueOf(l_newDocs == null || l_newDocs.length() < 2 ? "" : String.valueOf(l_newDocs) + ",") + l_docs[i];
            }
            ++i;
        }
        this.setExtAttribute(EXT_KEY_DOCUMENTS, l_newDocs);
    }

    protected void addSplit(AItemSplit split) {
        if (this.splits == null) {
            this.splits = new ArrayList<AItemSplit>();
        }
        this.splits.add(split);
    }

    public String getAmountString() {
        return Util.longAmountToString(this.amount);
    }

    public String getAmountStringForSave() {
        String l_amountForSave = Util.longAmountToString(this.amount);
        return l_amountForSave.replace(" ", "");
    }

    public long getLongAmount() {
        return this.amount;
    }

    public void setLongAmount(long amount) {
        this.amount = amount;
        this.saved = false;
        this.checkCounterPart();
    }

    public boolean isNegativeAmount() {
        return this.amount < 0L;
    }

    public String getBalanceString() {
        return Util.longAmountToString(this.balance);
    }

    public long getLongBalance() {
        return this.balance;
    }

    public boolean isNegativeBalance() {
        return this.balance < 0L;
    }

    public void save(BufferedWriter bw) throws Exception {
        bw.write("D" + this.dateFormat.format(this.date) + "\n");
        bw.write("T" + this.getAmountStringForSave() + "\n");
        if (this.category != null && this.category.length() > 0) {
            bw.write("L" + this.category + "\n");
        }
        if (this.payee != null && this.payee.length() > 0) {
            bw.write("P" + this.payee + "\n");
        }
        if (this.memo != null && this.memo.length() > 0) {
            bw.write("M" + this.memo + "\n");
        }
        if (this.num != null && this.num.length() > 0) {
            bw.write("N" + this.num + "\n");
        }
        bw.write("U" + this.uuid.toString() + "\n");
        if (this.hmoneyExt != null && this.hmoneyExt.length() > 0) {
            bw.write("H" + this.hmoneyExt + "\n");
        }
        bw.write("*" + this.flags + "\n");
        if (this.address != null) {
            int i = 0;
            while (i < 6) {
                if (this.address[i] == null) break;
                bw.write("A" + this.address[i] + "\n");
                ++i;
            }
        }
        if (this.splits != null) {
            for (AItemSplit l_ais : this.splits) {
                l_ais.save(bw);
            }
        }
        bw.write("^\n");
        if (this.dup != null) {
            this.dup.uuid = this.uuid;
            this.dup.save(bw);
        }
        this.saved = true;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        if (this.date != null && this.date.equals(date)) {
            return;
        }
        this.date = date;
        this.saved = false;
        this.checkCounterPart();
    }

    public String getMemo() {
        return this.memo;
    }

    public void setMemo(String memo) {
        if (Util.compareString(this.memo, memo) == 0) {
            return;
        }
        this.memo = memo;
        this.saved = false;
        this.checkCounterPart();
    }

    public boolean isCleared() {
        return (this.flags & 2) > 0;
    }

    public void setCleared(boolean cleared) {
        if (cleared == (this.flags & 2) > 0) {
            return;
        }
        this.flags = cleared ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
        this.saved = false;
        this.checkCounterPart();
    }

    public boolean isReconciled() {
        return (this.flags & 4) > 0;
    }

    public void setReconciled(boolean reconciled) {
        if (reconciled == (this.flags & 4) > 0) {
            return;
        }
        this.flags = reconciled ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
        this.saved = false;
        this.checkCounterPart();
    }

    public boolean isEImport() {
        return (this.flags & 8) > 0;
    }

    public void setEImport(boolean eImport) {
        if (eImport == (this.flags & 8) > 0) {
            return;
        }
        this.flags = eImport ? (this.flags |= 8) : (this.flags &= 0xFFFFFFF7);
        this.saved = false;
        this.checkCounterPart();
    }

    public boolean isReconciliatedWithPlanned() {
        return (this.flags & 0x20) > 0;
    }

    public void setReconciliatedWithPlanned(boolean recon) {
        if (recon == (this.flags & 0x20) > 0) {
            return;
        }
        this.flags = recon ? (this.flags |= 0x20) : (this.flags &= 0xFFFFFFDF);
        this.saved = false;
        this.checkCounterPart();
    }

    public boolean isUserValidated() {
        return (this.flags & 0x10) <= 0;
    }

    public void setUserValidated(boolean validated, Account account) {
        String l_tmpCategory = null;
        if (!validated == (this.flags & 0x10) > 0) {
            return;
        }
        if (validated && this.category != null && (this.category.startsWith(Messages.getString("TransferOperationBaseCategory")) || this.category.startsWith("["))) {
            l_tmpCategory = this.category;
            this.category = null;
        }
        this.flags = !validated ? (this.flags |= 0x10) : (this.flags &= 0xFFFFFFEF);
        if (l_tmpCategory != null) {
            this.setCategory(l_tmpCategory, account);
        }
        this.saved = false;
        this.checkCounterPart();
    }

    public boolean isRbexpense() {
        return (this.flags & 1) > 0;
    }

    public void setRbexpense(boolean rbexpense) {
        if (rbexpense == (this.flags & 1) > 0) {
            return;
        }
        this.flags = rbexpense ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
        this.saved = false;
        this.checkCounterPart();
    }

    public String getPayee() {
        return this.payee;
    }

    public void setPayee(String payee) {
        if (Util.compareString(this.payee, payee) == 0) {
            return;
        }
        this.payee = payee;
        this.saved = false;
        this.checkCounterPart();
    }

    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String categorySet, Account ownerAccount) {
        Account l_transferAccount;
        String l_transferAccountName;
        if (categorySet != null && categorySet.equals(Messages.getString("NoCategory"))) {
            categorySet = null;
        }
        if (Util.compareString(this.category, categorySet) == 0) {
            return;
        }
        if (this.isUserValidated() && this.category != null && this.category.startsWith("[")) {
            Logger.debug(TAG, "setCategory : Transfer detected, operation was=" + this.toString());
            l_transferAccountName = this.category.substring(1, this.category.length() - 1).trim();
            l_transferAccount = Account.getAccountByName(l_transferAccountName);
            if (l_transferAccount != null) {
                l_transferAccount.removeItemWithoutCategoryCheck(l_transferAccount.getAItemByUuid(this.uuid));
                l_transferAccount.calculateBalance();
            }
        }
        this.category = categorySet;
        this.saved = false;
        if (this.isUserValidated() && this.category != null && (this.category.startsWith(Messages.getString("TransferOperationBaseCategory")) || this.category.startsWith("["))) {
            l_transferAccountName = null;
            if (this.category.startsWith("[")) {
                l_transferAccountName = this.category.substring(1, this.category.length() - 1).trim();
            } else if (this.category.startsWith(Messages.getString("TransferOperationBaseCategory"))) {
                StringTokenizer l_st = new StringTokenizer(this.category, ":");
                l_st.nextToken();
                l_transferAccountName = l_st.nextToken().trim();
            }
            l_transferAccount = Account.getAccountByName(l_transferAccountName);
            if (l_transferAccount != null && ownerAccount != null) {
                this.category = "[" + l_transferAccountName + "]";
                AItem l_counterPart = new AItem(this, false);
                l_counterPart.category = "[" + ownerAccount.accountName + "]";
                l_transferAccount.addItem(l_counterPart);
                this.checkCounterPart();
            }
        }
    }

    private void checkCounterPart() {
        if (this.category == null || !this.category.startsWith("[")) {
            return;
        }
        String l_transferAccountName = this.category.substring(1, this.category.length() - 1).trim();
        Account l_transferAccount = Account.getAccountByName(l_transferAccountName);
        if (l_transferAccount == null) {
            return;
        }
        AItem l_ai = l_transferAccount.getAItemByUuid(this.uuid);
        if (l_ai == null) {
            return;
        }
        if (this.num != null) {
            l_ai.num = new String(this.num);
        }
        if (this.payee != null) {
            l_ai.payee = new String(this.payee);
        }
        if (this.memo != null) {
            l_ai.memo = new String(this.memo);
        }
        l_ai.flags = this.flags;
        l_ai.address = this.address;
        l_ai.splits = this.splits;
        l_ai.amount = -this.amount;
        l_ai.saved = false;
        l_transferAccount.calculateBalance();
    }

    public String getNum() {
        return this.num;
    }

    public void setNum(String num) {
        if (Util.compareString(this.num, num) == 0) {
            return;
        }
        this.num = num;
        this.saved = false;
        this.checkCounterPart();
    }

    public String[] getAddress() {
        return this.address;
    }

    public void setAddress(String[] address) {
        this.address = address;
        this.saved = false;
        this.checkCounterPart();
    }

    public List<AItemSplit> getSplits() {
        return this.splits;
    }

    public void setSplits(List<AItemSplit> splits) {
        this.splits = splits;
        this.saved = false;
        this.checkCounterPart();
    }

    public AItem(String firstLine, BufferedReader br, boolean dateDayFirst) throws Exception {
        this.getData(firstLine, dateDayFirst);
        while (true) {
            String l_line;
            if ((l_line = br.readLine()) == null || l_line.startsWith("^")) break;
            this.getData(l_line, dateDayFirst);
        }
        this.finalizeCurrentSplit();
    }

    private void finalizeCurrentSplit() throws Exception {
        if (this.currentSplit != null && this.currentSplit.category != null && this.currentSplit.amount > 0L) {
            this.addSplit(this.currentSplit);
            this.currentSplit = null;
        }
    }

    private void getData(String line, boolean dateDayFirst) throws Exception {
        if (line.startsWith("D")) {
            this.date = Util.parseDate(line.substring(1), dateDayFirst);
        } else if (line.startsWith("T")) {
            this.amount = Util.parseAmount(line.substring(1));
        } else if (line.startsWith("M")) {
            this.memo = line.substring(1);
        } else if (line.startsWith("*")) {
            this.flags = Integer.parseInt(line.substring(1));
        } else if (line.startsWith("N")) {
            this.num = line.substring(1);
        } else if (line.startsWith("U")) {
            this.uuid = UUID.fromString(line.substring(1));
        } else if (line.startsWith("H")) {
            this.hmoneyExt = line.substring(1);
        } else if (line.startsWith("P")) {
            this.payee = line.substring(1);
        } else if (line.startsWith("L")) {
            this.category = ACategory.addIfDontExist(line.substring(1));
        } else if (line.startsWith("A")) {
            if (this.address == null) {
                this.address = new String[6];
            }
            int i = 0;
            while (i < 6) {
                if (this.address[i] == null) {
                    this.address[i] = line.substring(1);
                    break;
                }
                ++i;
            }
        } else if (line.startsWith("S")) {
            this.finalizeCurrentSplit();
            if (this.currentSplit == null) {
                this.currentSplit = new AItemSplit();
            }
            this.currentSplit.category = ACategory.addIfDontExist(line.substring(1));
        }
        if (line.startsWith("E")) {
            this.finalizeCurrentSplit();
            if (this.currentSplit == null) {
                this.currentSplit = new AItemSplit();
            }
            this.currentSplit.memo = line.substring(1);
        }
        if (line.startsWith("$")) {
            this.finalizeCurrentSplit();
            if (this.currentSplit == null) {
                this.currentSplit = new AItemSplit();
            }
            this.currentSplit.amount = Util.parseAmount(line.substring(1));
        }
        if (line.startsWith("%")) {
            this.finalizeCurrentSplit();
            if (this.currentSplit == null) {
                this.currentSplit = new AItemSplit();
            }
            this.currentSplit.percent = Float.parseFloat(line.substring(1));
        }
    }

    public String getExtAttribute(String key) {
        if (this.hmoneyExt == null) {
            return null;
        }
        StringTokenizer l_st = new StringTokenizer(this.hmoneyExt, "|");
        while (l_st.hasMoreTokens()) {
            StringTokenizer l_st2 = new StringTokenizer(l_st.nextToken(), "=");
            if (l_st2.countTokens() != 2 || !l_st2.nextToken().equals(key)) continue;
            return l_st2.nextToken();
        }
        return null;
    }

    public void removeExtAttribute(String key) {
        this.setExtAttribute(key, null);
    }

    public void setExtAttribute(String key, String value) {
        if (this.hmoneyExt == null) {
            if (value != null) {
                this.hmoneyExt = String.valueOf(key) + "=" + value;
            }
            return;
        }
        String l_hmoneyExtNew = "";
        StringTokenizer l_st = new StringTokenizer(this.hmoneyExt, "|");
        boolean l_done = false;
        while (l_st.hasMoreTokens()) {
            StringTokenizer l_st2 = new StringTokenizer(l_st.nextToken(), "=");
            if (l_st2.countTokens() != 2) continue;
            String l_key = l_st2.nextToken();
            String l_value = l_st2.nextToken();
            if (l_key.equals(key)) {
                if (value != null) {
                    l_hmoneyExtNew = String.valueOf(l_hmoneyExtNew) + (l_hmoneyExtNew.length() < 2 ? "" : "|") + key + "=" + value;
                }
                l_done = true;
                continue;
            }
            l_hmoneyExtNew = String.valueOf(l_hmoneyExtNew) + (l_hmoneyExtNew.length() < 2 ? "" : "|") + l_key + "=" + l_value;
        }
        if (!l_done) {
            l_hmoneyExtNew = String.valueOf(l_hmoneyExtNew) + "|" + key + "=" + value;
        }
        this.saved = false;
        this.hmoneyExt = l_hmoneyExtNew;
        if (this.hmoneyExt.length() < 2) {
            this.hmoneyExt = null;
        }
    }
}

