/*
 * Decompiled with CFR 0.152.
 */
package com.hmoney.data;

import com.hmoney.Logger;
import com.hmoney.data.ACategory;
import com.hmoney.data.AItem;
import com.hmoney.data.AItemSplit;
import com.hmoney.data.Util;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;

public class QifImportExport {
    private static final String TAG = QifImportExport.class.getSimpleName();
    private static final String QIF_ACCOUNT_TYPE_TAG = "!Type";
    private List<AItem> qifItemList = new ArrayList<AItem>();

    public List<AItem> loadFile(String fileName, boolean dateDayFirst, boolean isMoneyMigration) throws Exception {
        BufferedReader l_br = null;
        try {
            Logger.info(TAG, "loadFile(" + fileName + ", " + dateDayFirst + ")");
            l_br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "ISO-8859-1"));
            String l_line = l_br.readLine();
            StringTokenizer l_st = new StringTokenizer(l_line, ":");
            if (l_st.nextToken().equalsIgnoreCase(QIF_ACCOUNT_TYPE_TAG)) {
                String l_accountType = l_st.nextToken();
                if (!(l_accountType.equalsIgnoreCase("Cash") || l_accountType.equalsIgnoreCase("Bank") || l_accountType.equalsIgnoreCase("CCard") || l_accountType.equalsIgnoreCase("Oth A") || l_accountType.equalsIgnoreCase("Oth L"))) {
                    throw new Exception("Account type is not handled by application : " + l_accountType);
                }
            } else {
                throw new Exception("Invalid QIF file");
            }
            while ((l_line = l_br.readLine()) != null) {
                AItem l_ai = new AItem();
                this.readQifItem(l_ai, l_line, l_br, dateDayFirst, isMoneyMigration);
                if (l_ai.getPayee() == null && l_ai.getMemo() != null) {
                    l_ai.setPayee(l_ai.getMemo());
                }
                if (l_ai.getDate() == null) {
                    l_ai.setDate(new Date());
                }
                l_ai.setEImport(true);
                l_ai.setUserValidated(false, null);
                this.qifItemList.add(l_ai);
            }
        }
        finally {
            if (l_br != null) {
                l_br.close();
            }
            ACategory.sort();
        }
        return this.qifItemList;
    }

    private void finalizeCurrentSplit(AItem aItem) throws Exception {
        if (aItem.currentSplit != null && aItem.currentSplit.category != null && aItem.currentSplit.amount > 0L) {
            aItem.addSplit(aItem.currentSplit);
            aItem.currentSplit = null;
        }
    }

    private void readQifItem(AItem aItem, String firstLine, BufferedReader br, boolean dateDayFirst, boolean isMoneyMigration) throws Exception {
        this.getData(aItem, firstLine, dateDayFirst, isMoneyMigration);
        while (true) {
            String l_line;
            if ((l_line = br.readLine()) == null || l_line.startsWith("^")) break;
            this.getData(aItem, l_line, dateDayFirst, isMoneyMigration);
        }
        this.finalizeCurrentSplit(aItem);
    }

    private void getData(AItem aItem, String line, boolean dateDayFirst, boolean isMoneyMigration) throws Exception {
        if (line.startsWith("D")) {
            aItem.setDate(Util.parseDate(line.substring(1), dateDayFirst));
        } else if (line.startsWith("T")) {
            aItem.setLongAmount(Util.parseAmount(line.substring(1)));
        } else if (line.startsWith("M")) {
            aItem.setMemo(line.substring(1));
        } else if (line.startsWith("*") || line.startsWith("C") || line.startsWith("R") || line.startsWith("X")) {
            if (line.contains("C") || line.contains("*")) {
                aItem.setCleared(true);
            }
            if (line.contains("R") || line.contains("X")) {
                aItem.setReconciled(true);
            }
        } else if (line.startsWith("N")) {
            aItem.setNum(line.substring(1));
        } else if (line.startsWith("P")) {
            aItem.setPayee(line.substring(1));
        } else if (line.startsWith("L") && isMoneyMigration) {
            aItem.category = ACategory.addIfDontExist(line.substring(1));
        } else if (line.startsWith("A")) {
            if (aItem.address == null) {
                aItem.address = new String[6];
            }
            int i = 0;
            while (i < 6) {
                if (aItem.address[i] == null) {
                    aItem.address[i] = line.substring(1);
                    break;
                }
                ++i;
            }
        } else if (line.startsWith("F")) {
            aItem.setRbexpense(true);
        } else if (line.startsWith("S")) {
            this.finalizeCurrentSplit(aItem);
            if (aItem.currentSplit == null) {
                aItem.currentSplit = new AItemSplit();
            }
            aItem.currentSplit.category = ACategory.addIfDontExist(line.substring(1));
        }
        if (line.startsWith("E")) {
            this.finalizeCurrentSplit(aItem);
            if (aItem.currentSplit == null) {
                aItem.currentSplit = new AItemSplit();
            }
            aItem.currentSplit.memo = line.substring(1);
        }
        if (line.startsWith("$")) {
            this.finalizeCurrentSplit(aItem);
            if (aItem.currentSplit == null) {
                aItem.currentSplit = new AItemSplit();
            }
            aItem.currentSplit.amount = Util.parseAmount(line.substring(1));
        }
        if (line.startsWith("%")) {
            this.finalizeCurrentSplit(aItem);
            if (aItem.currentSplit == null) {
                aItem.currentSplit = new AItemSplit();
            }
            aItem.currentSplit.percent = Float.parseFloat(line.substring(1));
        }
    }

    public void save(BufferedWriter bw, AItem aItem) throws Exception {
        bw.write("D" + aItem.dateFormat.format(aItem.date) + "\n");
        bw.write("T" + aItem.getAmountStringForSave() + "\n");
        if (aItem.category != null && aItem.category.length() > 0) {
            bw.write("L" + aItem.category + "\n");
        }
        if (aItem.payee != null && aItem.payee.length() > 0) {
            bw.write("P" + aItem.payee + "\n");
        }
        if (aItem.memo != null && aItem.memo.length() > 0) {
            bw.write("M" + aItem.memo + "\n");
        }
        if (aItem.num != null && aItem.num.length() > 0) {
            bw.write("N" + aItem.num + "\n");
        }
        bw.write("U" + aItem.uuid.toString() + "\n");
        if ((aItem.flags & 4) > 0 || (aItem.flags & 2) > 0) {
            bw.write(String.valueOf((aItem.flags & 2) > 0 ? "C" : "") + ((aItem.flags & 4) > 0 ? "R" : "") + "\n");
        }
        if ((aItem.flags & 1) > 0) {
            bw.write("F\n");
        }
        if (aItem.address != null) {
            int i = 0;
            while (i < 6) {
                if (aItem.address[i] == null) break;
                bw.write("A" + aItem.address[i] + "\n");
                ++i;
            }
        }
        if (aItem.splits != null) {
            for (AItemSplit l_ais : aItem.splits) {
                l_ais.save(bw);
            }
        }
        bw.write("^\n");
    }
}

