/*
 * Decompiled with CFR 0.152.
 */
package com.hmoney.gui;

import com.hmoney.Logger;
import com.hmoney.data.APlannedItem;
import com.hmoney.data.Account;
import com.hmoney.data.Util;
import com.hmoney.gui.GuiUtil;
import com.hmoney.gui.MainWindow;
import com.hmoney.gui.custom.DateChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;

public class APlannedItemTableCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private static final String TAG = APlannedItemTableCellEditor.class.getSimpleName();
    private int row;
    private int column;
    private JTextField textFieldEditor = new JTextField();
    private JComboBox<String> categoryComboBox = null;
    private JComboBox<String> accountComboBox = new JComboBox();
    private JComboBox<String> periodComboBox = new JComboBox();

    public APlannedItemTableCellEditor() {
        Logger.debug(TAG, "APlannedItemTableCellEditor constructor()");
        int i = 1;
        while (i <= 9) {
            this.periodComboBox.addItem(APlannedItem.getPeriodicityLabel(i));
            ++i;
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        Logger.debug(TAG, "getTableCellEditorComponent: value=" + value + ", isSelected=" + isSelected + ", row=" + row + ", column=" + column);
        this.row = row;
        this.column = column;
        switch (column) {
            case 1: {
                this.accountComboBox.removeAllItems();
                for (Account l_a : Account.openAccounts) {
                    this.accountComboBox.addItem(l_a.accountName);
                }
                this.accountComboBox.setSelectedItem((String)table.getValueAt(row, column));
                return this.accountComboBox;
            }
            case 3: {
                this.periodComboBox.setSelectedItem(table.getValueAt(row, column));
                return this.periodComboBox;
            }
            case 4: {
                this.categoryComboBox = GuiUtil.getCategoriesComboBox(null);
                this.categoryComboBox.setSelectedItem((String)table.getValueAt(row, column));
                JPanel l_panel = new JPanel();
                l_panel.setLayout(new BorderLayout());
                l_panel.add(this.categoryComboBox);
                try {
                    JButton l_chooseCategoryButton = GuiUtil.getChooseCategoryButton(22, 22);
                    l_chooseCategoryButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            GuiUtil.getCategoryPopup(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    String l_cat = GuiUtil.getCategoryChosenInCategoryPopup(e);
                                    APlannedItemTableCellEditor.this.categoryComboBox.setSelectedItem(l_cat);
                                }
                            }, null).show((Component)e.getSource(), 0, 0);
                        }
                    });
                    l_panel.add((Component)l_chooseCategoryButton, "East");
                    l_chooseCategoryButton.setPreferredSize(new Dimension(22, 22));
                    l_panel.revalidate();
                }
                catch (Exception l_chooseCategoryButton) {
                    // empty catch block
                }
                return l_panel;
            }
            case 2: {
                JPanel l_panel = new JPanel();
                l_panel.setLayout(new BorderLayout());
                this.textFieldEditor.setText((String)table.getValueAt(row, column));
                l_panel.add(this.textFieldEditor);
                try {
                    Date l_initDate;
                    try {
                        l_initDate = Util.parseDate(this.textFieldEditor.getText(), Util.getDateDayFirst());
                    }
                    catch (Exception e) {
                        l_initDate = Util.parseDate((String)table.getValueAt(row, column), Util.getDateDayFirst());
                    }
                    final Date l_opDate = l_initDate;
                    JButton l_chooseDateButton = GuiUtil.getChooseDateButton(22, 22);
                    l_chooseDateButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            String l_chosenDate = new DateChooser(MainWindow.getFrame(), l_opDate).getPickedDate();
                            if (l_chosenDate != null && l_chosenDate.length() > 0) {
                                APlannedItemTableCellEditor.this.textFieldEditor.setText(l_chosenDate);
                            }
                        }
                    });
                    l_panel.add((Component)l_chooseDateButton, "East");
                    l_chooseDateButton.setPreferredSize(new Dimension(22, 22));
                    l_panel.revalidate();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return l_panel;
            }
        }
        this.textFieldEditor.setText((String)table.getValueAt(row, column));
        return this.textFieldEditor;
    }

    @Override
    public Object getCellEditorValue() {
        Object l_res = null;
        switch (this.column) {
            case 3: {
                l_res = this.periodComboBox.getSelectedItem();
                break;
            }
            case 1: {
                l_res = this.accountComboBox.getSelectedItem();
                break;
            }
            case 4: {
                l_res = this.categoryComboBox.getSelectedItem();
                break;
            }
            default: {
                l_res = this.textFieldEditor.getText();
            }
        }
        Logger.debug(TAG, "getCellEditorValue: row=" + this.row + ", column=" + this.column + " returns Object=" + l_res);
        return l_res;
    }

    @Override
    public void fireEditingStopped() {
        Logger.debug(TAG, "fireEditingStopped()");
        super.fireEditingStopped();
    }

    @Override
    public void fireEditingCanceled() {
        Logger.debug(TAG, "fireEditingCanceled()");
        super.fireEditingStopped();
    }
}

