/*
 * Decompiled with CFR 0.152.
 */
package com.hmoney.gui;

import com.hmoney.Logger;
import com.hmoney.data.Util;
import com.hmoney.gui.MainWindow;
import com.hmoney.properties.HMProperties;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;

public class HMFrameListener
implements WindowListener,
WindowStateListener,
ComponentListener {
    private static final String TAG = HMFrameListener.class.getSimpleName();
    private WindowEvent lastStateWindowEvent = null;
    private int lastWidth = 0;
    private int lastHeight = 0;

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent we) {
        Util.saveAll(false);
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowStateChanged(WindowEvent e) {
        Logger.verbose(TAG, "windowStateChanged: " + e.toString());
        HMProperties.putProperty("frame.state", e.getNewState());
        switch (e.getNewState()) {
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                this.lastStateWindowEvent = e;
                break;
            }
            case 0: {
                this.lastStateWindowEvent = e;
            }
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
        Logger.verbose(TAG, "componentResized: " + e.toString());
        if (this.lastStateWindowEvent != null) {
            switch (this.lastStateWindowEvent.getNewState()) {
                case 1: 
                case 2: 
                case 4: 
                case 6: {
                    return;
                }
            }
        }
        HMProperties.putProperty("frame.left", MainWindow.getFrame().getX());
        HMProperties.putProperty("frame.top", MainWindow.getFrame().getY());
        this.lastWidth = MainWindow.getFrame().getWidth();
        HMProperties.putProperty("frame.width", this.lastWidth);
        this.lastHeight = MainWindow.getFrame().getHeight();
        HMProperties.putProperty("frame.height", this.lastHeight);
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        Logger.verbose(TAG, "componentMoved: " + e.toString());
        if (this.lastStateWindowEvent != null) {
            switch (this.lastStateWindowEvent.getNewState()) {
                case 1: 
                case 2: 
                case 4: 
                case 6: {
                    return;
                }
            }
        }
        if (this.lastWidth == 0 && this.lastWidth == 0 || MainWindow.getFrame().getWidth() == this.lastWidth && MainWindow.getFrame().getHeight() == this.lastHeight) {
            HMProperties.putProperty("frame.left", MainWindow.getFrame().getX());
            HMProperties.putProperty("frame.top", MainWindow.getFrame().getY());
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }
}

