/*
 * Decompiled with CFR 0.152.
 */
package com.hmoney.gui;

import com.hmoney.data.AItem;
import com.hmoney.data.APlannedItem;
import com.hmoney.data.Account;
import com.hmoney.data.Util;
import com.hmoney.gui.Constants;
import com.hmoney.gui.GuiUtil;
import com.hmoney.gui.IKeyboardListener;
import com.hmoney.gui.MainWindow;
import com.hmoney.gui.custom.DateChooser;
import com.hmoney.gui.custom.KeyboardMainListener;
import com.hmoney.messages.Messages;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class NewPlannedOperationDialog
extends JDialog
implements IKeyboardListener {
    private JTextField textFieldDate;
    private JTextField textFieldPayee;
    private JTextField textFieldMemo;
    private JTextField textFieldAmount;
    private JComboBox<String> comboBoxCategory;
    private JComboBox<String> accountComboBox;
    private JComboBox<String> periodComboBox;
    JRadioButton rdbtnDebit;
    public boolean okSelected = false;
    APlannedItem aPlannedItem = null;
    AItem baseAItem;
    String baseItemAccountName;

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            KeyboardMainListener.addCurrentListener(this);
            final NewPlannedOperationDialog thisNewOperationDialog = this;
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    KeyboardMainListener.removeListener(thisNewOperationDialog);
                }
            });
        }
        super.setVisible(visible);
    }

    @Override
    public void escapeKeyTyped() {
        this.dispose();
    }

    @Override
    public void enterKeyTyped() {
    }

    @Override
    public void deleteKeyTyped() {
    }

    public NewPlannedOperationDialog(JFrame frame, String title, boolean modal) {
        this(frame, title, modal, null, null);
    }

    public NewPlannedOperationDialog(JFrame frame, String title, boolean modal, AItem baseAItem, String baseItemAccountName) {
        super(frame, title, modal);
        this.setResizable(false);
        this.setSize(579, 509);
        this.setLocation(frame.getX() + 300, frame.getY() + 300);
        this.getContentPane().setLayout(null);
        this.baseAItem = baseAItem;
        this.baseItemAccountName = baseItemAccountName;
        JLabel lblDate = new JLabel("Prochaine \u00e9ch\u00e9ance");
        lblDate.setFont(new Font("Tahoma", 1, 12));
        lblDate.setBounds(335, 166, 134, 20);
        this.getContentPane().add(lblDate);
        this.periodComboBox = new JComboBox();
        this.periodComboBox.setBounds(10, 111, 427, 27);
        int i = 1;
        while (i <= 9) {
            this.periodComboBox.addItem(APlannedItem.getPeriodicityLabel(i));
            ++i;
        }
        this.getContentPane().add(this.periodComboBox);
        this.periodComboBox.setSelectedIndex(3);
        this.textFieldDate = new JTextField();
        GregorianCalendar l_gc = new GregorianCalendar();
        l_gc.setTime(baseAItem != null ? baseAItem.getDate() : new Date());
        l_gc.add(2, 1);
        this.textFieldDate.setText(Util.getSimpleDateFormatter().format(l_gc.getTime()));
        this.textFieldDate.setColumns(10);
        this.textFieldDate.setBounds(335, 188, 165, 27);
        this.getContentPane().add(this.textFieldDate);
        JLabel lblDdmmyyyy = new JLabel(Util.getDateUserInputTemplate());
        lblDdmmyyyy.setBounds(338, 218, 180, 16);
        this.getContentPane().add(lblDdmmyyyy);
        JLabel lblNum = new JLabel("P\u00e9riodicit\u00e9");
        lblNum.setFont(new Font("Tahoma", 1, 12));
        lblNum.setBounds(10, 86, 158, 14);
        this.getContentPane().add(lblNum);
        JLabel lblPayee = new JLabel("Tiers");
        lblPayee.setBounds(10, 251, 46, 14);
        this.getContentPane().add(lblPayee);
        this.textFieldPayee = new JTextField();
        this.textFieldPayee.setBounds(10, 267, 546, 27);
        this.getContentPane().add(this.textFieldPayee);
        if (baseAItem != null && baseAItem.getPayee() != null) {
            this.textFieldPayee.setText(baseAItem.getPayee());
        }
        this.textFieldPayee.setColumns(10);
        JLabel lblCategory = new JLabel("Cat\u00e9gorie");
        lblCategory.setBounds(10, 305, 210, 14);
        this.getContentPane().add(lblCategory);
        this.comboBoxCategory = GuiUtil.getCategoriesComboBox(null);
        this.comboBoxCategory.setBounds(9, 323, 490, 27);
        if (baseAItem != null && baseAItem.getCategory() != null) {
            this.comboBoxCategory.setSelectedItem(Util.getUserFriendlyCategoryString(baseAItem.getCategory()));
        }
        this.getContentPane().add(this.comboBoxCategory);
        JLabel lblMemo = new JLabel("Commentaire");
        lblMemo.setBounds(10, 361, 195, 14);
        this.getContentPane().add(lblMemo);
        this.textFieldMemo = new JTextField();
        this.textFieldMemo.setBounds(10, 379, 546, 27);
        if (baseAItem != null && baseAItem.getMemo() != null) {
            this.textFieldMemo.setText(baseAItem.getMemo());
        }
        this.getContentPane().add(this.textFieldMemo);
        this.textFieldMemo.setColumns(10);
        JLabel lblMontant = new JLabel("Montant");
        lblMontant.setFont(new Font("Tahoma", 1, 12));
        lblMontant.setBounds(129, 172, 180, 14);
        this.getContentPane().add(lblMontant);
        this.textFieldAmount = new JTextField();
        this.textFieldAmount.setBounds(129, 188, 165, 27);
        if (baseAItem != null) {
            this.textFieldAmount.setText(baseAItem.getAmountString().startsWith("-") ? baseAItem.getAmountString().substring(1) : baseAItem.getAmountString());
        }
        this.getContentPane().add(this.textFieldAmount);
        this.textFieldAmount.setColumns(10);
        JButton btnCancel = new JButton("Cancel");
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewPlannedOperationDialog.this.dispose();
            }
        });
        btnCancel.setBounds(96, 431, 143, 39);
        this.getContentPane().add(btnCancel);
        JButton btnOk = new JButton("OK");
        btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewPlannedOperationDialog.this.aPlannedItem = new APlannedItem();
                if (NewPlannedOperationDialog.this.textFieldPayee.getText().length() > 0) {
                    NewPlannedOperationDialog.this.aPlannedItem.setPayee(NewPlannedOperationDialog.this.textFieldPayee.getText());
                }
                if (NewPlannedOperationDialog.this.textFieldMemo.getText().length() > 0) {
                    NewPlannedOperationDialog.this.aPlannedItem.setMemo(NewPlannedOperationDialog.this.textFieldMemo.getText());
                }
                NewPlannedOperationDialog.this.aPlannedItem.setAccountName(NewPlannedOperationDialog.this.accountComboBox.getSelectedItem().toString());
                NewPlannedOperationDialog.this.aPlannedItem.setPeriodicity(APlannedItem.getPeriodicityFromLabel(NewPlannedOperationDialog.this.periodComboBox.getSelectedItem().toString()));
                try {
                    NewPlannedOperationDialog.this.aPlannedItem.setLongAmount(Util.parseAmount(NewPlannedOperationDialog.this.textFieldAmount.getText()));
                    if (NewPlannedOperationDialog.this.rdbtnDebit.isSelected()) {
                        NewPlannedOperationDialog.this.aPlannedItem.setLongAmount(-NewPlannedOperationDialog.this.aPlannedItem.getLongAmount());
                    }
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(NewPlannedOperationDialog.this.getContentPane(), "Le montant doit \u00eatre une valeur num\u00e9rique.", Messages.getString("WINDOW_TITLE_ERROR"), 0);
                    return;
                }
                try {
                    Date date = Util.parseDate(NewPlannedOperationDialog.this.textFieldDate.getText(), Util.getDateDayFirst());
                    NewPlannedOperationDialog.this.aPlannedItem.setDate(date);
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(NewPlannedOperationDialog.this.getContentPane(), "Date invalide", Messages.getString("WINDOW_TITLE_ERROR"), 0);
                    NewPlannedOperationDialog.this.textFieldDate.setText(Util.getDateUserInputTemplate());
                    return;
                }
                if (NewPlannedOperationDialog.this.comboBoxCategory.getSelectedIndex() > -1) {
                    NewPlannedOperationDialog.this.aPlannedItem.setCategory(NewPlannedOperationDialog.this.comboBoxCategory.getSelectedItem().toString());
                }
                NewPlannedOperationDialog.this.okSelected = true;
                NewPlannedOperationDialog.this.dispose();
            }
        });
        btnOk.setBounds(334, 431, 143, 39);
        this.getContentPane().add(btnOk);
        ButtonGroup l_bg = new ButtonGroup();
        JRadioButton rdbtnCredit = new JRadioButton("Cr\u00e9dit");
        rdbtnCredit.setForeground(Constants.darkGreenColor);
        l_bg.add(rdbtnCredit);
        rdbtnCredit.setFont(new Font("Tahoma", 1, 12));
        rdbtnCredit.setBounds(19, 172, 83, 23);
        this.getContentPane().add(rdbtnCredit);
        this.rdbtnDebit = new JRadioButton("D\u00e9bit");
        this.rdbtnDebit.setForeground(Constants.darkRedColor);
        l_bg.add(this.rdbtnDebit);
        this.rdbtnDebit.setFont(new Font("Tahoma", 1, 12));
        this.rdbtnDebit.setBounds(20, 198, 82, 23);
        this.getContentPane().add(this.rdbtnDebit);
        if (baseAItem != null && baseAItem.isNegativeAmount()) {
            rdbtnCredit.setSelected(false);
            this.rdbtnDebit.setSelected(true);
        } else {
            rdbtnCredit.setSelected(true);
            this.rdbtnDebit.setSelected(false);
        }
        JButton l_dateButton = GuiUtil.getChooseDateButton(36, 27);
        l_dateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Date l_inDate = new Date();
                try {
                    l_inDate = Util.parseDate(NewPlannedOperationDialog.this.textFieldDate.getText(), Util.getDateDayFirst());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String l_chosenDate = new DateChooser(MainWindow.getFrame(), l_inDate).getPickedDate();
                if (l_chosenDate != null && l_chosenDate.length() > 0) {
                    NewPlannedOperationDialog.this.textFieldDate.setText(l_chosenDate);
                }
            }
        });
        l_dateButton.setBounds(500, 188, 36, 27);
        this.getContentPane().add(l_dateButton);
        JButton l_categoryButton = GuiUtil.getChooseCategoryButton(36, 27);
        l_categoryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiUtil.getCategoryPopup(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String l_cat = GuiUtil.getCategoryChosenInCategoryPopup(e);
                        NewPlannedOperationDialog.this.comboBoxCategory.setSelectedItem(l_cat);
                    }
                }, null).show((Component)e.getSource(), 0, 0);
            }
        });
        l_categoryButton.setBounds(500, 323, 36, 27);
        this.getContentPane().add(l_categoryButton);
        JLabel lblAccount = new JLabel("Compte concern\u00e9");
        lblAccount.setFont(new Font("Tahoma", 1, 12));
        lblAccount.setBounds(10, 21, 180, 20);
        this.getContentPane().add(lblAccount);
        this.accountComboBox = new JComboBox();
        this.accountComboBox.setBounds(10, 48, 427, 27);
        for (Account l_a : Account.openAccounts) {
            this.accountComboBox.addItem(l_a.accountName);
        }
        if (baseItemAccountName != null) {
            this.accountComboBox.setSelectedItem(baseItemAccountName);
        }
        this.getContentPane().add(this.accountComboBox);
    }
}

