/*
 * Decompiled with CFR 0.152.
 */
package com.hmoney.gui.custom;

import com.hmoney.data.AccountFuturBalance;
import com.hmoney.data.AccountsFuturData;
import com.hmoney.data.DayBalance;
import com.hmoney.data.Util;
import com.hmoney.gui.Constants;
import com.hmoney.gui.DisplayedAccount;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;

public class HMGraphRenderer
extends JPanel {
    List<DayBalance> mdayBalances = null;
    AccountsFuturData accountsFuturData = null;
    String message = null;
    final int LEFT_PAD = 70;
    final int OTHER_PAD = 10;
    private long min;
    private long max;
    private int valuesScaleLines = 6;
    double y0;
    double xInc;
    double scale;
    int width;
    int height;
    float lineWidth = 3.0f;
    List<Integer> dateList = new ArrayList<Integer>();

    public HMGraphRenderer() {
        this.setBackground(Color.white);
    }

    public HMGraphRenderer(String message) {
        this();
        this.message = message;
    }

    public HMGraphRenderer(List<DayBalance> dayBalances) {
        this();
        this.mdayBalances = dayBalances;
    }

    public HMGraphRenderer(AccountsFuturData accountsFuturData) {
        this();
        this.accountsFuturData = accountsFuturData;
    }

    @Override
    protected void paintComponent(Graphics g) {
        float l_y;
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.dateList.clear();
        if (this.message != null) {
            g2.setFont(new Font("Arial", 1, 20));
            g2.drawString(this.message, this.width / 2 - 200, this.height / 2);
            return;
        }
        if (DisplayedAccount.isThereAStackedAccount()) {
            g2.setFont(new Font("Arial", 1, 20));
            g2.drawString("Pas de donn\u00e9es pour le graphe", this.width / 2 - 200, this.height / 2);
            return;
        }
        if (this.accountsFuturData != null) {
            if (this.accountsFuturData.accountsFuturBalances.size() == 0) {
                g2.setFont(new Font("Arial", 1, 20));
                g2.drawString("Pas de compte s\u00e9lectionn\u00e9 pour le graphe", this.width / 2 - 200, this.height / 2);
                return;
            }
            this.mdayBalances = this.accountsFuturData.accountsFuturBalances.get((int)0).dayBalances;
            this.min = this.accountsFuturData.afbMin;
            this.max = this.accountsFuturData.afbMax;
            this.valuesScaleLines = 12;
        } else {
            if (this.mdayBalances.size() == 0) {
                g2.setFont(new Font("Arial", 1, 20));
                g2.drawString("Pas d'op\u00e9ration pour ce compte", this.width / 2 - 200, this.height / 2);
                return;
            }
            this.calculateMinAndMax();
        }
        AffineTransform originTransform = g2.getTransform();
        g2.setFont(new Font("Arial", 0, 10));
        Font font = g2.getFont();
        FontRenderContext frc = g2.getFontRenderContext();
        LineMetrics lm = font.getLineMetrics("0", frc);
        float sh = lm.getAscent() + lm.getDescent();
        this.y0 = -((double)(this.height - 20) / (double)(this.max - this.min) * (double)this.min);
        this.xInc = (double)(this.width - 70 - 10) / (double)(this.mdayBalances.size() - 1);
        this.scale = (double)((float)(this.height - 20) - this.lineWidth) / (double)(this.max - this.min);
        g2.setPaint(Constants.graphUpBackgroundColor);
        g2.fillRect(70, 10, this.width - 80, this.height - 20);
        g2.setPaint(Constants.graphDownBackgroundColor);
        g2.fillRect(70, this.height - (int)this.y0 - 10, this.width - 80, (int)this.y0);
        if (this.accountsFuturData != null) {
            boolean storeDateLines = true;
            int i = 0;
            for (AccountFuturBalance l_afb : this.accountsFuturData.accountsFuturBalances) {
                this.drawDataLines(l_afb.dayBalances, g2, false, Color.gray, storeDateLines, 2);
                this.drawDataLines(l_afb.dayBalances, g2, false, Constants.graphColors[i++ % Constants.graphColors.length], false, 0);
                storeDateLines = false;
            }
        } else {
            this.drawDataLines(this.mdayBalances, g2, true, Constants.graphColors[0], true, 0);
            this.drawDataLines(this.mdayBalances, g2, false, Color.gray, false, 0);
        }
        g2.setStroke(new BasicStroke(1.0f, 1, 1));
        Color dateLinesColor = new Color(186, 172, 116);
        Color dateLabelsColor = new Color(96, 77, 0);
        g2.setPaint(new Color(96, 77, 0));
        int i = 0;
        while (i < this.dateList.size()) {
            double y1 = -this.y0 + (double)this.height - 10.0 - this.scale * (double)this.mdayBalances.get((int)this.dateList.get((int)i).intValue()).balance;
            y1 = 10.0;
            double x2 = 70.0 + (double)this.dateList.get(i).intValue() * this.xInc;
            String s = Util.getSimpleDateFormatter().format(this.mdayBalances.get((int)this.dateList.get((int)i).intValue()).date);
            g2.translate(x2, (float)(this.height - 10) - sh);
            g2.transform(AffineTransform.getRotateInstance(-0.7853981633974483));
            g2.setPaint(dateLabelsColor);
            g2.drawString(s, 0, -4);
            g2.setTransform(originTransform);
            g2.setPaint(dateLinesColor);
            g2.drawLine((int)x2 - 1, this.height - 10, (int)x2 - 1, (int)y1);
            ++i;
        }
        g2.setStroke(new BasicStroke(2.0f, 1, 1));
        g2.setPaint(Color.black);
        g2.draw(new Line2D.Double(70.0, 10.0, 70.0, this.height - 10));
        g2.draw(new Line2D.Double(70.0, this.height - 10, this.width - 10, this.height - 10));
        String s = Util.getSimpleDateFormatter().format(this.mdayBalances.get((int)0).date);
        float sw = (float)font.getStringBounds(s, frc).getWidth();
        g2.translate(sh, (float)(this.height - 10) - sh);
        g2.transform(AffineTransform.getRotateInstance(-1.5707963267948966));
        g2.drawString(s, (float)(this.height / 2) - sw, 70.0f);
        g2.setTransform(originTransform);
        s = Util.getSimpleDateFormatter().format(this.mdayBalances.get((int)(this.mdayBalances.size() - 1)).date);
        sw = (float)font.getStringBounds(s, frc).getWidth();
        g2.translate((double)this.width, (float)(this.height - 10) - sh);
        g2.transform(AffineTransform.getRotateInstance(-1.5707963267948966));
        g2.drawString(s, 0, 0);
        g2.setTransform(originTransform);
        float sy = 10.0f + ((float)(this.height - 20) - (float)s.length() * sh) / 2.0f + lm.getAscent();
        s = Util.longAmountToString(0L);
        sw = (float)font.getStringBounds(s, frc).getWidth();
        g2.drawString(s, 70.0f - sw - 4.0f, (float)(-this.y0) + (float)this.height - 10.0f);
        g2.drawLine(67, (int)(-this.y0) + this.height - 10, this.width - 10, (int)(-this.y0) + this.height - 10);
        s = Util.longAmountToString(this.max);
        sw = (float)font.getStringBounds(s, frc).getWidth();
        g2.drawString(s, 70.0f - sw - 4.0f, 10.0f);
        g2.drawLine(67, 10, this.width - 10, 10);
        g2.setStroke(new BasicStroke(1.0f, 1, 1));
        g2.setPaint(Color.black);
        int[] l_baseFactors = new int[]{1, 2, 5};
        int l_baseFactorIndex = 0;
        double l_minMaxDelta = this.max - this.min;
        double l_factor = 1.0;
        while (l_minMaxDelta / ((double)l_baseFactors[l_baseFactorIndex] * l_factor) >= (double)this.valuesScaleLines) {
            if (++l_baseFactorIndex <= 2) continue;
            l_factor *= 10.0;
            l_baseFactorIndex = 0;
        }
        l_factor *= (double)l_baseFactors[l_baseFactorIndex];
        int i2 = 1;
        while ((double)i2 * l_factor < (double)this.max) {
            s = Util.longAmountToString(Math.round((double)i2 * l_factor));
            sw = (float)font.getStringBounds(s, frc).getWidth();
            l_y = (float)(-this.y0 + (double)this.height - 10.0 - this.scale * (double)Math.round((double)i2 * l_factor));
            g2.drawString(s, 70.0f - sw - 4.0f, l_y);
            g2.drawLine(67, Math.round(l_y), this.width - 10, Math.round(l_y));
            ++i2;
        }
        i2 = -1;
        while ((double)i2 * l_factor > (double)this.min) {
            s = Util.longAmountToString(Math.round((double)i2 * l_factor));
            sw = (float)font.getStringBounds(s, frc).getWidth();
            l_y = (float)(-this.y0 + (double)this.height - 10.0 - this.scale * (double)Math.round((double)i2 * l_factor));
            g2.drawString(s, 70.0f - sw - 4.0f, l_y);
            g2.drawLine(67, Math.round(l_y), this.width - 10, Math.round(l_y));
            --i2;
        }
    }

    private void drawDataLines(List<DayBalance> dayBalances, Graphics2D g2, boolean drawPolygon, Color graphColor, boolean populateDateList, int lineYDelta) {
        int[] l_x4 = new int[4];
        int[] l_y4 = new int[4];
        g2.setPaint(graphColor);
        g2.setStroke(new BasicStroke(this.lineWidth, 1, 1));
        int l_nextDatePrint = 100;
        int i = 1;
        while (i < dayBalances.size()) {
            double x1 = 70.0 + (double)(i - 1) * this.xInc;
            double y1 = -this.y0 + (double)this.height - 10.0 - this.scale * (double)dayBalances.get((int)(i - 1)).balance;
            double x2 = 70.0 + (double)i * this.xInc;
            double y2 = -this.y0 + (double)this.height - 10.0 - this.scale * (double)dayBalances.get((int)i).balance;
            l_x4[0] = (int)x1;
            l_y4[0] = (int)y1;
            l_x4[1] = (int)x2;
            l_y4[1] = (int)y2;
            l_x4[2] = (int)x2;
            l_y4[2] = (int)(-this.y0) + this.height - 10;
            l_x4[3] = (int)x1;
            l_y4[3] = (int)(-this.y0) + this.height - 10;
            if (drawPolygon) {
                if (dayBalances.get((int)(i - 1)).balance < 0L) {
                    g2.setPaint(Constants.graphColors[3]);
                    g2.fillPolygon(l_x4, l_y4, 4);
                    g2.setPaint(graphColor);
                } else {
                    g2.fillPolygon(l_x4, l_y4, 4);
                }
            } else {
                g2.drawLine(l_x4[0], l_y4[0] + lineYDelta, l_x4[1], l_y4[1] + lineYDelta);
                g2.drawArc((int)((float)l_x4[0] - this.lineWidth), (int)((float)(l_y4[0] + lineYDelta) - this.lineWidth), (int)(this.lineWidth * 2.0f), (int)(this.lineWidth * 2.0f), 0, 360);
            }
            if (populateDateList && x2 > (double)l_nextDatePrint && x2 < (double)(this.width - 50)) {
                this.dateList.add(i);
                l_nextDatePrint += 100;
            }
            ++i;
        }
    }

    private long calculateMinAndMax() {
        this.max = 200000L;
        this.min = -200000L;
        int i = 0;
        while (i < this.mdayBalances.size()) {
            if (this.mdayBalances.get((int)i).balance > this.max) {
                this.max = this.mdayBalances.get((int)i).balance;
            }
            if (this.mdayBalances.get((int)i).balance < this.min) {
                this.min = this.mdayBalances.get((int)i).balance;
            }
            ++i;
        }
        return this.max;
    }
}

