/*
 * Decompiled with CFR 0.152.
 */
package com.hmoney.properties;

import com.hmoney.Logger;
import com.hmoney.data.ACategory;
import com.hmoney.data.Account;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class HMProperties {
    private static final String TAG = HMProperties.class.getSimpleName();
    private static Properties saveLocationProperties = new Properties();
    private static Properties stateProperties = new Properties();
    private static String saveLocation = null;
    private static String openDirLocation = null;
    public static final String SAVE_LOCATION_KEY = "save.dir_location_";
    public static final String OPEN_DIR_LOCATION_KEY = "open.dir_location";
    public static final String DATE_DAY_FIRST = "date.day_first";
    public static final String FRAME_LEFT = "frame.left";
    public static final String FRAME_TOP = "frame.top";
    public static final String FRAME_WIDTH = "frame.width";
    public static final String FRAME_HEIGHT = "frame.height";
    public static final String FRAME_STATE = "frame.state";
    public static final String HMY_ACCOUNT_FILES = "hmy.account_files";
    public static final String HMY_CATEGORY_PREFIX = "hmy.category";
    public static final String HMY_LOCALE = "hmy.locale";

    public static int getIntProperty(String property) {
        int l_val = 0;
        try {
            l_val = Integer.parseInt(stateProperties.getProperty(property));
        }
        catch (Exception e) {
            Logger.warn(TAG, "getIntProperty: Invalid integer in properties.");
        }
        Logger.verbose(TAG, "getIntProperty: returns " + property + "=" + l_val);
        return l_val;
    }

    public static String getStringProperty(String property) {
        String l_val = null;
        l_val = stateProperties.getProperty(property);
        Logger.verbose(TAG, "getStringProperty: returns " + property + "=" + l_val);
        return l_val;
    }

    public static void putProperty(String key, String val) {
        Logger.verbose(TAG, "putProperty: set " + key + "=" + val);
        stateProperties.put(key, val);
    }

    public static void putProperty(String key, int val) {
        Logger.verbose(TAG, "putProperty: set " + key + "=" + val);
        stateProperties.put(key, "" + val);
    }

    public static void removeProperty(String key) {
        Logger.verbose(TAG, "removeProperty( " + key + ")");
        stateProperties.remove(key);
    }

    private static void putDefaultProperty(String key, String val) {
        if (!stateProperties.containsKey(key)) {
            stateProperties.put(key, val);
        }
    }

    private static void putDefaultProperty(String key, int val) {
        if (!stateProperties.containsKey(key)) {
            stateProperties.put(key, "" + val);
        }
    }

    public static String getSaveLocation() {
        if (saveLocation != null) {
            return saveLocation;
        }
        String l_stateLocation = String.valueOf(HMProperties.getUserHomeDotHMoneyDir()) + File.separator + "saveloc.hmoney";
        try {
            saveLocationProperties.load(new FileInputStream(l_stateLocation));
            saveLocation = saveLocationProperties.getProperty("save.dir_location_0");
            openDirLocation = saveLocationProperties.getProperty(OPEN_DIR_LOCATION_KEY);
            if (openDirLocation == null || openDirLocation.length() < 2) {
                openDirLocation = "" + new File(System.getProperty("user.home")).getAbsoluteFile();
            }
            return saveLocation;
        }
        catch (IOException e) {
            Logger.warn(TAG, "getPropertiesLocation: no properties file found.");
            HMProperties.setSaveLocation(null);
            return saveLocation;
        }
    }

    public static List<String> getSaveLocationHistory() {
        ArrayList<String> l_res = new ArrayList<String>();
        int i = 0;
        while (i < 20) {
            String l_val = (String)saveLocationProperties.get(SAVE_LOCATION_KEY + i);
            if (l_val != null) {
                l_res.add(l_val);
            }
            ++i;
        }
        return l_res;
    }

    private static String getUserHomeDotHMoneyDir() {
        File l_hmoneyHomeDir = new File(String.valueOf(System.getProperty("user.home")) + File.separator + ".hmoney");
        if (!l_hmoneyHomeDir.exists()) {
            l_hmoneyHomeDir.mkdir();
        }
        return l_hmoneyHomeDir.getAbsoluteFile().toString();
    }

    public static String getOpenDirLocation() {
        return openDirLocation;
    }

    public static boolean setOpenDirLocation(String dirLocation) {
        try {
            String l_stateLocation = String.valueOf(HMProperties.getUserHomeDotHMoneyDir()) + File.separator + "saveloc.hmoney";
            openDirLocation = dirLocation;
            saveLocationProperties.put(OPEN_DIR_LOCATION_KEY, openDirLocation);
            saveLocationProperties.store(new FileOutputStream(l_stateLocation), "HMoney properties files directory");
            return true;
        }
        catch (IOException e) {
            Logger.error(TAG, "setOpenDirLocation: " + e);
            return false;
        }
    }

    public static boolean setSaveLocation(String dirLocation) {
        if (dirLocation == null) {
            dirLocation = HMProperties.getUserHomeDotHMoneyDir();
        }
        if (openDirLocation == null || openDirLocation.length() < 2) {
            openDirLocation = "" + new File(System.getProperty("user.home")).getAbsoluteFile();
        }
        String l_stateLocation = String.valueOf(HMProperties.getUserHomeDotHMoneyDir()) + File.separator + "saveloc.hmoney";
        Properties l_nextSaveLocationProperties = new Properties();
        try {
            int i = 0;
            while (i < 19) {
                String l_val = (String)saveLocationProperties.get(SAVE_LOCATION_KEY + i);
                if (l_val != null && !l_val.equals(dirLocation) && !l_nextSaveLocationProperties.containsValue(l_val)) {
                    l_nextSaveLocationProperties.put(SAVE_LOCATION_KEY + (i + 1), l_val);
                }
                ++i;
            }
            l_nextSaveLocationProperties.put("save.dir_location_0", dirLocation);
            l_nextSaveLocationProperties.put(OPEN_DIR_LOCATION_KEY, openDirLocation);
            saveLocation = dirLocation;
            saveLocationProperties = l_nextSaveLocationProperties;
            saveLocationProperties.store(new FileOutputStream(l_stateLocation), "HMoney properties files directory");
            return true;
        }
        catch (IOException e) {
            Logger.error(TAG, "setPropertiesLocation: " + e);
            return false;
        }
    }

    private static void setDefaultProperties() {
        HMProperties.putDefaultProperty(FRAME_LEFT, 0);
        HMProperties.putDefaultProperty(FRAME_TOP, 0);
        HMProperties.putDefaultProperty(FRAME_WIDTH, 1280);
        HMProperties.putDefaultProperty(FRAME_HEIGHT, 1024);
        HMProperties.putDefaultProperty(FRAME_STATE, 0);
        HMProperties.putDefaultProperty(DATE_DAY_FIRST, "true");
    }

    public static boolean loadProperties() {
        boolean l_loadOK = false;
        try {
            String l_hmoneyStateDirStr = HMProperties.getSaveLocation();
            File l_hmoneyStateDir = null;
            if (l_hmoneyStateDirStr != null) {
                l_hmoneyStateDir = new File(l_hmoneyStateDirStr);
            }
            if (l_hmoneyStateDir != null && l_hmoneyStateDir.exists()) {
                String l_propFileName = l_hmoneyStateDir.getAbsoluteFile() + File.separator + "hmoney.properties";
                try {
                    stateProperties.load(new FileInputStream(l_propFileName));
                    ACategory.restoreFromProperties(stateProperties);
                    l_loadOK = true;
                }
                catch (IOException e) {
                    Logger.warn(TAG, "loadProperties: no properties file found.");
                }
            }
        }
        finally {
            if (!l_loadOK) {
                HMProperties.setDefaultProperties();
            }
        }
        return l_loadOK;
    }

    public static boolean storeProperties() {
        if (stateProperties.isEmpty()) {
            Logger.warn(TAG, "storeProperties: no properties to save");
            return false;
        }
        String l_hmoneyStateDirStr = HMProperties.getSaveLocation();
        File l_hmoneyStateDir = null;
        if (l_hmoneyStateDirStr != null) {
            l_hmoneyStateDir = new File(l_hmoneyStateDirStr);
        }
        if (l_hmoneyStateDir != null && l_hmoneyStateDir.exists()) {
            ACategory.putCategoriesInProperties(stateProperties);
            String l_propFileName = l_hmoneyStateDir.getAbsoluteFile() + File.separator + "hmoney.properties";
            try {
                stateProperties.store(new FileOutputStream(l_propFileName), "HMoney properties file");
                ACategory.setSaved(true);
                return true;
            }
            catch (IOException e) {
                Logger.error(TAG, "storeProperties: " + e);
            }
        }
        return false;
    }

    public static void updateAccountList() {
        String l_al = "";
        for (Account l_a : Account.openAccounts) {
            l_al = String.valueOf(l_al) + (l_al.length() < 1 ? "" : ",") + l_a.accountName;
        }
        HMProperties.putProperty(HMY_ACCOUNT_FILES, l_al);
        HMProperties.storeProperties();
    }
}

