/*
 * Decompiled with CFR 0.152.
 */
package com.hmoney.data;

import com.hmoney.Logger;
import com.hmoney.data.APlannedItem;
import com.hmoney.data.Account;
import com.hmoney.data.CategoryStrings;
import com.hmoney.data.Util;
import com.hmoney.messages.Messages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

public class ACategory {
    private static final String TAG = ACategory.class.getSimpleName();
    private static List<String> categories = new ArrayList<String>();
    private static boolean saved = true;
    private static boolean sorted = true;

    public static void sort() {
        if (sorted) {
            Logger.verbose(TAG, "sort: canceled (no changes)");
            return;
        }
        Logger.verbose(TAG, "sort: " + categories.size() + " elements");
        Collections.sort(categories, Util.getCollator());
        sorted = true;
    }

    public static CategoryStrings addIfDontExist(String category) throws Exception {
        return ACategory.addIfDontExist(category, true);
    }

    public static CategoryStrings addIfDontExist(String category, boolean checkCategory) throws Exception {
        CategoryStrings l_catS;
        if (checkCategory && category != null) {
            if (category.equals(Messages.getString("NoCategory"))) {
                return null;
            }
            if (category.equals("null")) {
                return null;
            }
        }
        if (!categories.contains((l_catS = new CategoryStrings(category)).getNormalizedLabel())) {
            categories.add(l_catS.getNormalizedLabel());
            sorted = false;
            saved = false;
        }
        return l_catS;
    }

    public static void cleanCategories() {
        ArrayList<String> l_toBeRemoved = new ArrayList<String>();
        for (String l_cat : categories) {
            if (l_cat.equals(Messages.getString("NoCategory"))) {
                l_toBeRemoved.add(l_cat);
            }
            if (l_cat.equals("null")) {
                l_toBeRemoved.add(l_cat);
            }
            if (!l_cat.equals("<aucune>")) continue;
            l_toBeRemoved.add(l_cat);
        }
        for (String l_cat : l_toBeRemoved) {
            categories.remove(l_cat);
        }
    }

    public static void removeIfExists(String category) {
        if (categories.contains(category)) {
            categories.remove(category);
            sorted = false;
            saved = false;
        }
    }

    public static boolean contains(String category) {
        return categories.contains(category);
    }

    public static final List<String> getCategories() {
        ArrayList<String> l_catList = new ArrayList<String>();
        for (String l_cat : categories) {
            if (l_cat.startsWith("[")) continue;
            l_catList.add(l_cat);
        }
        return l_catList;
    }

    public static void restoreFromProperties(Properties props) {
        for (Object l_o : props.keySet()) {
            String l_s = (String)l_o;
            if (!l_s.startsWith("hmy.category")) continue;
            try {
                ACategory.addIfDontExist(props.getProperty(l_s), false);
            }
            catch (Exception e) {
                Logger.error(TAG, "restoreFromProperties: inserting category '" + l_s + "': " + e.getMessage());
            }
        }
        sorted = false;
        ACategory.sort();
    }

    public static void putCategoriesInProperties(Properties props) {
        if (!saved) {
            ArrayList<String> l_tbrArray = new ArrayList<String>();
            for (Object l_o : props.keySet()) {
                String l_s = (String)l_o;
                if (!l_s.startsWith("hmy.category")) continue;
                l_tbrArray.add(l_s);
            }
            for (String l_key : l_tbrArray) {
                props.remove(l_key);
            }
            int l_catCount = 0;
            for (String l_cat : categories) {
                props.put("hmy.category" + ++l_catCount, l_cat);
            }
        }
    }

    public static void setSaved(boolean saved) {
        ACategory.saved = !saved;
    }

    public static boolean getSaved() {
        return saved;
    }

    public static void checkNewCategoryBeforeAddind(String newCategory) throws Exception {
        if (newCategory == null || newCategory.length() < 2) {
            throw new Exception(Messages.getString("CategoriesDialog.54"));
        }
        CategoryStrings l_catS = new CategoryStrings(newCategory);
        if (categories.contains(l_catS.getNormalizedLabel())) {
            throw new Exception(Messages.getString("CategoriesDialog.48"));
        }
        if (newCategory.indexOf(":") != newCategory.lastIndexOf(":")) {
            throw new Exception(Messages.getString("CategoriesDialog.50"));
        }
        if (newCategory.contains("[") || newCategory.contains("]") || newCategory.contains(",")) {
            throw new Exception(Messages.getString("CategoriesDialog.52"));
        }
    }

    public static void removeUnusedDefaultCategories(String locale) {
        Logger.info(TAG, "removeUnusedDefaultCategories(" + locale + ")");
        String[] l_cats = null;
        int i = 0;
        while (i < Messages.languages_codes.length) {
            if (Messages.languages_codes[i].equals(locale)) {
                l_cats = Messages.default_categories[i];
            }
            ++i;
        }
        i = 0;
        while (i < l_cats.length) {
            List<Account> l_accList;
            void l_removeCat = l_cats[i];
            if (ACategory.contains((String)l_removeCat) && (l_accList = Account.checkIfCategoryIsReferenced((String)l_removeCat)).isEmpty() && !APlannedItem.checkIfCategoryIsReferenced((String)l_removeCat)) {
                ACategory.removeIfExists((String)l_removeCat);
            }
            ++i;
        }
        ACategory.sort();
    }

    public static void addDefaultCategories(String locale) {
        Logger.info(TAG, "addDefaultCategories(" + locale + ")");
        String[] l_cats = null;
        int i = 0;
        while (i < Messages.languages_codes.length) {
            if (Messages.languages_codes[i].equals(locale)) {
                l_cats = Messages.default_categories[i];
            }
            ++i;
        }
        i = 0;
        while (i < l_cats.length) {
            try {
                ACategory.addIfDontExist(l_cats[i], false);
            }
            catch (Exception e) {
                Logger.error(TAG, "addDefaultCategories: inserting category '" + l_cats[i] + "': " + e.getMessage());
            }
            ++i;
        }
    }
}

