/*
 * Decompiled with CFR 0.152.
 */
package com.hmoney.data;

import com.hmoney.data.AItem;
import com.hmoney.data.Util;
import java.util.Comparator;

public class AItemComparators {
    private static final String TAG = AItemComparators.class.getSimpleName();
    public static final int DATE = 0;
    public static final int PAYEE = 1;
    public static final int CATEGORY = 2;
    public static final int AMOUNT = 3;
    public static final int NUM = 4;
    public static final int BALANCE = 5;
    public static final int MEMO = 6;
    public static final int CLEARED_RECONCILED = 7;

    public static Comparator<AItem> getComparator(int comparatorType, final boolean ascending) {
        Comparator<AItem> l_comp = null;
        switch (comparatorType) {
            case 1: {
                l_comp = new Comparator<AItem>(){

                    @Override
                    public int compare(AItem ai1, AItem ai2) {
                        int l_res = Util.compareStringIgnoreCase(ai1.payee, ai2.payee);
                        return ascending ? l_res : -l_res;
                    }

                    public String toString() {
                        return "Payee comparator, ascending=" + ascending;
                    }
                };
                break;
            }
            case 2: {
                l_comp = new Comparator<AItem>(){

                    @Override
                    public int compare(AItem ai1, AItem ai2) {
                        int l_res = Util.compareStringIgnoreCase(Util.getUserFriendlyCategoryString(ai1.category), Util.getUserFriendlyCategoryString(ai2.category));
                        return ascending ? l_res : -l_res;
                    }

                    public String toString() {
                        return "Category comparator, ascending=" + ascending;
                    }
                };
                break;
            }
            case 3: {
                l_comp = new Comparator<AItem>(){

                    @Override
                    public int compare(AItem ai1, AItem ai2) {
                        int l_res = Float.compare(ai1.amount, ai2.amount);
                        return ascending ? l_res : -l_res;
                    }

                    public String toString() {
                        return "Amount comparator, ascending=" + ascending;
                    }
                };
                break;
            }
            case 4: {
                l_comp = new Comparator<AItem>(){

                    @Override
                    public int compare(AItem ai1, AItem ai2) {
                        int l_res = Util.compareStringIgnoreCase(ai1.num, ai2.num);
                        return ascending ? l_res : -l_res;
                    }

                    public String toString() {
                        return "Num comparator, ascending=" + ascending;
                    }
                };
                break;
            }
            case 5: {
                l_comp = new Comparator<AItem>(){

                    @Override
                    public int compare(AItem ai1, AItem ai2) {
                        int l_res = Float.compare(ai1.balance, ai2.balance);
                        return ascending ? l_res : -l_res;
                    }

                    public String toString() {
                        return "Balance comparator, ascending=" + ascending;
                    }
                };
                break;
            }
            case 6: {
                l_comp = new Comparator<AItem>(){

                    @Override
                    public int compare(AItem ai1, AItem ai2) {
                        int l_res = Util.compareStringIgnoreCase(ai1.memo, ai2.memo);
                        return ascending ? l_res : -l_res;
                    }

                    public String toString() {
                        return "Memo comparator, ascending=" + ascending;
                    }
                };
                break;
            }
            case 7: {
                l_comp = new Comparator<AItem>(){

                    @Override
                    public int compare(AItem ai1, AItem ai2) {
                        int l_v1 = (ai1.flags & 2) > 0 ? 1 : 0;
                        int l_v2 = (ai2.flags & 2) > 0 ? 1 : 0;
                        int l_res = (l_v2 += (ai2.flags & 4) > 0 ? 2 : 0) - (l_v1 += (ai1.flags & 4) > 0 ? 2 : 0);
                        return ascending ? l_res : -l_res;
                    }

                    public String toString() {
                        return "Cleared and Reconciled comparator, ascending=" + ascending;
                    }
                };
                break;
            }
            default: {
                l_comp = new Comparator<AItem>(){

                    @Override
                    public int compare(AItem ai1, AItem ai2) {
                        int l_res = ai1.date.compareTo(ai2.date);
                        if (l_res == 0) {
                            if (ai1.amount > ai2.amount) {
                                l_res = -1;
                            }
                            if (ai1.amount < ai2.amount) {
                                l_res = 1;
                            }
                        }
                        return ascending ? l_res : -l_res;
                    }

                    public String toString() {
                        return "Date comparator, ascending=" + ascending;
                    }
                };
            }
        }
        return l_comp;
    }
}

