/*
 * Decompiled with CFR 0.152.
 */
package com.hmoney.data;

import com.hmoney.Logger;
import com.hmoney.data.ACategory;
import com.hmoney.data.AItem;
import com.hmoney.data.AItemComparators;
import com.hmoney.data.AItemSplit;
import com.hmoney.data.Util;
import com.hmoney.messages.Messages;
import com.hmoney.properties.HMProperties;
import com.hmoney.properties.Versions;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.UUID;

public class Account {
    private static final String TAG = Account.class.getSimpleName();
    public static List<Account> openAccounts = new ArrayList<Account>();
    public static final String ACCOUNT_TYPE_CASH = "Cash";
    public static final String ACCOUNT_TYPE_BANK = "Bank";
    public static final String ACCOUNT_TYPE_CCARD = "CCard";
    public static final String ACCOUNT_TYPE_OTH_A = "Oth A";
    public static final String ACCOUNT_TYPE_OTH_L = "Oth L";
    public static final String ACCOUNT_TYPE_INVST = "Invst";
    public static final String ACCOUNT_TYPE_INVOICE = "Invoice";
    public static final String ACCOUNT_TYPE_CAT = "Cat";
    public static final String ACCOUNT_TYPE_CLASS = "Class";
    public static final String ACCOUNT_TYPE_MEMORIZED = "Memorized";
    public String accountType = null;
    public String accountName = null;
    public long initialAmount = 0L;
    private boolean graphBills = false;
    public Date firstOperationDate = null;
    public Date lastOperationDate = null;
    public long balance = 0L;
    private static final String accountTypeLabel = "AType";
    private static final String accountInitialAmountLabel = "AInitialAmount";
    private static final String accountGraphBillsLabel = "AGraphBills";
    public boolean balanceEnabled = true;
    private boolean saved = true;
    private ArrayList<AItem> aItemList = new ArrayList();

    public static String getAccountTypeLabel(String QifAccountType) {
        if (ACCOUNT_TYPE_CASH.equals(QifAccountType)) {
            return Messages.getString("ACCOUNT_TYPE_CASH_LABEL");
        }
        if (ACCOUNT_TYPE_BANK.equals(QifAccountType)) {
            return Messages.getString("ACCOUNT_TYPE_BANK_LABEL");
        }
        if (ACCOUNT_TYPE_CCARD.equals(QifAccountType)) {
            return Messages.getString("ACCOUNT_TYPE_CREDITCARD_LABEL");
        }
        if (ACCOUNT_TYPE_OTH_A.equals(QifAccountType)) {
            return Messages.getString("ACCOUNT_TYPE_ASSETS_LABEL");
        }
        if (ACCOUNT_TYPE_OTH_L.equals(QifAccountType)) {
            return Messages.getString("ACCOUNT_TYPE_LIABILITIES_LABEL");
        }
        return null;
    }

    public static String getAccountTypeFromLabel(String AccountTypeLabel) {
        if (Messages.getString("ACCOUNT_TYPE_CASH_LABEL").equals(AccountTypeLabel)) {
            return ACCOUNT_TYPE_CASH;
        }
        if (Messages.getString("ACCOUNT_TYPE_BANK_LABEL").equals(AccountTypeLabel)) {
            return ACCOUNT_TYPE_BANK;
        }
        if (Messages.getString("ACCOUNT_TYPE_CREDITCARD_LABEL").equals(AccountTypeLabel)) {
            return ACCOUNT_TYPE_CCARD;
        }
        if (Messages.getString("ACCOUNT_TYPE_ASSETS_LABEL").equals(AccountTypeLabel)) {
            return ACCOUNT_TYPE_OTH_A;
        }
        if (Messages.getString("ACCOUNT_TYPE_LIABILITIES_LABEL").equals(AccountTypeLabel)) {
            return ACCOUNT_TYPE_OTH_L;
        }
        return null;
    }

    public Account(boolean saved) {
        this.saved = saved;
    }

    public Account(Account copySrc) {
        this.accountType = new String(copySrc.accountType);
        this.accountName = new String(copySrc.accountName);
        this.initialAmount = copySrc.initialAmount;
        this.balance = copySrc.balance;
        this.balanceEnabled = copySrc.balanceEnabled;
        this.saved = copySrc.saved;
        int i = 0;
        while (i < copySrc.aItemList.size()) {
            this.aItemList.add(new AItem(copySrc.aItemList.get(i), true));
            ++i;
        }
    }

    public AItem getItem(int index) {
        return this.aItemList.get(index);
    }

    public int getItemListSize() {
        return this.aItemList.size();
    }

    public boolean addItem(AItem newAItem) {
        this.saved = false;
        return this.aItemList.add(newAItem);
    }

    public AItem removeItem(int index) {
        AItem l_ai = this.aItemList.get(index);
        this.saved = false;
        if (l_ai.isUserValidated()) {
            l_ai.setCategory("", this);
        }
        return this.aItemList.remove(index);
    }

    protected boolean removeItemWithoutCategoryCheck(AItem item) {
        int l_index = this.aItemList.indexOf(item);
        if (l_index < 0) {
            return false;
        }
        this.saved = false;
        return this.aItemList.remove(item);
    }

    public boolean removeItem(AItem item) {
        int l_index = this.aItemList.indexOf(item);
        if (l_index < 0) {
            return false;
        }
        this.saved = false;
        AItem l_ai = this.aItemList.get(l_index);
        if (l_ai.isUserValidated()) {
            l_ai.setCategory("", this);
        }
        return this.aItemList.remove(item);
    }

    public int indexOf(AItem aItem) {
        return this.aItemList.indexOf(aItem);
    }

    public Account(String accType, boolean balEnabled) {
        this.accountType = accType;
        this.balanceEnabled = balEnabled;
    }

    public String toString() {
        StringBuilder l_sb = new StringBuilder();
        l_sb.append("[Account: accountType=" + this.accountType + ",\n");
        if (this.aItemList != null) {
            for (AItem l_qi : this.aItemList) {
                l_sb.append(l_qi.toString());
            }
        }
        l_sb.append("]");
        return l_sb.toString();
    }

    public List<AItem> searchOperations(String searchString, int searchType) {
        ArrayList<AItem> l_searchResultList = new ArrayList<AItem>();
        String l_sic = searchString.toLowerCase();
        for (AItem l_ai : this.aItemList) {
            boolean l_match = false;
            switch (searchType) {
                case 0: {
                    if (l_ai.getMemo() != null && l_ai.getMemo().toLowerCase().contains(l_sic)) {
                        l_match = true;
                        break;
                    }
                    if (l_ai.getCategory() != null && l_ai.getCategory().toLowerCase().contains(l_sic)) {
                        l_match = true;
                        break;
                    }
                    if (l_ai.getPayee() != null && l_ai.getPayee().toLowerCase().contains(l_sic)) {
                        l_match = true;
                        break;
                    }
                    if (l_ai.getCategory() == null || !l_ai.getCategory().toLowerCase().startsWith(l_sic)) break;
                    l_match = true;
                    break;
                }
                case 1: {
                    if (l_ai.getPayee() == null || !l_ai.getPayee().toLowerCase().contains(l_sic)) break;
                    l_match = true;
                    break;
                }
                case 2: {
                    if (l_ai.getCategory() == null || !l_ai.getCategory().toLowerCase().startsWith(l_sic)) break;
                    l_match = true;
                }
            }
            if (!l_match) continue;
            l_ai.setAccountName(this.accountName);
            l_searchResultList.add(l_ai);
        }
        return l_searchResultList;
    }

    public AItem getAItemByUuid(UUID uuid) {
        for (AItem l_ai : this.aItemList) {
            if (!l_ai.uuid.equals(uuid)) continue;
            return l_ai;
        }
        return null;
    }

    public List<AItem> calculateBalance() {
        ArrayList<AItem> l_balanceCopyAItem = new ArrayList<AItem>(this.aItemList);
        Comparator<AItem> l_comp = AItemComparators.getComparator(0, true);
        Collections.sort(l_balanceCopyAItem, l_comp);
        this.firstOperationDate = null;
        this.lastOperationDate = null;
        if (l_balanceCopyAItem.size() > 0) {
            this.firstOperationDate = ((AItem)l_balanceCopyAItem.get((int)0)).date;
            this.lastOperationDate = ((AItem)l_balanceCopyAItem.get((int)(l_balanceCopyAItem.size() - 1))).date;
        }
        long l_curBal = this.initialAmount;
        for (AItem l_ai : l_balanceCopyAItem) {
            l_curBal = l_ai.balance = l_curBal + l_ai.getLongAmount();
        }
        this.balance = l_curBal;
        return l_balanceCopyAItem;
    }

    public void sort(int sortType, boolean ascending) {
        Comparator<AItem> l_comp = AItemComparators.getComparator(sortType, ascending);
        Collections.sort(this.aItemList, l_comp);
    }

    public void save() throws Exception {
        BufferedWriter l_bw = null;
        try {
            Logger.info(TAG, "save account '" + this.accountName + "'");
            l_bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(String.valueOf(HMProperties.getSaveLocation()) + File.separator + this.accountName + ".hmy"), "ISO-8859-1"));
            l_bw.write("hmyVersion=2.0.1\n");
            l_bw.write("AType=" + this.accountType + "\n");
            l_bw.write("AInitialAmount=" + this.initialAmount + "\n");
            l_bw.write("AGraphBills=" + this.graphBills + "\n");
            for (AItem l_ai : this.aItemList) {
                l_ai.save(l_bw);
            }
            this.saved = true;
        }
        finally {
            if (l_bw != null) {
                l_bw.close();
            }
        }
    }

    public void loadFile(String accountName) throws Exception {
        this.accountName = accountName;
        BufferedReader l_br = null;
        try {
            Logger.info(TAG, "loadFile(" + accountName + ")");
            l_br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(String.valueOf(HMProperties.getSaveLocation()) + File.separator + accountName + ".hmy"), "ISO-8859-1"));
            String l_line = l_br.readLine();
            StringTokenizer l_st = new StringTokenizer(l_line, "=");
            String l_accountVersion = "1.2.0";
            String l_currentToken = l_st.nextToken();
            if (l_currentToken.equals("hmyVersion")) {
                l_accountVersion = l_st.nextToken();
                l_line = l_br.readLine();
                l_st = new StringTokenizer(l_line, "=");
                l_currentToken = l_st.nextToken();
            }
            if (Versions.versionsDiff("1.2.1", l_accountVersion) >= 0L) {
                Logger.info(TAG, "Handling pre 1.2.1 version for account '" + accountName + "' : " + l_accountVersion);
            }
            if (l_currentToken.equals(accountTypeLabel)) {
                this.accountType = l_st.nextToken();
                if (!(this.accountType.equals(ACCOUNT_TYPE_CASH) || this.accountType.equals(ACCOUNT_TYPE_BANK) || this.accountType.equals(ACCOUNT_TYPE_CCARD) || this.accountType.equals(ACCOUNT_TYPE_OTH_A) || this.accountType.equals(ACCOUNT_TYPE_OTH_L))) {
                    throw new Exception("Account type is not handled by application : " + this.accountType);
                }
            } else {
                throw new Exception("Invalid Account file : account type");
            }
            l_line = l_br.readLine();
            l_st = new StringTokenizer(l_line, "=");
            if (!l_st.nextToken().equals(accountInitialAmountLabel)) {
                throw new Exception("Invalid Account file : account initial amount");
            }
            this.initialAmount = Util.parseAmount(l_st.nextToken());
            l_line = l_br.readLine();
            l_st = new StringTokenizer(l_line, "=");
            if (!l_st.nextToken().equals(accountGraphBillsLabel)) {
                throw new Exception("Invalid Account file : bills graph flag missing");
            }
            this.graphBills = Boolean.parseBoolean(l_st.nextToken());
            this.aItemList = new ArrayList();
            UUID l_dupUuid = null;
            while ((l_line = l_br.readLine()) != null) {
                AItem l_ai = new AItem(l_line, l_br, false);
                if (l_ai.getExtAttribute("newlyImport") != null && l_ai.getExtAttribute("newlyImport").equalsIgnoreCase("true")) {
                    l_ai.setNewlyImported(true);
                }
                if (l_ai.uuid.equals(l_dupUuid)) {
                    this.getAItemByUuid(l_dupUuid).dup = l_ai;
                    continue;
                }
                this.aItemList.add(l_ai);
                l_dupUuid = l_ai.uuid;
            }
        }
        finally {
            if (l_br != null) {
                l_br.close();
            }
            ACategory.sort();
        }
    }

    public static List<Account> checkIfCategoryIsReferenced(String category) {
        ArrayList<Account> l_containingAccounts = new ArrayList<Account>();
        block0: for (Account l_a : openAccounts) {
            for (AItem l_ai : l_a.aItemList) {
                if (l_ai.getCategory() == null || !l_ai.getCategory().equals(category)) continue;
                l_containingAccounts.add(l_a);
                continue block0;
            }
        }
        return l_containingAccounts;
    }

    public static void changeCategoryOnAllAccounts(String oldCategory, String newCategory) {
        for (Account l_a : openAccounts) {
            l_a.changeCategoryOnAccount(oldCategory, newCategory);
        }
    }

    public static Account getAccountByName(String accountName) {
        for (Account l_a : openAccounts) {
            if (!l_a.accountName.equals(accountName)) continue;
            return l_a;
        }
        return null;
    }

    public static Account removeAccount(String accountName) {
        Account l_a = Account.getAccountByName(accountName);
        openAccounts.remove(l_a);
        try {
            Logger.info(TAG, "removing account file for account '" + accountName + "'");
            File l_f = new File(String.valueOf(HMProperties.getSaveLocation()) + File.separator + accountName + ".hmy");
            l_f.delete();
        }
        catch (Exception e) {
            Logger.error(TAG, "removeAccountFile: file deletion failed !");
        }
        return l_a;
    }

    public static void renameAccount(String oldAccountName, String newAccountName) {
        Account l_a = Account.getAccountByName(oldAccountName);
        openAccounts.remove(l_a);
        l_a.accountName = new String(newAccountName);
        openAccounts.add(l_a);
        for (Account l_a2 : openAccounts) {
            l_a2.changeAccountNameOnAccount(oldAccountName, newAccountName);
        }
        try {
            Logger.info(TAG, "renaming account file from '" + oldAccountName + "' to '" + newAccountName + "'");
            File l_fSrc = new File(String.valueOf(HMProperties.getSaveLocation()) + File.separator + oldAccountName + ".hmy");
            File l_fDest = new File(String.valueOf(HMProperties.getSaveLocation()) + File.separator + newAccountName + ".hmy");
            l_fSrc.renameTo(l_fDest);
        }
        catch (Exception e) {
            Logger.error(TAG, "removeAccountFile: file deletion failed !");
        }
    }

    public void changeCategoryOnAccount(String oldCategory, String newCategory) {
        for (AItem l_ai : this.aItemList) {
            if (l_ai.getCategory() != null && Util.compareString(l_ai.getCategory(), oldCategory) == 0) {
                l_ai.setCategory(newCategory, this);
            }
            if (l_ai.splits == null) continue;
            for (AItemSplit l_ais : l_ai.splits) {
                if (l_ais.category == null || Util.compareString(l_ais.category, oldCategory) != 0) continue;
                l_ais.category = newCategory;
                l_ai.saved = false;
            }
        }
    }

    public void changeAccountNameOnAccount(String oldAccountName, String newAccountName) {
        for (AItem l_ai : this.aItemList) {
            if (l_ai.category == null || !l_ai.category.equals("[" + oldAccountName + "]")) continue;
            l_ai.category = "[" + newAccountName + "]";
        }
    }

    public void addOperations(List<AItem> importedItems) {
        if (importedItems.size() < 1) {
            return;
        }
        this.aItemList.addAll(importedItems);
        this.saved = false;
    }

    public AItem findDup(AItem orig) {
        AItem l_res = null;
        for (AItem l_pDup : this.aItemList) {
            if (l_pDup.uuid.equals(orig.uuid) || l_pDup.amount != orig.amount) continue;
            Calendar l_pDupCal = Calendar.getInstance(Util.getLocaleFromString(HMProperties.getStringProperty("hmy.locale")));
            l_pDupCal.setTime(l_pDup.date);
            Calendar l_origCal = Calendar.getInstance(Util.getLocaleFromString(HMProperties.getStringProperty("hmy.locale")));
            l_origCal.setTime(orig.date);
            l_pDupCal.add(5, 5);
            if (!l_origCal.before(l_pDupCal)) continue;
            l_pDupCal.add(5, -10);
            if (!l_origCal.after(l_pDupCal) || l_pDup.getDup() != null) continue;
            l_res = l_pDup;
            break;
        }
        return l_res;
    }

    public int guessCategoryForImportedItems() {
        int l_nbGuess = 0;
        for (AItem l_ai : this.aItemList) {
            int l_matchIndex;
            if (!l_ai.getNewlyImported() || l_ai.isUserValidated() || l_ai.wasCategoryOnceSet() || (l_matchIndex = Util.getAItemMatchForCategory(l_ai, this)) == -1) continue;
            l_ai.setCategory(this.getItem(l_matchIndex).getCategory(), this);
            ++l_nbGuess;
        }
        return l_nbGuess;
    }

    public boolean isSaved() {
        if (!this.saved) {
            return this.saved;
        }
        for (AItem l_ai : this.aItemList) {
            if (l_ai.saved) continue;
            return l_ai.saved;
        }
        return this.saved;
    }

    public int getNotValidatedOperationCount() {
        int l_res = 0;
        for (AItem l_ai : this.aItemList) {
            if (l_ai.isUserValidated() && l_ai.dup == null) continue;
            ++l_res;
        }
        return l_res;
    }

    public boolean isGraphBills() {
        return this.graphBills;
    }

    public void setGraphBills(boolean graphBills) {
        this.graphBills = graphBills;
        this.saved = false;
    }
}

