/*
 * Decompiled with CFR 0.152.
 */
package com.hmoney.data;

import com.hmoney.Logger;
import com.hmoney.data.ACategory;
import com.hmoney.data.AItem;
import com.hmoney.data.AItemSplit;
import com.hmoney.data.CategoryStrings;
import com.hmoney.data.Util;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;

public class QifImportExport {
    private static final String TAG = QifImportExport.class.getSimpleName();
    private static final String QIF_ACCOUNT_TYPE_TAG = "!Type";
    private static final String QIF_ACCOUNT_ACCOUNT_TAG = "!Account";
    private List<AItem> qifItemList = new ArrayList<AItem>();

    public List<AItem> loadFile(String fileName, boolean dateDayFirst, boolean isMoneyMigration) throws Exception {
        BufferedReader l_br = null;
        try {
            Logger.info(TAG, "loadFile(" + fileName + ", " + dateDayFirst + ")");
            l_br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "ISO-8859-1"));
            String l_line = null;
            while ((l_line = l_br.readLine()) != null) {
                AItem l_ai = this.readQifItem(l_line, l_br, dateDayFirst, isMoneyMigration);
                if (l_ai == null) continue;
                if (l_ai.getPayee() == null && l_ai.getMemo() != null) {
                    l_ai.setPayee(l_ai.getMemo());
                }
                if (l_ai.getDate() == null) {
                    l_ai.setDate(new Date());
                }
                l_ai.setEImport(true);
                l_ai.setUserValidated(false, null);
                this.qifItemList.add(l_ai);
            }
        }
        finally {
            if (l_br != null) {
                l_br.close();
            }
            ACategory.sort();
        }
        return this.qifItemList;
    }

    private void finalizeCurrentSplit(AItem aItem) throws Exception {
        if (aItem.currentSplit != null && aItem.currentSplit.category != null && aItem.currentSplit.amount > 0L) {
            aItem.addSplit(aItem.currentSplit);
            aItem.currentSplit = null;
        }
    }

    private AItem readQifItem(String firstLine, BufferedReader br, boolean dateDayFirst, boolean isMoneyMigration) throws Exception {
        boolean l_foundData = false;
        AItem l_ai = new AItem();
        l_foundData |= this.getData(l_ai, firstLine, dateDayFirst, isMoneyMigration);
        while (true) {
            String l_line;
            if ((l_line = br.readLine()) == null || l_line.startsWith("^")) break;
            l_foundData |= this.getData(l_ai, l_line, dateDayFirst, isMoneyMigration);
        }
        this.finalizeCurrentSplit(l_ai);
        if (!l_foundData) {
            return null;
        }
        return l_ai;
    }

    private boolean getData(AItem aItem, String line, boolean dateDayFirst, boolean isMoneyMigration) throws Exception {
        if (line.startsWith("!")) {
            StringTokenizer l_st = new StringTokenizer(line, ":");
            if (l_st.hasMoreTokens()) {
                String l_accountTypeName = l_st.nextToken();
                if (l_accountTypeName.equalsIgnoreCase(QIF_ACCOUNT_TYPE_TAG)) {
                    String l_accountTypeValue;
                    if (!(!l_st.hasMoreTokens() || (l_accountTypeValue = l_st.nextToken()).equalsIgnoreCase("Cash") || l_accountTypeValue.equalsIgnoreCase("Bank") || l_accountTypeValue.equalsIgnoreCase("CCard") || l_accountTypeValue.equalsIgnoreCase("Oth A") || l_accountTypeValue.equalsIgnoreCase("Oth L"))) {
                        if (l_accountTypeValue.equalsIgnoreCase("Invst") || l_accountTypeValue.equalsIgnoreCase("Cat") || l_accountTypeValue.equalsIgnoreCase("Class") || l_accountTypeValue.equalsIgnoreCase("Memorized")) {
                            throw new Exception("Account type is not handled by application: " + l_accountTypeValue);
                        }
                        if (l_accountTypeValue.equalsIgnoreCase("Invoice")) {
                            throw new Exception("Account type is not handled by application (Quicken for Business only): " + l_accountTypeValue);
                        }
                    }
                } else if (l_accountTypeName.equalsIgnoreCase(QIF_ACCOUNT_ACCOUNT_TAG)) {
                    throw new Exception("HMoney cannot process 'Account' type QIF file");
                }
            }
        } else if (line.startsWith("D")) {
            aItem.setDate(Util.parseDate(line.substring(1), dateDayFirst));
        } else if (line.startsWith("T")) {
            aItem.setLongAmount(Util.parseAmount(line.substring(1)));
        } else if (line.startsWith("M")) {
            aItem.setMemo(line.substring(1));
        } else if (line.startsWith("*") || line.startsWith("C") || line.startsWith("R") || line.startsWith("X")) {
            if (line.contains("C") || line.contains("*")) {
                aItem.setCleared(true);
            }
            if (line.contains("R") || line.contains("X")) {
                aItem.setReconciled(true);
            }
        } else if (line.startsWith("N")) {
            aItem.setNum(line.substring(1));
        } else if (line.startsWith("P")) {
            aItem.setPayee(line.substring(1));
        } else if (line.startsWith("L") && isMoneyMigration) {
            CategoryStrings l_catS = ACategory.addIfDontExist(line.substring(1));
            if (l_catS != null) {
                aItem.category = l_catS.getNormalizedLabel();
            }
        } else if (line.startsWith("A")) {
            if (aItem.address == null) {
                aItem.address = new String[6];
            }
            int i = 0;
            while (i < 6) {
                if (aItem.address[i] == null) {
                    aItem.address[i] = line.substring(1);
                    break;
                }
                ++i;
            }
        } else if (line.startsWith("F")) {
            aItem.setRbexpense(true);
        } else if (line.startsWith("S")) {
            CategoryStrings l_catS;
            this.finalizeCurrentSplit(aItem);
            if (aItem.currentSplit == null) {
                aItem.currentSplit = new AItemSplit();
            }
            if ((l_catS = ACategory.addIfDontExist(line.substring(1))) != null) {
                aItem.currentSplit.category = l_catS.getNormalizedLabel();
            }
        } else if (line.startsWith("E")) {
            this.finalizeCurrentSplit(aItem);
            if (aItem.currentSplit == null) {
                aItem.currentSplit = new AItemSplit();
            }
            aItem.currentSplit.memo = line.substring(1);
        } else if (line.startsWith("$")) {
            this.finalizeCurrentSplit(aItem);
            if (aItem.currentSplit == null) {
                aItem.currentSplit = new AItemSplit();
            }
            aItem.currentSplit.amount = Util.parseAmount(line.substring(1));
        } else if (line.startsWith("%")) {
            this.finalizeCurrentSplit(aItem);
            if (aItem.currentSplit == null) {
                aItem.currentSplit = new AItemSplit();
            }
            aItem.currentSplit.percent = Float.parseFloat(line.substring(1));
        } else {
            return false;
        }
        return true;
    }

    public void save(BufferedWriter bw, AItem aItem) throws Exception {
        bw.write("D" + Util.getSimpleDateFormatter().format(aItem.date) + "\n");
        bw.write("T" + aItem.getAmountStringForSave() + "\n");
        if (aItem.category != null && aItem.category.length() > 0) {
            bw.write("L" + aItem.category + "\n");
        }
        if (aItem.payee != null && aItem.payee.length() > 0) {
            bw.write("P" + aItem.payee + "\n");
        }
        if (aItem.memo != null && aItem.memo.length() > 0) {
            bw.write("M" + aItem.memo + "\n");
        }
        if (aItem.num != null && aItem.num.length() > 0) {
            bw.write("N" + aItem.num + "\n");
        }
        bw.write("U" + aItem.uuid.toString() + "\n");
        if ((aItem.flags & 4) > 0 || (aItem.flags & 2) > 0) {
            bw.write(String.valueOf((aItem.flags & 2) > 0 ? "C" : "") + ((aItem.flags & 4) > 0 ? "R" : "") + "\n");
        }
        if ((aItem.flags & 1) > 0) {
            bw.write("F\n");
        }
        if (aItem.address != null) {
            int i = 0;
            while (i < 6) {
                if (aItem.address[i] == null) break;
                bw.write("A" + aItem.address[i] + "\n");
                ++i;
            }
        }
        if (aItem.splits != null) {
            for (AItemSplit l_ais : aItem.splits) {
                l_ais.save(bw);
            }
        }
        bw.write("^\n");
    }
}

