/*
 * Decompiled with CFR 0.152.
 */
package com.hmoney.gui;

import com.hmoney.Logger;
import com.hmoney.data.APlannedItem;
import com.hmoney.data.Account;
import com.hmoney.data.Util;
import com.hmoney.gui.DisplayedAccount;
import com.hmoney.gui.GuiUtil;
import com.hmoney.gui.IKeyboardListener;
import com.hmoney.gui.MainWindow;
import com.hmoney.gui.custom.DateChooser;
import com.hmoney.gui.custom.IconListRenderer;
import com.hmoney.gui.custom.KeyboardMainListener;
import com.hmoney.messages.Messages;
import com.hmoney.properties.HMProperties;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Date;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class AccountDialog
extends JDialog
implements IKeyboardListener {
    private static final String TAG = AccountDialog.class.getSimpleName();
    public JTextField accountName;
    public JTextField initialAmount;
    JComboBox<Object> accountTypeChoice;
    public boolean okSelected = false;
    public JTextField txtOpeningDate;
    Account editAccount;

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            KeyboardMainListener.addCurrentListener(this);
            final AccountDialog thisAccountDialog = this;
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    KeyboardMainListener.removeListener(thisAccountDialog);
                }
            });
        }
        super.setVisible(visible);
    }

    @Override
    public void escapeKeyTyped() {
        this.dispose();
    }

    @Override
    public void enterKeyTyped() {
    }

    @Override
    public void deleteKeyTyped() {
    }

    public AccountDialog(Frame frame, String title, Account editAccount) {
        super(frame, title, true);
        this.setResizable(false);
        this.setSize(262, 359);
        this.setLocation(MainWindow.getFrame().getX() + 300, MainWindow.getFrame().getY() + 300);
        this.getContentPane().setLayout(null);
        this.editAccount = editAccount;
        JLabel lblAccountName = new JLabel(Messages.getString("AccountDialog.0"));
        lblAccountName.setBounds(35, 89, 134, 14);
        this.getContentPane().add(lblAccountName);
        JLabel lblInitialAmount = new JLabel(Messages.getString("AccountDialog.1"));
        lblInitialAmount.setBounds(35, 151, 134, 14);
        this.getContentPane().add(lblInitialAmount);
        this.accountName = new JTextField();
        this.accountName.setBounds(35, 109, 179, 27);
        this.getContentPane().add(this.accountName);
        this.accountName.setColumns(10);
        if (this.editAccount != null) {
            this.accountName.setText(this.editAccount.accountName);
        }
        this.initialAmount = new JTextField();
        this.initialAmount.setText("0");
        this.initialAmount.setBounds(35, 170, 179, 27);
        this.getContentPane().add(this.initialAmount);
        this.initialAmount.setColumns(10);
        if (this.editAccount != null) {
            this.initialAmount.setText(Util.longAmountToString(this.editAccount.initialAmount));
            this.initialAmount.setEnabled(false);
        }
        JLabel lblAccountType = new JLabel(Messages.getString("AccountDialog.3"));
        lblAccountType.setBounds(35, 11, 134, 14);
        this.getContentPane().add(lblAccountType);
        this.accountTypeChoice = new JComboBox();
        this.accountTypeChoice.setBounds(35, 33, 179, 36);
        this.accountTypeChoice.addItem(Account.getAccountTypeLabel("Bank"));
        this.accountTypeChoice.addItem(Account.getAccountTypeLabel("CCard"));
        this.accountTypeChoice.addItem(Account.getAccountTypeLabel("Cash"));
        this.accountTypeChoice.addItem(Account.getAccountTypeLabel("Oth A"));
        this.accountTypeChoice.addItem(Account.getAccountTypeLabel("Oth L"));
        HashMap<Object, Icon> l_iconMap = new HashMap<Object, Icon>();
        l_iconMap.put(Account.getAccountTypeLabel("Bank"), new ImageIcon(GuiUtil.getAccountImageIcon("Bank").getImage().getScaledInstance(32, 32, 4)));
        l_iconMap.put(Account.getAccountTypeLabel("CCard"), new ImageIcon(GuiUtil.getAccountImageIcon("CCard").getImage().getScaledInstance(32, 32, 4)));
        l_iconMap.put(Account.getAccountTypeLabel("Cash"), new ImageIcon(GuiUtil.getAccountImageIcon("Cash").getImage().getScaledInstance(32, 32, 4)));
        l_iconMap.put(Account.getAccountTypeLabel("Oth A"), new ImageIcon(GuiUtil.getAccountImageIcon("Oth A").getImage().getScaledInstance(32, 32, 4)));
        l_iconMap.put(Account.getAccountTypeLabel("Oth L"), new ImageIcon(GuiUtil.getAccountImageIcon("Oth L").getImage().getScaledInstance(32, 32, 4)));
        this.accountTypeChoice.setRenderer(new IconListRenderer(l_iconMap));
        this.getContentPane().add(this.accountTypeChoice);
        if (this.editAccount != null) {
            this.accountTypeChoice.setSelectedItem(Account.getAccountTypeLabel(this.editAccount.accountType));
        }
        JLabel lblOpeningDate = new JLabel(Messages.getString("AccountDialog.4"));
        lblOpeningDate.setBounds(34, 207, 134, 20);
        this.getContentPane().add(lblOpeningDate);
        this.txtOpeningDate = new JTextField();
        this.txtOpeningDate.setText(Util.getSimpleDateFormatter().format(new Date()));
        this.txtOpeningDate.setBounds(34, 229, 152, 27);
        this.getContentPane().add(this.txtOpeningDate);
        this.txtOpeningDate.setColumns(10);
        if (this.editAccount != null) {
            this.txtOpeningDate.setText(Util.getSimpleDateFormatter().format(this.editAccount.calculateBalance().get(0).getDate()));
            this.txtOpeningDate.setEnabled(false);
        }
        JButton btnOk = new JButton(Messages.getString("AccountDialog.5"));
        final Account finalEditAccount = this.editAccount;
        btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (finalEditAccount == null) {
                    if (AccountDialog.checkAccountName(AccountDialog.this.accountName.getText(), AccountDialog.this.getContentPane()) > 0) {
                        return;
                    }
                    try {
                        Float.parseFloat(AccountDialog.this.initialAmount.getText());
                    }
                    catch (Exception e2) {
                        JOptionPane.showMessageDialog(AccountDialog.this.getContentPane(), Messages.getString("AccountDialog.10"), Messages.getString("WINDOW_TITLE_ERROR"), 0);
                        return;
                    }
                    try {
                        Date e2 = Util.parseDate(AccountDialog.this.txtOpeningDate.getText(), Util.getDateDayFirst());
                    }
                    catch (Exception e2) {
                        JOptionPane.showMessageDialog(AccountDialog.this.getContentPane(), Messages.getString("AccountDialog.12"), Messages.getString("WINDOW_TITLE_ERROR"), 0);
                        AccountDialog.this.txtOpeningDate.setText(Util.getDateUserInputTemplate());
                        return;
                    }
                }
                try {
                    if (!finalEditAccount.accountType.equals(AccountDialog.this.accountTypeChoice.getSelectedItem().toString())) {
                        finalEditAccount.accountType = Account.getAccountTypeFromLabel(AccountDialog.this.accountTypeChoice.getSelectedItem().toString());
                        finalEditAccount.save();
                    }
                    String l_newAccName = AccountDialog.this.accountName.getText();
                    String l_oldAccountName = finalEditAccount.accountName;
                    if (!finalEditAccount.accountName.equals(l_newAccName)) {
                        if (AccountDialog.checkAccountName(l_newAccName, null) > 0) {
                            return;
                        }
                        int l_res = JOptionPane.showConfirmDialog(null, String.valueOf(Messages.getString("AccountDialog.9")) + finalEditAccount.accountName + Messages.getString("AccountDialog.11") + l_newAccName + "'", "", 2);
                        if (l_res != 0) {
                            return;
                        }
                        Account.renameAccount(l_oldAccountName, l_newAccName);
                        APlannedItem.changeAccountNameOnPlannedItems(l_oldAccountName, l_newAccName);
                        HMProperties.updateAccountList();
                        if (DisplayedAccount.getDisplayedAccount() != null && DisplayedAccount.getDisplayedAccount().accountName != null && DisplayedAccount.getDisplayedAccount().accountName.equals(l_newAccName) && MainWindow.itemsMainPanel.homepageButton != null) {
                            MainWindow.itemsMainPanel.homepageButton.doClick();
                        }
                    }
                    int i = 0;
                    while (i < MainWindow.accountMenuItems.size()) {
                        JMenuItem l_mi = MainWindow.accountMenuItems.get(i);
                        if (l_mi.getText().equals(l_oldAccountName)) {
                            l_mi.setText(l_newAccName);
                            l_mi.setIcon(new ImageIcon(GuiUtil.getAccountImageIcon(finalEditAccount.accountType).getImage().getScaledInstance(32, 32, 4)));
                            JCheckBoxMenuItem lcbmi = (JCheckBoxMenuItem)MainWindow.mnBillsGraphAccountsMenu.getItem(i + MainWindow.mnBillsGraphAccountsMenuAccountsIndexGap);
                            lcbmi.setText(l_newAccName);
                            JMenuItem l_mi2 = MainWindow.mnAccountPropertiesMenu.getItem(i);
                            l_mi2.setText(l_newAccName);
                            l_mi2.setIcon(new ImageIcon(GuiUtil.getAccountImageIcon(finalEditAccount.accountType).getImage().getScaledInstance(32, 32, 4)));
                            break;
                        }
                        ++i;
                    }
                    MainWindow.summaryHtmlPanel.displayAccounts();
                    if (MainWindow.itemsMainPanel != null && MainWindow.itemsMainPanel.homepageButton != null) {
                        MainWindow.itemsMainPanel.homepageButton.doClick();
                    }
                }
                catch (Exception e2) {
                    Logger.error(TAG, "btnOk.actionPerformed(): " + e2);
                }
                AccountDialog.this.okSelected = true;
                AccountDialog.this.dispose();
            }
        });
        btnOk.setBounds(134, 292, 89, 28);
        this.getContentPane().add(btnOk);
        JButton btnCancel = new JButton(Messages.getString("AccountDialog.14"));
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AccountDialog.this.dispose();
            }
        });
        btnCancel.setBounds(35, 292, 89, 28);
        this.getContentPane().add(btnCancel);
        JLabel label = new JLabel(Util.getDateUserInputTemplate());
        label.setBounds(34, 260, 180, 16);
        this.getContentPane().add(label);
        JButton l_dateButton = GuiUtil.getChooseDateButton(28, 23);
        l_dateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Date l_inDate = new Date();
                try {
                    l_inDate = Util.parseDate(AccountDialog.this.txtOpeningDate.getText(), Util.getDateDayFirst());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String l_chosenDate = new DateChooser(MainWindow.getFrame(), l_inDate).getPickedDate();
                if (l_chosenDate != null && l_chosenDate.length() > 0) {
                    AccountDialog.this.txtOpeningDate.setText(l_chosenDate);
                }
            }
        });
        l_dateButton.setBounds(189, 228, 28, 27);
        this.getContentPane().add(l_dateButton);
    }

    public static int checkAccountName(String accountName, Container container) {
        if (accountName.length() < 1) {
            JOptionPane.showMessageDialog(container, Messages.getString("AccountDialog.6"), Messages.getString("WINDOW_TITLE_ERROR"), 0);
            return 1;
        }
        if (accountName.length() > 30) {
            JOptionPane.showMessageDialog(container, Messages.getString("AccountDialog.7"), Messages.getString("WINDOW_TITLE_ERROR"), 0);
            return 2;
        }
        if (Account.getAccountByName(accountName) != null) {
            JOptionPane.showMessageDialog(null, Messages.getString("AccountDialog.8"), Messages.getString("WINDOW_TITLE_ERROR"), 0);
            return 3;
        }
        String[] stringArray = Messages.reservedKeywords;
        int n = Messages.reservedKeywords.length;
        int n2 = 0;
        while (n2 < n) {
            String reserved = stringArray[n2];
            if (accountName.contains(reserved)) {
                JOptionPane.showMessageDialog(container, "\"" + reserved + Messages.getString("AccountDialog.13"), Messages.getString("WINDOW_TITLE_ERROR"), 0);
                return 4;
            }
            ++n2;
        }
        if (accountName.indexOf("[") > -1 || accountName.indexOf("]") > -1 || accountName.indexOf(",") > -1 || accountName.indexOf(":") > -1 || accountName.indexOf(";") > -1 || accountName.indexOf("|") > -1) {
            JOptionPane.showMessageDialog(container, String.valueOf(Messages.getString("AccountDialog.15")) + "[" + Messages.getString("AccountDialog.16") + "]" + Messages.getString("AccountDialog.17"), Messages.getString("WINDOW_TITLE_ERROR"), 0);
            return 5;
        }
        return 0;
    }
}

