/*
 * Decompiled with CFR 0.152.
 */
package com.hmoney.gui;

import com.hmoney.Logger;
import com.hmoney.data.ACategory;
import com.hmoney.data.APlannedItem;
import com.hmoney.data.Account;
import com.hmoney.data.CategoryStrings;
import com.hmoney.gui.DisplayedAccount;
import com.hmoney.gui.IKeyboardListener;
import com.hmoney.gui.MainWindow;
import com.hmoney.gui.custom.KeyboardMainListener;
import com.hmoney.messages.Messages;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CategoriesDialog
extends JDialog
implements IKeyboardListener {
    private static final String TAG = CategoriesDialog.class.getSimpleName();
    private JTextField catTextField;
    private DefaultListModel<String> listModel;
    private JList<String> catList = new JList();
    private JButton btnAddNewCategory;
    private JButton btnRemoveSelectedCategory;
    private JButton btnEditSelectedCategory;
    private JButton btnMigrateCategory;

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            KeyboardMainListener.addCurrentListener(this);
            final CategoriesDialog thisCategoriesDialog = this;
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    KeyboardMainListener.removeListener(thisCategoriesDialog);
                }
            });
        }
        super.setVisible(visible);
    }

    @Override
    public void escapeKeyTyped() {
    }

    @Override
    public void enterKeyTyped() {
    }

    @Override
    public void deleteKeyTyped() {
    }

    public CategoriesDialog(Frame frame, String title) {
        super(frame, title);
        this.setResizable(false);
        this.setSize(644, 562);
        this.setLocation(MainWindow.getFrame().getX() + 300, MainWindow.getFrame().getY() + 300);
        this.getContentPane().setLayout(null);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBounds(0, 0, 638, 285);
        this.getContentPane().add(scrollPane);
        this.catList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                String l_selcat = (String)CategoriesDialog.this.catList.getSelectedValue();
                boolean l_bCatOK = l_selcat != null && l_selcat.length() > 1;
                CategoriesDialog.this.btnRemoveSelectedCategory.setEnabled(l_bCatOK);
                CategoriesDialog.this.btnEditSelectedCategory.setEnabled(l_bCatOK);
                CategoriesDialog.this.btnMigrateCategory.setEnabled(l_bCatOK);
            }
        });
        scrollPane.setViewportView(this.catList);
        this.listModel = new DefaultListModel();
        this.catList.setModel(this.listModel);
        this.refillCategoryList(this.listModel);
        this.catTextField = new JTextField();
        this.catTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                String l_inText = CategoriesDialog.this.catTextField.getText();
                boolean l_bCatOK = l_inText != null && l_inText.length() > 1;
                CategoriesDialog.this.btnAddNewCategory.setEnabled(l_bCatOK);
            }
        });
        this.catTextField.setBounds(10, 386, 386, 27);
        this.getContentPane().add(this.catTextField);
        this.catTextField.setColumns(10);
        JButton btnClose = new JButton("<html>" + Messages.getString("CategoriesDialog.1") + "</html>");
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CategoriesDialog.this.dispose();
            }
        });
        btnClose.setBounds(251, 487, 135, 36);
        this.getContentPane().add(btnClose);
        this.btnAddNewCategory = new JButton("<html>" + Messages.getString("CategoriesDialog.4") + "</html>");
        this.btnAddNewCategory.setEnabled(false);
        this.btnAddNewCategory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String l_newCat = CategoriesDialog.this.catTextField.getText();
                if (!CategoriesDialog.this.checkNewCategory(l_newCat)) {
                    return;
                }
                CategoryStrings l_addedCatS = null;
                try {
                    l_addedCatS = ACategory.addIfDontExist(l_newCat);
                }
                catch (Exception ex) {
                    Logger.error(TAG, "btnAddNewCategory.actionPerformed(): adding category '" + l_newCat + "': " + ex.getMessage());
                    return;
                }
                ACategory.sort();
                CategoriesDialog.this.refillCategoryList(CategoriesDialog.this.listModel);
                CategoriesDialog.this.catList.setSelectedValue(l_addedCatS.getNormalizedLabel(), true);
                CategoriesDialog.this.catTextField.setText("");
            }
        });
        this.btnAddNewCategory.setBounds(406, 386, 203, 27);
        this.getContentPane().add(this.btnAddNewCategory);
        JLabel lblNote = new JLabel("<html>" + Messages.getString("CategoriesDialog.8") + Messages.getString("CategoriesDialog.9") + "</html>");
        lblNote.setBounds(10, 420, 599, 36);
        this.getContentPane().add(lblNote);
        this.btnRemoveSelectedCategory = new JButton("<html>" + Messages.getString("CategoriesDialog.12") + "</html>");
        this.btnRemoveSelectedCategory.setEnabled(false);
        this.btnRemoveSelectedCategory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String l_removeCat = (String)CategoriesDialog.this.catList.getSelectedValue();
                if (l_removeCat == null || l_removeCat.length() < 1) {
                    return;
                }
                if (ACategory.contains(l_removeCat)) {
                    List<Account> l_accList = Account.checkIfCategoryIsReferenced(l_removeCat);
                    if (!l_accList.isEmpty()) {
                        String l_accountNames = "";
                        for (Account l_a : l_accList) {
                            if (l_accountNames.length() > 0) {
                                l_accountNames = String.valueOf(l_accountNames) + ", ";
                            }
                            l_accountNames = String.valueOf(l_accountNames) + l_a.accountName;
                        }
                        JOptionPane.showMessageDialog(CategoriesDialog.this.getContentPane(), String.valueOf(Messages.getString("CategoriesDialog.16")) + l_accountNames, Messages.getString("WINDOW_TITLE_ERROR"), 1);
                        return;
                    }
                    if (APlannedItem.checkIfCategoryIsReferenced(l_removeCat)) {
                        JOptionPane.showMessageDialog(CategoriesDialog.this.getContentPane(), Messages.getString("CategoriesDialog.18"), Messages.getString("WINDOW_TITLE_ERROR"), 1);
                        return;
                    }
                    int l_res = JOptionPane.showConfirmDialog(null, String.valueOf(Messages.getString("CategoriesDialog.20")) + l_removeCat + Messages.getString("CategoriesDialog.21"), "", 2);
                    if (l_res != 0) {
                        return;
                    }
                    ACategory.removeIfExists(l_removeCat);
                    ACategory.sort();
                    CategoriesDialog.this.refillCategoryList(CategoriesDialog.this.listModel);
                }
            }
        });
        this.btnRemoveSelectedCategory.setBounds(433, 307, 182, 44);
        this.getContentPane().add(this.btnRemoveSelectedCategory);
        this.btnEditSelectedCategory = new JButton("<html>" + Messages.getString("CategoriesDialog.24") + "</html>");
        this.btnEditSelectedCategory.setEnabled(false);
        this.btnEditSelectedCategory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String l_newCat = (String)JOptionPane.showInputDialog(null, Messages.getString("CategoriesDialog.26"), Messages.getString("WINDOW_TITLE_INPUT"), 3, null, null, (String)CategoriesDialog.this.catList.getSelectedValue());
                if (l_newCat == null) {
                    return;
                }
                CategoryStrings l_catS = null;
                try {
                    l_catS = new CategoryStrings(l_newCat);
                }
                catch (Exception ex) {
                    Logger.error(TAG, "btnEditSelectedCategory.actionPerformed(): making CategoryStrings for '" + l_newCat + "': " + ex.getMessage());
                    return;
                }
                if (!CategoriesDialog.this.checkNewCategory(l_catS.getNormalizedLabel())) {
                    return;
                }
                String l_oldCat = (String)CategoriesDialog.this.catList.getSelectedValue();
                int l_res = JOptionPane.showConfirmDialog(null, String.valueOf(Messages.getString("CategoriesDialog.28")) + l_oldCat + Messages.getString("CategoriesDialog.29") + l_newCat + "'", "", 2);
                if (l_res != 0) {
                    return;
                }
                Account.changeCategoryOnAllAccounts(l_oldCat, l_newCat);
                APlannedItem.changeCategoryOnPlannedItems(l_oldCat, l_newCat);
                ACategory.removeIfExists(l_oldCat);
                CategoryStrings l_addedCatS = null;
                try {
                    l_addedCatS = ACategory.addIfDontExist(l_newCat);
                }
                catch (Exception ex) {
                    Logger.error(TAG, "btnEditSelectedCategory.actionPerformed()(2): adding category '" + l_newCat + "': " + ex.getMessage());
                    return;
                }
                ACategory.sort();
                CategoriesDialog.this.refillCategoryList(CategoriesDialog.this.listModel);
                CategoriesDialog.this.catList.setSelectedValue(l_addedCatS.getNormalizedLabel(), true);
                if (DisplayedAccount.isThereAStackedAccount()) {
                    DisplayedAccount.getDisplayedAccount().changeCategoryOnAccount(l_oldCat, l_newCat);
                }
                MainWindow.aItemTable.getTableModel().fireTableDataChanged();
                MainWindow.aPlannedItemTable.getTableModel().fireTableDataChanged();
            }
        });
        this.btnEditSelectedCategory.setBounds(23, 307, 182, 44);
        this.getContentPane().add(this.btnEditSelectedCategory);
        this.btnMigrateCategory = new JButton("<html>" + Messages.getString("CategoriesDialog.33") + "</html>");
        this.btnMigrateCategory.setEnabled(false);
        this.btnMigrateCategory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String l_origCat = (String)CategoriesDialog.this.catList.getSelectedValue();
                if (l_origCat == null || l_origCat.length() < 1) {
                    return;
                }
                Object[] l_choiceValues = new String[ACategory.getCategories().size()];
                int i1 = 0;
                for (String l_cat : ACategory.getCategories()) {
                    l_choiceValues[i1++] = l_cat;
                }
                String l_targetCat = (String)JOptionPane.showInputDialog(null, String.valueOf(Messages.getString("CategoriesDialog.35")) + l_origCat + "'.", Messages.getString("WINDOW_TITLE_SELECT"), 3, null, l_choiceValues, l_choiceValues[0]);
                if (l_targetCat == null) {
                    return;
                }
                int l_res = JOptionPane.showConfirmDialog(null, String.valueOf(Messages.getString("CategoriesDialog.38")) + l_origCat + Messages.getString("CategoriesDialog.39") + l_targetCat + "'", "", 2);
                if (l_res != 0) {
                    return;
                }
                Account.changeCategoryOnAllAccounts(l_origCat, l_targetCat);
                APlannedItem.changeCategoryOnPlannedItems(l_origCat, l_targetCat);
                if (DisplayedAccount.isThereAStackedAccount()) {
                    DisplayedAccount.getDisplayedAccount().changeCategoryOnAccount(l_origCat, l_targetCat);
                }
                MainWindow.aItemTable.getTableModel().fireTableDataChanged();
                MainWindow.aPlannedItemTable.getTableModel().fireTableDataChanged();
                JOptionPane.showMessageDialog(CategoriesDialog.this.getContentPane(), String.valueOf(Messages.getString("CategoriesDialog.42")) + l_origCat + Messages.getString("CategoriesDialog.43"), "INFO", 1);
            }
        });
        this.btnMigrateCategory.setBounds(228, 307, 182, 44);
        this.getContentPane().add(this.btnMigrateCategory);
        JSeparator separator = new JSeparator();
        separator.setBounds(10, 373, 618, 2);
        this.getContentPane().add(separator);
        JSeparator separator_1 = new JSeparator();
        separator_1.setBounds(10, 467, 618, 2);
        this.getContentPane().add(separator_1);
    }

    private void refillCategoryList(DefaultListModel<String> listModel) {
        listModel.clear();
        for (String l_cat : ACategory.getCategories()) {
            listModel.addElement(l_cat);
        }
    }

    private boolean checkNewCategory(String newCategory) {
        String[] stringArray = Messages.reservedKeywords;
        int n = Messages.reservedKeywords.length;
        int n2 = 0;
        while (n2 < n) {
            String reserved = stringArray[n2];
            if (newCategory.contains(reserved)) {
                JOptionPane.showMessageDialog(this.getContentPane(), "\"" + reserved + Messages.getString("CategoriesDialog.46"), "INFO", 1);
                return false;
            }
            ++n2;
        }
        try {
            ACategory.checkNewCategoryBeforeAddind(newCategory);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.getContentPane(), e.getMessage(), Messages.getString("WINDOW_TITLE_ERROR"), 1);
            Logger.error(TAG, "checkNewCategory: checking category '" + newCategory + "': " + e.getMessage());
            return false;
        }
        return true;
    }
}

