/*
 * Decompiled with CFR 0.152.
 */
package com.hmoney.gui;

import com.hmoney.Logger;
import com.hmoney.data.DayBalance;
import com.hmoney.data.Util;
import com.hmoney.gui.AItemTable;
import com.hmoney.gui.Constants;
import com.hmoney.gui.DisplayedAccount;
import com.hmoney.gui.GuiUtil;
import com.hmoney.gui.MainWindow;
import com.hmoney.gui.MenuManager;
import com.hmoney.gui.NewOperationDialog;
import com.hmoney.gui.custom.HMGraphRenderer;
import com.hmoney.gui.custom.KeyboardMainListener;
import com.hmoney.messages.Messages;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class ItemsPanel
extends JPanel {
    private static final String TAG = ItemsPanel.class.getSimpleName();
    JSplitPane splitPane;
    JPanel splitPaneBottomPanel;
    private float splitpaneDividerLocation = 0.8f;
    JButton homepageButton;
    JLabel accountLabel;

    public ItemsPanel(final AItemTable aItemTable) {
        this.setLayout(new BorderLayout(0, 0));
        JPanel panelTop = new JPanel();
        JPanel panelTopLeft = new JPanel();
        panelTop.setLayout(new BorderLayout(0, 0));
        panelTopLeft.setLayout(new BorderLayout(0, 0));
        this.add((Component)panelTop, "North");
        this.homepageButton = new JButton(Messages.getString("ItemsPanel.0"));
        this.homepageButton.setIcon(new ImageIcon(GuiUtil.getImageIcon("home.png").getImage().getScaledInstance(24, 24, 4)));
        this.homepageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.contentPanel.removeAll();
                KeyboardMainListener.removeListener(aItemTable);
                MainWindow.contentPanel.add(MainWindow.summaryHtmlPanel);
                MenuManager.inHomePage();
                GuiUtil.displayBusyCursor();
                MainWindow.summaryHtmlPanel.displayAccounts();
            }
        });
        panelTopLeft.add((Component)this.homepageButton, "West");
        JButton l_newOperationButton = new JButton(Messages.getString("ItemsPanel.2"));
        l_newOperationButton.setIcon(new ImageIcon(GuiUtil.getImageIcon("plus.png").getImage().getScaledInstance(24, 24, 4)));
        l_newOperationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewOperationDialog l_newOpDlg = new NewOperationDialog(MainWindow.getFrame(), Messages.getString("ItemsPanel.4"), true);
                l_newOpDlg.setVisible(true);
                if (!l_newOpDlg.okSelected) {
                    return;
                }
                DisplayedAccount.getDisplayedAccount().addItem(l_newOpDlg.aItem);
                DisplayedAccount.getDisplayedAccount().calculateBalance();
                DisplayedAccount.getDisplayedAccount().sort(0, true);
                aItemTable.getTableModel().fireTableDataChanged();
                int l_rowSel = DisplayedAccount.getDisplayedAccount().indexOf(l_newOpDlg.aItem);
                GuiUtil.showTableElementInViewPort(MainWindow.aItemTable, l_rowSel, 4);
                ItemsPanel.this.updateGraph(null);
            }
        });
        panelTopLeft.add((Component)l_newOperationButton, "Center");
        panelTop.add((Component)panelTopLeft, "West");
        JButton l_billBookButton = new JButton(Messages.getString("ItemsPanel.5"));
        l_billBookButton.setIcon(new ImageIcon(GuiUtil.getImageIcon("bbook.png").getImage().getScaledInstance(41, 24, 4)));
        l_billBookButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.mntmPlannedItems.doClick();
            }
        });
        panelTopLeft.add((Component)l_billBookButton, "East");
        panelTop.add((Component)panelTopLeft, "West");
        JPanel accountLabelPanel = new JPanel();
        accountLabelPanel.setBackground(Constants.tableHeaderBgColor);
        accountLabelPanel.setForeground(Color.white);
        this.accountLabel = new JLabel();
        this.accountLabel.setForeground(Color.black);
        this.accountLabel.setFont(new Font("Sans Serif", 1, 24));
        this.accountLabel.setIcon(new ImageIcon(GuiUtil.getAccountImageIcon("Bank").getImage().getScaledInstance(32, 32, 4)));
        accountLabelPanel.add(this.accountLabel);
        panelTop.add((Component)accountLabelPanel, "Center");
        this.splitPane = new JSplitPane(0);
        this.splitPaneBottomPanel = new JPanel();
        this.splitPaneBottomPanel.setLayout(new BorderLayout(0, 0));
        JScrollPane scrollPane = new JScrollPane(aItemTable);
        this.splitPane.setTopComponent(scrollPane);
        this.splitPane.setBottomComponent(this.splitPaneBottomPanel);
        this.add(this.splitPane);
        ItemsPanel.setDividerLocation(this.splitPane, this.splitpaneDividerLocation);
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                Logger.verbose(TAG, "addAncestorListener.ancestorAdded: set divider location=" + ItemsPanel.this.splitpaneDividerLocation);
                ItemsPanel.this.splitPane.setDividerLocation(ItemsPanel.this.splitpaneDividerLocation);
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                if (ItemsPanel.this.splitPane.getHeight() > 0) {
                    ItemsPanel.this.splitpaneDividerLocation = (float)ItemsPanel.this.splitPane.getDividerLocation() / (float)ItemsPanel.this.splitPane.getHeight();
                    Logger.verbose(TAG, "addAncestorListener.ancestorAdded: save divider location=" + ItemsPanel.this.splitpaneDividerLocation);
                }
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
    }

    public static JSplitPane setDividerLocation(final JSplitPane splitter, final double proportion) {
        if (splitter.isShowing()) {
            if (splitter.getWidth() > 0 && splitter.getHeight() > 0) {
                splitter.setDividerLocation(proportion);
            } else {
                splitter.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentResized(ComponentEvent ce) {
                        splitter.removeComponentListener(this);
                        ItemsPanel.setDividerLocation(splitter, proportion);
                    }
                });
            }
        } else {
            splitter.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    if ((e.getChangeFlags() & 4L) != 0L && splitter.isShowing()) {
                        splitter.removeHierarchyListener(this);
                        ItemsPanel.setDividerLocation(splitter, proportion);
                    }
                }
            });
        }
        return splitter;
    }

    private void drawGraph(String message) {
        List<DayBalance> l_data = null;
        HMGraphRenderer l_gd = null;
        if (message != null) {
            l_gd = new HMGraphRenderer(message);
        } else {
            try {
                GregorianCalendar l_gc = new GregorianCalendar();
                l_gc.setTimeInMillis(System.currentTimeMillis());
                l_gc.set(11, 0);
                l_gc.set(12, 0);
                l_gc.set(13, 0);
                l_gc.add(2, -3);
                l_data = Util.getDailyBalance(DisplayedAccount.getDisplayedAccount(), l_gc.getTime(), new Date());
                l_gd = new HMGraphRenderer(l_data);
            }
            catch (Exception ex) {
                Logger.error(TAG, "updateGraph(): " + ex.toString());
            }
        }
        if (l_gd != null) {
            this.splitPaneBottomPanel.removeAll();
            this.splitPaneBottomPanel.add(l_gd);
            this.splitPaneBottomPanel.validate();
            this.splitPaneBottomPanel.repaint();
        }
    }

    public void updateGraph(String message) {
        final String l_finalMsg = message;
        SwingUtilities.invokeLater(new Thread(){

            @Override
            public void run() {
                ItemsPanel.this.drawGraph(l_finalMsg);
            }
        });
    }
}

