/*
 * Decompiled with CFR 0.152.
 */
package com.hmoney.gui;

import com.hmoney.Logger;
import com.hmoney.data.ACategory;
import com.hmoney.data.AItem;
import com.hmoney.data.APlannedItem;
import com.hmoney.data.Account;
import com.hmoney.data.DayAndMonthInvertedException;
import com.hmoney.data.OfxImport;
import com.hmoney.data.OfxSaxImporter;
import com.hmoney.data.QifImportExport;
import com.hmoney.data.Util;
import com.hmoney.gui.AItemTable;
import com.hmoney.gui.AItemTableCellEditor;
import com.hmoney.gui.AItemTableCellRenderer;
import com.hmoney.gui.AItemTableSelectionListener;
import com.hmoney.gui.APlannedItemTable;
import com.hmoney.gui.APlannedItemTableCellEditor;
import com.hmoney.gui.APlannedItemTableCellRenderer;
import com.hmoney.gui.AccountDialog;
import com.hmoney.gui.CategoriesDialog;
import com.hmoney.gui.Constants;
import com.hmoney.gui.DisplayedAccount;
import com.hmoney.gui.GuiUtil;
import com.hmoney.gui.HMFrameListener;
import com.hmoney.gui.ItemTablePopupListener;
import com.hmoney.gui.ItemsPanel;
import com.hmoney.gui.MenuManager;
import com.hmoney.gui.PlannedItemTablePopupListener;
import com.hmoney.gui.PlannedItemsPanel;
import com.hmoney.gui.SummaryHtmlPanel;
import com.hmoney.gui.custom.DateFormatCheckboxAccessory;
import com.hmoney.gui.custom.KeyboardMainListener;
import com.hmoney.gui.custom.Splash;
import com.hmoney.messages.Messages;
import com.hmoney.properties.HMProperties;
import com.hmoney.zip.Unzip;
import com.hmoney.zip.ZipMaker;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.ColorUIResource;

public class MainWindow {
    private static final String TAG = MainWindow.class.getSimpleName();
    private static JFrame frame;
    public static JPanel contentPanel;
    static SummaryHtmlPanel summaryHtmlPanel;
    static ItemsPanel itemsMainPanel;
    static PlannedItemsPanel plannedItemsMainPanel;
    protected static AItemTable aItemTable;
    protected static APlannedItemTable aPlannedItemTable;
    private static final Font tableHeaderFont;
    static List<JMenuItem> accountMenuItems;
    protected static JMenuBar menuBar;
    protected static JMenu mnAccountsMenu;
    protected static JMenu mnAccountPropertiesMenu;
    protected static JMenu mnBillsGraphAccountsMenu;
    protected static int mnBillsGraphAccountsMenuAccountsIndexGap;
    protected static JCheckBoxMenuItem mn30DaysGraphMenu;
    protected static JCheckBoxMenuItem mn90DaysGraphMenu;
    protected static JCheckBoxMenuItem mn6MonthsGraphMenu;
    protected static JCheckBoxMenuItem mn1YearGraphMenu;
    protected static JMenu mnOptionsMenu;
    protected static JMenu selectStateLocationMenu;
    protected static JMenuItem newAccountMenuItem;
    protected static JMenuItem deleteAccountMenuItem;
    protected static JMenuItem qifFileImportMenuItem;
    protected static JMenuItem ofxFileImportMenuItem;
    protected static JMenuItem saveArchiveFileMenuItem;
    protected static JMenuItem loadArchiveFileMenuItem;
    protected static JMenu msMoneyMenu;
    protected static JMenuItem msMoneyImportMenuItem;
    protected static JMenuItem mnSave;
    protected static JMenuItem mntmExit;
    protected static JMenuItem mntmExitWithoutSaving;
    protected static JMenuItem mntmAdjustColWidth;
    protected static JMenuItem categoryDlgMenuItem;
    protected static JMenuItem markAllClearedMenuItem;
    protected static JMenuItem markAllValidatedMenuItem;
    protected static JMenuItem aboutMenuItem;
    protected static JMenuItem mntmSearchSimple;
    protected static JMenuItem mntmSearchFull;
    protected static JMenuItem mntmClearSearch;
    protected static JMenuItem mntmCalc;
    protected static JMenuItem mntmPlannedItems;
    private static final int GRAPH_DAYS_30 = 30;
    private static final int GRAPH_DAYS_90 = 90;
    private static final int GRAPH_DAYS_182 = 182;
    private static final int GRAPH_DAYS_365 = 365;
    private static long lastAdjustColumnWidthTS;

    static {
        summaryHtmlPanel = null;
        plannedItemsMainPanel = null;
        tableHeaderFont = new Font("Sans Serif", 1, 14);
        accountMenuItems = new ArrayList<JMenuItem>();
        mnBillsGraphAccountsMenuAccountsIndexGap = -100;
        lastAdjustColumnWidthTS = 0L;
    }

    public static void main(String[] args) {
        Logger.setLevel(2);
        if (!HMProperties.loadProperties()) {
            Logger.warn(TAG, "main: Unable to restore state from directory '" + HMProperties.getSaveLocation() + "'");
        }
        Messages.init();
        ACategory.cleanCategories();
        try {
            Image image = GuiUtil.getImageIcon("splash.png").getImage();
            final Splash splash = new Splash(null, image);
            splash.setVisible(true);
            Timer timer = new Timer(2500, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    splash.setVisible(false);
                    splash.dispose();
                }
            });
            timer.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    MainWindow l_mainWindow = new MainWindow();
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static JFrame getFrame() {
        return frame;
    }

    public MainWindow() {
        try {
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
            int n = lookAndFeelInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
                if ("Nimbus".equals(info.getName())) {
                    UIManager.setLookAndFeel(info.getClassName());
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initialize();
    }

    private void initialize() {
        KeyboardMainListener.init();
        UIManager.put("ComboBox.selectionBackground", new ColorUIResource(Constants.selectedCellBgColor));
        UIManager.put("ComboBox.background", new ColorUIResource(Constants.oddRowColor));
        frame = new JFrame();
        frame.setBounds(HMProperties.getIntProperty("frame.left"), HMProperties.getIntProperty("frame.top"), HMProperties.getIntProperty("frame.width"), HMProperties.getIntProperty("frame.height"));
        frame.setDefaultCloseOperation(2);
        frame.getContentPane().setLayout(new BorderLayout(0, 0));
        frame.setIconImage(GuiUtil.getImageIcon("hmicon.png").getImage());
        frame.setTitle(String.valueOf(Messages.getString("MainWindow.0")) + 2 + "." + 0 + "." + 1);
        frame.setExtendedState(HMProperties.getIntProperty("frame.state"));
        HMFrameListener l_frameListener = new HMFrameListener();
        frame.addWindowListener(l_frameListener);
        frame.addWindowStateListener(l_frameListener);
        frame.addComponentListener(l_frameListener);
        GuiUtil.displayBusyCursor();
        summaryHtmlPanel = new SummaryHtmlPanel(this);
        contentPanel = new JPanel();
        frame.getContentPane().add(contentPanel);
        contentPanel.setLayout(new BorderLayout(0, 0));
        contentPanel.add(summaryHtmlPanel);
        aItemTable = new AItemTable();
        aItemTable.setShowGrid(false);
        aItemTable.setModel(aItemTable.getNewCustomTableModel());
        AItemTableCellRenderer l_aitcr = new AItemTableCellRenderer();
        aItemTable.setDefaultRenderer(Integer.class, l_aitcr);
        aItemTable.setDefaultRenderer(String.class, l_aitcr);
        AItemTableCellEditor l_aitce = new AItemTableCellEditor();
        aItemTable.setDefaultEditor(String.class, l_aitce);
        aItemTable.setBackground(Color.white);
        aItemTable.getTableHeader().setReorderingAllowed(false);
        aItemTable.getTableHeader().setFont(tableHeaderFont);
        aItemTable.getTableHeader().setBackground(Constants.tableHeaderBgColor);
        aItemTable.getTableHeader().setForeground(Constants.tableFontColor);
        aItemTable.getTableHeader().setToolTipText(Messages.getString("MainWindow.9"));
        aItemTable.addComponentListener(aItemTable);
        aItemTable.addMouseListener(new ItemTablePopupListener());
        aItemTable.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int col = aItemTable.columnAtPoint(e.getPoint());
                String name = aItemTable.getColumnName(col);
                aItemTable.clickOnColumnHeader(col, DisplayedAccount.getDisplayedAccount(), true);
                MainWindow.refreshTableViewPort();
            }
        });
        itemsMainPanel = new ItemsPanel(aItemTable);
        aItemTable.setSelectionMode(2);
        ListSelectionModel listSelectionModel = aItemTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AItemTableSelectionListener());
        aItemTable.setSelectionModel(listSelectionModel);
        APlannedItem.loadItems();
        aPlannedItemTable = new APlannedItemTable();
        aPlannedItemTable.setShowGrid(false);
        aPlannedItemTable.setModel(aPlannedItemTable.getNewCustomTableModel());
        APlannedItemTableCellRenderer l_apitcr = new APlannedItemTableCellRenderer();
        aPlannedItemTable.setDefaultRenderer(Integer.class, l_apitcr);
        aPlannedItemTable.setDefaultRenderer(String.class, l_apitcr);
        APlannedItemTableCellEditor l_apitce = new APlannedItemTableCellEditor();
        aPlannedItemTable.setDefaultEditor(String.class, l_apitce);
        aPlannedItemTable.setSelectionMode(0);
        aPlannedItemTable.setBackground(Color.white);
        aPlannedItemTable.getTableHeader().setReorderingAllowed(false);
        aPlannedItemTable.getTableHeader().setFont(tableHeaderFont);
        aPlannedItemTable.getTableHeader().setBackground(Constants.plannedTableHeaderBgColor);
        aPlannedItemTable.getTableHeader().setForeground(Constants.tableFontColor);
        aPlannedItemTable.addComponentListener(aPlannedItemTable);
        aPlannedItemTable.addMouseListener(new PlannedItemTablePopupListener());
        plannedItemsMainPanel = new PlannedItemsPanel(aPlannedItemTable);
        menuBar = new JMenuBar();
        menuBar.setAlignmentX(0.0f);
        frame.getContentPane().add((Component)menuBar, "North");
        JMenu mnFileMenu = new JMenu(Messages.getString("MainWindow.10"));
        menuBar.add(mnFileMenu);
        mnFileMenu.setHorizontalAlignment(2);
        final String l_newAccountText = Messages.getString("MainWindow.11");
        newAccountMenuItem = new JMenuItem(l_newAccountText);
        newAccountMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AccountDialog l_naDlg = new AccountDialog((Frame)frame, l_newAccountText, null);
                l_naDlg.setVisible(true);
                if (l_naDlg.okSelected) {
                    try {
                        MainWindow.this.addAccount(true, l_naDlg.accountName.getText().trim(), Account.getAccountTypeFromLabel(l_naDlg.accountTypeChoice.getSelectedItem().toString()), l_naDlg.initialAmount.getText(), l_naDlg.txtOpeningDate.getText());
                        summaryHtmlPanel.displayAccounts();
                    }
                    catch (Exception e2) {
                        Logger.error(TAG, "newAccountMenuItem: actionPerformed: " + e2);
                    }
                }
            }
        });
        mnFileMenu.add(newAccountMenuItem);
        deleteAccountMenuItem = new JMenuItem(Messages.getString("MainWindow.13"));
        deleteAccountMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] l_choiceValues = new String[Account.openAccounts.size()];
                int i1 = 0;
                for (Account l_a : Account.openAccounts) {
                    l_choiceValues[i1++] = l_a.accountName;
                }
                String l_delAccount = (String)JOptionPane.showInputDialog(null, Messages.getString("MainWindow.14"), Messages.getString("WINDOW_TITLE_SELECT"), 3, null, l_choiceValues, l_choiceValues[0]);
                if (l_delAccount == null) {
                    return;
                }
                int l_res = JOptionPane.showConfirmDialog(null, String.valueOf(Messages.getString("MainWindow.16")) + l_delAccount + "'", Messages.getString("WINDOW_TITLE_WARNING"), 2);
                if (l_res != 0) {
                    return;
                }
                Account.removeAccount(l_delAccount);
                HMProperties.updateAccountList();
                int i = 0;
                while (i < accountMenuItems.size()) {
                    JMenuItem l_mi = accountMenuItems.get(i);
                    if (l_mi.getText().equals(l_delAccount)) {
                        accountMenuItems.remove(l_mi);
                        mnAccountsMenu.remove(l_mi);
                        mnBillsGraphAccountsMenu.remove(i + mnBillsGraphAccountsMenuAccountsIndexGap);
                        mnAccountPropertiesMenu.remove(i);
                        break;
                    }
                    ++i;
                }
                summaryHtmlPanel.displayAccounts();
                if (DisplayedAccount.getDisplayedAccount() != null && DisplayedAccount.getDisplayedAccount().accountName.equals(l_delAccount)) {
                    MainWindow.itemsMainPanel.homepageButton.doClick();
                }
            }
        });
        mnFileMenu.add(deleteAccountMenuItem);
        mnAccountPropertiesMenu = new JMenu(Messages.getString("MainWindow.19"));
        mnFileMenu.add(mnAccountPropertiesMenu);
        mnFileMenu.addSeparator();
        qifFileImportMenuItem = new JMenuItem(Messages.getString("MainWindow.20"));
        qifFileImportMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser l_jfc = new JFileChooser();
                l_jfc.setFileSelectionMode(0);
                l_jfc.setCurrentDirectory(new File(HMProperties.getOpenDirLocation()));
                l_jfc.setAccessory(new DateFormatCheckboxAccessory(l_jfc));
                l_jfc.setFileFilter(new FileFilter(){

                    @Override
                    public String getDescription() {
                        return Messages.getString("MainWindow.21");
                    }

                    @Override
                    public boolean accept(File f) {
                        return f.isDirectory() || f.getName().toLowerCase().endsWith(".qif");
                    }
                });
                int l_jfRes = l_jfc.showDialog(frame, Messages.getString("MainWindow.23"));
                if (l_jfRes == 0) {
                    boolean l_invertDayAndMonthDateReadFormat = ((DateFormatCheckboxAccessory)l_jfc.getAccessory()).isSelected();
                    File file = l_jfc.getSelectedFile();
                    String sfilename = file.getPath();
                    HMProperties.setOpenDirLocation(file.getParent());
                    Logger.debug(TAG, "initialize: mnfileChooseFolder.actionPerformed: chosen file is: " + sfilename + " ,  l_invertDayAndMonthDateReadFormat=" + l_invertDayAndMonthDateReadFormat);
                    String l_importAccount = MainWindow.chooseImportAccount();
                    if (l_importAccount == null) {
                        return;
                    }
                    MainWindow.this.importFile(true, l_importAccount, sfilename, l_invertDayAndMonthDateReadFormat, false);
                }
            }
        });
        mnFileMenu.add(qifFileImportMenuItem);
        ofxFileImportMenuItem = new JMenuItem(Messages.getString("MainWindow.30"));
        ofxFileImportMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser l_jfc = new JFileChooser();
                l_jfc.setFileSelectionMode(0);
                l_jfc.setCurrentDirectory(new File(HMProperties.getOpenDirLocation()));
                l_jfc.setFileFilter(new FileFilter(){

                    @Override
                    public String getDescription() {
                        return Messages.getString("MainWindow.31");
                    }

                    @Override
                    public boolean accept(File f) {
                        return f.isDirectory() || f.getName().toLowerCase().endsWith(".ofx");
                    }
                });
                int l_jfRes = l_jfc.showDialog(frame, Messages.getString("MainWindow.33"));
                if (l_jfRes == 0) {
                    File file = l_jfc.getSelectedFile();
                    String sfilename = file.getPath();
                    HMProperties.setOpenDirLocation(file.getParent());
                    Logger.debug(TAG, "initialize: mnfileChooseFolder.actionPerformed: chosen file is: " + sfilename);
                    String l_importAccount = MainWindow.chooseImportAccount();
                    if (l_importAccount == null) {
                        return;
                    }
                    MainWindow.this.importFile(false, l_importAccount, sfilename, false, false);
                }
            }
        });
        mnFileMenu.add(ofxFileImportMenuItem);
        mnFileMenu.addSeparator();
        msMoneyMenu = new JMenu(Messages.getString("MainWindow.39"));
        msMoneyImportMenuItem = new JMenuItem(Messages.getString("MainWindow.40"));
        msMoneyImportMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int l_res = JOptionPane.showConfirmDialog(MainWindow.getFrame(), String.valueOf(Messages.getString("MainWindow.41")) + Messages.getString("MainWindow.42") + Messages.getString("MainWindow.43") + Messages.getString("MainWindow.44") + Messages.getString("MainWindow.45"), Messages.getString("MainWindow.46"), 2);
                if (l_res != 0) {
                    return;
                }
                JFileChooser l_jfc = new JFileChooser();
                l_jfc.setFileSelectionMode(0);
                l_jfc.setCurrentDirectory(new File(HMProperties.getOpenDirLocation()));
                l_jfc.setAccessory(new DateFormatCheckboxAccessory(l_jfc));
                l_jfc.setFileFilter(new FileFilter(){

                    @Override
                    public String getDescription() {
                        return Messages.getString("MainWindow.47");
                    }

                    @Override
                    public boolean accept(File f) {
                        return f.isDirectory() || f.getName().toLowerCase().endsWith(".qif");
                    }
                });
                int l_jfRes = l_jfc.showDialog(frame, Messages.getString("MainWindow.49"));
                if (l_jfRes == 0) {
                    boolean l_invertDayAndMonthDateReadFormat = ((DateFormatCheckboxAccessory)l_jfc.getAccessory()).isSelected();
                    File file = l_jfc.getSelectedFile();
                    String sfilename = file.getPath();
                    HMProperties.setOpenDirLocation(file.getParent());
                    Logger.debug(TAG, "initialize: mnfileChooseFolder.actionPerformed: chosen file is: " + sfilename + " ,  l_invertDayAndMonthDateReadFormat=" + l_invertDayAndMonthDateReadFormat);
                    String l_importAccount = MainWindow.chooseImportAccount();
                    if (l_importAccount == null) {
                        return;
                    }
                    MainWindow.this.importFile(true, l_importAccount, sfilename, l_invertDayAndMonthDateReadFormat, true);
                }
            }
        });
        msMoneyMenu.add(msMoneyImportMenuItem);
        mnFileMenu.add(msMoneyMenu);
        mnFileMenu.addSeparator();
        saveArchiveFileMenuItem = new JMenuItem(Messages.getString("MainWindow.59"));
        saveArchiveFileMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser l_jfc = new JFileChooser();
                l_jfc.setCurrentDirectory(new File(HMProperties.getOpenDirLocation()));
                SimpleDateFormat l_sdf = new SimpleDateFormat("yyyyMMdd-HHmm");
                Date l_date = new Date();
                l_jfc.setSelectedFile(new File(String.valueOf(HMProperties.getOpenDirLocation()) + File.separator + "HMoney_archive_" + l_sdf.format(l_date) + "-hmy.zip"));
                int l_jfRes = l_jfc.showSaveDialog(frame);
                if (l_jfRes == 0) {
                    try {
                        int l_res;
                        File l_file = l_jfc.getSelectedFile();
                        if (l_file.exists() && (l_res = JOptionPane.showConfirmDialog(null, Messages.getString("MainWindow.63"), Messages.getString("WINDOW_TITLE_WARNING"), 2)) != 0) {
                            return;
                        }
                        String l_archiveFileName = l_file.getAbsoluteFile().toString();
                        if (l_archiveFileName != null && !l_archiveFileName.endsWith(".zip")) {
                            l_archiveFileName = String.valueOf(l_archiveFileName) + ".zip";
                        }
                        GuiUtil.displayBusyCursor();
                        MainWindow.this.save(true);
                        ZipMaker l_zm = new ZipMaker();
                        l_zm.copyDirectoryToZipFile(new File(HMProperties.getSaveLocation()), new File(l_archiveFileName));
                        GuiUtil.displayNormalCursor();
                    }
                    catch (Exception ex) {
                        Logger.error(TAG, "Error exporting archive : " + ex);
                    }
                }
            }
        });
        mnFileMenu.add(saveArchiveFileMenuItem);
        loadArchiveFileMenuItem = new JMenuItem(Messages.getString("MainWindow.68"));
        loadArchiveFileMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser l_jfc = new JFileChooser();
                l_jfc.setFileSelectionMode(0);
                l_jfc.setCurrentDirectory(new File(HMProperties.getOpenDirLocation()));
                l_jfc.setFileFilter(new FileFilter(){

                    @Override
                    public String getDescription() {
                        return Messages.getString("MainWindow.69");
                    }

                    @Override
                    public boolean accept(File f) {
                        return f.isDirectory() || f.getName().toLowerCase().endsWith(".zip");
                    }
                });
                int l_jfRes = l_jfc.showDialog(frame, Messages.getString("MainWindow.71"));
                if (l_jfRes == 0) {
                    int l_res = JOptionPane.showConfirmDialog(null, Messages.getString("MainWindow.72"), Messages.getString("WINDOW_TITLE_WARNING"), 2);
                    if (l_res != 0) {
                        return;
                    }
                    File file = l_jfc.getSelectedFile();
                    String sfilename = file.getPath();
                    HMProperties.setOpenDirLocation(file.getParent());
                    Logger.debug(TAG, "initialize: loadArchiveFileMenuItem.actionPerformed: chosen file is: " + sfilename);
                    GuiUtil.displayBusyCursor();
                    try {
                        Unzip.archiveToDir(new File(sfilename), new File(HMProperties.getSaveLocation()));
                        JOptionPane.showMessageDialog(MainWindow.getFrame(), String.valueOf(Messages.getString("MainWindow.75")) + Messages.getString("MainWindow.76"), Messages.getString("MainWindow.77"), 2);
                        System.exit(0);
                    }
                    catch (Exception ex) {
                        Logger.error(TAG, "Error importing archive : " + ex);
                    }
                    GuiUtil.displayNormalCursor();
                }
            }
        });
        mnFileMenu.add(loadArchiveFileMenuItem);
        mnFileMenu.addSeparator();
        mntmExitWithoutSaving = new JMenuItem(Messages.getString("MainWindow.56"));
        mntmExitWithoutSaving.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int l_res = JOptionPane.showConfirmDialog(null, Messages.getString("MainWindow.57"), Messages.getString("WINDOW_TITLE_WARNING"), 2);
                if (l_res != 0) {
                    return;
                }
                System.exit(0);
            }
        });
        mnFileMenu.add(mntmExitWithoutSaving);
        mnFileMenu.addSeparator();
        mnSave = new JMenuItem(Messages.getString("MainWindow.79"));
        mnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiUtil.displayBusyCursor();
                MainWindow.this.save(true);
                GuiUtil.displayNormalCursor();
            }
        });
        mnFileMenu.add(mnSave);
        mntmExit = new JMenuItem(Messages.getString("MainWindow.80"));
        mntmExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Util.saveAll(false);
                frame.dispose();
            }
        });
        mnFileMenu.add(mntmExit);
        JMenu mnEditMenu = new JMenu(Messages.getString("MainWindow.81"));
        menuBar.add(mnEditMenu);
        mntmSearchSimple = new JMenuItem(Messages.getString("MainWindow.82"));
        mntmSearchSimple.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String l_searchString = JOptionPane.showInputDialog(null, Messages.getString("MainWindow.83"), Messages.getString("MainWindow.84"), 3);
                if (l_searchString == null) {
                    return;
                }
                MainWindow.searchOperations(l_searchString, 0);
                itemsMainPanel.updateGraph(null);
            }
        });
        mnEditMenu.add(mntmSearchSimple);
        mntmSearchFull = new JMenuItem(Messages.getString("MainWindow.85"));
        mntmSearchFull.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String l_searchString = JOptionPane.showInputDialog(null, Messages.getString("MainWindow.86"), Messages.getString("MainWindow.87"), 3);
                if (l_searchString == null) {
                    return;
                }
                Account l_resAccount = new Account("searchResults", false);
                for (Account l_a : Account.openAccounts) {
                    List<AItem> l_il = l_a.searchOperations(l_searchString, 0);
                    l_resAccount.addOperations(l_il);
                }
                DisplayedAccount.pushAccount(l_resAccount, mntmSearchFull);
                if (DisplayedAccount.getDisplayedAccount() != null) {
                    aItemTable.clickOnColumnHeader(2, DisplayedAccount.getDisplayedAccount(), false);
                }
                MainWindow.refreshTableViewPort();
                itemsMainPanel.updateGraph(null);
            }
        });
        mnEditMenu.add(mntmSearchFull);
        mntmClearSearch = new JMenuItem(Messages.getString("MainWindow.89"));
        mntmClearSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DisplayedAccount.popAccount();
                MainWindow.refreshTableViewPort();
                itemsMainPanel.updateGraph(null);
            }
        });
        mnEditMenu.add(mntmClearSearch);
        mntmClearSearch.setEnabled(false);
        mnEditMenu.addSeparator();
        mntmAdjustColWidth = new JMenuItem(Messages.getString("MainWindow.90"));
        mntmAdjustColWidth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                aItemTable.setColWidth(aItemTable.getWidth());
            }
        });
        mnEditMenu.add(mntmAdjustColWidth);
        mnEditMenu.addSeparator();
        final String l_catMenuItemText = Messages.getString("MainWindow.91");
        categoryDlgMenuItem = new JMenuItem(l_catMenuItemText);
        categoryDlgMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CategoriesDialog l_catDlg = new CategoriesDialog((Frame)frame, l_catMenuItemText);
                l_catDlg.setVisible(true);
                if (!ACategory.getSaved()) {
                    Util.saveAll(false);
                }
            }
        });
        mnEditMenu.add(categoryDlgMenuItem);
        JMenuItem addDefaultCategoriesMenuItem = new JMenuItem(Messages.getString("MainWindow.114"));
        addDefaultCategoriesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int l_res = JOptionPane.showConfirmDialog(null, Messages.getString("MainWindow.115"), Messages.getString("WINDOW_TITLE_WARNING"), 2);
                if (l_res != 0) {
                    return;
                }
                GuiUtil.displayBusyCursor();
                ACategory.addDefaultCategories(HMProperties.getStringProperty("hmy.locale"));
                GuiUtil.displayNormalCursor();
            }
        });
        mnEditMenu.add(addDefaultCategoriesMenuItem);
        JMenuItem removeUnusedDefaultCategoriesMenuItem = new JMenuItem(Messages.getString("MainWindow.113"));
        removeUnusedDefaultCategoriesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int l_res = JOptionPane.showConfirmDialog(null, Messages.getString("MainWindow.116"), Messages.getString("WINDOW_TITLE_WARNING"), 2);
                if (l_res != 0) {
                    return;
                }
                GuiUtil.displayBusyCursor();
                ACategory.removeUnusedDefaultCategories(HMProperties.getStringProperty("hmy.locale"));
                GuiUtil.displayNormalCursor();
            }
        });
        mnEditMenu.add(removeUnusedDefaultCategoriesMenuItem);
        mnEditMenu.addSeparator();
        markAllValidatedMenuItem = new JMenuItem(Messages.getString("MainWindow.92"));
        markAllValidatedMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int l_res = JOptionPane.showConfirmDialog(null, Messages.getString("MainWindow.93"), Messages.getString("WINDOW_TITLE_WARNING"), 2);
                if (l_res != 0) {
                    return;
                }
                int i = 0;
                while (i < DisplayedAccount.getDisplayedAccount().getItemListSize()) {
                    AItem l_ai = DisplayedAccount.getDisplayedAccount().getItem(i);
                    if (!l_ai.isUserValidated()) {
                        l_ai.setUserValidated(true, DisplayedAccount.getDisplayedAccount());
                    }
                    ++i;
                }
                MainWindow.refreshTableViewPort();
            }
        });
        mnEditMenu.add(markAllValidatedMenuItem);
        markAllClearedMenuItem = new JMenuItem(Messages.getString("MainWindow.95"));
        markAllClearedMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int l_res = JOptionPane.showConfirmDialog(null, Messages.getString("MainWindow.96"), Messages.getString("WINDOW_TITLE_WARNING"), 2);
                if (l_res != 0) {
                    return;
                }
                int i = 0;
                while (i < DisplayedAccount.getDisplayedAccount().getItemListSize()) {
                    AItem l_ai = DisplayedAccount.getDisplayedAccount().getItem(i);
                    if (!l_ai.isCleared()) {
                        l_ai.setCleared(true);
                    }
                    ++i;
                }
                MainWindow.refreshTableViewPort();
            }
        });
        mnEditMenu.add(markAllClearedMenuItem);
        mnAccountsMenu = new JMenu(Messages.getString("MainWindow.98"));
        menuBar.add(mnAccountsMenu);
        mnBillsGraphAccountsMenu = new JMenu(Messages.getString("MainWindow.99"));
        menuBar.add(mnBillsGraphAccountsMenu);
        mntmPlannedItems = new JMenuItem(Messages.getString("MainWindow.100"));
        mntmPlannedItems.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiUtil.displayBusyCursor();
                try {
                    MenuManager.inBills();
                    contentPanel.removeAll();
                    contentPanel.setBackground(Color.red);
                    contentPanel.add(plannedItemsMainPanel);
                    KeyboardMainListener.addCurrentListener(aPlannedItemTable);
                    contentPanel.validate();
                    contentPanel.repaint();
                    plannedItemsMainPanel.updateGraph();
                }
                finally {
                    GuiUtil.displayNormalCursor();
                }
            }
        });
        mnBillsGraphAccountsMenu.add(mntmPlannedItems);
        mnBillsGraphAccountsMenu.addSeparator();
        mnBillsGraphAccountsMenu.addSeparator();
        mn30DaysGraphMenu = new JCheckBoxMenuItem(Messages.getString("MainWindow.101"));
        mn30DaysGraphMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.setGraphDays(30);
            }
        });
        mnBillsGraphAccountsMenu.add(mn30DaysGraphMenu);
        mn90DaysGraphMenu = new JCheckBoxMenuItem(Messages.getString("MainWindow.102"));
        mn90DaysGraphMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.setGraphDays(90);
            }
        });
        mnBillsGraphAccountsMenu.add(mn90DaysGraphMenu);
        mn6MonthsGraphMenu = new JCheckBoxMenuItem(Messages.getString("MainWindow.103"));
        mn6MonthsGraphMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.setGraphDays(182);
            }
        });
        mnBillsGraphAccountsMenu.add(mn6MonthsGraphMenu);
        mn1YearGraphMenu = new JCheckBoxMenuItem(Messages.getString("MainWindow.104"));
        mn1YearGraphMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.setGraphDays(365);
            }
        });
        mnBillsGraphAccountsMenu.add(mn1YearGraphMenu);
        mnBillsGraphAccountsMenu.addSeparator();
        mnBillsGraphAccountsMenu.addSeparator();
        mnBillsGraphAccountsMenuAccountsIndexGap = 9;
        mnOptionsMenu = new JMenu(Messages.getString("MainWindow.105"));
        menuBar.add(mnOptionsMenu);
        selectStateLocationMenu = new JMenu(Messages.getString("MainWindow.106"));
        mnOptionsMenu.add(selectStateLocationMenu);
        MainWindow.updateSaveLocationMenu();
        JMenu selectLanguageMenu = new JMenu(Messages.getString("MainWindow.107"));
        mnOptionsMenu.add(selectLanguageMenu);
        int i = 0;
        while (i < Messages.languages_codes.length) {
            JCheckBoxMenuItem languageMenuItem = new JCheckBoxMenuItem(String.valueOf(Messages.languages[i]) + " - " + Messages.languages_codes[i]);
            final String l_langCode = Messages.languages_codes[i];
            languageMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainWindow.this.setLanguage(l_langCode);
                }
            });
            selectLanguageMenu.add(languageMenuItem);
            if (HMProperties.getStringProperty("hmy.locale") != null && HMProperties.getStringProperty("hmy.locale").equals(l_langCode)) {
                languageMenuItem.setSelected(true);
            }
            ++i;
        }
        mnOptionsMenu.addSeparator();
        JMenuItem webSiteMenuItem = new JMenuItem(Messages.getString("MainWindow.117"));
        webSiteMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (!Desktop.isDesktopSupported()) {
                        throw new Exception("Unsupported desktop");
                    }
                    Desktop.getDesktop().browse(new URI("http://hmoney.mooo.com"));
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, String.valueOf(Messages.getString("MainWindow.120")) + ex);
                }
            }
        });
        mnOptionsMenu.add(webSiteMenuItem);
        aboutMenuItem = new JMenuItem(Messages.getString("MainWindow.121"));
        aboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(null, String.valueOf(Messages.getString("MainWindow.122")) + 2 + "." + 0 + "." + 1 + Messages.getString("MainWindow.125") + System.getProperty("java.vendor") + " " + System.getProperty("java.version") + Messages.getString("MainWindow.129") + System.getProperty("java.home") + "</font>" + Messages.getString("MainWindow.132") + Messages.getString("MainWindow.133") + Messages.getString("MainWindow.134") + Messages.getString("MainWindow.135") + Messages.getString("MainWindow.136") + Messages.getString("MainWindow.137") + Messages.getString("MainWindow.138") + Messages.getString("MainWindow.139") + Messages.getString("MainWindow.140") + Messages.getString("MainWindow.141") + Messages.getString("MainWindow.142") + Messages.getString("MainWindow.143") + Messages.getString("MainWindow.144") + Messages.getString("MainWindow.145") + "</html>");
            }
        });
        mnOptionsMenu.add(aboutMenuItem);
        SwingUtilities.invokeLater(new Thread(){

            @Override
            public void run() {
                String l_accountFiles = HMProperties.getStringProperty("hmy.account_files");
                if (l_accountFiles != null && l_accountFiles.length() > 0) {
                    StringTokenizer l_st = new StringTokenizer(l_accountFiles, ",");
                    while (l_st.hasMoreTokens()) {
                        String l_fn = null;
                        try {
                            l_fn = l_st.nextToken().trim();
                            MainWindow.this.addAccount(false, l_fn, null, null, null);
                        }
                        catch (Exception e) {
                            Logger.error(TAG, "SwingUtilities.invokeLater.run(): addAccount('" + l_fn + "'): " + e);
                            e.printStackTrace(System.err);
                        }
                    }
                }
                MenuManager.inHomePage();
                summaryHtmlPanel.displayAccounts();
                MainWindow.setGraphDays(APlannedItem.getGraphDays());
            }
        });
        MainWindow.adjustColumnWidth();
        this.initDragAndDrop();
        GuiUtil.displayNormalCursor();
    }

    private void setLanguage(String newLocale) {
        Messages.saveLocaleSetting(newLocale);
        JOptionPane.showMessageDialog(null, Messages.getString("MainWindow.149"));
    }

    private void addAccount(boolean newAccount, String accountName, String accountType, String initialAmount, String openingDate) throws Exception {
        Logger.debug(TAG, "addAccount (" + newAccount + ", " + accountName + ", " + accountType + ", " + initialAmount + ")");
        Account l_a = new Account(!newAccount);
        if (newAccount) {
            l_a.accountType = accountType;
            l_a.accountName = accountName;
            AItem l_ai = new AItem(Util.parseAmount(initialAmount));
            l_ai.setMemo(Messages.getString("MainWindow.155"));
            l_ai.setDate(new Date());
            if (openingDate != null) {
                l_ai.setDate(Util.parseDate(openingDate, Util.getDateDayFirst()));
            }
            l_a.addItem(l_ai);
        } else {
            l_a.loadFile(accountName);
        }
        l_a.calculateBalance();
        Logger.info(TAG, " Adding account '" + l_a.accountName + "'");
        Account.openAccounts.add(l_a);
        if (newAccount) {
            l_a.save();
        }
        HMProperties.updateAccountList();
        JMenuItem mntmAccount = new JMenuItem(accountName, new ImageIcon(GuiUtil.getAccountImageIcon(l_a.accountType).getImage().getScaledInstance(32, 32, 4)));
        accountMenuItems.add(mntmAccount);
        mntmAccount.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMenuItem l_source = (JMenuItem)e.getSource();
                String l_accountName = l_source.getText();
                MainWindow.this.displayAccount(l_accountName);
            }
        });
        mnAccountsMenu.add(mntmAccount);
        mnAccountsMenu.addSeparator();
        JCheckBoxMenuItem mntmGraphBillsForAccount = new JCheckBoxMenuItem(accountName);
        mntmGraphBillsForAccount.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMenuItem l_source = (JMenuItem)e.getSource();
                String l_accountName = l_source.getText();
                Logger.info(TAG, " Changing graph option for account '" + l_accountName + "'");
                Account l_a = Account.getAccountByName(l_accountName);
                l_a.setGraphBills(!l_a.isGraphBills());
                if (l_a.isGraphBills()) {
                    l_source.setForeground(Constants.plannedTableHeaderBgColor);
                } else {
                    l_source.setForeground(Color.black);
                }
                plannedItemsMainPanel.updateGraph();
            }
        });
        if (l_a.isGraphBills()) {
            mntmGraphBillsForAccount.setSelected(true);
            mntmGraphBillsForAccount.setForeground(Constants.plannedTableHeaderBgColor);
        } else {
            mntmGraphBillsForAccount.setForeground(Color.black);
        }
        mnBillsGraphAccountsMenu.add(mntmGraphBillsForAccount);
        JMenuItem mntmAccountProperties = new JMenuItem(accountName, new ImageIcon(GuiUtil.getAccountImageIcon(l_a.accountType).getImage().getScaledInstance(32, 32, 4)));
        mnAccountPropertiesMenu.add(mntmAccountProperties);
        mntmAccountProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMenuItem l_source = (JMenuItem)e.getSource();
                String l_accountName = l_source.getText();
                Logger.info(TAG, " Properties dialog for account '" + l_accountName + "'");
                Account l_a = Account.getAccountByName(l_accountName);
                AccountDialog l_naDlg = new AccountDialog((Frame)frame, String.valueOf(Messages.getString("MainWindow.164")) + l_a.accountName, l_a);
                l_naDlg.setVisible(true);
            }
        });
        if (newAccount) {
            mntmAccount.doClick();
        }
    }

    public void displayAccount(String account) {
        GuiUtil.displayBusyCursor();
        contentPanel.removeAll();
        contentPanel.add(itemsMainPanel);
        KeyboardMainListener.addCurrentListener(aItemTable);
        contentPanel.repaint();
        Logger.info(TAG, " Displaying account '" + account + "'");
        Account l_a = Account.getAccountByName(account);
        DisplayedAccount.setDisplayedAccount(l_a);
        aItemTable.setModel(aItemTable.getNewCustomTableModel());
        DisplayedAccount.getDisplayedAccount().calculateBalance();
        aItemTable.clickOnColumnHeader(2, DisplayedAccount.getDisplayedAccount(), false);
        aItemTable.setColWidth(aItemTable.getWidth());
        MainWindow.itemsMainPanel.accountLabel.setText("  " + DisplayedAccount.getDisplayedAccount().accountName);
        MainWindow.itemsMainPanel.accountLabel.setIcon(new ImageIcon(GuiUtil.getAccountImageIcon(DisplayedAccount.getDisplayedAccount().accountType).getImage().getScaledInstance(32, 32, 4)));
        contentPanel.validate();
        contentPanel.repaint();
        MenuManager.inAccount(DisplayedAccount.getDisplayedAccount().accountName);
        itemsMainPanel.updateGraph(null);
        SwingUtilities.invokeLater(new Thread(){

            @Override
            public void run() {
                aItemTable.scrollRectToVisible(aItemTable.getCellRect(DisplayedAccount.getDisplayedAccount().getItemListSize() > 0 ? DisplayedAccount.getDisplayedAccount().getItemListSize() - 1 : 0, 0, true));
            }
        });
        GuiUtil.displayNormalCursor();
    }

    private void save(boolean forceSave) {
        GuiUtil.displayBusyCursor();
        try {
            Util.saveAll(forceSave);
        }
        catch (Exception e) {
            Logger.error(TAG, "loadFile: " + e.toString());
            e.printStackTrace();
        }
        GuiUtil.displayNormalCursor();
    }

    private void importFile(boolean qifImport, String importAccount, String fileName, boolean invertDayAndMonthDateReadFormat, boolean isMoneyMigration) {
        GuiUtil.displayBusyCursor();
        List<AItem> l_importedItems = null;
        boolean dateDayFirst = Util.getDateDayFirst();
        if (invertDayAndMonthDateReadFormat) {
            dateDayFirst = !dateDayFirst;
        }
        try {
            if (qifImport) {
                try {
                    l_importedItems = new QifImportExport().loadFile(fileName, dateDayFirst, isMoneyMigration);
                }
                catch (DayAndMonthInvertedException damie) {
                    Logger.warn(TAG, "loadFile: " + damie.toString());
                    try {
                        l_importedItems = new QifImportExport().loadFile(fileName, !dateDayFirst, isMoneyMigration);
                    }
                    catch (Exception e) {
                        Logger.error(TAG, "loadFile: " + e.toString());
                        e.printStackTrace(System.err);
                    }
                }
            } else {
                try {
                    OfxSaxImporter l_ofxSaxImporter = new OfxSaxImporter();
                    l_importedItems = l_ofxSaxImporter.loadFile(fileName);
                }
                catch (Exception e) {
                    try {
                        OfxImport l_ofxImport = new OfxImport();
                        l_importedItems = l_ofxImport.loadFile(fileName);
                    }
                    catch (Exception e2) {
                        Logger.error(TAG, "loadFile: " + e.toString() + " , then " + e2.toString());
                        e2.printStackTrace(System.err);
                    }
                }
            }
            Logger.debug(TAG, "loadFile: Imported operations count=" + l_importedItems.size());
            if (l_importedItems.size() < 1) {
                return;
            }
            try {
                Account l_importAccount = Account.getAccountByName(importAccount);
                ArrayList<AItem> l_removeAIList = new ArrayList<AItem>();
                int i = 0;
                while (i < l_importedItems.size()) {
                    l_importedItems.get(i).setNewlyImported(true);
                    AItem l_dup = l_importAccount.findDup(l_importedItems.get(i));
                    if (l_dup != null) {
                        l_dup.setDup(l_importedItems.get(i));
                        l_removeAIList.add(l_importedItems.get(i));
                    }
                    ++i;
                }
                for (AItem l_ai : l_removeAIList) {
                    l_importedItems.remove(l_ai);
                }
                l_importAccount.addOperations(l_importedItems);
                l_importAccount.guessCategoryForImportedItems();
                l_importAccount.calculateBalance();
                aItemTable.setModel(aItemTable.getNewCustomTableModel());
                if (DisplayedAccount.getDisplayedAccount() != null) {
                    aItemTable.clickOnColumnHeader(2, DisplayedAccount.getDisplayedAccount(), false);
                }
                summaryHtmlPanel.displayAccounts();
                this.displayAccount(importAccount);
            }
            catch (Exception e) {
                Logger.error(TAG, "loadFile: " + e.toString());
                JOptionPane.showMessageDialog(MainWindow.getFrame(), String.valueOf(Messages.getString("MainWindow.172")) + e.getMessage(), Messages.getString("WINDOW_TITLE_ERROR"), 2);
            }
        }
        finally {
            GuiUtil.displayNormalCursor();
        }
    }

    private static void refreshTableViewPort() {
        aItemTable.setVisible(false);
        aItemTable.setVisible(true);
        aItemTable.setFont(new Font("Serif", 1, 20));
    }

    public static void adjustColumnWidth() {
        if (System.currentTimeMillis() < lastAdjustColumnWidthTS + 20000L) {
            return;
        }
        lastAdjustColumnWidthTS = System.currentTimeMillis();
        SwingUtilities.invokeLater(new Thread(){

            @Override
            public void run() {
                aItemTable.setColWidth(aItemTable.getWidth());
            }
        });
    }

    public static void setGraphDays(int days) {
        mn30DaysGraphMenu.setSelected(false);
        mn30DaysGraphMenu.setForeground(Color.black);
        mn90DaysGraphMenu.setSelected(false);
        mn90DaysGraphMenu.setForeground(Color.black);
        mn6MonthsGraphMenu.setSelected(false);
        mn6MonthsGraphMenu.setForeground(Color.black);
        mn1YearGraphMenu.setSelected(false);
        mn1YearGraphMenu.setForeground(Color.black);
        switch (days) {
            case 30: {
                mn30DaysGraphMenu.setSelected(true);
                mn30DaysGraphMenu.setForeground(Constants.plannedTableHeaderBgColor);
                break;
            }
            case 90: {
                mn90DaysGraphMenu.setSelected(true);
                mn90DaysGraphMenu.setForeground(Constants.plannedTableHeaderBgColor);
                break;
            }
            case 182: {
                mn6MonthsGraphMenu.setSelected(true);
                mn6MonthsGraphMenu.setForeground(Constants.plannedTableHeaderBgColor);
                break;
            }
            case 365: {
                mn1YearGraphMenu.setSelected(true);
                mn1YearGraphMenu.setForeground(Constants.plannedTableHeaderBgColor);
            }
        }
        APlannedItem.setGraphDays(days);
        plannedItemsMainPanel.updateGraph();
    }

    public static void searchOperations(String searchString, int searchType) {
        Account l_resAccount = new Account("searchResults", false);
        l_resAccount.addOperations(DisplayedAccount.getDisplayedAccount().searchOperations(searchString, searchType));
        DisplayedAccount.pushAccount(l_resAccount, mntmSearchSimple);
        MainWindow.refreshTableViewPort();
    }

    public static void updateSaveLocationMenu() {
        selectStateLocationMenu.removeAll();
        JMenuItem changeStateLocationMenuItem = new JMenuItem(Messages.getString("MainWindow.176"));
        selectStateLocationMenu.add(changeStateLocationMenuItem);
        selectStateLocationMenu.addSeparator();
        changeStateLocationMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser l_jfc = new JFileChooser();
                l_jfc.setFileSelectionMode(1);
                l_jfc.setCurrentDirectory(new File(HMProperties.getOpenDirLocation()));
                int l_jfRes = l_jfc.showDialog(frame, Messages.getString("MainWindow.177"));
                if (l_jfRes == 0) {
                    File l_file = l_jfc.getSelectedFile();
                    String l_sfilename = l_file.getPath();
                    HMProperties.setOpenDirLocation(l_sfilename);
                    MainWindow.updateSaveLocationAndExit(l_sfilename);
                }
            }
        });
        for (String l_dir : HMProperties.getSaveLocationHistory()) {
            JCheckBoxMenuItem l_historyStateLocationMenuItem = new JCheckBoxMenuItem(l_dir);
            selectStateLocationMenu.add(l_historyStateLocationMenuItem);
            if (l_dir != null && l_dir.equals(HMProperties.getSaveLocation())) {
                l_historyStateLocationMenuItem.setBackground(Constants.tableHeaderBgColor);
                l_historyStateLocationMenuItem.setForeground(Color.blue);
                l_historyStateLocationMenuItem.setSelected(true);
            }
            l_historyStateLocationMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JMenuItem l_source = (JMenuItem)e.getSource();
                    String l_dirName = l_source.getText();
                    MainWindow.updateSaveLocationAndExit(l_dirName);
                }
            });
        }
    }

    public static void updateSaveLocationAndExit(String saveDir) {
        Logger.debug(TAG, "updateSaveLocationAndExit: chosen dir is: " + saveDir);
        Util.saveAll(false);
        HMProperties.setSaveLocation(saveDir);
        MainWindow.updateSaveLocationMenu();
        JOptionPane.showMessageDialog(MainWindow.getFrame(), String.valueOf(Messages.getString("MainWindow.179")) + Messages.getString("MainWindow.180") + "<br><center>" + saveDir + "</center></html>", Messages.getString("MainWindow.183"), 2);
        MainWindow.getFrame().dispose();
    }

    private static String chooseImportAccount() {
        Object[] l_choiceValues = new String[Account.openAccounts.size()];
        int i1 = 0;
        for (Account l_a : Account.openAccounts) {
            l_choiceValues[i1++] = l_a.accountName;
        }
        String l_importAccount = (String)JOptionPane.showInputDialog(null, Messages.getString("MainWindow.26"), Messages.getString("WINDOW_TITLE_SELECT"), 3, null, l_choiceValues, l_choiceValues[0]);
        if (l_importAccount == null) {
            JOptionPane.showMessageDialog(null, Messages.getString("MainWindow.28"), Messages.getString("WINDOW_TITLE_INFO"), 1, null);
        }
        return l_importAccount;
    }

    private void initDragAndDrop() {
        frame.setDropTarget(new DropTarget(){

            /*
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public synchronized void drop(DropTargetDropEvent dtde) {
                try {
                    l_transfer = dtde.getTransferable();
                    if (!l_transfer.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) ** GOTO lbl-1000
                    dtde.acceptDrop(3);
                    objects = (List)l_transfer.getTransferData(DataFlavor.javaFileListFlavor);
                    var5_5 = objects.iterator();
                    if (true) ** GOTO lbl28
lbl-1000:
                    // 1 sources

                    {
                        JOptionPane.showMessageDialog(null, Messages.getString("MainWindow.190"), Messages.getString("WINDOW_TITLE_INFO"), 1, null);
                        return;
                        do {
                            if (!((object = var5_5.next()) instanceof File)) continue;
                            source = (File)object;
                            l_absFileName = source.getAbsolutePath().toLowerCase();
                            if (l_absFileName.endsWith(".ofx")) {
                                l_importAccount = MainWindow.access$4();
                                if (l_importAccount == null) {
                                    return;
                                }
                                MainWindow.access$5(MainWindow.this, false, l_importAccount, source.getPath(), false, false);
                                continue;
                            }
                            if (l_absFileName.endsWith(".qif")) {
                                l_importAccount = MainWindow.access$4();
                                if (l_importAccount == null) {
                                    return;
                                }
                                ** try [egrp 3[TRYBLOCK] [2 : 152->220)] { 
lbl25:
                                // 1 sources

                                MainWindow.access$5(MainWindow.this, true, l_importAccount, source.getPath(), false, false);
                                continue;
                            }
                            JOptionPane.showMessageDialog(null, Messages.getString("MainWindow.191"), Messages.getString("WINDOW_TITLE_INFO"), 1, null);
lbl28:
                            // 5 sources

                        } while (var5_5.hasNext());
                        return;
                    }
                }
lbl30:
                // 2 sources

                catch (Exception ex) {
                    Logger.error(MainWindow.access$3(), "drop: " + ex.getMessage());
                    return;
                }
                finally {
                    dtde.dropComplete(true);
                }
            }
        });
    }
}

