/*
 * Decompiled with CFR 0.152.
 */
package com.hmoney.gui;

import com.hmoney.Logger;
import com.hmoney.data.APlannedItem;
import com.hmoney.data.Account;
import com.hmoney.data.AccountFuturBalance;
import com.hmoney.data.AccountsFuturData;
import com.hmoney.data.Util;
import com.hmoney.gui.APlannedItemTable;
import com.hmoney.gui.Constants;
import com.hmoney.gui.GuiUtil;
import com.hmoney.gui.MainWindow;
import com.hmoney.gui.MenuManager;
import com.hmoney.gui.NewPlannedOperationDialog;
import com.hmoney.gui.custom.HMGraphRenderer;
import com.hmoney.gui.custom.KeyboardMainListener;
import com.hmoney.messages.Messages;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class PlannedItemsPanel
extends JPanel {
    private static final String TAG = PlannedItemsPanel.class.getSimpleName();
    JSplitPane splitPane;
    JPanel splitPaneBottomPanel;
    JPanel graphAccountsPanel;
    private float splitpaneDividerLocation = 0.4f;
    JButton homepageButton;
    JLabel plannedItemsTopLabel;

    public PlannedItemsPanel(final APlannedItemTable aPlannedItemTable) {
        this.setLayout(new BorderLayout(0, 0));
        JPanel panelTop = new JPanel();
        JPanel panelTopLeft = new JPanel();
        panelTop.setLayout(new BorderLayout(0, 0));
        panelTopLeft.setLayout(new BorderLayout(0, 0));
        this.add((Component)panelTop, "North");
        this.homepageButton = new JButton(Messages.getString("PlannedItemsPanel.0"));
        this.homepageButton.setIcon(new ImageIcon(GuiUtil.getImageIcon("home.png").getImage().getScaledInstance(24, 24, 4)));
        final APlannedItemTable thisPlannedItemsTable = aPlannedItemTable;
        this.homepageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.contentPanel.removeAll();
                KeyboardMainListener.removeListener(thisPlannedItemsTable);
                MainWindow.contentPanel.add(MainWindow.summaryHtmlPanel);
                MenuManager.inHomePage();
                GuiUtil.displayBusyCursor();
                MainWindow.summaryHtmlPanel.displayAccounts();
            }
        });
        panelTopLeft.add((Component)this.homepageButton, "West");
        JButton l_newOperationButton = new JButton(Messages.getString("PlannedItemsPanel.2"));
        l_newOperationButton.setIcon(new ImageIcon(GuiUtil.getImageIcon("plus.png").getImage().getScaledInstance(24, 24, 4)));
        l_newOperationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewPlannedOperationDialog l_newOpDlg = new NewPlannedOperationDialog(MainWindow.getFrame(), Messages.getString("PlannedItemsPanel.4"), true);
                l_newOpDlg.setVisible(true);
                if (!l_newOpDlg.okSelected) {
                    return;
                }
                APlannedItem.addItem(l_newOpDlg.aPlannedItem);
                APlannedItem.sort(0, true);
                aPlannedItemTable.getTableModel().fireTableDataChanged();
                int l_rowSel = APlannedItem.indexOf(l_newOpDlg.aPlannedItem);
                GuiUtil.showTableElementInViewPort(MainWindow.aPlannedItemTable, l_rowSel, 0);
                PlannedItemsPanel.this.updateGraph();
            }
        });
        panelTopLeft.add((Component)l_newOperationButton, "Center");
        panelTop.add((Component)panelTopLeft, "West");
        JPanel accountLabelPanel = new JPanel();
        accountLabelPanel.setBackground(Constants.plannedTableHeaderBgColor);
        accountLabelPanel.setForeground(Color.white);
        this.plannedItemsTopLabel = new JLabel();
        this.plannedItemsTopLabel.setForeground(Color.white);
        this.plannedItemsTopLabel.setFont(new Font("Sans Serif", 1, 24));
        this.plannedItemsTopLabel.setText("  " + Messages.getString("PlannedItemsPanel.6"));
        this.plannedItemsTopLabel.setIcon(new ImageIcon(GuiUtil.getImageIcon("planning.png").getImage().getScaledInstance(64, 32, 4)));
        accountLabelPanel.add(this.plannedItemsTopLabel);
        panelTop.add((Component)accountLabelPanel, "Center");
        this.splitPane = new JSplitPane(0);
        this.splitPaneBottomPanel = new JPanel();
        this.splitPaneBottomPanel.setLayout(new BorderLayout(0, 0));
        JScrollPane scrollPane = new JScrollPane(aPlannedItemTable);
        this.splitPane.setTopComponent(scrollPane);
        this.splitPane.setBottomComponent(this.splitPaneBottomPanel);
        this.add(this.splitPane);
        PlannedItemsPanel.setDividerLocation(this.splitPane, this.splitpaneDividerLocation);
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                Logger.debug(TAG, "addAncestorListener.ancestorAdded: set divider location=" + PlannedItemsPanel.this.splitpaneDividerLocation);
                PlannedItemsPanel.this.splitPane.setDividerLocation(PlannedItemsPanel.this.splitpaneDividerLocation);
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                if (PlannedItemsPanel.this.splitPane.getHeight() > 0) {
                    PlannedItemsPanel.this.splitpaneDividerLocation = (float)PlannedItemsPanel.this.splitPane.getDividerLocation() / (float)PlannedItemsPanel.this.splitPane.getHeight();
                    Logger.debug(TAG, "addAncestorListener.ancestorAdded: save divider location=" + PlannedItemsPanel.this.splitpaneDividerLocation);
                }
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
    }

    public static JSplitPane setDividerLocation(final JSplitPane splitter, final double proportion) {
        if (splitter.isShowing()) {
            if (splitter.getWidth() > 0 && splitter.getHeight() > 0) {
                splitter.setDividerLocation(proportion);
            } else {
                splitter.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentResized(ComponentEvent ce) {
                        splitter.removeComponentListener(this);
                        PlannedItemsPanel.setDividerLocation(splitter, proportion);
                    }
                });
            }
        } else {
            splitter.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    if ((e.getChangeFlags() & 4L) != 0L && splitter.isShowing()) {
                        splitter.removeHierarchyListener(this);
                        PlannedItemsPanel.setDividerLocation(splitter, proportion);
                    }
                }
            });
        }
        return splitter;
    }

    private void drawGraph() {
        AccountsFuturData l_data = null;
        try {
            String[] l_acNames = new String[Account.openAccounts.size()];
            int i = 0;
            for (Account l_a : Account.openAccounts) {
                if (!l_a.isGraphBills()) continue;
                l_acNames[i++] = l_a.accountName;
            }
            l_data = Util.getAccountFuturBalances(l_acNames, APlannedItem.getGraphDays());
        }
        catch (Exception ex) {
            Logger.error(TAG, ex.toString());
        }
        if (l_data != null) {
            this.splitPaneBottomPanel.removeAll();
            this.splitPaneBottomPanel.setLayout(new BorderLayout());
            this.graphAccountsPanel = new JPanel();
            this.graphAccountsPanel.setBackground(Color.white);
            int i = 0;
            for (AccountFuturBalance l_afb : l_data.accountsFuturBalances) {
                if (i > 0) {
                    JLabel l_sep = new JLabel("~");
                    l_sep.setForeground(Color.black);
                    this.graphAccountsPanel.add(l_sep);
                }
                JLabel l_accLabel = new JLabel(l_afb.accountName);
                l_accLabel.setForeground(Constants.graphColors[i++ % Constants.graphColors.length]);
                this.graphAccountsPanel.add(l_accLabel);
            }
            this.splitPaneBottomPanel.add((Component)this.graphAccountsPanel, "North");
            this.splitPaneBottomPanel.add(new HMGraphRenderer(l_data));
            this.splitPaneBottomPanel.validate();
            this.splitPaneBottomPanel.repaint();
        }
    }

    public void updateGraph() {
        SwingUtilities.invokeLater(new Thread(){

            @Override
            public void run() {
                MainWindow.plannedItemsMainPanel.drawGraph();
            }
        });
    }
}

