/*
 * Decompiled with CFR 0.152.
 */
package com.hmoney.gui.custom;

import com.hmoney.data.Util;
import com.hmoney.gui.Constants;
import com.hmoney.gui.GuiUtil;
import com.hmoney.gui.IKeyboardListener;
import com.hmoney.gui.custom.KeyboardMainListener;
import com.hmoney.messages.Messages;
import com.hmoney.properties.HMProperties;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.KeyEventDispatcher;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DateChooser
extends JDialog
implements IKeyboardListener {
    private static final String TAG = DateChooser.class.getSimpleName();
    public static final String DialogTitlePrefix = Messages.getString("DateChooser.0");
    int initMonth;
    int initYear;
    int initDay;
    int todayMonth;
    int todayYear;
    int todayDay;
    Calendar currentMonthAndYear = null;
    JLabel label = new JLabel("", 0);
    String chosenDate = "";
    JButton[] button = new JButton[49];
    Locale locale = Util.getLocaleFromString(HMProperties.getStringProperty("hmy.locale"));
    KeyEventDispatcher keyEventDispatcher;

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            KeyboardMainListener.addCurrentListener(this);
            final DateChooser thisDateChooser = this;
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    KeyboardMainListener.removeListener(thisDateChooser);
                }
            });
        }
        super.setVisible(visible);
    }

    public DateChooser(JFrame parent, Date initDate) {
        super(parent, DialogTitlePrefix, true);
        this.setIconImage(GuiUtil.getImageIcon("calendar.png").getImage());
        this.currentMonthAndYear = Calendar.getInstance();
        this.currentMonthAndYear.setTime(initDate);
        this.initMonth = this.currentMonthAndYear.get(2);
        this.initYear = this.currentMonthAndYear.get(1);
        this.initDay = this.currentMonthAndYear.get(5);
        Calendar l_cal = Calendar.getInstance();
        l_cal.setTime(new Date());
        this.todayMonth = l_cal.get(2);
        this.todayYear = l_cal.get(1);
        this.todayDay = l_cal.get(5);
        String[] namesOfDays = DateFormatSymbols.getInstance(this.locale).getShortWeekdays();
        JPanel p1 = new JPanel(new GridLayout(7, 7));
        p1.setPreferredSize(new Dimension(480, 160));
        p1.setBackground(Color.lightGray);
        int x = 0;
        while (x < this.button.length) {
            final int selection = x;
            this.button[x] = new JButton();
            this.button[x].setFocusPainted(false);
            if (x > 6) {
                this.button[x].setBackground(Color.gray);
                this.button[x].addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        DateChooser.this.chosenDate = DateChooser.this.button[selection].getActionCommand();
                        if (DateChooser.this.chosenDate != null && DateChooser.this.chosenDate.length() > 0) {
                            DateChooser.this.dispose();
                        }
                    }
                });
            }
            if (x < 7) {
                this.button[x].setBackground(Color.white);
                this.button[x].setForeground(Color.red);
                this.button[x].setFont(Constants.tahomaBold11Font);
                this.button[x].setText(namesOfDays[x + 1]);
            }
            p1.add(this.button[x]);
            ++x;
        }
        JPanel p2 = new JPanel(new GridLayout(1, 3));
        JButton previous = new JButton("   \u25c4   ");
        previous.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DateChooser.this.currentMonthAndYear.add(2, -1);
                DateChooser.this.displayDate();
            }
        });
        p2.add(previous);
        p2.add(this.label);
        JButton next = new JButton("   \u25ba   ");
        next.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DateChooser.this.currentMonthAndYear.add(2, 1);
                DateChooser.this.displayDate();
            }
        });
        p2.add(next);
        this.add((Component)p1, "Center");
        this.add((Component)p2, "South");
        this.pack();
        this.setLocationRelativeTo(parent);
        this.displayDate();
        this.setVisible(true);
    }

    @Override
    public void escapeKeyTyped() {
        this.dispose();
    }

    @Override
    public void enterKeyTyped() {
    }

    @Override
    public void deleteKeyTyped() {
    }

    public void displayDate() {
        int x = 7;
        while (x < this.button.length) {
            this.button[x].setText("");
            this.button[x].setBackground(Color.gray);
            ++x;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(Messages.getString("DateChooser.7"), this.locale);
        Calendar cal = Calendar.getInstance();
        cal.set(this.currentMonthAndYear.get(1), this.currentMonthAndYear.get(2), 1);
        int dayOfWeek = cal.get(7);
        int daysInMonth = cal.getActualMaximum(5);
        int x2 = 6 + dayOfWeek;
        int day = 1;
        while (day <= daysInMonth) {
            this.button[x2].setText("" + day);
            if (this.currentMonthAndYear.get(1) == this.todayYear && this.currentMonthAndYear.get(2) == this.todayMonth && day == this.todayDay) {
                this.button[x2].setBackground(Constants.todayDateButtonBgColor);
            } else if (this.currentMonthAndYear.get(1) == this.initYear && this.currentMonthAndYear.get(2) == this.initMonth && day == this.initDay) {
                this.button[x2].setBackground(Constants.selectedCellBgColor);
            } else {
                this.button[x2].setBackground(Color.lightGray);
            }
            ++x2;
            ++day;
        }
        this.label.setFont(Constants.tahomaBold12Font);
        this.label.setText(sdf.format(cal.getTime()));
        this.setTitle(String.valueOf(DialogTitlePrefix) + " : " + sdf.format(cal.getTime()));
    }

    public String getPickedDate() {
        if (this.chosenDate.equals("")) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.set(this.currentMonthAndYear.get(1), this.currentMonthAndYear.get(2), Integer.parseInt(this.chosenDate));
        return Util.getSimpleDateFormatter().format(cal.getTime());
    }
}

