/*
 * Decompiled with CFR 0.152.
 */
package com.hmoney.gui.custom;

import com.hmoney.Logger;
import com.hmoney.gui.IKeyboardListener;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;

public class KeyboardMainListener {
    private static final String TAG = KeyboardMainListener.class.getSimpleName();
    static final List<IKeyboardListener> keyListeners = new ArrayList<IKeyboardListener>();

    public static void addCurrentListener(IKeyboardListener ikl) {
        Logger.debug(TAG, "KeyboardMainListener.addCurrentListener: " + ikl.getClass().getSimpleName());
        keyListeners.add(ikl);
    }

    public static void removeListener(IKeyboardListener ikl) {
        Logger.debug(TAG, "KeyboardMainListener.removeListener: " + ikl.getClass().getSimpleName());
        keyListeners.remove(ikl);
    }

    public static void init() {
        Logger.debug(TAG, "KeyboardMainListener.init()");
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent e) {
                int l_listenerIndex = keyListeners.size() - 1;
                if (l_listenerIndex < 0) {
                    return false;
                }
                if (e.getID() == 401 && e.getKeyCode() == 10) {
                    Logger.verbose(TAG, "KeyboardFocusManager.keyPressed: VK_ENTER -> " + keyListeners.get(l_listenerIndex).getClass().getSimpleName());
                    keyListeners.get(l_listenerIndex).enterKeyTyped();
                } else if (e.getID() == 401 && e.getKeyCode() == 127) {
                    Logger.verbose(TAG, "KeyboardFocusManager.keyPressed: KeyEvent.VK_DELETE -> " + keyListeners.get(l_listenerIndex).getClass().getSimpleName());
                    keyListeners.get(l_listenerIndex).deleteKeyTyped();
                } else if (e.getID() == 401 && e.getKeyCode() == 27) {
                    Logger.verbose(TAG, "KeyboardFocusManager.keyPressed: KeyEvent.VK_ESCAPE -> " + keyListeners.get(l_listenerIndex).getClass().getSimpleName());
                    keyListeners.get(l_listenerIndex).escapeKeyTyped();
                }
                return false;
            }
        });
    }
}

