/*
 * Decompiled with CFR 0.152.
 */
package com.hmoney.messages;

import com.hmoney.Logger;
import com.hmoney.data.Util;
import com.hmoney.properties.HMProperties;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;

public class Messages {
    private static final String TAG = Messages.class.getSimpleName();
    private static final String BUNDLE_NAME = "com.hmoney.messages.messages";
    private static ResourceBundle RESOURCE_BUNDLE;
    public static final String[] reservedKeywords;
    public static final String[] languages;
    public static final String[] languages_codes;
    public static final String[][] default_categories;

    static {
        reservedKeywords = new String[]{"Virement", "Transfer", "aucune cat\u00e9gorie", "no category", "null", "[", "]"};
        languages = new String[]{"English GB", "English US", "Fran\u00e7ais"};
        languages_codes = new String[]{"en_GB", "en_US", "fr_FR"};
        default_categories = new String[][]{{"Automobile", "Automobile : Car Payment", "Automobile : Gasoline", "Automobile : Maintenance", "Bank", "Bank : Credit Card", "Bank : Interest Paid", "Bank : Service Charge", "Bank : Fees", "Bills", "Bills : Cable/Satellite", "Bills : Television", "Bills : Cell Phone", "Bills : Cellular", "Bills : Electricity", "Bills : Garbage & Recycle", "Bills : Health Club", "Bills : Homeowner's Dues", "Bills : Membership Fees", "Bills : Mortgage Payment", "Bills : Natural Gas/Oil", "Bills : Newspaper", "Bills : Online/Internet Service", "Bills : Other Loan Payment", "Bills : Rent", "Bills : Student Loan Payment", "Bills : Telephone", "Bills : Water & Sewer", "Cash Withdrawal", "Children", "Children : Child Support", "Children : Daycare", "Children : Toys", "Children : Clothing", "Clothing", "Education", "Food", "Food : Groceries", "Food : Dining out", "Food : Restaurant", "Gifts/Donations", "Gifts/Donations : Charitable Donations", "Gifts/Donations : Gifts", "Healthcare", "Healthcare : Dental", "Healthcare : Eyecare", "Healthcare : Hospital", "Healthcare : Physician", "Healthcare : Prescriptions", "Healthcare : Dental", "Healthcare : Dental", "Healthcare : Dental", "Healthcare : Dental", "Hobbies/Leisure", "Hobbies/Leisure : Books & Magazines", "Hobbies/Leisure : Cultural Events", "Hobbies/Leisure : Entertaining", "Hobbies/Leisure : Movies & Video Rentals", "Hobbies/Leisure : Sporting Goods", "Hobbies/Leisure : Toys & Games", "Household", "Household : Furnishings", "Household : Home Improvement", "Household : House Cleaning", "Household : Yard Service", "Income/Interest", "Investment Income", "Investment Income : Capital Gains", "Investment Income : Dividends", "Investment Income : Interest", "Investment Income : Tax-Exempt Interest", "Insurance", "Insurance : Automobile", "Insurance : Health", "Insurance : Homeowner", "Insurance : Life", "Job Expense", "Job Expense : Non-Reimbursed", "Job Expense : Reimbursed", "Loan", "Loan : Loan Interest", "Loan : Mortgage Interest", "Loan : Student Loan Interest", "Miscellaneous", "Mortgage/Rent", "Not an Expense", "Other Income", "Other Income : Child Support Received", "Other Income : Employee Stock Option", "Other Income : Gifts Received", "Other Income : Loan Principal Received", "Other Income : Lotteries", "Other Income : State & Local Tax Refund", "Other Income : Unemployment Compensation", "Personal Care", "Pet Care", "Pet Care : Food", "Pet Care : Supplies", "Pet Care : Veterinarian", "Phone/Wireless", "Retirement Income", "Retirement Income : IRA Distributions", "Retirement Income : Pensions & Annuities", "Retirement Income : Social Security Benefits", "Services/Memberships", "Taxes", "Taxes : Federal Income Tax", "Taxes : Federal Income Tax-Previous Year", "Taxes : Local Income Tax", "Taxes : Medicare Tax", "Taxes : Real Estate Taxes", "Taxes : Sales Tax", "Taxes : Social Security Tax", "Taxes : State Income Tax", "Taxes : State/Provincial", "Travel/Vacation", "Travel/Vacation : Lodging", "Travel/Vacation : Travel", "Utilities", "Wages & Salary", "Wages & Salary : Bonus", "Wages & Salary : Commission", "Wages & Salary : Employer Matching", "Wages & Salary : Gross Pay", "Wages & Salary : Net Pay", "Wages & Salary : Overtime"}, {"Automobile", "Automobile : Car Payment", "Automobile : Gasoline", "Automobile : Maintenance", "Bank", "Bank : Credit Card", "Bank : Interest Paid", "Bank : Service Charge", "Bank : Fees", "Bills", "Bills : Cable/Satellite", "Bills : Television", "Bills : Cell Phone", "Bills : Cellular", "Bills : Electricity", "Bills : Garbage & Recycle", "Bills : Health Club", "Bills : Homeowner's Dues", "Bills : Membership Fees", "Bills : Mortgage Payment", "Bills : Natural Gas/Oil", "Bills : Newspaper", "Bills : Online/Internet Service", "Bills : Other Loan Payment", "Bills : Rent", "Bills : Student Loan Payment", "Bills : Telephone", "Bills : Water & Sewer", "Cash Withdrawal", "Children", "Children : Child Support", "Children : Daycare", "Children : Toys", "Children : Clothing", "Clothing", "Education", "Food", "Food : Groceries", "Food : Dining out", "Food : Restaurant", "Gifts/Donations", "Gifts/Donations : Charitable Donations", "Gifts/Donations : Gifts", "Healthcare", "Healthcare : Dental", "Healthcare : Eyecare", "Healthcare : Hospital", "Healthcare : Physician", "Healthcare : Prescriptions", "Healthcare : Dental", "Healthcare : Dental", "Healthcare : Dental", "Healthcare : Dental", "Hobbies/Leisure", "Hobbies/Leisure : Books & Magazines", "Hobbies/Leisure : Cultural Events", "Hobbies/Leisure : Entertaining", "Hobbies/Leisure : Movies & Video Rentals", "Hobbies/Leisure : Sporting Goods", "Hobbies/Leisure : Toys & Games", "Household", "Household : Furnishings", "Household : Home Improvement", "Household : House Cleaning", "Household : Yard Service", "Income/Interest", "Investment Income", "Investment Income : Capital Gains", "Investment Income : Dividends", "Investment Income : Interest", "Investment Income : Tax-Exempt Interest", "Insurance", "Insurance : Automobile", "Insurance : Health", "Insurance : Homeowner", "Insurance : Life", "Job Expense", "Job Expense : Non-Reimbursed", "Job Expense : Reimbursed", "Loan", "Loan : Loan Interest", "Loan : Mortgage Interest", "Loan : Student Loan Interest", "Miscellaneous", "Mortgage/Rent", "Not an Expense", "Other Income", "Other Income : Child Support Received", "Other Income : Employee Stock Option", "Other Income : Gifts Received", "Other Income : Loan Principal Received", "Other Income : Lotteries", "Other Income : State & Local Tax Refund", "Other Income : Unemployment Compensation", "Personal Care", "Pet Care", "Pet Care : Food", "Pet Care : Supplies", "Pet Care : Veterinarian", "Phone/Wireless", "Retirement Income", "Retirement Income : IRA Distributions", "Retirement Income : Pensions & Annuities", "Retirement Income : Social Security Benefits", "Services/Memberships", "Taxes", "Taxes : Federal Income Tax", "Taxes : Federal Income Tax-Previous Year", "Taxes : Local Income Tax", "Taxes : Medicare Tax", "Taxes : Real Estate Taxes", "Taxes : Sales Tax", "Taxes : Social Security Tax", "Taxes : State Income Tax", "Taxes : State/Provincial", "Travel/Vacation", "Travel/Vacation : Lodging", "Travel/Vacation : Travel", "Utilities", "Wages & Salary", "Wages & Salary : Bonus", "Wages & Salary : Commission", "Wages & Salary : Employer Matching", "Wages & Salary : Gross Pay", "Wages & Salary : Net Pay", "Wages & Salary : Overtime"}, {"Abonnement-factures", "Abonnement-factures : Eau", "Abonnement-factures : Electricit\u00e9", "Abonnement-factures : Gaz", "Alimentation", "Alimentation : Caf\u00e9-Bar", "Alimentation : Restaurant", "Alimentation : Restaurant d'entreprise", "Alimentation : Epicerie", "Animaux domestiques", "Animaux domestiques : Alimentation", "Animaux domestiques : Fournitures diverses", "Animaux domestiques : V\u00e9t\u00e9rinaire", "Assurance", "Assurance : Auto-moto", "Assurance : Habitation", "Auto-moto", "Auto-moto : Accessoires", "Auto-moto : Achat v\u00e9hicule", "Auto-moto : Assurance Auto-moto", "Auto-moto : Carburant", "Auto-moto : Contraventions", "Auto-moto : Controle technique", "Auto-moto : Entretien-r\u00e9parations", "Auto-moto : Frais l\u00e9gaux", "Auto-moto : Parking-p\u00e9age", "Autres revenus", "Autres revenus : Dons et cadeaux", "Autres revenus : Vente \u00e9quipements divers", "Autres revenus : Vente v\u00e9hicule", "Cadeaux", "Coiffeur-esth\u00e9ticienne", "Divers", "Divers : Cadeaux", "Divers : Frais de douanes", "Divers : Frais l\u00e9gaux", "Dons caritatifs", "Ecommerce", "Ecommerce : Frais affranchissement", "Enfants", "Enfants : Activit\u00e9 sportive ou culturelle", "Enfants : Frais de cantine", "Enfants : Frais de garde", "Enfants : Frais divers", "Enfants : Habillement-chaussures", "Enfants : M\u00e9decin - sant\u00e9", "Equipement", "Equipement : Ordinateur et accessoires", "Equipement : T\u00e9l\u00e9vision et accessoires", "Factures", "Factures : Abonnement TV-c\u00e2ble", "Factures : Eau", "Factures : Electricit\u00e9", "Factures : Frais de parution d'annonce", "Factures : Gaz", "Factures : Remboursement de pr\u00eat immobilier", "Factures : T\u00e9l\u00e9phone", "Factures : T\u00e9l\u00e9phone mobile", "Factures : T\u00e9l\u00e9service-Internet", "Frais bancaires", "Frais bancaires : Agios", "Frais bancaires : Carte de paiement - de cr\u00e9dit", "Frais bancaires : Frais de carte bancaire", "Frais bancaires : Frais divers", "Frais professionnels", "Habillement", "Habillement : Accessoires", "Habillement : Chaussures", "Habillement : Vetements", "Imp\u00f4ts", "Imp\u00f4ts : Autres imp\u00f4ts", "Imp\u00f4ts : Imp\u00f4ts sur le revenu", "Imp\u00f4ts : Imp\u00f4ts sur le revenu-Ann\u00e9e pr\u00e9c.", "Imp\u00f4ts : Redevance audiovisuelle", "Imp\u00f4ts : Taxe d'habitation", "Imp\u00f4ts : Taxe fonci\u00e8re", "Logement", "Logement : Achat r\u00e9sidence principale", "Logement : Ameublement", "Logement : Am\u00e9nagement - Bricolage", "Logement : Entretien", "Logement : Frais de d\u00e9m\u00e9nagement", "Logement : Jardinage", "Logement : M\u00e9nage", "Logement : Syndic", "Logement : Travaux - D\u00e9coration", "Logement : Electrom\u00e9nager", "Logement : Equipement du logement", "Loisirs-culture", "Loisirs-culture : Activit\u00e9 sportive", "Loisirs-culture : Articles de sport", "Loisirs-culture : Cin\u00e9ma-spectacle", "Loisirs-culture : Cotisations clubs", "Loisirs-culture : Disques-cassettes", "Loisirs-culture : Equipement divers", "Loisirs-culture : Jeux", "Loisirs-culture : Livres", "Loisirs-culture : Logiciels", "Loisirs-culture : Manifestations sportives", "Pr\u00eat", "Pr\u00eat : Assurance de pr\u00eat", "Pr\u00eat : Capital", "Pr\u00eat : Frais de courtier", "Pr\u00eat : Int\u00e9r\u00eats du pr\u00eat immobilier", "Pr\u00eat : Maison", "Retrait d'esp\u00e8ces", "Revenus de placement", "Revenus de placement : Caution d'un logement", "Revenus de placement : Dividendes", "Revenus de placement : Int\u00e9r\u00eats exon\u00e9r\u00e9s d'imp\u00f4ts", "Revenus de placement : Loyer", "Revenus de placement : Plus-values", "Revenus de placement : Remboursement foncier part locataire", "Sant\u00e9", "Sant\u00e9 : Analyses m\u00e9dicales", "Sant\u00e9 : Compl\u00e9ments alimentaires", "Sant\u00e9 : Dentiste", "Sant\u00e9 : Dermatologue", "Sant\u00e9 : H\u00f4pital", "Sant\u00e9 : Kin\u00e9sith\u00e9rapeute", "Sant\u00e9 : M\u00e9decin", "Sant\u00e9 : Neurologue", "Sant\u00e9 : Oculiste", "Sant\u00e9 : Osth\u00e9opathe-\u00e9thiopathe", "Sant\u00e9 : Parapharmacie", "Sant\u00e9 : Pharmacie", "Sant\u00e9 : Radiographies", "Sant\u00e9 : Remb. CPAM", "Sant\u00e9 : Remb. Mutuelle", "Sant\u00e9 : Rhumatologue", "Traitements et salaires", "Traitements et salaires : Primes diverses", "Traitements et salaires : Remb. frais professionnels", "Traitements et salaires : Salaire net", "Transports", "Transports : Metro-Bus-Train", "Vacances", "Vacances : Alimentation-restaurant", "Vacances : Commission de change", "Vacances : Contentieux", "Vacances : Divers", "Vacances : Location de voiture", "Vacances : Logement", "Vacances : Restauration", "Vacances : Retrait d'esp\u00e8ces", "Vacances : Ski", "Vacances : S\u00e9jours", "Vacances : Voyage", "Virmt vers un compte supprim\u00e9"}};
    }

    private Messages() {
    }

    public static void init() {
        if (HMProperties.getStringProperty("hmy.locale") != null) {
            Messages.init(Util.getLocaleFromString(HMProperties.getStringProperty("hmy.locale")));
            return;
        }
        String l_defaultLocale = Util.getDefaultLocale().toString();
        Logger.info(TAG, "init() - default locale=" + l_defaultLocale);
        try {
            JComboBox<String> l_cbLocale = new JComboBox<String>();
            int i = 0;
            while (i < languages_codes.length) {
                l_cbLocale.addItem(String.valueOf(languages[i]) + " - " + languages_codes[i]);
                if (l_defaultLocale.equalsIgnoreCase(languages_codes[i])) {
                    l_cbLocale.setSelectedIndex(i);
                }
                ++i;
            }
            JOptionPane.showMessageDialog(null, l_cbLocale, "Please choose language  --  SVP choisissez votre langue", 3);
            String l_sLocale = (String)l_cbLocale.getSelectedItem();
            if (l_sLocale != null && l_sLocale.length() > 5) {
                String l_locale = l_sLocale.substring(l_sLocale.length() - 5);
                Messages.init(Util.getLocaleFromString(l_locale));
                Messages.saveLocaleSetting(l_locale);
            } else {
                Messages.init(Util.getLocaleFromString("en_GB"));
                Messages.saveLocaleSetting("en_GB");
            }
        }
        catch (Exception e) {
            Messages.init(Util.getLocaleFromString("en_GB"));
            Messages.saveLocaleSetting("en_GB");
        }
    }

    public static void init(Locale locale) {
        Logger.info(TAG, "init(" + locale + ")");
        RESOURCE_BUNDLE = ResourceBundle.getBundle(BUNDLE_NAME, locale);
    }

    public static String getString(String key) {
        try {
            return RESOURCE_BUNDLE.getString(key);
        }
        catch (MissingResourceException e) {
            return String.valueOf('!') + key + '!';
        }
    }

    public static void saveLocaleSetting(String locale) {
        HMProperties.putProperty("hmy.locale", locale);
        if (locale.endsWith("US")) {
            HMProperties.putProperty("date.day_first", "false");
        } else {
            HMProperties.putProperty("date.day_first", "true");
        }
    }
}

