/*
 * Decompiled with CFR 0.152.
 */
package moneyview.data;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import moneyview.Logger;
import moneyview.data.ACategory;
import moneyview.data.AItem;
import moneyview.data.Util;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OfxSaxImporter
extends DefaultHandler {
    private static final String TAG = OfxSaxImporter.class.getSimpleName();
    private static final String OFX_BANK_ID_TAG = "BANKID";
    private static final String OFX_ACCOUNT_ID_TAG = "ACCTID";
    private static final String OFX_STMTTRN_ID_TAG = "STMTTRN";
    private static final String OFX_TRNTYPE_ID_TAG = "TRNTYPE";
    private static final String OFX_DTPOSTED_ID_TAG = "DTPOSTED";
    private static final String OFX_TRNAMT_ID_TAG = "TRNAMT";
    private static final String OFX_NAME_ID_TAG = "NAME";
    private static final String OFX_MEMO_ID_TAG = "MEMO";
    private static final String OFX_CHECKNUM_ID_TAG = "CHECKNUM";
    private static final String OFX_REFNUM_ID_TAG = "REFNUM";
    public String bankId = null;
    public String accountId = null;
    private List<AItem> ofxItemList = new ArrayList<AItem>();
    private StringBuffer buffer;
    private AItem aItem;

    public List<AItem> loadFile(String fileName) throws Exception {
        try {
            SAXParserFactory l_fatory = SAXParserFactory.newInstance();
            SAXParser l_parser = l_fatory.newSAXParser();
            Logger.info(TAG, "loadFile(" + fileName + ")");
            FileInputStream l_f = new FileInputStream(fileName);
            l_parser.parse((InputStream)l_f, (DefaultHandler)this);
        }
        finally {
            ACategory.sort();
        }
        return this.ofxItemList;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals(OFX_STMTTRN_ID_TAG)) {
            this.aItem = new AItem();
        } else {
            this.buffer = new StringBuffer();
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals(OFX_BANK_ID_TAG)) {
            this.bankId = this.buffer.toString();
            this.buffer = null;
        } else if (qName.equals(OFX_ACCOUNT_ID_TAG)) {
            this.accountId = this.buffer.toString();
            this.buffer = null;
        }
        if (qName.equals(OFX_STMTTRN_ID_TAG)) {
            if (this.aItem.getDate() == null) {
                this.aItem.setDate(new Date());
            }
            this.aItem.setEImport(true);
            this.aItem.setUserValidated(false, null);
            this.ofxItemList.add(this.aItem);
            this.buffer = null;
        } else if (qName.equals(OFX_DTPOSTED_ID_TAG)) {
            try {
                this.aItem.setDate(Util.parseOfxDate(this.buffer.toString()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.buffer = null;
        } else if (qName.equals(OFX_TRNAMT_ID_TAG)) {
            try {
                this.aItem.setLongAmount(Util.parseAmount(this.buffer.toString()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.buffer = null;
        } else if (qName.equals(OFX_MEMO_ID_TAG)) {
            this.aItem.setMemo(this.buffer.toString());
            this.buffer = null;
        } else if (qName.equals(OFX_CHECKNUM_ID_TAG)) {
            this.aItem.setNum(this.buffer.toString());
            this.buffer = null;
        } else if (qName.equals(OFX_REFNUM_ID_TAG)) {
            if (this.aItem.getNum() == null || this.aItem.getNum().length() < 1) {
                this.aItem.setNum(this.buffer.toString());
            }
            this.buffer = null;
        } else if (qName.equals(OFX_NAME_ID_TAG)) {
            this.aItem.setPayee(this.buffer.toString());
            this.buffer = null;
        }
        qName.equals(OFX_TRNTYPE_ID_TAG);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String l_readStr = new String(ch, start, length);
        if (this.buffer != null) {
            this.buffer.append(l_readStr);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        Logger.debug(TAG, "startDocument()");
    }

    @Override
    public void endDocument() throws SAXException {
        Logger.debug(TAG, "endDocument()");
    }
}

