/*
 * Decompiled with CFR 0.152.
 */
package moneyview.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import moneyview.Logger;
import moneyview.data.AItem;
import moneyview.data.Util;
import moneyview.gui.Constants;
import moneyview.gui.DisplayedAccount;
import moneyview.gui.GuiUtil;
import moneyview.gui.MainWindow;
import moneyview.gui.custom.DateChooser;
import moneyview.messages.Messages;

public class AItemTableCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private static final String TAG = AItemTableCellEditor.class.getSimpleName();
    private int row;
    private int column;
    private JTextField textFieldEditor = new JTextField();
    private JComboBox<String> categoryComboBox = null;
    private JComboBox<String> crComboBox = new JComboBox();

    public AItemTableCellEditor() {
        Logger.debug(TAG, "AItemTableCellEditor constructor()");
        this.crComboBox.addItem(null);
        this.crComboBox.addItem(Messages.getString("OperationClearedValue"));
        this.crComboBox.addItem(Messages.getString("OperationReconciledValue"));
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        Logger.debug(TAG, "getTableCellEditorComponent: value=" + value + ", isSelected=" + isSelected + ", row=" + row + ", column=" + column);
        this.row = row;
        this.column = column;
        switch (column) {
            case 1: {
                this.crComboBox.setSelectedItem((String)table.getValueAt(row, column));
                return this.crComboBox;
            }
            case 3: {
                this.categoryComboBox = GuiUtil.getCategoriesComboBox(DisplayedAccount.getDisplayedAccount());
                this.categoryComboBox.setSelectedItem((String)table.getValueAt(row, column));
                final JPanel l_panel = new JPanel();
                final JTable l_table = table;
                final int l_row = row;
                final int l_column = column;
                l_panel.setLayout(new BorderLayout());
                l_panel.add(this.categoryComboBox);
                try {
                    JButton l_chooseCategoryButton = GuiUtil.getChooseCategoryButton(28, 28);
                    l_chooseCategoryButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            GuiUtil.getCategoryPopup(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    l_panel.remove(AItemTableCellEditor.this.categoryComboBox);
                                    AItemTableCellEditor.this.categoryComboBox = GuiUtil.getCategoriesComboBox(DisplayedAccount.getDisplayedAccount());
                                    AItemTableCellEditor.this.categoryComboBox.setSelectedItem((String)l_table.getValueAt(l_row, l_column));
                                    l_panel.add((Component)AItemTableCellEditor.this.categoryComboBox, "Center");
                                    String l_cat = GuiUtil.getCategoryChosenInCategoryPopup(e);
                                    AItemTableCellEditor.this.categoryComboBox.setSelectedItem(l_cat);
                                }
                            }, DisplayedAccount.getDisplayedAccount()).show((Component)e.getSource(), 0, 0);
                        }
                    });
                    l_panel.add((Component)l_chooseCategoryButton, "East");
                    l_chooseCategoryButton.setPreferredSize(new Dimension(28, 28));
                    l_panel.revalidate();
                }
                catch (Exception l_chooseCategoryButton) {
                    // empty catch block
                }
                return l_panel;
            }
            case 2: {
                JPanel l_panel = new JPanel();
                l_panel.setLayout(new BorderLayout());
                this.textFieldEditor.setText((String)table.getValueAt(row, column));
                l_panel.add(this.textFieldEditor);
                try {
                    Date l_initDate;
                    try {
                        l_initDate = Util.parseDate(this.textFieldEditor.getText(), Util.getDateDayFirst());
                    }
                    catch (Exception e) {
                        l_initDate = Util.parseDate((String)table.getValueAt(row, column), Util.getDateDayFirst());
                    }
                    final Date l_opDate = l_initDate;
                    JButton l_chooseDateButton = GuiUtil.getChooseDateButton(28, 28);
                    l_chooseDateButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            String l_chosenDate = new DateChooser(MainWindow.getFrame(), l_opDate).getPickedDate();
                            if (l_chosenDate != null && l_chosenDate.length() > 0) {
                                AItemTableCellEditor.this.textFieldEditor.setText(l_chosenDate);
                            }
                        }
                    });
                    l_panel.add((Component)l_chooseDateButton, "East");
                    l_chooseDateButton.setPreferredSize(new Dimension(28, 28));
                    l_panel.revalidate();
                }
                catch (Exception l_initDate) {
                    // empty catch block
                }
                return l_panel;
            }
            case 4: {
                final AItem l_rowAItem = DisplayedAccount.getDisplayedAccount().getItem(row);
                if (l_rowAItem.isUserValidated() && l_rowAItem.getDup() == null) break;
                final int l_row = row;
                final long l_editorPopupMillis = System.currentTimeMillis();
                JPanel l_panel = new JPanel();
                l_panel.setLayout(new BorderLayout());
                if (l_rowAItem.getDup() == null) {
                    this.textFieldEditor.setText((String)table.getValueAt(row, column));
                    l_panel.add((Component)this.textFieldEditor, "North");
                    JPanel l_bPanel = new JPanel();
                    JLabel l_label = new JLabel("<html>" + Messages.getString("AItemTableCellEditor.0") + " &#9658; </html>");
                    l_label.setForeground(Constants.lightBlue);
                    l_bPanel.add((Component)l_label, "West");
                    l_bPanel.setBackground(Color.black);
                    JButton l_acceptEIButton = new JButton(Messages.getString("AItemTableCellEditor.10"));
                    l_acceptEIButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (System.currentTimeMillis() < l_editorPopupMillis + 500L) {
                                return;
                            }
                            l_rowAItem.setUserValidated(true, DisplayedAccount.getDisplayedAccount());
                            l_rowAItem.setNewlyImported(false);
                            AItemTableCellEditor.this.fireEditingStopped();
                        }
                    });
                    l_acceptEIButton.setMargin(new Insets(0, 0, 0, 0));
                    l_bPanel.add((Component)l_acceptEIButton, "Center");
                    JButton l_rejectEIButton = new JButton(Messages.getString("AItemTableCellEditor.11"));
                    l_rejectEIButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (System.currentTimeMillis() < l_editorPopupMillis + 500L) {
                                return;
                            }
                            AItemTableCellEditor.this.fireEditingStopped();
                            MainWindow.aItemTable.removeRow(l_row, false);
                        }
                    });
                    l_rejectEIButton.setMargin(new Insets(0, 0, 0, 0));
                    l_bPanel.add((Component)l_rejectEIButton, "East");
                    l_panel.add((Component)l_bPanel, "Center");
                } else {
                    this.textFieldEditor.setText((String)table.getValueAt(row, column));
                    JLabel l_label = new JLabel("<html>" + Util.stringNotNull(l_rowAItem.getPayee()) + "<br><br>" + "<font color=\"blue\">" + Util.stringNotNull(l_rowAItem.getDup().getPayee()) + "</font></html>");
                    l_panel.add((Component)l_label, "North");
                    JPanel l_bPanel = new JPanel();
                    l_bPanel.setBackground(Color.black);
                    JButton l_keepExistingButton = new JButton(Messages.getString("AItemTableCellEditor.16"));
                    l_keepExistingButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (System.currentTimeMillis() < l_editorPopupMillis + 500L) {
                                return;
                            }
                            AItemTableCellEditor.this.fireEditingStopped();
                            l_rowAItem.setDup(null);
                        }
                    });
                    l_keepExistingButton.setMargin(new Insets(0, 0, 0, 0));
                    l_bPanel.add((Component)l_keepExistingButton, "West");
                    JButton l_keepDownloadedButton = new JButton(Messages.getString("AItemTableCellEditor.17"));
                    l_keepDownloadedButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (System.currentTimeMillis() < l_editorPopupMillis + 500L) {
                                return;
                            }
                            AItemTableCellEditor.this.textFieldEditor.setText(l_rowAItem.getDup().getPayee());
                            l_rowAItem.setNum(l_rowAItem.getDup().getNum());
                            l_rowAItem.setDate(l_rowAItem.getDup().getDate());
                            l_rowAItem.setPayee(l_rowAItem.getDup().getPayee());
                            l_rowAItem.setMemo(l_rowAItem.getDup().getMemo());
                            l_rowAItem.setLongAmount(l_rowAItem.getDup().getLongAmount());
                            l_rowAItem.setAddress(l_rowAItem.getDup().getAddress());
                            l_rowAItem.setSplits(l_rowAItem.getDup().getSplits());
                            l_rowAItem.setCategory(l_rowAItem.getDup().getCategory(), DisplayedAccount.getDisplayedAccount());
                            l_rowAItem.setUserValidated(l_rowAItem.getDup().isUserValidated(), DisplayedAccount.getDisplayedAccount());
                            l_rowAItem.setDup(null);
                            AItemTableCellEditor.this.fireEditingStopped();
                        }
                    });
                    l_keepDownloadedButton.setMargin(new Insets(0, 0, 0, 0));
                    l_bPanel.add((Component)l_keepDownloadedButton, "Center");
                    JButton l_keepBothButton = new JButton(Messages.getString("AItemTableCellEditor.18"));
                    l_keepBothButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (System.currentTimeMillis() < l_editorPopupMillis + 500L) {
                                return;
                            }
                            AItemTableCellEditor.this.textFieldEditor.setText(l_rowAItem.getDup().getPayee());
                            AItem l_new = l_rowAItem.getDup();
                            l_rowAItem.setDup(null);
                            l_new.setNewUuid();
                            AItemTableCellEditor.this.fireEditingStopped();
                            DisplayedAccount.getDisplayedAccount().addItem(l_new);
                            DisplayedAccount.getDisplayedAccount().calculateBalance();
                            MainWindow.aItemTable.clickOnColumnHeader(2, DisplayedAccount.getDisplayedAccount(), false);
                            int l_rowSel = DisplayedAccount.getDisplayedAccount().indexOf(l_new);
                            GuiUtil.showTableElementInViewPort(MainWindow.aItemTable, l_rowSel, 4);
                        }
                    });
                    l_keepBothButton.setMargin(new Insets(0, 0, 0, 0));
                    l_bPanel.add((Component)l_keepBothButton, "East");
                    l_panel.add((Component)l_bPanel, "Center");
                }
                l_panel.revalidate();
                return l_panel;
            }
        }
        this.textFieldEditor.setText((String)table.getValueAt(row, column));
        return this.textFieldEditor;
    }

    @Override
    public Object getCellEditorValue() {
        Object l_res = null;
        switch (this.column) {
            case 1: {
                l_res = this.crComboBox.getSelectedItem();
                break;
            }
            case 3: {
                l_res = this.categoryComboBox.getSelectedItem();
                break;
            }
            default: {
                l_res = this.textFieldEditor.getText();
            }
        }
        Logger.verbose(TAG, "getCellEditorValue: row=" + this.row + ", column=" + this.column + " returns Object=" + l_res);
        return l_res;
    }

    @Override
    public void fireEditingStopped() {
        Logger.verbose(TAG, "fireEditingStopped()");
        super.fireEditingStopped();
    }

    @Override
    public void fireEditingCanceled() {
        Logger.verbose(TAG, "fireEditingCanceled()");
        super.fireEditingStopped();
    }
}

