/*
 * Decompiled with CFR 0.152.
 */
package moneyview.gui;

import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import moneyview.data.AItem;
import moneyview.data.APlannedItem;
import moneyview.data.Util;
import moneyview.gui.Constants;
import moneyview.gui.DisplayedAccount;
import moneyview.gui.GuiUtil;
import moneyview.gui.MainWindow;
import moneyview.messages.Messages;

public class AItemTableCellRenderer
extends JLabel
implements TableCellRenderer {
    private static final String TAG = AItemTableCellRenderer.class.getSimpleName();
    private static final long serialVersionUID = 1969L;
    private static Icon attachedIcon = new ImageIcon(GuiUtil.getImageIcon("attached.png").getImage().getScaledInstance(24, 24, 4));
    private static EmptyBorder emptyBorder = new EmptyBorder(1, 2, 1, 2);
    private static String leftEditRightMenu = "<html>" + Messages.getString("AItemTableCellRenderer.2") + "</html>";

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        Color theForeground = Constants.tableFontColor;
        Color theBackground = Color.white;
        if (row % 2 > 0) {
            theBackground = Constants.oddRowColor;
        }
        AItem l_rowAItem = DisplayedAccount.getDisplayedAccount().getItem(row);
        if (isSelected) {
            theBackground = Constants.selectedRowBgColor;
            this.setFont(Constants.tableFontBold);
        } else {
            this.setFont(l_rowAItem.isUserValidated() && l_rowAItem.getDup() == null ? Constants.tableFont : Constants.tableFontBold);
        }
        this.setOpaque(true);
        this.setBackground(theBackground);
        this.setForeground(theForeground);
        this.setIcon(null);
        if (hasFocus) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        } else {
            this.setBorder(emptyBorder);
        }
        int l_dupHeight = 140;
        int l_notApprovedHeight = 80;
        int l_cellWidth = table.getColumnModel().getColumn(4).getWidth();
        if (l_cellWidth < 350) {
            l_dupHeight = (int)((double)l_dupHeight * 1.6);
            l_notApprovedHeight = (int)((double)l_notApprovedHeight * 1.2);
        }
        if (l_rowAItem.getDup() != null) {
            if (MainWindow.aItemTable.getRowHeight(row) != l_dupHeight) {
                MainWindow.aItemTable.setRowHeight(row, l_dupHeight);
            }
        } else if (!l_rowAItem.isUserValidated()) {
            if (MainWindow.aItemTable.getRowHeight(row) != l_notApprovedHeight) {
                MainWindow.aItemTable.setRowHeight(row, l_notApprovedHeight);
            }
        } else if (MainWindow.aItemTable.getRowHeight(row) != 28) {
            MainWindow.aItemTable.setRowHeight(row, 28);
        }
        String l_toolTipText = leftEditRightMenu;
        this.setVerticalAlignment(1);
        switch (col) {
            case 0: {
                String l_text = Util.stringNotNull(l_rowAItem.getNum());
                if (l_rowAItem.getDup() != null) {
                    l_text = "<html>" + l_text + "<br><br><font color=\"blue\">" + Util.stringNotNull(l_rowAItem.getDup().getNum()) + "</font></html>";
                }
                this.setText(l_text);
                this.setHorizontalAlignment(2);
                if (hasFocus) {
                    this.setBackground(Constants.selectedCellBgColor);
                }
                l_toolTipText = l_rowAItem.getNum();
                break;
            }
            case 1: {
                if (l_rowAItem.isReconciled()) {
                    this.setBackground(Constants.reconciledBgColor);
                    this.setText("<html><b>" + Messages.getString("OperationReconciledValue") + "</b></html>");
                    l_toolTipText = Messages.getString("AItemTableCellRenderer.14");
                } else if (l_rowAItem.isCleared()) {
                    this.setBackground(Constants.clearedBgColor);
                    this.setText(Messages.getString("OperationClearedValue"));
                    l_toolTipText = Messages.getString("AItemTableCellRenderer.16");
                } else if (l_rowAItem.isEImport()) {
                    this.setBackground(Constants.noCRBgColor);
                    this.setText(Messages.getString("OperationEImportedValue"));
                    l_toolTipText = Messages.getString("AItemTableCellRenderer.18");
                } else {
                    this.setBackground(Constants.noCRBgColor);
                    this.setText("");
                    l_toolTipText = Messages.getString("AItemTableCellRenderer.20");
                }
                this.setHorizontalAlignment(0);
                break;
            }
            case 2: {
                String l_text = Util.getSimpleDateFormatter().format(l_rowAItem.getDate());
                if (l_rowAItem.getDup() != null) {
                    l_text = "<html>" + l_text + "<br><br><font color=\"blue\">" + Util.getSimpleDateFormatter().format(l_rowAItem.getDup().getDate()) + "</font></html>";
                }
                this.setText(l_text);
                this.setHorizontalAlignment(0);
                if (hasFocus) {
                    this.setBackground(Constants.selectedCellBgColor);
                }
                l_toolTipText = leftEditRightMenu;
                break;
            }
            case 3: {
                String l_text = Util.stringNotNull(Util.getUserFriendlyCategoryString(l_rowAItem.getCategory()));
                if (l_rowAItem.getDup() != null) {
                    l_text = "<html>" + l_text + "<br><br><font color=\"blue\">" + Util.stringNotNull(Util.getUserFriendlyCategoryString(l_rowAItem.getDup().getCategory())) + "</font></html>";
                } else if (!l_rowAItem.isUserValidated()) {
                    this.setForeground(Color.blue);
                }
                this.setText(l_text);
                this.setHorizontalAlignment(2);
                if (hasFocus) {
                    this.setBackground(Constants.selectedCellBgColor);
                }
                l_toolTipText = leftEditRightMenu;
                break;
            }
            case 4: {
                List<APlannedItem> l_pil;
                String l_text = Util.stringNotNull(l_rowAItem.getPayee());
                if (l_rowAItem.getDup() != null) {
                    l_text = "<html>" + l_text + "<br><br>";
                    l_text = String.valueOf(l_text) + "<font color=\"blue\">" + Util.stringNotNull(l_rowAItem.getDup().getPayee()) + "</font>";
                    l_text = String.valueOf(l_text) + "<br><br>" + Messages.getString("AItemTableCellRenderer.33") + "</html>";
                } else if (!l_rowAItem.isUserValidated()) {
                    l_text = "<html>" + l_text + "<br><br>";
                    l_text = String.valueOf(l_text) + Messages.getString("AItemTableCellRenderer.37") + "</html>";
                }
                if (!l_rowAItem.isReconciliatedWithPlanned() && (l_pil = APlannedItem.getNextOccurrencesOnAccount(DisplayedAccount.getDisplayedAccount().accountName, l_rowAItem.getLongAmount(), l_rowAItem.getDate())).size() > 0) {
                    this.setForeground(Constants.plannedTableFontColor);
                }
                this.setText(l_text);
                this.setHorizontalAlignment(2);
                if (hasFocus) {
                    this.setBackground(Constants.selectedCellBgColor);
                }
                l_toolTipText = leftEditRightMenu;
                break;
            }
            case 5: {
                String l_text = Util.stringNotNull(l_rowAItem.getMemo());
                if (l_rowAItem.getDocuments() != null && l_rowAItem.getDocuments().length > 0) {
                    this.setIcon(attachedIcon);
                }
                if (l_rowAItem.getDup() != null) {
                    l_text = "<html>" + l_text + "<br><br><font color=\"blue\">" + Util.stringNotNull(l_rowAItem.getDup().getMemo()) + "</font></html>";
                }
                this.setText(l_text);
                this.setHorizontalAlignment(2);
                if (!hasFocus) break;
                this.setBackground(Constants.selectedCellBgColor);
                break;
            }
            case 6: {
                if (l_rowAItem.isNegativeAmount()) {
                    this.setForeground(Constants.darkRedColor);
                } else {
                    this.setForeground(Constants.darkGreenColor);
                }
                String l_text = l_rowAItem.getAmountString();
                if (l_rowAItem.getDup() != null) {
                    l_text = "<html>" + l_text + "<br><br><font color=\"blue\">" + l_rowAItem.getDup().getAmountString() + "</font></html>";
                }
                this.setText(l_text);
                this.setHorizontalAlignment(4);
                if (hasFocus) {
                    this.setBackground(Constants.selectedCellBgColor);
                }
                l_toolTipText = "<html><b>" + Messages.getString("AItemTableCellRenderer.46") + "</b></html>";
                break;
            }
            case 7: {
                if (!DisplayedAccount.getDisplayedAccount().balanceEnabled) {
                    this.setText(l_rowAItem.getAccountName());
                } else {
                    if (l_rowAItem.isNegativeBalance()) {
                        this.setForeground(Constants.darkRedColor);
                    } else {
                        this.setForeground(Constants.darkGreenColor);
                    }
                    String l_text = l_rowAItem.getBalanceString();
                    if (l_rowAItem.getDup() != null) {
                        l_text = "<html>" + l_text + "<br><br><font color=\"blue\">" + Util.longAmountToString(l_rowAItem.getLongBalance() + l_rowAItem.getDup().getLongAmount() - l_rowAItem.getLongAmount()) + "</font></html>";
                    }
                    this.setText(l_text);
                }
                this.setHorizontalAlignment(4);
                if (!hasFocus) break;
                this.setBackground(Constants.selectedCellBgColor);
            }
        }
        this.setToolTipText(l_toolTipText);
        return this;
    }
}

