/*
 * Decompiled with CFR 0.152.
 */
package moneyview.gui;

import java.awt.Color;
import java.awt.Component;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import moneyview.data.APlannedItem;
import moneyview.data.Util;
import moneyview.gui.Constants;
import moneyview.gui.MainWindow;
import moneyview.messages.Messages;

public class APlannedItemTableCellRenderer
extends JLabel
implements TableCellRenderer {
    private static final String TAG = APlannedItemTableCellRenderer.class.getSimpleName();
    private static final long serialVersionUID = 1969L;
    private static String leftEditRightMenu = "<html>" + Messages.getString("APlannedItemTableCellRenderer.1") + "</html>";

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        Color theForeground = Constants.plannedTableFontColor;
        Color theBackground = Color.white;
        if (row % 2 > 0) {
            theBackground = Constants.plannedOddRowColor;
        }
        APlannedItem l_rowAPlannedItem = APlannedItem.getItem(row);
        Date l_nowDate = new Date();
        if (isSelected) {
            theBackground = Constants.selectedRowBgColor;
            this.setFont(Constants.tableFontBold);
        } else {
            this.setFont(l_rowAPlannedItem.isUserValidated() ? Constants.tableFont : Constants.tableFontBold);
        }
        this.setOpaque(true);
        this.setBackground(theBackground);
        this.setForeground(theForeground);
        if (hasFocus) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        } else {
            this.setBorder(new EmptyBorder(1, 2, 1, 2));
        }
        int l_LateOccurrencesCountAtDate = l_rowAPlannedItem.getLateOccurrencesCountAtDate(l_nowDate);
        if (l_LateOccurrencesCountAtDate > 0) {
            if (MainWindow.aPlannedItemTable.getRowHeight(row) != 34) {
                MainWindow.aPlannedItemTable.setRowHeight(row, 34);
            }
        } else if (MainWindow.aPlannedItemTable.getRowHeight(row) != 22) {
            MainWindow.aPlannedItemTable.setRowHeight(row, 22);
        }
        String l_toolTipText = "";
        this.setVerticalAlignment(1);
        switch (col) {
            case 0: {
                if (l_LateOccurrencesCountAtDate > 0) {
                    String l_text = "<html>" + Util.stringNotNull(l_rowAPlannedItem.getPayee()) + "<br>";
                    String l_j = String.valueOf(Messages.getString("APlannedItemTableCellRenderer.7")) + (l_rowAPlannedItem.getAtDateLatenessInDays(l_nowDate) > 1 ? Messages.getString("APlannedItemTableCellRenderer.8") : "");
                    String l_o = String.valueOf(Messages.getString("APlannedItemTableCellRenderer.10")) + (l_LateOccurrencesCountAtDate > 1 ? Messages.getString("APlannedItemTableCellRenderer.11") : "");
                    l_text = String.valueOf(l_text) + "<font color=\"red\">" + Messages.getString("APlannedItemTableCellRenderer.14") + l_rowAPlannedItem.getAtDateLatenessInDays(l_nowDate) + " " + l_j + Messages.getString("APlannedItemTableCellRenderer.16") + l_LateOccurrencesCountAtDate + " " + l_o + ")</font></html>";
                    this.setText(l_text);
                } else {
                    this.setText(Util.stringNotNull(l_rowAPlannedItem.getPayee()));
                }
                this.setHorizontalAlignment(2);
                if (hasFocus) {
                    this.setBackground(Constants.selectedCellBgColor);
                }
                l_toolTipText = leftEditRightMenu;
                break;
            }
            case 1: {
                String l_text = Util.stringNotNull(l_rowAPlannedItem.getAccountName());
                this.setText(l_text);
                this.setHorizontalAlignment(2);
                if (!hasFocus) break;
                this.setBackground(Constants.selectedCellBgColor);
                l_toolTipText = l_rowAPlannedItem.getNum();
                break;
            }
            case 2: {
                String l_text = Util.getSimpleDateFormatter().format(l_rowAPlannedItem.getDate());
                this.setText(l_text);
                this.setHorizontalAlignment(0);
                if (hasFocus) {
                    this.setBackground(Constants.selectedCellBgColor);
                }
                l_toolTipText = leftEditRightMenu;
                break;
            }
            case 3: {
                String l_text = APlannedItem.getPeriodicityLabel(l_rowAPlannedItem.getPeriodicity());
                this.setText(l_text);
                this.setHorizontalAlignment(0);
                if (hasFocus) {
                    this.setBackground(Constants.selectedCellBgColor);
                }
                l_toolTipText = leftEditRightMenu;
                break;
            }
            case 4: {
                String l_text = Util.stringNotNull(Util.getUserFriendlyCategoryString(l_rowAPlannedItem.getCategory()));
                this.setText(l_text);
                this.setHorizontalAlignment(2);
                if (hasFocus) {
                    this.setBackground(Constants.selectedCellBgColor);
                }
                l_toolTipText = leftEditRightMenu;
                break;
            }
            case 5: {
                String l_text = Util.stringNotNull(l_rowAPlannedItem.getMemo());
                this.setText(l_text);
                this.setHorizontalAlignment(2);
                if (!hasFocus) break;
                this.setBackground(Constants.selectedCellBgColor);
                l_toolTipText = leftEditRightMenu;
                break;
            }
            case 6: {
                if (l_rowAPlannedItem.isNegativeAmount()) {
                    this.setForeground(Constants.darkRedColor);
                } else {
                    this.setForeground(Constants.darkGreenColor);
                }
                String l_text = l_rowAPlannedItem.getAmountString();
                this.setText(l_text);
                this.setHorizontalAlignment(4);
                if (!hasFocus) break;
                this.setBackground(Constants.selectedCellBgColor);
                l_toolTipText = leftEditRightMenu;
            }
        }
        this.setToolTipText(l_toolTipText);
        return this;
    }
}

