/*
 * Decompiled with CFR 0.152.
 */
package moneyview.gui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import moneyview.Logger;
import moneyview.data.ACategory;
import moneyview.data.Account;
import moneyview.data.Util;
import moneyview.gui.Constants;
import moneyview.gui.MainWindow;
import moneyview.messages.Messages;

public class GuiUtil {
    private static final String TAG = GuiUtil.class.getSimpleName();

    public static ImageIcon getImageIcon(String fileName) {
        return new ImageIcon(GuiUtil.class.getResource("images/" + fileName));
    }

    public static ImageIcon getAccountImageIcon(String accountType) {
        ImageIcon l_accountIcon = null;
        if (accountType.equals("Bank")) {
            l_accountIcon = GuiUtil.getImageIcon("bank.png");
        }
        if (accountType.equals("Cash")) {
            l_accountIcon = GuiUtil.getImageIcon("cash.png");
        }
        if (accountType.equals("CCard")) {
            l_accountIcon = GuiUtil.getImageIcon("ccard.png");
        }
        if (accountType.equals("Oth A")) {
            l_accountIcon = GuiUtil.getImageIcon("assets.png");
        }
        if (accountType.equals("Oth L")) {
            l_accountIcon = GuiUtil.getImageIcon("liabilities.png");
        }
        return l_accountIcon;
    }

    public static JButton getChooseDateButton(int width, int height) {
        JButton l_chooseDateButton = new JButton();
        Image l_img = GuiUtil.getImageIcon("calendar.png").getImage();
        l_img = l_img.getScaledInstance(width, height, 4);
        l_chooseDateButton.setIcon(new ImageIcon(l_img));
        return l_chooseDateButton;
    }

    public static JButton getChooseCategoryButton(int width, int height) {
        JButton l_chooseCategoryButton = new JButton();
        Image l_img = GuiUtil.getImageIcon("menu.png").getImage();
        l_img = l_img.getScaledInstance(width, height, 4);
        l_chooseCategoryButton.setIcon(new ImageIcon(l_img));
        return l_chooseCategoryButton;
    }

    public static JComboBox<String> getCategoriesComboBox(Account currentAccount) {
        JComboBox<String> l_categoryComboBox = new JComboBox<String>();
        l_categoryComboBox.addItem(Messages.getString("NoCategory"));
        for (String l_cat : ACategory.getCategories()) {
            l_categoryComboBox.addItem(l_cat);
        }
        for (Account l_a : Account.openAccounts) {
            if (currentAccount != null && currentAccount.accountName.equals(l_a.accountName)) continue;
            String l_transferCat = String.valueOf(Messages.getString("TransferOperationBaseCategory")) + " : " + l_a.accountName;
            l_categoryComboBox.addItem(l_transferCat);
        }
        return l_categoryComboBox;
    }

    private static int getCountOfSubCategories(String category) {
        int l_count = 0;
        for (String l_cat : ACategory.getCategories()) {
            if (!l_cat.startsWith(String.valueOf(category) + " : ")) continue;
            ++l_count;
        }
        return l_count;
    }

    public static String getParentCategory(String category) {
        StringTokenizer l_st = new StringTokenizer(category, ":");
        return l_st.nextToken().trim();
    }

    public static String getSubCategory(String category) {
        StringTokenizer l_st = new StringTokenizer(category, ":");
        l_st.nextToken();
        if (!l_st.hasMoreTokens()) {
            return null;
        }
        return l_st.nextToken().trim();
    }

    public static String getCategoryChosenInCategoryPopup(ActionEvent e) {
        String l_subCat = e.getActionCommand();
        JMenuItem l_jmi = (JMenuItem)e.getSource();
        JPopupMenu l_jpm = (JPopupMenu)l_jmi.getParent();
        String l_cat = l_subCat;
        if (l_jpm.getInvoker() instanceof JMenu) {
            JMenu l_menu = (JMenu)l_jpm.getInvoker();
            l_cat = String.valueOf(l_menu.getText()) + (l_subCat.startsWith("[") ? "" : " : " + l_subCat);
        }
        Logger.info(TAG, "getCategoryChosenInCategoryPopup()=" + l_cat);
        return l_cat;
    }

    public static JPopupMenu getCategoryPopup(ActionListener actionListener, Account currentAccount) {
        Logger.debug(TAG, "getCategoryPopup()");
        JPopupMenu popup = new JPopupMenu();
        int l_indexSCat = 0;
        JMenu l_mnuCat = null;
        String l_prevParentCat = null;
        JMenuItem l_mniNoCat = new JMenuItem(GuiUtil.getParentCategory(Messages.getString("NoCategory")));
        l_mniNoCat.setForeground(Color.blue);
        popup.add(l_mniNoCat);
        l_mniNoCat.addActionListener(actionListener);
        for (String l_cat : ACategory.getCategories()) {
            JMenuItem l_mniCat;
            if (!GuiUtil.getParentCategory(l_cat).equals(l_prevParentCat)) {
                if (ACategory.contains(GuiUtil.getParentCategory(l_cat)) && GuiUtil.getCountOfSubCategories(GuiUtil.getParentCategory(l_cat)) == 0) {
                    l_mniCat = new JMenuItem(l_cat);
                    l_mniCat.setForeground(Color.blue);
                    popup.add(l_mniCat);
                    l_mniCat.addActionListener(actionListener);
                    l_prevParentCat = GuiUtil.getParentCategory(l_cat);
                } else {
                    l_mnuCat = new JMenu(GuiUtil.getParentCategory(l_cat));
                    popup.add(l_mnuCat);
                    l_mnuCat.addActionListener(actionListener);
                    l_indexSCat = 0;
                    l_prevParentCat = GuiUtil.getParentCategory(l_cat);
                    if (GuiUtil.getSubCategory(l_cat) == null) {
                        l_mniCat = new JMenuItem("[ " + GuiUtil.getParentCategory(l_cat) + " " + "]");
                        l_mniCat.setForeground(Color.blue);
                        l_mnuCat.add(l_mniCat);
                        l_mniCat.addActionListener(actionListener);
                    }
                }
            }
            if (GuiUtil.getSubCategory(l_cat) == null) continue;
            l_mniCat = new JMenuItem(GuiUtil.getSubCategory(l_cat));
            if (l_indexSCat++ % 2 == 0) {
                l_mniCat.setBackground(Color.white);
            }
            l_mnuCat.add(l_mniCat);
            l_mniCat.addActionListener(actionListener);
        }
        popup.addSeparator();
        popup.addSeparator();
        JMenu l_transferMenu = new JMenu(Messages.getString("TransferOperationBaseCategory"));
        popup.add(l_transferMenu);
        for (Account l_a : Account.openAccounts) {
            if (currentAccount != null && currentAccount.accountName.equals(l_a.accountName)) continue;
            JMenuItem l_mniTransfer = new JMenuItem(l_a.accountName);
            l_mniTransfer.setIcon(new ImageIcon(GuiUtil.getAccountImageIcon(l_a.accountType).getImage().getScaledInstance(32, 32, 4)));
            if (l_indexSCat++ % 2 == 0) {
                l_mniTransfer.setBackground(Color.white);
            }
            l_transferMenu.add(l_mniTransfer);
            l_mniTransfer.addActionListener(actionListener);
        }
        return popup;
    }

    public static void showTableElementInViewPort(final JTable table, final int rowSelection, final int columnSelection) {
        SwingUtilities.invokeLater(new Thread(){

            @Override
            public void run() {
                table.changeSelection(rowSelection, columnSelection, false, false);
                table.scrollRectToVisible(table.getCellRect(rowSelection, 0, true));
            }
        });
    }

    public static boolean isModalDialogShowing() {
        Window[] windows = Window.getWindows();
        if (windows != null) {
            Window[] windowArray = windows;
            int n = windows.length;
            int n2 = 0;
            while (n2 < n) {
                Window w = windowArray[n2];
                if (w.isShowing() && w instanceof Dialog && ((Dialog)w).isModal()) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static void displayBusyCursor() {
        MainWindow.getFrame().setCursor(Cursor.getPredefinedCursor(3));
    }

    public static void displayNormalCursor() {
        MainWindow.getFrame().setCursor(Cursor.getDefaultCursor());
    }

    public static String getHtmlForAmount(long amount) {
        if (amount < 0L) {
            return "<font color=\"#" + GuiUtil.getHtmlColorValue(Constants.darkRedColor) + "\">" + Util.longAmountToString(amount) + "</font>";
        }
        return "<font color=\"#" + GuiUtil.getHtmlColorValue(Constants.darkGreenColor) + "\">" + Util.longAmountToString(amount) + "</font>";
    }

    public static String getHtmlColorValue(Color c) {
        return Integer.toHexString(c.getRGB()).substring(2);
    }
}

