/*
 * Decompiled with CFR 0.152.
 */
package moneyview.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.EditorKit;
import moneyview.Logger;
import moneyview.data.Account;
import moneyview.data.Util;
import moneyview.gui.Constants;
import moneyview.gui.GuiUtil;
import moneyview.gui.MainWindow;
import moneyview.gui.custom.MVPieChart;
import moneyview.messages.Messages;

public class ReportsHtmlPanel
extends JPanel {
    private static final String TAG = ReportsHtmlPanel.class.getSimpleName();
    private MainWindow mainWindow;
    private JTextPane jTextPane;
    JButton homepageButton;
    JLabel reportsTopLabel;
    Dictionary<URL, Image> cache = null;
    private static final String grossExpensesUrlStr = "http://grossExpenses.img";
    private static final String grossIncomesUrlStr = "http://grossIncomes.img";
    private static final String calculatedExpensesUrlStr = "http://calculatedExpenses.img";
    private static final String calculatedIncomesUrlStr = "http://calculatedIncomes.img";

    public ReportsHtmlPanel(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
        this.setLayout(new BorderLayout(0, 0));
        JPanel panelTop = new JPanel();
        JPanel panelTopLeft = new JPanel();
        panelTop.setLayout(new BorderLayout(0, 0));
        panelTopLeft.setLayout(new BorderLayout(0, 0));
        this.add((Component)panelTop, "North");
        this.homepageButton = new JButton(Messages.getString("ReportsHtmlPanel.0"));
        this.homepageButton.setIcon(new ImageIcon(GuiUtil.getImageIcon("home.png").getImage().getScaledInstance(24, 24, 4)));
        this.homepageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.mnHomeMenu.doClick();
            }
        });
        panelTopLeft.add((Component)this.homepageButton, "West");
        panelTop.add((Component)panelTopLeft, "West");
        JPanel reportsTitleLabelPanel = new JPanel();
        reportsTitleLabelPanel.setBackground(Constants.reportsHeaderPanelBG);
        this.reportsTopLabel = new JLabel();
        this.reportsTopLabel.setForeground(Color.black);
        this.reportsTopLabel.setFont(new Font("Sans Serif", 1, 24));
        this.reportsTopLabel.setText("  " + Messages.getString("ReportsHtmlPanel.1"));
        this.reportsTopLabel.setIcon(new ImageIcon(GuiUtil.getImageIcon("piechart.png").getImage().getScaledInstance(32, 32, 4)));
        reportsTitleLabelPanel.add(this.reportsTopLabel);
        panelTop.add((Component)reportsTitleLabelPanel, "Center");
        this.jTextPane = new JTextPane();
        EditorKit l_kit = this.jTextPane.getEditorKitForContentType("text/html");
        this.jTextPane.setEditable(false);
        this.jTextPane.setEditorKit(l_kit);
        this.jTextPane.addHyperlinkListener(new HTMLListener());
        JScrollPane scrollPane = new JScrollPane(this.jTextPane, 20, 31);
        this.add((Component)scrollPane, "Center");
        try {
            this.cache = (Dictionary)this.jTextPane.getDocument().getProperty("imageCache");
            if (this.cache == null) {
                this.cache = new Hashtable<URL, Image>();
                this.jTextPane.getDocument().putProperty("imageCache", this.cache);
            }
        }
        catch (Exception e) {
            Logger.error(TAG, "ReportsHtmlPanel(): " + e);
        }
    }

    public void displayMainExpensesAndIncomes(int days) {
        StringBuilder l_sb = new StringBuilder();
        l_sb.append("<html><body bgcolor=\"#EEEEEE\"><center><table bgcolor=\"#EEEEEE\" border='0' font color=\"#494429\" vertical-align:middle>");
        GregorianCalendar l_gc = new GregorianCalendar();
        l_gc.add(5, -days);
        Map<String, Long> l_grossExpensesMap = Account.getCategoriesByGrossAmounts(l_gc.getTime(), 15, true);
        l_sb.append(this.dataToHtmlTable(l_grossExpensesMap, grossExpensesUrlStr, Messages.getString("ReportsHtmlPanel.14")));
        l_sb.append("<tr bgcolor=\"#666666\"><td></td></tr>");
        Map<String, Long> l_grossIncomesMap = Account.getCategoriesByGrossAmounts(l_gc.getTime(), 15, false);
        l_sb.append(this.dataToHtmlTable(l_grossIncomesMap, grossIncomesUrlStr, Messages.getString("ReportsHtmlPanel.16")));
        l_sb.append("<tr bgcolor=\"#666666\"><td></td></tr>");
        Map<String, Long> l_calculatedExpensesMap = Account.getCategoriesByNetAmounts(l_gc.getTime(), 15, true);
        l_sb.append(this.dataToHtmlTable(l_calculatedExpensesMap, calculatedExpensesUrlStr, Messages.getString("ReportsHtmlPanel.18")));
        l_sb.append("<tr bgcolor=\"#666666\"><td></td></tr>");
        Map<String, Long> l_calculatedIncomesMap = Account.getCategoriesByNetAmounts(l_gc.getTime(), 15, false);
        l_sb.append(this.dataToHtmlTable(l_calculatedIncomesMap, calculatedIncomesUrlStr, Messages.getString("ReportsHtmlPanel.20")));
        l_sb.append("<tr><td></td><td>");
        l_sb.append("<font size=\"6\"><u>" + Messages.getString("ReportsHtmlPanel.23") + "</u> : </font><br>" + Messages.getString("ReportsHtmlPanel.25") + Messages.getString("ACCOUNT_TYPE_BANK_LABEL") + ", " + Messages.getString("ACCOUNT_TYPE_CASH_LABEL") + Messages.getString("ReportsHtmlPanel.29") + Messages.getString("ACCOUNT_TYPE_CREDITCARD_LABEL") + ".<br>");
        l_sb.append(String.valueOf(Messages.getString("ReportsHtmlPanel.32")) + Messages.getString("MainWindow.192") + "'.<br>");
        l_sb.append(String.valueOf(Messages.getString("ReportsHtmlPanel.35")) + "<br>");
        l_sb.append(String.valueOf(Messages.getString("ReportsHtmlPanel.37")) + "<br>");
        l_sb.append(String.valueOf(Messages.getString("ReportsHtmlPanel.39")) + Messages.getString("Other") + "'." + "<br><br>");
        l_sb.append("<font size=\"6\"><u>" + Messages.getString("ReportsHtmlPanel.44") + "</u> : </font><br>" + Messages.getString("ReportsHtmlPanel.46") + Messages.getString("ACCOUNT_TYPE_BANK_LABEL") + ", " + Messages.getString("ACCOUNT_TYPE_CASH_LABEL") + Messages.getString("ReportsHtmlPanel.50") + Messages.getString("ACCOUNT_TYPE_CREDITCARD_LABEL") + ".<br>");
        l_sb.append(String.valueOf(Messages.getString("ReportsHtmlPanel.53")) + Messages.getString("MainWindow.192") + "'.<br>");
        l_sb.append(String.valueOf(Messages.getString("ReportsHtmlPanel.56")) + "<br>");
        l_sb.append(String.valueOf(Messages.getString("ReportsHtmlPanel.58")) + "<br>");
        l_sb.append(String.valueOf(Messages.getString("ReportsHtmlPanel.60")) + "<br>");
        l_sb.append(String.valueOf(Messages.getString("ReportsHtmlPanel.62")) + Messages.getString("Other") + "'." + "<br>");
        l_sb.append("</td></tr>");
        l_sb.append("</table></center></body></html>");
        this.jTextPane.setText(l_sb.toString());
    }

    public String dataToHtmlTable(Map<String, Long> data, String cacheUrlString, String tableTitle) {
        StringBuilder l_sb = new StringBuilder();
        l_sb.append("<tr><td><font size=\"6\">" + tableTitle + "</font></td></tr>");
        l_sb.append("<tr bgcolor=\"#EEEEEE\"><td>");
        if (data.size() < 2) {
            l_sb.append("<center><h2><br><br><br>" + Messages.getString("ReportsHtmlPanel.3") + "</h2></center>");
            return l_sb.toString();
        }
        l_sb.append("<table border='0' font color=\"#494429\">");
        long l_expensesTotal = 0L;
        int l_index = 0;
        for (Map.Entry<String, Long> l_me : data.entrySet()) {
            l_sb.append("<tr><td width=\"250\"><b><font size=\"4\">" + Util.getUserFriendlyCategoryString(l_me.getKey()) + "</font></b></td>");
            l_sb.append("<td width=\"100\"><b>" + GuiUtil.getHtmlForAmount(l_me.getValue()) + "</b></td>");
            l_sb.append("<td width=\"32\" bgcolor=\"#" + GuiUtil.getHtmlColorValue(Constants.graphColors[l_index]) + "\">&nbsp;&nbsp;</td>");
            ++l_index;
            l_sb.append("</tr>");
            l_expensesTotal += l_me.getValue().longValue();
        }
        try {
            BufferedImage l_pieChart = new BufferedImage(400, 400, 1);
            Graphics l_g = l_pieChart.getGraphics();
            MVPieChart.drawPie(l_g, new Rectangle(0, 0, 400, 400), data, new Color(238, 238, 238));
            this.cache.put(new URL(cacheUrlString), l_pieChart);
        }
        catch (MalformedURLException e) {
            Logger.error(TAG, "dataToHtmlTable(): " + e);
        }
        l_sb.append("</table></td><td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<img src=\"" + cacheUrlString + "\">");
        l_sb.append("<b><font size=\"4\">" + Messages.getString("ReportsHtmlPanel.2") + " " + GuiUtil.getHtmlForAmount(l_expensesTotal) + "</font></b>");
        l_sb.append("</td></tr>");
        return l_sb.toString();
    }

    private class HTMLListener
    implements HyperlinkListener {
        private HTMLListener() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                try {
                    StringTokenizer l_st = new StringTokenizer("" + e.getURL(), "/");
                    while (l_st.hasMoreTokens()) {
                        if (!l_st.nextToken().equals("homePage")) continue;
                        MainWindow.mnHomeMenu.doClick();
                    }
                }
                catch (Exception ex) {
                    Logger.error(TAG, "HTMLListener.hyperlinkUpdate: " + ex);
                    ex.printStackTrace();
                }
            }
        }
    }
}

