/*
 * Decompiled with CFR 0.152.
 */
package moneyview.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.EditorKit;
import moneyview.Logger;
import moneyview.data.Account;
import moneyview.data.AccountFuturBalance;
import moneyview.data.AccountsFuturData;
import moneyview.data.DayBalance;
import moneyview.data.Util;
import moneyview.gui.Constants;
import moneyview.gui.GuiUtil;
import moneyview.gui.MainWindow;
import moneyview.messages.Messages;

public class SummaryHtmlPanel
extends JPanel {
    private static final String TAG = SummaryHtmlPanel.class.getSimpleName();
    private MainWindow mainWindow;
    private Image bgImage;
    private JTextPane jTextPane;
    private static final String bankUrlStr = "http:\\bank.png";
    private static final String cashUrlStr = "http:\\cash.png";
    private static final String ccardUrlStr = "http:\\ccard.png";
    private static final String liabilitiesUrlStr = "http:\\liabilities.png";
    private static final String assetsUrlStr = "http:\\assets.png";
    private static final String greenupUrlStr = "http:\\greenup.png";
    private static final String greenequalUrlStr = "http:\\greenequal.png";
    private static final String greendownUrlStr = "http:\\greendown.png";
    private static final String redupUrlStr = "http:\\redup.png";
    private static final String redequalUrlStr = "http:\\redequal.png";
    private static final String reddownUrlStr = "http:\\reddown.png";
    long grandTotal = 0L;

    public SummaryHtmlPanel(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
        this.bgImage = GuiUtil.getImageIcon("bgmoney.png").getImage();
        this.setLayout(new BorderLayout(20, 20));
        JLabel lblListeDesComptes = new JLabel("<html><h1>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + Messages.getString("SummaryHtmlPanel.13") + "<br><font color=\"#D8D8D8\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + Messages.getString("SummaryHtmlPanel.15") + "</font></h1></html>");
        lblListeDesComptes.setFont(new Font("Tahoma", 1, 30));
        lblListeDesComptes.setForeground(Color.white);
        this.add((Component)lblListeDesComptes, "North");
        this.jTextPane = new JTextPane();
        EditorKit l_kit = this.jTextPane.getEditorKitForContentType("text/html");
        this.jTextPane.setEditable(false);
        this.jTextPane.setEditorKit(l_kit);
        this.jTextPane.addHyperlinkListener(new HTMLListener());
        JScrollPane scrollPane = new JScrollPane(this.jTextPane, 20, 31);
        this.add((Component)scrollPane, "Center");
        try {
            Hashtable<URL, Image> cache = (Hashtable<URL, Image>)this.jTextPane.getDocument().getProperty("imageCache");
            if (cache == null) {
                cache = new Hashtable<URL, Image>();
                this.jTextPane.getDocument().putProperty("imageCache", cache);
            }
            URL l_bankUrl = new URL(bankUrlStr);
            URL l_cashUrl = new URL(cashUrlStr);
            URL l_ccardUrl = new URL(ccardUrlStr);
            URL l_liabilitiesUrl = new URL(liabilitiesUrlStr);
            URL l_assetsUrl = new URL(assetsUrlStr);
            Image l_bankImage = GuiUtil.getAccountImageIcon("Bank").getImage().getScaledInstance(64, 64, 4);
            ((Dictionary)cache).put(l_bankUrl, l_bankImage);
            Image l_cashImage = GuiUtil.getAccountImageIcon("Cash").getImage().getScaledInstance(64, 64, 4);
            ((Dictionary)cache).put(l_cashUrl, l_cashImage);
            Image l_ccardImage = GuiUtil.getAccountImageIcon("CCard").getImage().getScaledInstance(64, 64, 4);
            ((Dictionary)cache).put(l_ccardUrl, l_ccardImage);
            Image l_liabilitiesImage = GuiUtil.getAccountImageIcon("Oth L").getImage().getScaledInstance(64, 64, 4);
            ((Dictionary)cache).put(l_liabilitiesUrl, l_liabilitiesImage);
            Image l_assetsImage = GuiUtil.getAccountImageIcon("Oth A").getImage().getScaledInstance(64, 64, 4);
            ((Dictionary)cache).put(l_assetsUrl, l_assetsImage);
            URL l_greenupUrl = new URL(greenupUrlStr);
            URL l_greenequalUrl = new URL(greenequalUrlStr);
            URL l_greendownUrl = new URL(greendownUrlStr);
            URL l_redupUrl = new URL(redupUrlStr);
            URL l_redequalUrl = new URL(redequalUrlStr);
            URL l_reddownUrl = new URL(reddownUrlStr);
            Image l_greenupImage = GuiUtil.getImageIcon("greenup.png").getImage().getScaledInstance(24, 24, 4);
            ((Dictionary)cache).put(l_greenupUrl, l_greenupImage);
            Image l_greenequalImage = GuiUtil.getImageIcon("greenequal.png").getImage().getScaledInstance(24, 24, 4);
            ((Dictionary)cache).put(l_greenequalUrl, l_greenequalImage);
            Image l_greendownImage = GuiUtil.getImageIcon("greendown.png").getImage().getScaledInstance(24, 24, 4);
            ((Dictionary)cache).put(l_greendownUrl, l_greendownImage);
            Image l_redupImage = GuiUtil.getImageIcon("redup.png").getImage().getScaledInstance(24, 24, 4);
            ((Dictionary)cache).put(l_redupUrl, l_redupImage);
            Image l_redequalImage = GuiUtil.getImageIcon("redequal.png").getImage().getScaledInstance(24, 24, 4);
            ((Dictionary)cache).put(l_redequalUrl, l_redequalImage);
            Image l_reddownImage = GuiUtil.getImageIcon("reddown.png").getImage().getScaledInstance(24, 24, 4);
            ((Dictionary)cache).put(l_reddownUrl, l_reddownImage);
        }
        catch (MalformedURLException e) {
            Logger.error(TAG, "SummaryHtmlPanel(): " + e);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        g.drawImage(this.bgImage, 0, 0, null);
    }

    private static String getAccountTypeImageUrl(String accountType) {
        if (accountType.equals("Bank")) {
            return bankUrlStr;
        }
        if (accountType.equals("Cash")) {
            return cashUrlStr;
        }
        if (accountType.equals("CCard")) {
            return ccardUrlStr;
        }
        if (accountType.equals("Oth L")) {
            return liabilitiesUrlStr;
        }
        if (accountType.equals("Oth A")) {
            return assetsUrlStr;
        }
        return null;
    }

    public void displayAccounts() {
        if (Account.openAccounts.size() < 1) {
            this.jTextPane.setText("<html><body><center><h1><br><br><br>" + Messages.getString("SummaryHtmlPanel.29") + "</h1></center></body></html>");
            this.validate();
            this.repaint();
            GuiUtil.displayNormalCursor();
            return;
        }
        StringBuilder l_sb = new StringBuilder();
        l_sb.append("<html><body bgcolor=\"#666666\"><center><table border='0' font color=\"#494429\" vertical-align:middle>");
        l_sb.append("<tr><td></td><td></td></tr>");
        ArrayList<String> l_existingAccountsTypes = new ArrayList<String>();
        this.accountsSummaryByType("Bank");
        for (Account l_a : Account.openAccounts) {
            if (l_existingAccountsTypes.contains(l_a.accountType)) continue;
            l_existingAccountsTypes.add(l_a.accountType);
        }
        this.grandTotal = 0L;
        for (String l_at : l_existingAccountsTypes) {
            l_sb.append("<tr bgcolor=\"#EEEEEE\"><td><img src=\"" + SummaryHtmlPanel.getAccountTypeImageUrl(l_at) + "\"></td>");
            l_sb.append("<table border='0' font color=\"#494429\">");
            l_sb.append(this.accountsSummaryByType(l_at));
            l_sb.append("</table>");
        }
        l_sb.append("<tr bgcolor=\"#CCCCCC\"><td></td>");
        l_sb.append("<table border='0' font color=\"#494429\">");
        l_sb.append("<tr><td width=\"500\"><td align=\"right\" width=\"250\">" + Messages.getString("SummaryHtmlPanel.40") + "  </td><td align=\"right\" width=\"200\"><b>" + GuiUtil.getHtmlForAmount(this.grandTotal) + "</b></td></tr>");
        l_sb.append("</table>");
        l_sb.append("</table></center></body></html>");
        this.jTextPane.setText(l_sb.toString());
        this.validate();
        this.repaint();
        GuiUtil.displayNormalCursor();
    }

    private String accountsSummaryByType(String accountType) {
        StringBuilder l_sb = new StringBuilder();
        long l_total = 0L;
        for (Account l_a : Account.openAccounts) {
            if (!l_a.accountType.equals(accountType)) continue;
            l_sb.append("<tr><td width=\"500\"><b><font size=\"5\"><a href=\"http://showAccount/" + l_a.accountName + "\">").append(l_a.accountName).append("</a></font></b></td>");
            int l_opCount = l_a.getItemListSize();
            boolean l_boldLastOperationDate = false;
            if (l_opCount > 0 && ("Bank".equals(l_a.accountType) || "CCard".equals(l_a.accountType) || "Cash".equals(l_a.accountType))) {
                GregorianCalendar l_gc = new GregorianCalendar();
                l_gc.add(2, -1);
                if (l_a.getItem(l_a.getItemListSize() - 1).getDate().before(l_gc.getTime())) {
                    l_boldLastOperationDate = true;
                }
            }
            l_sb.append("<td width=\"250\">" + Messages.getString("SummaryHtmlPanel.49") + (l_opCount > 0 ? String.valueOf(l_boldLastOperationDate ? "<b>" : "") + Util.getSimpleDateFormatter().format(l_a.getItem(l_a.getItemListSize() - 1).getDate()) + (l_boldLastOperationDate ? "</b>" : "") : Messages.getString("SummaryHtmlPanel.50")) + "<br>");
            int l_notValidatedOperationCount = l_a.getNotValidatedOperationCount();
            if (l_notValidatedOperationCount > 0) {
                l_sb.append("<b><FONT style=\"BACKGROUND-COLOR: yellow\">" + Messages.getString("SummaryHtmlPanel.53") + "</font></b> / " + Messages.getString("SummaryHtmlPanel.55") + " = <b><FONT style=\"BACKGROUND-COLOR: yellow\">" + l_notValidatedOperationCount + "</font></b> / " + l_opCount);
            } else {
                l_sb.append(String.valueOf(Messages.getString("SummaryHtmlPanel.53")) + " / " + Messages.getString("SummaryHtmlPanel.55") + " = " + l_notValidatedOperationCount + " / ");
                if (l_a.getItemListSize() > 0 && l_a.getItem(l_a.getItemListSize() - 1).isReconciled()) {
                    l_sb.append("<font style=\"BACKGROUND-COLOR: #" + GuiUtil.getHtmlColorValue(Constants.reconciledBgColor) + "\">").append(l_opCount).append("</font>");
                } else {
                    l_sb.append(l_opCount);
                }
            }
            l_sb.append("</td><td width=\"200\" align=\"right\">");
            if (l_opCount == 0 || !l_a.balanceEnabled) {
                l_sb.append(Messages.getString("SummaryHtmlPanel.50"));
                l_sb.append("</td><td>");
            } else {
                l_sb.append("<b>" + GuiUtil.getHtmlForAmount(l_a.balance) + "</b>");
                l_total += l_a.balance;
                String l_accountTendancy = this.getTendancyForAccount(l_a);
                l_sb.append("</td><td align=\"right\">");
                if (l_accountTendancy != null) {
                    l_sb.append("<img src=\"http:\\" + l_accountTendancy + ".png\"></td>");
                }
            }
            l_sb.append("</td></tr>");
        }
        l_sb.append("<tr><td></td><td align=\"right\" >" + Messages.getString("SummaryHtmlPanel.76") + "  </td><td align=\"right\"><b>" + GuiUtil.getHtmlForAmount(l_total) + "</b></td></tr>");
        this.grandTotal += l_total;
        return l_sb.toString();
    }

    private String getTendancyForAccount(Account account) {
        AccountsFuturData l_data = null;
        try {
            l_data = Util.getAccountFuturBalances(new String[]{account.accountName}, 30);
            if (l_data != null) {
                boolean l_isNegativeWithin30Days = false;
                AccountFuturBalance l_afb = l_data.accountsFuturBalances.get(0);
                if (l_afb != null) {
                    List<DayBalance> l_dayBalances = l_afb.dayBalances;
                    int i = 1;
                    while (i < l_dayBalances.size()) {
                        if (l_dayBalances.get((int)i).balance < 0L) {
                            l_isNegativeWithin30Days = true;
                            break;
                        }
                        ++i;
                    }
                    String l_iconName = l_isNegativeWithin30Days ? "red" : "green";
                    l_iconName = (double)l_dayBalances.get((int)(l_dayBalances.size() - 1)).balance < (l_dayBalances.get((int)0).balance <= 0L ? (double)l_dayBalances.get((int)0).balance * 1.1 : (double)l_dayBalances.get((int)0).balance * 0.9) ? String.valueOf(l_iconName) + "down" : ((double)l_dayBalances.get((int)(l_dayBalances.size() - 1)).balance > (l_dayBalances.get((int)0).balance >= 0L ? (double)l_dayBalances.get((int)0).balance * 1.1 : (double)l_dayBalances.get((int)0).balance * 0.9) ? String.valueOf(l_iconName) + "up" : String.valueOf(l_iconName) + "equal");
                    return l_iconName;
                }
            }
        }
        catch (Exception ex) {
            Logger.error(TAG, ex.toString());
            ex.printStackTrace();
        }
        return null;
    }

    static /* synthetic */ MainWindow access$0(SummaryHtmlPanel summaryHtmlPanel) {
        return summaryHtmlPanel.mainWindow;
    }

    private class HTMLListener
    implements HyperlinkListener {
        private HTMLListener() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                try {
                    StringTokenizer l_st = new StringTokenizer("" + e.getURL(), "/");
                    while (l_st.hasMoreTokens()) {
                        if (!l_st.nextToken().equals("showAccount")) continue;
                        String l_accountName = l_st.nextToken();
                        for (JMenuItem l_mi : MainWindow.accountMenuItems) {
                            if (!l_mi.getText().equals(l_accountName)) continue;
                            l_mi.doClick();
                        }
                    }
                }
                catch (Exception ex) {
                    Logger.error(TAG, "HTMLListener.hyperlinkUpdate: " + ex);
                    ex.printStackTrace();
                }
            }
        }
    }
}

