/*
 * Decompiled with CFR 0.152.
 */
package moneyview.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import moneyview.data.AItem;
import moneyview.data.Account;
import moneyview.gui.DisplayedAccount;
import moneyview.gui.IKeyboardListener;
import moneyview.gui.custom.KeyboardMainListener;
import moneyview.messages.Messages;

public class TransferOperationToAccountDialog
extends JDialog
implements IKeyboardListener {
    public boolean okSelected = false;
    public String selectedAccount = null;
    JComboBox<String> accountComboBox = new JComboBox();

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            KeyboardMainListener.addCurrentListener(this);
            final TransferOperationToAccountDialog thisTransferOperationToAccountDialog = this;
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    KeyboardMainListener.removeListener(thisTransferOperationToAccountDialog);
                }
            });
        }
        super.setVisible(visible);
    }

    @Override
    public void escapeKeyTyped() {
        this.dispose();
    }

    @Override
    public void enterKeyTyped() {
    }

    @Override
    public void deleteKeyTyped() {
    }

    public TransferOperationToAccountDialog(JFrame frame, String title, boolean isCopying, AItem aItem) {
        super(frame, title, true);
        this.setResizable(false);
        this.setSize(390, 202);
        this.setLocation(frame.getX() + 300, frame.getY() + 300);
        this.getContentPane().setLayout(null);
        this.accountComboBox.setBounds(33, 46, 320, 33);
        this.getContentPane().add(this.accountComboBox);
        for (Account l_a : Account.openAccounts) {
            if (!isCopying && l_a.accountName.equals(DisplayedAccount.getDisplayedAccount().accountName) || aItem.getCategory() != null && aItem.getCategory().equals("[" + l_a.accountName + "]")) continue;
            this.accountComboBox.addItem(l_a.accountName);
        }
        JLabel lblSelectionnezUnNouveau = new JLabel(Messages.getString("TransferOperationToAccountDialog.0"));
        lblSelectionnezUnNouveau.setBounds(33, 21, 299, 14);
        this.getContentPane().add(lblSelectionnezUnNouveau);
        JButton cancelButton = new JButton(Messages.getString("TransferOperationToAccountDialog.1"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TransferOperationToAccountDialog.this.dispose();
            }
        });
        cancelButton.setBounds(33, 110, 141, 33);
        this.getContentPane().add(cancelButton);
        JButton btnOk = new JButton(Messages.getString("TransferOperationToAccountDialog.2"));
        btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TransferOperationToAccountDialog.this.okSelected = true;
                TransferOperationToAccountDialog.this.selectedAccount = (String)TransferOperationToAccountDialog.this.accountComboBox.getSelectedItem();
                TransferOperationToAccountDialog.this.dispose();
            }
        });
        btnOk.setBounds(212, 110, 141, 33);
        this.getContentPane().add(btnOk);
    }
}

