/*
 * Decompiled with CFR 0.152.
 */
package moneyview.gui.custom;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Map;
import javax.swing.JComponent;
import moneyview.gui.Constants;

public class MVPieChart
extends JComponent {
    private static final String TAG = MVPieChart.class.getSimpleName();

    public static void drawPie(Graphics g, Rectangle area, Map<String, Long> keyValuesMap, Color bgcolor) {
        g.setColor(bgcolor);
        g.fillRect(area.x, area.y, area.width, area.height);
        g.setColor(Color.black);
        g.fillArc(area.x, area.y, area.width, area.height, 0, 360);
        long total = 0L;
        for (Map.Entry<String, Long> l_me : keyValuesMap.entrySet()) {
            total += l_me.getValue().longValue();
        }
        if (total == 0L) {
            return;
        }
        double curValue = 0.0;
        int startAngle = 0;
        int l_index = 0;
        for (Map.Entry<String, Long> l_me : keyValuesMap.entrySet()) {
            startAngle = (int)(curValue * 360.0 / (double)total);
            int arcAngle = (int)(l_me.getValue() * 360L / total);
            g.setColor(Constants.graphColors[l_index]);
            ++l_index;
            g.fillArc(area.x + 5, area.y + 5, area.width - 10, area.height - 10, startAngle, arcAngle);
            curValue += (double)l_me.getValue().longValue();
        }
    }
}

