/*
 * Decompiled with CFR 0.152.
 */
package moneyview.properties;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.JOptionPane;
import moneyview.Logger;
import moneyview.data.ACategory;
import moneyview.data.Account;

public class HMProperties {
    private static final String TAG = HMProperties.class.getSimpleName();
    private static Properties saveLocationProperties = new Properties();
    private static Properties stateProperties = new Properties();
    private static String saveLocation = null;
    private static String openDirLocation = null;
    public static final String SAVE_LOCATION_KEY = "save.dir_location_";
    public static final String OPEN_DIR_LOCATION_KEY = "open.dir_location";
    public static final String DATE_DAY_FIRST = "date.day_first";
    public static final String FRAME_LEFT = "frame.left";
    public static final String FRAME_TOP = "frame.top";
    public static final String FRAME_WIDTH = "frame.width";
    public static final String FRAME_HEIGHT = "frame.height";
    public static final String FRAME_STATE = "frame.state";
    public static final String HMY_ACCOUNT_FILES = "hmy.account_files";
    public static final String HMY_CATEGORY_PREFIX = "hmy.category";
    public static final String HMY_LOCALE = "hmy.locale";
    public static final String HMY_VERSION = "hmy.version";
    public static final String HMY_REPORTS_DAYS = "hmy.reports_days";
    private static final String HMY_PROPERTIES_FILENAME = "moneyview.properties";
    public static final String HMY_SAVE_DIR_LOCATION_FILENAME = "savedir.location";
    private static final String HMY_MAIN_SAVE_DIR_NAME = ".moneyview";
    private static final String HMY_SAVE_DIR_PROPERTIES_COMMENT = "MoneyView properties for save directories";
    private static final String OLD_HMY_PROPERTIES_FILENAME = "hmoney.properties";
    public static final String OLD_HMY_SAVE_DIR_LOCATION_FILENAME = "saveloc.hmoney";
    private static final String OLD_HMY_MAIN_SAVE_DIR_NAME = ".hmoney";
    private static boolean checkMigrateFromHmoneyToMoneyviewDone = false;

    public static int getIntProperty(String property) {
        int l_val = 0;
        try {
            l_val = Integer.parseInt(stateProperties.getProperty(property));
        }
        catch (Exception e) {
            Logger.warn(TAG, "getIntProperty: Invalid integer in properties.");
        }
        Logger.verbose(TAG, "getIntProperty: returns " + property + "=" + l_val);
        return l_val;
    }

    public static String getStringProperty(String property) {
        String l_val = null;
        l_val = stateProperties.getProperty(property);
        Logger.verbose(TAG, "getStringProperty: returns " + property + "=" + l_val);
        return l_val;
    }

    public static void putProperty(String key, String val) {
        Logger.verbose(TAG, "putProperty: set " + key + "=" + val);
        stateProperties.put(key, val);
    }

    public static void putProperty(String key, int val) {
        Logger.verbose(TAG, "putProperty: set " + key + "=" + val);
        stateProperties.put(key, "" + val);
    }

    public static void removeProperty(String key) {
        Logger.verbose(TAG, "removeProperty( " + key + ")");
        stateProperties.remove(key);
    }

    private static void putDefaultProperty(String key, String val) {
        if (!stateProperties.containsKey(key)) {
            stateProperties.put(key, val);
        }
    }

    private static void putDefaultProperty(String key, int val) {
        if (!stateProperties.containsKey(key)) {
            stateProperties.put(key, "" + val);
        }
    }

    public static String getSaveLocation() {
        if (saveLocation != null) {
            return saveLocation;
        }
        String l_stateLocation = String.valueOf(HMProperties.getMainSaveDirInUserHome()) + File.separator + HMY_SAVE_DIR_LOCATION_FILENAME;
        try {
            FileInputStream l_fi = new FileInputStream(l_stateLocation);
            saveLocationProperties.load(l_fi);
            l_fi.close();
            saveLocation = saveLocationProperties.getProperty("save.dir_location_0");
            openDirLocation = saveLocationProperties.getProperty(OPEN_DIR_LOCATION_KEY);
            if (openDirLocation == null || openDirLocation.length() < 2) {
                openDirLocation = "" + new File(System.getProperty("user.home")).getAbsoluteFile();
            }
        }
        catch (IOException e) {
            Logger.warn(TAG, "getPropertiesLocation: no properties file found.");
            HMProperties.setSaveLocation(null);
        }
        Logger.info(TAG, "getSaveLocation()=" + saveLocation);
        return saveLocation;
    }

    public static List<String> getSaveLocationHistory() {
        ArrayList<String> l_res = new ArrayList<String>();
        int i = 0;
        while (i < 20) {
            String l_val = (String)saveLocationProperties.get(SAVE_LOCATION_KEY + i);
            if (l_val != null) {
                l_res.add(l_val);
            }
            ++i;
        }
        return l_res;
    }

    private static void checkMigrateFromHmoneyToMoneyview() {
        if (checkMigrateFromHmoneyToMoneyviewDone) {
            return;
        }
        checkMigrateFromHmoneyToMoneyviewDone = true;
        Logger.verbose(TAG, "checkMigrateFromHmoneyToMoneyview()");
        String l_mainSaveDirName = String.valueOf(System.getProperty("user.home")) + File.separator + HMY_MAIN_SAVE_DIR_NAME;
        String l_hmoneyMainSaveDirName = String.valueOf(System.getProperty("user.home")) + File.separator + OLD_HMY_MAIN_SAVE_DIR_NAME;
        File l_hmoneyMainSaveDir = new File(l_hmoneyMainSaveDirName);
        File l_MainSaveDirectory = new File(l_mainSaveDirName);
        if (l_hmoneyMainSaveDir.exists() && !l_MainSaveDirectory.exists()) {
            l_hmoneyMainSaveDir.renameTo(l_MainSaveDirectory);
        }
        String l_saveDirLocationFileName = String.valueOf(l_mainSaveDirName) + File.separator + HMY_SAVE_DIR_LOCATION_FILENAME;
        File l_hmoneySaveDirLocationFileName = new File(String.valueOf(l_mainSaveDirName) + File.separator + OLD_HMY_SAVE_DIR_LOCATION_FILENAME);
        File l_savedirLocationFile = new File(l_saveDirLocationFileName);
        if (l_hmoneySaveDirLocationFileName.exists() && !l_savedirLocationFile.exists()) {
            l_hmoneySaveDirLocationFileName.renameTo(l_savedirLocationFile);
        } else if (l_hmoneySaveDirLocationFileName.exists() && l_savedirLocationFile.exists()) {
            l_hmoneySaveDirLocationFileName.delete();
        }
        String l_stateLocation = String.valueOf(l_mainSaveDirName) + File.separator + HMY_SAVE_DIR_LOCATION_FILENAME;
        try {
            FileInputStream l_fi = new FileInputStream(l_stateLocation);
            saveLocationProperties.load(l_fi);
            l_fi.close();
            int i = 0;
            while (i < 20) {
                String l_val = (String)saveLocationProperties.get(SAVE_LOCATION_KEY + i);
                if (l_val != null && l_val.equals(l_hmoneyMainSaveDirName)) {
                    saveLocationProperties.put(SAVE_LOCATION_KEY + i, l_mainSaveDirName);
                }
                ++i;
            }
            FileOutputStream l_fo = new FileOutputStream(l_stateLocation);
            saveLocationProperties.store(l_fo, HMY_SAVE_DIR_PROPERTIES_COMMENT);
            l_fo.close();
        }
        catch (IOException e) {
            Logger.warn(TAG, "getPropertiesLocation: no properties file found.");
        }
    }

    private static String getMainSaveDirInUserHome() {
        Logger.verbose(TAG, "getMainSaveDirInUserHome()");
        HMProperties.checkMigrateFromHmoneyToMoneyview();
        File l_hmoneyHomeDir = new File(String.valueOf(System.getProperty("user.home")) + File.separator + HMY_MAIN_SAVE_DIR_NAME);
        if (!l_hmoneyHomeDir.exists()) {
            JOptionPane.showMessageDialog(null, "<html><H2><br><center>MoneyView will save its files in the default directory: USER_HOME" + File.separator + HMY_MAIN_SAVE_DIR_NAME + "<br>" + "On this computer this is directory: " + l_hmoneyHomeDir.getAbsolutePath() + "<br><br><hr><br>" + "Les fichiers de MoneyView sont par d\u00e9faut dans le r\u00e9pertoire : USER_HOME" + File.separator + HMY_MAIN_SAVE_DIR_NAME + "<br>" + "Sur cet ordinateur, c'est le r\u00e9pertoire : " + l_hmoneyHomeDir.getAbsolutePath() + "</center><br><br></H2></html>", "IMPORTANT", 1);
            l_hmoneyHomeDir.mkdir();
        }
        return l_hmoneyHomeDir.getAbsoluteFile().toString();
    }

    public static String getOpenDirLocation() {
        return openDirLocation;
    }

    public static boolean setOpenDirLocation(String dirLocation) {
        try {
            String l_stateLocation = String.valueOf(HMProperties.getMainSaveDirInUserHome()) + File.separator + HMY_SAVE_DIR_LOCATION_FILENAME;
            openDirLocation = dirLocation;
            saveLocationProperties.put(OPEN_DIR_LOCATION_KEY, openDirLocation);
            FileOutputStream l_fo = new FileOutputStream(l_stateLocation);
            saveLocationProperties.store(l_fo, HMY_SAVE_DIR_PROPERTIES_COMMENT);
            l_fo.close();
            return true;
        }
        catch (IOException e) {
            Logger.error(TAG, "setOpenDirLocation: " + e);
            return false;
        }
    }

    public static boolean setSaveLocation(String dirLocation) {
        if (dirLocation == null) {
            dirLocation = HMProperties.getMainSaveDirInUserHome();
        }
        if (openDirLocation == null || openDirLocation.length() < 2) {
            openDirLocation = "" + new File(System.getProperty("user.home")).getAbsoluteFile();
        }
        String l_stateLocation = String.valueOf(HMProperties.getMainSaveDirInUserHome()) + File.separator + HMY_SAVE_DIR_LOCATION_FILENAME;
        Properties l_nextSaveLocationProperties = new Properties();
        try {
            int i = 0;
            while (i < 19) {
                String l_val = (String)saveLocationProperties.get(SAVE_LOCATION_KEY + i);
                if (l_val != null && !l_val.equals(dirLocation) && !l_nextSaveLocationProperties.containsValue(l_val)) {
                    l_nextSaveLocationProperties.put(SAVE_LOCATION_KEY + (i + 1), l_val);
                }
                ++i;
            }
            l_nextSaveLocationProperties.put("save.dir_location_0", dirLocation);
            l_nextSaveLocationProperties.put(OPEN_DIR_LOCATION_KEY, openDirLocation);
            saveLocation = dirLocation;
            saveLocationProperties = l_nextSaveLocationProperties;
            FileOutputStream l_fo = new FileOutputStream(l_stateLocation);
            saveLocationProperties.store(l_fo, HMY_SAVE_DIR_PROPERTIES_COMMENT);
            l_fo.close();
            return true;
        }
        catch (IOException e) {
            Logger.error(TAG, "setPropertiesLocation: " + e);
            return false;
        }
    }

    private static void setDefaultProperties() {
        HMProperties.putDefaultProperty(FRAME_LEFT, 0);
        HMProperties.putDefaultProperty(FRAME_TOP, 0);
        HMProperties.putDefaultProperty(FRAME_WIDTH, 1280);
        HMProperties.putDefaultProperty(FRAME_HEIGHT, 1024);
        HMProperties.putDefaultProperty(FRAME_STATE, 0);
        HMProperties.putDefaultProperty(DATE_DAY_FIRST, "true");
    }

    public static boolean loadProperties() {
        Logger.verbose(TAG, "loadProperties()");
        boolean l_loadOK = false;
        try {
            String l_saveDirName = HMProperties.getSaveLocation();
            File l_saveDir = null;
            if (l_saveDirName != null) {
                l_saveDir = new File(l_saveDirName);
            }
            if (l_saveDir != null && l_saveDir.exists()) {
                String l_propFilename = String.valueOf(l_saveDirName) + File.separator + HMY_PROPERTIES_FILENAME;
                File l_hmoneyPropFile = new File(String.valueOf(l_saveDirName) + File.separator + OLD_HMY_PROPERTIES_FILENAME);
                File l_propFile = new File(l_propFilename);
                if (l_hmoneyPropFile.exists() && !l_propFile.exists()) {
                    l_hmoneyPropFile.renameTo(l_propFile);
                }
                try {
                    FileInputStream l_fi = new FileInputStream(l_propFilename);
                    stateProperties.load(l_fi);
                    l_fi.close();
                    ACategory.restoreFromProperties(stateProperties);
                    l_loadOK = true;
                }
                catch (IOException e) {
                    Logger.warn(TAG, "loadProperties: no properties file found.");
                }
            }
        }
        finally {
            if (!l_loadOK) {
                HMProperties.setDefaultProperties();
            }
        }
        return l_loadOK;
    }

    public static boolean storeProperties() {
        if (stateProperties.isEmpty()) {
            Logger.warn(TAG, "storeProperties: no properties to save");
            return false;
        }
        stateProperties.put(HMY_VERSION, "2.1.0");
        String l_hmoneyStateDirStr = HMProperties.getSaveLocation();
        File l_hmoneyStateDir = null;
        if (l_hmoneyStateDirStr != null) {
            l_hmoneyStateDir = new File(l_hmoneyStateDirStr);
        }
        if (l_hmoneyStateDir != null && l_hmoneyStateDir.exists()) {
            ACategory.putCategoriesInProperties(stateProperties);
            String l_propFileName = l_hmoneyStateDir.getAbsoluteFile() + File.separator + HMY_PROPERTIES_FILENAME;
            try {
                FileOutputStream l_fo = new FileOutputStream(l_propFileName);
                stateProperties.store(l_fo, "MoneyView properties file");
                ACategory.setSaved(true);
                l_fo.close();
                return true;
            }
            catch (IOException e) {
                Logger.error(TAG, "storeProperties: " + e);
            }
        }
        return false;
    }

    public static void updateAccountList() {
        String l_al = "";
        for (Account l_a : Account.openAccounts) {
            l_al = String.valueOf(l_al) + (l_al.length() < 1 ? "" : ",") + l_a.accountName;
        }
        HMProperties.putProperty(HMY_ACCOUNT_FILES, l_al);
        HMProperties.storeProperties();
    }
}

