/*
 * Decompiled with CFR 0.152.
 */
package moneyview.zip;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import moneyview.Logger;

public class Unzip {
    private static final String TAG = Unzip.class.getSimpleName();

    public static void main(String[] args) throws IOException {
        File destDirectory = new File("C:\\tmpzipout");
        File zipFile = new File("C:\\tmp.zip");
        try {
            Unzip.purgeDirectory(destDirectory, true);
            Unzip.archiveToDir(zipFile, destDirectory);
        }
        catch (Exception e) {
            System.out.println("error : " + e);
        }
        System.out.println("done");
    }

    public static void archiveToDir(File zipFile, File destDirectory) throws Exception {
        Logger.info(TAG, "archiveToDir( " + zipFile + ", " + destDirectory + ")");
        Unzip.purgeDirectory(destDirectory, true);
        byte[] l_buffer = new byte[2048];
        ZipFile l_zf = new ZipFile(zipFile);
        Enumeration<? extends ZipEntry> e = l_zf.entries();
        while (e.hasMoreElements()) {
            ZipEntry l_ze = e.nextElement();
            if (l_ze.getName().equalsIgnoreCase("savedir.location")) continue;
            Logger.debug(TAG, "archiveToDir(): unzipping '" + l_ze.getName() + "'");
            File l_f = new File(destDirectory + File.separator + l_ze.getName());
            Unzip.makeParentDirsIfRequired(l_f);
            FileOutputStream l_fo = new FileOutputStream(l_f);
            InputStream l_zin = l_zf.getInputStream(l_ze);
            int l_readBytes = 0;
            while ((l_readBytes = l_zin.read(l_buffer, 0, l_buffer.length)) > -1) {
                l_fo.write(l_buffer, 0, l_readBytes);
            }
            l_zin.close();
            l_fo.close();
            l_f.setLastModified(l_ze.getTime());
        }
        l_zf.close();
    }

    private static void makeParentDirsIfRequired(File file) {
        if (file.getParent() != null) {
            File l_dir = new File(file.getParent());
            if (l_dir.exists()) {
                return;
            }
            Unzip.makeParentDirsIfRequired(l_dir);
            l_dir.mkdir();
        }
    }

    private static void purgeDirectory(File dir, boolean isRootDir) {
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                Unzip.purgeDirectory(file, false);
            }
            if (!isRootDir || !file.getName().equalsIgnoreCase("savedir.location") && !file.getName().equalsIgnoreCase("saveloc.hmoney")) {
                file.delete();
            }
            ++n2;
        }
    }
}

