/*
 * Decompiled with CFR 0.152.
 */
package moneyview;

import com.formdev.flatlaf.FlatDarculaLaf;
import com.formdev.flatlaf.FlatDarkLaf;
import com.formdev.flatlaf.FlatIntelliJLaf;
import com.formdev.flatlaf.FlatLightLaf;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.table.DefaultTableModel;

public class LafDemo {
    public static void changeLaf(JFrame frame, String laf) {
        System.out.println("changeLaf to " + laf);
        if (laf.equals("metal")) {
            try {
                System.out.println("Setting metal");
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
                System.out.println("ERROR: " + e.toString());
                e.printStackTrace();
            }
        }
        if (laf.equals("nimbus")) {
            try {
                System.out.println("Setting nimbus");
                UIManager.setLookAndFeel("javax.swing.plaf.nimbus.NimbusLookAndFeel");
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
                System.out.println("ERROR: " + e.toString());
                e.printStackTrace();
            }
        }
        if (laf.equals("system")) {
            try {
                System.out.println("Setting system");
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
                System.out.println("ERROR: " + e.toString());
                e.printStackTrace();
            }
        }
        if (laf.equals("FlatLight")) {
            try {
                System.out.println("Setting FlatLight");
                UIManager.setLookAndFeel(FlatLightLaf.class.getName());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
                System.out.println("ERROR: " + e.toString());
                e.printStackTrace();
            }
        }
        if (laf.equals("FlatDark")) {
            try {
                System.out.println("Setting FlatDark");
                UIManager.setLookAndFeel(FlatDarkLaf.class.getName());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
                System.out.println("ERROR: " + e.toString());
                e.printStackTrace();
            }
        }
        if (laf.equals("FlatIntelliJ")) {
            try {
                System.out.println("Setting FlatIntelliJ");
                UIManager.setLookAndFeel(FlatIntelliJLaf.class.getName());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
                System.out.println("ERROR: " + e.toString());
                e.printStackTrace();
            }
        }
        if (laf.equals("FlatDarcula")) {
            try {
                System.out.println("Setting FlatDarcula");
                UIManager.setLookAndFeel(FlatDarculaLaf.class.getName());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
                System.out.println("ERROR: " + e.toString());
                e.printStackTrace();
            }
        }
        SwingUtilities.updateComponentTreeUI(frame);
    }

    public static void main(String[] args) {
        UIManager.installLookAndFeel("Flat Light", FlatLightLaf.class.getName());
        UIManager.installLookAndFeel("Flat Dark", FlatDarkLaf.class.getName());
        UIManager.installLookAndFeel("Flat IntelliJ", FlatIntelliJLaf.class.getName());
        UIManager.installLookAndFeel("Flat Darcula", FlatDarculaLaf.class.getName());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                final JFrame frame = new JFrame();
                JPanel panel = new JPanel();
                JButton btnDemo = new JButton("JButton");
                JSpinner spnDemo = new JSpinner();
                JComboBox<String> cmbDemo = new JComboBox<String>();
                cmbDemo.addItem("One");
                cmbDemo.addItem("Two");
                cmbDemo.addItem("Three");
                JMenuBar mBar = new JMenuBar();
                frame.setJMenuBar(mBar);
                JMenu mnuLaf = new JMenu("Look and feel");
                mBar.add(mnuLaf);
                ButtonGroup btnGroup = new ButtonGroup();
                HashMap<String, JRadioButtonMenuItem> lafMap = new HashMap<String, JRadioButtonMenuItem>();
                for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                    JRadioButtonMenuItem mniLaf = new JRadioButtonMenuItem(info.getName());
                    lafMap.put(info.getName(), mniLaf);
                    btnGroup.add(mniLaf);
                    mnuLaf.add(mniLaf);
                    mniLaf.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            try {
                                String lafName = e.getActionCommand();
                                System.out.println("Setting LaF to " + lafName);
                                for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                                    if (!lafName.equals(info.getName())) continue;
                                    UIManager.setLookAndFeel(info.getClassName());
                                }
                            }
                            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
                                System.out.println("ERROR: " + ex.toString());
                                ex.printStackTrace();
                            }
                            SwingUtilities.updateComponentTreeUI(frame);
                        }
                    });
                }
                DefaultTableModel model = new DefaultTableModel(new Object[0][], new String[]{"First", "Second"});
                model.addRow(new Object[]{"Some text", "Another text"});
                JTable table = new JTable(model);
                panel.add(btnDemo);
                panel.add(spnDemo);
                panel.add(cmbDemo);
                frame.add((Component)panel, "North");
                frame.add((Component)new JScrollPane(table), "Center");
                frame.setDefaultCloseOperation(2);
                frame.pack();
                frame.setVisible(true);
            }
        });
    }
}

