/*
 * Decompiled with CFR 0.152.
 */
package moneyview;

import java.awt.EventQueue;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.charset.Charset;
import javax.swing.Timer;
import moneyview.Logger;
import moneyview.data.ACategory;
import moneyview.gui.GuiUtil;
import moneyview.gui.MainWindow;
import moneyview.gui.custom.Splash;
import moneyview.messages.Messages;
import moneyview.properties.HMProperties;

public class Launcher {
    private static final String TAG = Launcher.class.getSimpleName();

    public static void main(String[] args) {
        Logger.setLevel(3);
        Logger.warn(TAG, "Upon first launch of the application is it normal to have warnings about some (yet) missing files and values, which will be created");
        Logger.info(TAG, "file.encoding=" + System.getProperty("file.encoding"));
        Logger.info(TAG, "Charset=" + Charset.defaultCharset().name());
        try {
            Image image = GuiUtil.getImageIcon("splash.png").getImage();
            final Splash splash = new Splash(null, image);
            splash.setVisible(true);
            Timer timer = new Timer(3000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    splash.setVisible(false);
                    splash.dispose();
                }
            });
            timer.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!HMProperties.loadProperties()) {
            Logger.warn(TAG, "main: Unable to restore state from directory '" + HMProperties.getSaveLocation() + "'");
        }
        Messages.init();
        ACategory.cleanCategories();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    new MainWindow();
                    MainWindow.getFrame().setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

