/*
 * Decompiled with CFR 0.152.
 */
package moneyview.data;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.StringTokenizer;
import java.util.UUID;
import moneyview.Logger;
import moneyview.data.AItem;
import moneyview.data.AItemComparators;
import moneyview.data.Account;
import moneyview.data.Util;
import moneyview.io.IOUtil;
import moneyview.messages.Messages;
import moneyview.properties.HMProperties;
import moneyview.properties.Versions;

public class APlannedItem
extends AItem {
    private static final String TAG = APlannedItem.class.getSimpleName();
    public static List<APlannedItem> plannedItems = new ArrayList<APlannedItem>();
    private static boolean itemsSaved = true;
    String accountName = null;
    int periodicity;
    public static final String EXT_KEY_ACCOUNT_NAME = "accName";
    public static final String EXT_KEY_PERIODICITY = "periodicity";
    public static final String PLANNED_ITEMS_FILENAME = "plannedOp.hpmy";
    private static int graphDays = 90;
    static final String graphDaysFileEntry = "graphDays";
    public static final int PERIODICITY_DAY = 1;
    public static final int PERIODICITY_WEEK = 2;
    public static final int PERIODICITY_2xWEEKS = 3;
    public static final int PERIODICITY_MONTH = 4;
    public static final int PERIODICITY_2xMONTHS = 5;
    public static final int PERIODICITY_3xMONTHS = 6;
    public static final int PERIODICITY_HALF_YEAR = 7;
    public static final int PERIODICITY_YEAR = 8;
    public static final int PERIODICITY_2xYEARS = 9;

    public APlannedItem() {
    }

    public APlannedItem(APlannedItem copySrc, boolean copyCategory) {
        super(copySrc, copyCategory);
        this.periodicity = copySrc.periodicity;
        this.accountName = copySrc.accountName;
    }

    public static String getPeriodicityLabel(int periodicity) {
        switch (periodicity) {
            case 1: {
                return Messages.getString("plannedOperationPeriodicityDaily");
            }
            case 2: {
                return Messages.getString("plannedOperationPeriodicityWeekly");
            }
            case 3: {
                return Messages.getString("plannedOperationPeriodicityBiweekly");
            }
            case 4: {
                return Messages.getString("plannedOperationPeriodicityMonthly");
            }
            case 5: {
                return Messages.getString("plannedOperationPeriodicityBimonthly");
            }
            case 6: {
                return Messages.getString("plannedOperationPeriodicityThreeMonthly");
            }
            case 7: {
                return Messages.getString("plannedOperationPeriodicitySemester");
            }
            case 8: {
                return Messages.getString("plannedOperationPeriodicityAnnual");
            }
            case 9: {
                return Messages.getString("plannedOperationPeriodicityBiannual");
            }
        }
        return null;
    }

    public static int getPeriodicityFromLabel(String periodicityLabel) {
        if (periodicityLabel.equals(Messages.getString("plannedOperationPeriodicityDaily"))) {
            return 1;
        }
        if (periodicityLabel.equals(Messages.getString("plannedOperationPeriodicityWeekly"))) {
            return 2;
        }
        if (periodicityLabel.equals(Messages.getString("plannedOperationPeriodicityBiweekly"))) {
            return 3;
        }
        if (periodicityLabel.equals(Messages.getString("plannedOperationPeriodicityMonthly"))) {
            return 4;
        }
        if (periodicityLabel.equals(Messages.getString("plannedOperationPeriodicityBimonthly"))) {
            return 5;
        }
        if (periodicityLabel.equals(Messages.getString("plannedOperationPeriodicityThreeMonthly"))) {
            return 6;
        }
        if (periodicityLabel.equals(Messages.getString("plannedOperationPeriodicitySemester"))) {
            return 7;
        }
        if (periodicityLabel.equals(Messages.getString("plannedOperationPeriodicityAnnual"))) {
            return 8;
        }
        if (periodicityLabel.equals(Messages.getString("plannedOperationPeriodicityBiannual"))) {
            return 9;
        }
        return -1;
    }

    public static APlannedItem getItem(int index) {
        return plannedItems.get(index);
    }

    public static int getItemListSize() {
        return plannedItems.size();
    }

    public static boolean addItem(APlannedItem newAItem) {
        itemsSaved = false;
        return plannedItems.add(newAItem);
    }

    public static APlannedItem removeItem(int index) {
        APlannedItem l_api = plannedItems.remove(index);
        if (l_api != null) {
            itemsSaved = false;
        }
        return l_api;
    }

    public static boolean removeItem(APlannedItem item) {
        int l_index = plannedItems.indexOf(item);
        if (l_index < 0) {
            return false;
        }
        itemsSaved = false;
        return plannedItems.remove(item);
    }

    public static int indexOf(APlannedItem aItem) {
        return plannedItems.indexOf(aItem);
    }

    public static boolean isSaved() {
        if (!itemsSaved) {
            return itemsSaved;
        }
        for (APlannedItem l_api : plannedItems) {
            if (l_api.saved) continue;
            return l_api.saved;
        }
        return itemsSaved;
    }

    public static void sort(int sortType, boolean ascending) {
        Comparator<AItem> l_comp = AItemComparators.getComparator(sortType, ascending);
        Collections.sort(plannedItems, l_comp);
    }

    public static List<APlannedItem> getNextOccurrencesOnAccount(String accountName, long amount, Date date) {
        int maxAbsolutDelayInDays = 62;
        double maxPeriodsDelay = 0.75;
        double maxAmountRatio = 1.5;
        ArrayList<APlannedItem> l_res = new ArrayList<APlannedItem>();
        APlannedItem.sort(0, true);
        GregorianCalendar l_gc1ref = new GregorianCalendar();
        l_gc1ref.setTime(date);
        GregorianCalendar l_gc2ref = new GregorianCalendar();
        l_gc2ref.setTime(date);
        for (APlannedItem l_api : plannedItems) {
            if (!l_api.accountName.equals(accountName) || !((double)Math.abs(l_api.getLongAmount()) < Math.abs((double)amount * 1.5)) || !((double)Math.abs(l_api.getLongAmount()) > Math.abs((double)amount / 1.5))) continue;
            GregorianCalendar l_gc1 = new GregorianCalendar();
            l_gc1.setTime(l_gc1ref.getTime());
            GregorianCalendar l_gc2 = new GregorianCalendar();
            l_gc2.setTime(l_gc2ref.getTime());
            APlannedItem.addPeriods(l_gc1, -0.75, l_api.periodicity, 62);
            APlannedItem.addPeriods(l_gc2, 0.75, l_api.periodicity, 62);
            GregorianCalendar l_gcDate = new GregorianCalendar();
            l_gcDate.setTime(l_api.getDate());
            if (!l_gc1.before(l_gcDate) || !l_gc2.after(l_gcDate)) continue;
            l_res.add(l_api);
        }
        return l_res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveItems(boolean forceSave, String password) {
        if (!forceSave && APlannedItem.isSaved()) {
            return;
        }
        BufferedWriter l_bw = null;
        try {
            Logger.debug(TAG, "saveItems(forceSave=" + forceSave + ")");
            l_bw = IOUtil.getBufferedWriter(HMProperties.getSaveLocation() + File.separator + PLANNED_ITEMS_FILENAME, password);
            IOUtil.writeUtf8Header(l_bw, "Account data for planned items");
            l_bw.write("hmyVersion=2.4.0\n");
            l_bw.write("graphDays=" + graphDays + "\n");
            for (APlannedItem l_api : plannedItems) {
                l_api.save(l_bw);
            }
            itemsSaved = true;
        }
        catch (Exception e) {
            Logger.error(TAG, "saveItems() : " + e);
        }
        finally {
            try {
                if (l_bw != null) {
                    l_bw.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadItems(String password) {
        BufferedReader l_br = null;
        try {
            Logger.debug(TAG, "loadItems()");
            l_br = IOUtil.getBufferedReader(HMProperties.getSaveLocation() + File.separator + PLANNED_ITEMS_FILENAME, password);
            plannedItems = new ArrayList<APlannedItem>();
            String l_line = l_br.readLine();
            while (l_line.startsWith("#")) {
                l_line = l_br.readLine();
            }
            StringTokenizer l_st = new StringTokenizer(l_line, "=");
            String l_accountVersion = "1.2.0";
            String l_currentToken = l_st.nextToken();
            if (l_currentToken.equals("hmyVersion")) {
                l_accountVersion = l_st.nextToken();
                l_line = l_br.readLine();
                l_st = new StringTokenizer(l_line, "=");
                l_currentToken = l_st.nextToken();
            }
            if (Versions.versionsDiff("1.2.1", l_accountVersion) >= 0L) {
                Logger.info(TAG, "Handling pre 1.2.1 version for planned items : " + l_accountVersion);
            }
            if (l_currentToken.equals(graphDaysFileEntry)) {
                graphDays = Integer.parseInt(l_st.nextToken());
            }
            while (true) {
                try {
                    while ((l_line = l_br.readLine()) != null) {
                        APlannedItem l_api = new APlannedItem(l_line, l_br);
                        plannedItems.add(l_api);
                    }
                }
                catch (Exception e) {
                    Logger.error(TAG, "loadItems() : error on one planned item=" + e);
                    continue;
                }
                break;
            }
            APlannedItem.sort(0, true);
        }
        catch (FileNotFoundException e) {
            Logger.info(TAG, "loadItems() : No file for planned items");
        }
        catch (Exception e) {
            Logger.error(TAG, "loadItems() : " + e);
            e.printStackTrace(System.err);
        }
        finally {
            try {
                if (l_br != null) {
                    l_br.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public static long getPlannedDelta(String accountName, Date targetDate) {
        long l_res = 0L;
        for (APlannedItem l_api : plannedItems) {
            GregorianCalendar l_gc;
            if (l_api.accountName.equals(accountName)) {
                l_gc = new GregorianCalendar();
                l_gc.setTime(l_api.date);
                l_gc.set(11, 0);
                l_gc.set(12, 0);
                l_gc.set(13, 0);
                while (l_gc.getTime().compareTo(targetDate) <= 0) {
                    l_res += l_api.amount;
                    l_api.addPeriod(l_gc);
                }
            }
            if (l_api.category == null || !l_api.category.equals("[" + accountName + "]")) continue;
            l_gc = new GregorianCalendar();
            l_gc.setTime(l_api.date);
            l_gc.set(11, 0);
            l_gc.set(12, 0);
            l_gc.set(13, 0);
            while (l_gc.getTime().compareTo(targetDate) <= 0) {
                l_res -= l_api.amount;
                l_api.addPeriod(l_gc);
            }
        }
        return l_res;
    }

    public static void changeAccountNameOnPlannedItems(String oldAccountName, String newAccountName) {
        for (APlannedItem l_api : plannedItems) {
            if (l_api.accountName.equals(oldAccountName)) {
                l_api.accountName = newAccountName;
                l_api.saved = false;
            }
            if (l_api.category == null || !l_api.category.equals("[" + oldAccountName + "]")) continue;
            l_api.category = "[" + newAccountName + "]";
            l_api.saved = false;
        }
    }

    @Override
    public void save(BufferedWriter bw) throws Exception {
        this.setExtAttribute(EXT_KEY_ACCOUNT_NAME, this.accountName);
        this.setExtAttribute(EXT_KEY_PERIODICITY, "" + this.periodicity);
        super.save(bw);
    }

    public APlannedItem(String firstLine, BufferedReader br) throws Exception {
        super(firstLine, br, false);
        try {
            this.accountName = this.getExtAttribute(EXT_KEY_ACCOUNT_NAME);
            this.periodicity = Integer.parseInt(this.getExtAttribute(EXT_KEY_PERIODICITY));
        }
        catch (Exception e) {
            try {
                StringTokenizer l_st = new StringTokenizer(this.hmoneyExt, "|");
                if (l_st.hasMoreTokens()) {
                    this.accountName = l_st.nextToken();
                    if (l_st.hasMoreTokens()) {
                        this.periodicity = Integer.parseInt(l_st.nextToken());
                    }
                }
            }
            catch (Exception e2) {
                Logger.error(TAG, "APlannedItem constructor: EX2=" + e2 + " , hmoneyExt=" + this.hmoneyExt + " , UUID=" + this.uuid);
                throw e2;
            }
        }
    }

    public static APlannedItem getAPlannedItemByUuid(UUID uuid, APlannedItem notThis) {
        for (APlannedItem l_api : plannedItems) {
            if (!l_api.uuid.equals(uuid) || l_api.hashCode() == notThis.hashCode()) continue;
            return l_api;
        }
        return null;
    }

    public void setCategory(String categorySet) {
        if (categorySet != null && categorySet.equals(Messages.getString("NoCategory"))) {
            categorySet = null;
        }
        if (Util.compareString(this.category, categorySet) == 0) {
            return;
        }
        this.category = categorySet;
        this.saved = false;
        if (this.category.startsWith(Messages.getString("TransferOperationBaseCategory"))) {
            StringTokenizer l_st = new StringTokenizer(this.category, ":");
            l_st.nextToken();
            String l_transferAccountName = l_st.nextToken().trim();
            if (l_transferAccountName != null) {
                this.category = "[" + l_transferAccountName + "]";
            }
        }
    }

    public void ignoreNextOccurrence() {
        GregorianCalendar l_gc = new GregorianCalendar();
        l_gc.setTime(this.getDate());
        this.addPeriod(l_gc);
        this.setDate(l_gc.getTime());
        this.saved = false;
    }

    public void ignoreAllPassedOccurrences() {
        GregorianCalendar l_gc = new GregorianCalendar();
        l_gc.setTime(new Date());
        l_gc.set(11, 0);
        l_gc.set(12, 0);
        l_gc.set(13, 0);
        Date l_now = l_gc.getTime();
        l_gc.setTime(this.getDate());
        while (l_now.compareTo(this.getDate()) > 0) {
            this.addPeriod(l_gc);
            this.setDate(l_gc.getTime());
        }
        this.saved = false;
    }

    public void enterInTargetAccount() {
        Account l_ta = Account.getAccountByName(this.accountName);
        AItem l_ai = new AItem();
        l_ai.setDate(this.getDate());
        l_ai.setNum(this.getNum());
        l_ai.setLongAmount(this.getLongAmount());
        l_ai.setPayee(this.getPayee());
        l_ai.setCategory(this.getCategory(), l_ta);
        l_ai.setReconciliatedWithPlanned(true);
        l_ai.setMemo(this.getMemo());
        l_ai.setCleared(true);
        l_ta.addItem(l_ai);
    }

    @Override
    public String getAccountName() {
        return this.accountName;
    }

    @Override
    public void setAccountName(String accountName) {
        if (Util.compareString(this.accountName, accountName) == 0) {
            return;
        }
        this.accountName = accountName;
        this.saved = false;
    }

    public int getPeriodicity() {
        return this.periodicity;
    }

    public void setPeriodicity(int periodicity) {
        if (this.periodicity == periodicity) {
            return;
        }
        this.periodicity = periodicity;
        this.saved = false;
    }

    public static void addPeriods(GregorianCalendar gc, double periodCount, int periodicity, int maxAbsolutDelayInDays) {
        int l_sign = 1;
        if (periodCount < 0.0) {
            l_sign = -1;
        }
        periodCount = Math.abs(periodCount);
        switch (periodicity) {
            case 1: {
                gc.add(11, l_sign * Math.min((int)(25.0 * periodCount), 24 * maxAbsolutDelayInDays));
                break;
            }
            case 2: {
                gc.add(5, l_sign * Math.min((int)(8.0 * periodCount), maxAbsolutDelayInDays));
                break;
            }
            case 3: {
                gc.add(5, l_sign * Math.min((int)(15.0 * periodCount), maxAbsolutDelayInDays));
                break;
            }
            case 4: {
                gc.add(5, l_sign * Math.min((int)(31.0 * periodCount), maxAbsolutDelayInDays));
                break;
            }
            case 5: {
                gc.add(5, l_sign * Math.min((int)(62.0 * periodCount), maxAbsolutDelayInDays));
                break;
            }
            case 6: {
                gc.add(5, l_sign * Math.min((int)(92.0 * periodCount), maxAbsolutDelayInDays));
                break;
            }
            case 7: {
                gc.add(5, l_sign * Math.min((int)(183.0 * periodCount), maxAbsolutDelayInDays));
                break;
            }
            case 8: {
                gc.add(5, l_sign * Math.min((int)(366.0 * periodCount), maxAbsolutDelayInDays));
                break;
            }
            case 9: {
                gc.add(5, l_sign * Math.min((int)(731.0 * periodCount), maxAbsolutDelayInDays));
            }
        }
    }

    public void addPeriod(GregorianCalendar gc) {
        switch (this.periodicity) {
            case 1: {
                gc.add(5, 1);
                break;
            }
            case 2: {
                gc.add(3, 1);
                break;
            }
            case 3: {
                gc.add(3, 2);
                break;
            }
            case 4: {
                gc.add(2, 1);
                break;
            }
            case 5: {
                gc.add(2, 2);
                break;
            }
            case 6: {
                gc.add(2, 3);
                break;
            }
            case 7: {
                gc.add(2, 6);
                break;
            }
            case 8: {
                gc.add(1, 1);
                break;
            }
            case 9: {
                gc.add(1, 2);
            }
        }
    }

    public int getAtDateLatenessInDays(Date targetDate) {
        GregorianCalendar l_gc = new GregorianCalendar();
        l_gc.setTime(targetDate);
        l_gc.set(11, 0);
        l_gc.set(12, 0);
        l_gc.set(13, 0);
        Date l_td = l_gc.getTime();
        l_gc.setTime(this.date);
        l_gc.set(11, 0);
        l_gc.set(12, 0);
        l_gc.set(13, 0);
        Date l_d = l_gc.getTime();
        int l_res = (int)((l_td.getTime() - l_d.getTime()) / 86400000L);
        return l_res;
    }

    public int getLateOccurrencesCountAtDate(Date targetDate) {
        int l_res = 0;
        GregorianCalendar l_gc = new GregorianCalendar();
        l_gc.setTime(targetDate);
        l_gc.set(11, 0);
        l_gc.set(12, 0);
        l_gc.set(13, 0);
        Date l_td = l_gc.getTime();
        l_gc.setTime(this.date);
        l_gc.set(11, 0);
        l_gc.set(12, 0);
        l_gc.set(13, 0);
        l_gc.add(5, 1);
        while (l_gc.getTime().compareTo(l_td) < 0) {
            ++l_res;
            this.addPeriod(l_gc);
        }
        return l_res;
    }

    public static int getGraphDays() {
        return graphDays;
    }

    public static void setGraphDays(int graphDays) {
        if (APlannedItem.graphDays == graphDays) {
            return;
        }
        itemsSaved = false;
        APlannedItem.graphDays = graphDays;
    }

    public static boolean checkIfCategoryIsReferenced(String category) {
        for (APlannedItem l_api : plannedItems) {
            if (l_api.getCategory() == null || !l_api.getCategory().equals(category)) continue;
            return true;
        }
        return false;
    }

    public static void changeCategoryOnPlannedItems(String oldCategory, String newCategory) {
        for (APlannedItem l_api : plannedItems) {
            if (l_api.getCategory() == null || Util.compareString(l_api.getCategory(), oldCategory) != 0) continue;
            l_api.setCategory(newCategory);
        }
    }
}

