/*
 * Decompiled with CFR 0.152.
 */
package moneyview.data;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import moneyview.Logger;
import moneyview.data.ACategory;
import moneyview.data.AItem;
import moneyview.data.Util;

public class OfxImport {
    private static final String TAG = OfxImport.class.getSimpleName();
    private static final String OFX_BANK_ID_TAG = "<BANKID>";
    private static final String OFX_ACCOUNT_ID_TAG = "<ACCTID>";
    private static final String OFX_BEGIN_STMTTRN_ID_TAG = "<STMTTRN>";
    private static final String OFX_TRNTYPE_ID_TAG = "<TRNTYPE>";
    private static final String OFX_DTPOSTED_ID_TAG = "<DTPOSTED>";
    private static final String OFX_TRNAMT_ID_TAG = "<TRNAMT>";
    private static final String OFX_NAME_ID_TAG = "<NAME>";
    private static final String OFX_MEMO_ID_TAG = "<MEMO>";
    private static final String OFX_CHECKNUM_ID_TAG = "<CHECKNUM>";
    private static final String OFX_REFNUM_ID_TAG = "<REFNUM>";
    private static final String OFX_END_OF_STMTTRN_ID_TAG = "</STMTTRN>";
    public String bankId = null;
    public String accountId = null;
    private List<AItem> ofxItemList = new ArrayList<AItem>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AItem> loadFile(String fileName) throws Exception {
        BufferedReader l_br = null;
        try {
            String l_line;
            Logger.info(TAG, "loadFile(" + fileName + ")");
            l_br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "ISO-8859-1"));
            while ((l_line = l_br.readLine()) != null) {
                if ((l_line = l_line.trim()).startsWith(OFX_BANK_ID_TAG)) {
                    this.bankId = this.removeXmlTags(OFX_BANK_ID_TAG, l_line);
                }
                if (l_line.startsWith(OFX_ACCOUNT_ID_TAG)) {
                    this.accountId = this.removeXmlTags(OFX_ACCOUNT_ID_TAG, l_line);
                }
                if (!l_line.startsWith(OFX_BEGIN_STMTTRN_ID_TAG)) continue;
                AItem l_ai = this.readOfxItem(l_br);
                if (l_ai == null) {
                    break;
                }
                if (l_ai.getDate() == null) {
                    l_ai.setDate(new Date());
                }
                l_ai.setEImport(true);
                l_ai.setUserValidated(false, null);
                this.ofxItemList.add(l_ai);
            }
        }
        finally {
            if (l_br != null) {
                l_br.close();
            }
            ACategory.sort();
        }
        return this.ofxItemList;
    }

    private String removeXmlTags(String xmlTag, String parsedString) {
        String l_value = parsedString.substring(xmlTag.length());
        int l_tagEndIndex = l_value.indexOf("</");
        if (l_tagEndIndex > -1) {
            l_value = l_value.substring(0, l_tagEndIndex);
        }
        return l_value;
    }

    private AItem readOfxItem(BufferedReader br) throws Exception {
        AItem l_aItem = new AItem();
        while (true) {
            String l_line;
            if ((l_line = br.readLine()) != null) {
                l_line = l_line.trim();
            }
            if (l_line == null || l_line.startsWith(OFX_END_OF_STMTTRN_ID_TAG)) break;
            if (l_line.startsWith(OFX_DTPOSTED_ID_TAG)) {
                l_aItem.setDate(Util.parseOfxDate(this.removeXmlTags(OFX_DTPOSTED_ID_TAG, l_line)));
            } else if (l_line.startsWith(OFX_TRNAMT_ID_TAG)) {
                l_aItem.setLongAmount(Util.ofxParseAmount(this.removeXmlTags(OFX_TRNAMT_ID_TAG, l_line)));
            } else if (l_line.startsWith(OFX_MEMO_ID_TAG)) {
                l_aItem.setMemo(this.removeXmlTags(OFX_MEMO_ID_TAG, l_line));
            } else if (l_line.startsWith(OFX_CHECKNUM_ID_TAG)) {
                l_aItem.setNum(this.removeXmlTags(OFX_CHECKNUM_ID_TAG, l_line));
            } else if (l_line.startsWith(OFX_REFNUM_ID_TAG)) {
                if (l_aItem.getNum() == null || l_aItem.getNum().length() < 1) {
                    l_aItem.setNum(this.removeXmlTags(OFX_REFNUM_ID_TAG, l_line));
                }
            } else if (l_line.startsWith(OFX_NAME_ID_TAG)) {
                l_aItem.setPayee(this.removeXmlTags(OFX_NAME_ID_TAG, l_line));
            }
            if (!l_line.startsWith(OFX_TRNTYPE_ID_TAG)) continue;
        }
        return l_aItem;
    }
}

