/*
 * Decompiled with CFR 0.152.
 */
package moneyview.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.Collator;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import moneyview.Logger;
import moneyview.data.AItem;
import moneyview.data.APlannedItem;
import moneyview.data.Account;
import moneyview.data.AccountFuturBalance;
import moneyview.data.AccountsFuturData;
import moneyview.data.DayAndMonthInvertedException;
import moneyview.data.DayBalance;
import moneyview.gui.MainWindow;
import moneyview.io.IOUtil;
import moneyview.messages.Messages;
import moneyview.properties.HMProperties;

public class Util {
    private static final String TAG = Util.class.getSimpleName();
    public static final BigDecimal x100 = new BigDecimal(100);
    public static final SimpleDateFormat ofxDateFormat = new SimpleDateFormat("yyyyMMdd");
    public static final SimpleDateFormat ofxDateFormatWithHourMinSec = new SimpleDateFormat("yyyyMMddHHmmss");
    public static SimpleDateFormat hmyDateFormat = new SimpleDateFormat("yyyyMMdd");
    private static SimpleDateFormat shortDateFormat;
    private static String dateUserInputTemplate;
    public static final int MATCH_MIN_SCORE = 6;
    public static final int MATCH_STRING_MIN_LEN = 2;

    public static long parseAmount(String total) throws Exception {
        long l_total = 0L;
        String total2 = total;
        while (total2.indexOf(",") != total2.lastIndexOf(",")) {
            total2.replaceFirst(",", "");
        }
        String l_s2total = total2.replace(",", ".").replace(" ", "");
        l_total = x100.multiply(new BigDecimal(l_s2total)).longValue();
        return l_total;
    }

    public static long qifParseAmount(String total) throws Exception {
        long l_total = 0L;
        String l_s2total = total.replace(",", "").replace(" ", "");
        l_total = x100.multiply(new BigDecimal(l_s2total)).longValue();
        return l_total;
    }

    public static long ofxParseAmount(String total) throws Exception {
        long l_total = 0L;
        String l_s2total = total.replace(",", "").replace(".", "").replace(" ", "");
        l_total = new BigDecimal(l_s2total).longValue();
        return l_total;
    }

    public static String getUserFriendlyCategoryString(String category) {
        if (category != null) {
            if (category.startsWith("[")) {
                return Messages.getString("TransferOperationBaseCategory") + " : " + category.substring(1, category.length() - 1).trim();
            }
            if (category.equals(Messages.getString("NoCategory"))) {
                return "";
            }
        }
        return category;
    }

    public static boolean isValidCategory(String category) {
        if (category == null) {
            return false;
        }
        if (category.trim().length() < 1) {
            return false;
        }
        return !category.equals(Messages.getString("NoCategory"));
    }

    public static String longAmountToString(long amount) {
        boolean l_neg = false;
        if (amount < 0L) {
            l_neg = true;
        }
        String l_sa = "" + amount;
        if (l_neg) {
            l_sa = l_sa.substring(1);
        }
        int l_sal = l_sa.length();
        String l_res = null;
        switch (l_sal) {
            case 2: {
                l_res = "0." + l_sa;
                break;
            }
            case 1: {
                l_res = "0.0" + l_sa;
                break;
            }
            default: {
                l_res = l_sa.substring(0, l_sal - 2) + "." + l_sa.substring(l_sal - 2);
            }
        }
        for (int i = 6; i < l_res.length(); ++i) {
            if (i != 6 && (i - 6) % 4 != 0) continue;
            l_res = l_res.substring(0, l_res.length() - i) + " " + l_res.substring(l_res.length() - i);
        }
        if (l_neg) {
            l_res = "-" + l_res;
        }
        return l_res;
    }

    public static long stringAmountToLong(String amount) throws Exception {
        amount = amount.trim().replace(",", "").replace(" ", "");
        BigDecimal l_bd = BigDecimal.valueOf(Double.parseDouble(amount));
        return x100.multiply(l_bd).longValue();
    }

    public static int compareStringIgnoreCase(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return 0;
        }
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        return Util.getCollator().compare(s1.toLowerCase(), s2.toLowerCase());
    }

    public static int compareString(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return 0;
        }
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        return Util.getCollator().compare(s1, s2);
    }

    public static Date parseOfxDate(String dateString) throws Exception {
        if (dateString.length() == 14) {
            try {
                return ofxDateFormatWithHourMinSec.parse(dateString);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            return ofxDateFormat.parse(dateString);
        }
        catch (Exception exception) {
            return new Date();
        }
    }

    public static Date parseDate(String dateString, boolean dateDayFirst) throws Exception {
        StringTokenizer l_st = new StringTokenizer(dateString, "/'");
        String l_sd1 = l_st.nextToken().trim();
        String l_sd2 = l_st.nextToken().trim();
        String l_sd3 = l_st.nextToken().trim();
        int l_d1 = Integer.parseInt(l_sd1);
        int l_d2 = Integer.parseInt(l_sd2);
        if (dateDayFirst) {
            if (l_d2 > 12) {
                throw new DayAndMonthInvertedException("Date is in US format");
            }
            if (l_d1 > 31) {
                throw new Exception("Invalid date");
            }
        } else {
            if (l_d1 > 12) {
                throw new DayAndMonthInvertedException("Date is in french format");
            }
            if (l_d2 > 31) {
                throw new Exception("Invalid date");
            }
        }
        int l_d3 = 0;
        GregorianCalendar l_gcNow = new GregorianCalendar();
        if (l_sd3.length() == 2) {
            l_d3 = Integer.parseInt(l_sd3);
            l_d3 += l_gcNow.get(1) / 100 * 100;
        } else if (l_sd3.length() == 3) {
            l_d3 = Integer.parseInt(l_sd3);
            l_d3 += l_gcNow.get(1) / 1000 * 1000;
        } else if (l_sd3.length() == 4) {
            l_d3 = Integer.parseInt(l_sd3);
        } else {
            throw new Exception("Year is not correctly formated in date : " + l_sd3);
        }
        GregorianCalendar l_gc = null;
        l_gc = dateDayFirst ? new GregorianCalendar(l_d3, l_d2 - 1, l_d1) : new GregorianCalendar(l_d3, l_d1 - 1, l_d2);
        return l_gc.getTime();
    }

    public static boolean getDateDayFirst() {
        return Boolean.parseBoolean(HMProperties.getStringProperty("date.day_first"));
    }

    public static SimpleDateFormat getSimpleDateFormatter() {
        if (shortDateFormat == null) {
            shortDateFormat = new SimpleDateFormat(Messages.getString("shortDateFormatterTemplate"));
        }
        return shortDateFormat;
    }

    public static String getDateUserInputTemplate() {
        if (dateUserInputTemplate == null) {
            dateUserInputTemplate = Messages.getString("dateUserInputTemplate");
        }
        return dateUserInputTemplate;
    }

    public static void saveAll(boolean forceSave) {
        if (IOUtil.notUtf8FileFound) {
            forceSave = true;
        }
        for (Account l_a : Account.openAccounts) {
            try {
                if (l_a.isSaved() && !forceSave) continue;
                l_a.save(MainWindow.encryptionPassword);
            }
            catch (Exception e) {
                Logger.error(TAG, "saveAll: " + e.toString());
                e.printStackTrace();
            }
        }
        APlannedItem.saveItems(forceSave, MainWindow.encryptionPassword);
        HMProperties.storeProperties();
    }

    public static Collator getCollator() {
        return Collator.getInstance();
    }

    public static boolean safeEquals(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        return o1 != null && o2 != null && o1.equals(o2);
    }

    public static Locale getLocaleFromString(String sLocale) {
        StringTokenizer l_st = new StringTokenizer(sLocale, "_");
        String l_lang = l_st.nextToken();
        String l_country = l_st.nextToken();
        return new Locale(l_lang, l_country);
    }

    public static Locale getDefaultLocale() {
        return Locale.getDefault();
    }

    public static String stringNotNull(String in) {
        if (in == null) {
            return "";
        }
        return in;
    }

    private static int amountWeighting(String match, double targetAmount, double acItemAmount) throws Exception {
        double d = Math.abs(acItemAmount - targetAmount);
        double M = Math.max(Math.abs(acItemAmount), Math.abs(targetAmount));
        double c = 1.0;
        if (M + d != 0.0) {
            c = M / (M + d);
        }
        int l_qualityMatch = 0;
        for (int i = 0; i < match.length(); ++i) {
            if (match.charAt(i) > '0' && match.charAt(i) < '9' || match.charAt(i) == 'X') {
                ++l_qualityMatch;
                continue;
            }
            l_qualityMatch += 5;
        }
        double l_addScore = (double)match.length() + (double)match.length() * c * 10.0;
        Logger.verbose(TAG, "matchLength= " + match.length() + " ,  weighted addScore= " + (l_addScore *= (double)l_qualityMatch));
        return (int)Math.round(l_addScore);
    }

    public static double similarity(String s1, String s2) {
        int longerLength;
        String longer = s1;
        String shorter = s2;
        if (s1.length() < s2.length()) {
            longer = s2;
            shorter = s1;
        }
        if ((longerLength = longer.length()) == 0) {
            return 1.0;
        }
        return (double)(longerLength - Util.editDistance(longer, shorter)) / (double)longerLength;
    }

    public static int editDistance(String s1, String s2) {
        s1 = s1.toLowerCase();
        s2 = s2.toLowerCase();
        int[] costs = new int[s2.length() + 1];
        for (int i = 0; i <= s1.length(); ++i) {
            int lastValue = i;
            for (int j = 0; j <= s2.length(); ++j) {
                if (i == 0) {
                    costs[j] = j;
                    continue;
                }
                if (j <= 0) continue;
                int newValue = costs[j - 1];
                if (s1.charAt(i - 1) != s2.charAt(j - 1)) {
                    newValue = Math.min(Math.min(newValue, lastValue), costs[j]) + 1;
                }
                costs[j - 1] = lastValue;
                lastValue = newValue;
            }
            if (i <= 0) continue;
            costs[s2.length()] = lastValue;
        }
        return costs[s2.length()];
    }

    public static int getAItemMatchForCategory(AItem target, Account account) {
        String sTargetPayee = target.getPayee();
        String sTargetMemo = target.getMemo();
        HashMap<Integer, Integer> l_matchMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < account.getItemListSize(); ++i) {
            int l_s;
            AItem l_acItem = account.getItem(i);
            if (l_acItem.getNewlyImported() && !l_acItem.isUserValidated() && !l_acItem.wasCategoryOnceSet() || l_acItem.equals(target) || l_acItem == target) continue;
            if (sTargetPayee != null && sTargetPayee.length() >= 2 && l_acItem.getPayee() != null && l_acItem.getPayee().length() >= 2) {
                double l_similarityP = Util.similarity(sTargetPayee, l_acItem.getPayee());
                if (l_matchMap.get(i) == null) {
                    l_matchMap.put(i, 0);
                }
                l_s = (Integer)l_matchMap.get(i);
                l_matchMap.put(i, l_s + (int)(l_similarityP * 1000000.0));
            }
            if (sTargetMemo == null || sTargetMemo.length() < 2 || l_acItem.getMemo() == null || l_acItem.getMemo().length() < 2) continue;
            double l_similarityM = Util.similarity(sTargetMemo, l_acItem.getMemo());
            if (l_matchMap.get(i) == null) {
                l_matchMap.put(i, 0);
            }
            l_s = (Integer)l_matchMap.get(i);
            l_matchMap.put(i, l_s + (int)(l_similarityM * 500000.0));
        }
        int l_key = -1;
        int l_value = 6;
        for (Integer l_i : l_matchMap.keySet()) {
            if (l_value > (Integer)l_matchMap.get(l_i)) continue;
            l_key = l_i;
            l_value = (Integer)l_matchMap.get(l_i);
        }
        return l_key;
    }

    public static List<DayBalance> getDailyBalance(Account account, Date startDate, Date endDate) {
        ArrayList<DayBalance> l_res;
        block2: {
            l_res = new ArrayList<DayBalance>();
            List<AItem> l_sortedAndBalancedCopyAItem = account.calculateBalance();
            Calendar l_cal = Calendar.getInstance();
            l_cal.setTime(startDate);
            long l_dayBalance = 0L;
            int l_index = 0;
            int l_maxIndex = l_sortedAndBalancedCopyAItem.size() - 1;
            AItem l_ai = l_sortedAndBalancedCopyAItem.get(l_index);
            l_dayBalance = l_ai.balance;
            if (l_maxIndex < 0) break block2;
            do {
                if (l_ai.date.getTime() <= l_cal.getTimeInMillis()) {
                    l_dayBalance = l_ai.balance;
                    l_index = Math.min(l_index + 1, l_maxIndex);
                    l_ai = l_sortedAndBalancedCopyAItem.get(l_index);
                }
                if (l_ai.date.getTime() <= l_cal.getTimeInMillis() && l_index < l_maxIndex) continue;
                DayBalance l_db = new DayBalance();
                l_db.date = l_cal.getTime();
                l_db.balance = l_dayBalance;
                l_res.add(l_db);
                l_cal.add(5, 1);
            } while (l_cal.getTimeInMillis() <= endDate.getTime());
        }
        return l_res;
    }

    public static AccountsFuturData getAccountFuturBalances(String[] accountNames, int days) {
        return Util.getAccountFuturBalances(accountNames, days, false);
    }

    public static AccountsFuturData getAccountFuturBalances(String[] accountNames, int days, boolean skipPresentDay) {
        AccountsFuturData l_res = new AccountsFuturData();
        for (String l_accountName : accountNames) {
            GregorianCalendar l_gc = new GregorianCalendar();
            l_gc.setTimeInMillis(System.currentTimeMillis() + (long)(skipPresentDay ? 86400000 : 0));
            l_gc.set(11, 0);
            l_gc.set(12, 0);
            l_gc.set(13, 0);
            Account l_a = Account.getAccountByName(l_accountName);
            if (l_a == null) continue;
            List<AItem> l_sortedAndBalancedCopyAItem = l_a.calculateBalance();
            long l_ab = 0L;
            if (l_sortedAndBalancedCopyAItem.size() > 0) {
                l_ab = l_sortedAndBalancedCopyAItem.get((int)(l_sortedAndBalancedCopyAItem.size() - 1)).balance;
            }
            AccountFuturBalance l_afb = new AccountFuturBalance(l_a.accountName);
            for (int i = 0; i < days; ++i) {
                long l_plannedOperationsDelta = APlannedItem.getPlannedDelta(l_a.accountName, l_gc.getTime());
                l_afb.add(l_gc.getTime(), l_ab + l_plannedOperationsDelta);
                l_res.setMinMax(l_ab + l_plannedOperationsDelta);
                l_gc.add(5, 1);
            }
            l_res.accountFuturBalances.add(l_afb);
        }
        return l_res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File source, File dest) throws Exception {
        FileInputStream is = null;
        OutputStream os = null;
        try {
            int length;
            is = new FileInputStream(source);
            os = new FileOutputStream(dest);
            byte[] buffer = new byte[4096];
            while ((length = ((InputStream)is).read(buffer)) > 0) {
                os.write(buffer, 0, length);
            }
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    public static <K extends Comparable, V extends Comparable> Map<K, V> sortByValues(Map<K, V> map, final boolean reverse) {
        LinkedList<Map.Entry<K, V>> entries = new LinkedList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(entries, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                if (reverse) {
                    return ((Comparable)o2.getValue()).compareTo(o1.getValue());
                }
                return ((Comparable)o1.getValue()).compareTo(o2.getValue());
            }
        });
        LinkedHashMap sortedMap = new LinkedHashMap();
        for (Map.Entry entry : entries) {
            sortedMap.put(entry.getKey(), entry.getValue());
        }
        return sortedMap;
    }

    public static <K extends Comparable, V extends Comparable> Map<K, V> sortByKeys(Map<K, V> map, boolean reverse) {
        LinkedList<K> keys = new LinkedList<K>(map.keySet());
        Comparator l_cmp = Collections.reverseOrder();
        Collections.sort(keys, l_cmp);
        LinkedHashMap<Comparable, V> sortedMap = new LinkedHashMap<Comparable, V>();
        for (Comparable key : keys) {
            sortedMap.put(key, map.get(key));
        }
        return sortedMap;
    }
}

