/*
 * Decompiled with CFR 0.152.
 */
package moneyview.gui;

import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Date;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import moneyview.Logger;
import moneyview.data.AItem;
import moneyview.data.Account;
import moneyview.data.Util;
import moneyview.gui.AItemTableSelectionListener;
import moneyview.gui.DisplayedAccount;
import moneyview.gui.GuiUtil;
import moneyview.gui.IKeyboardListener;
import moneyview.gui.MainWindow;
import moneyview.messages.Messages;

public class AItemTable
extends JTable
implements ComponentListener,
IKeyboardListener {
    private static final String TAG = AItemTable.class.getSimpleName();
    private static final long serialVersionUID = 1969L;
    private static AbstractTableModel tableModel = null;
    public static final int COLUMN_INDEX_NUM = 0;
    public static final int COLUMN_INDEX_CR = 1;
    public static final int COLUMN_INDEX_DATE = 2;
    public static final int COLUMN_INDEX_CATEGORY = 3;
    public static final int COLUMN_INDEX_PAYEE = 4;
    public static final int COLUMN_INDEX_MEMO = 5;
    public static final int COLUMN_INDEX_AMOUNT = 6;
    public static final int COLUMN_INDEX_BALANCE = 7;
    public static final int ROW_HEIGHT = 24;
    public static final int NOT_APPROVED_ROW_HEIGHT = 80;
    public static final int DUP_ROW_HEIGHT = 140;
    int lastRow = -1;
    int lastColumn = -1;
    static String[] columnNames = new String[8];
    boolean[] columnSortOrder = new boolean[]{true, true, true, true, true, true, true, true};
    int[] columnWidth = new int[]{5, 2, 7, 18, 34, 18, 8, 8};
    int selectedColumn = 2;

    public AItemTable() {
        this.setRowHeight(24);
    }

    @Override
    public void escapeKeyTyped() {
        if (this.isEditing()) {
            this.getCellEditor().cancelCellEditing();
        }
    }

    @Override
    public void enterKeyTyped() {
        if (this.isEditing()) {
            this.getCellEditor().stopCellEditing();
        }
    }

    @Override
    public void deleteKeyTyped() {
        int l_row = MainWindow.aItemTable.getSelectedRow();
        if (l_row < 0 || this.isEditing()) {
            return;
        }
        this.removeRow(l_row, true);
    }

    public boolean removeRow(int row, boolean confirmRemove) {
        if (confirmRemove) {
            if (!AItemTableSelectionListener.lessThanTwoCellsSelected()) {
                return false;
            }
            int l_res = JOptionPane.showConfirmDialog(null, Messages.getString("AItemTable.0"), "", 2);
            if (l_res != 0) {
                return false;
            }
        }
        DisplayedAccount.getDisplayedAccount().removeItem(row);
        DisplayedAccount.getDisplayedAccount().calculateBalance();
        MainWindow.aItemTable.getTableModel().fireTableRowsDeleted(row, row);
        MainWindow.itemsMainPanel.updateGraph(null);
        this.lastRow = -1;
        this.lastColumn = -1;
        return true;
    }

    public AbstractTableModel getTableModel() {
        return tableModel;
    }

    public void resetColumnSortOrder() {
        for (int i = 0; i < this.columnSortOrder.length; ++i) {
            this.columnSortOrder[i] = true;
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        boolean l_res = false;
        switch (col) {
            case 4: {
                if (!DisplayedAccount.getDisplayedAccount().getItem(row).isUserValidated() || DisplayedAccount.getDisplayedAccount().getItem(row).getDup() != null) {
                    l_res = true;
                    break;
                }
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                if (this.lastRow == row && this.lastColumn == col) {
                    l_res = true;
                    break;
                }
            }
            default: {
                l_res = false;
            }
        }
        this.lastRow = row;
        this.lastColumn = col;
        Logger.verbose(TAG, "isCellEditable: returns " + l_res);
        return l_res;
    }

    @Override
    public void setModel(TableModel tableModel) {
        super.setModel(tableModel);
        this.lastRow = -1;
        this.lastColumn = -1;
    }

    public AbstractTableModel getNewCustomTableModel() {
        tableModel = new AbstractTableModel(){

            @Override
            public Object getValueAt(int row, int col) {
                AItem l_rowAItem = DisplayedAccount.getDisplayedAccount().getItem(row);
                switch (col) {
                    case 0: {
                        return l_rowAItem.getNum();
                    }
                    case 1: {
                        if (l_rowAItem.isReconciled()) {
                            return Messages.getString("OperationReconciledValue");
                        }
                        if (l_rowAItem.isCleared()) {
                            return Messages.getString("OperationClearedValue");
                        }
                        if (l_rowAItem.isLitigious()) {
                            return Messages.getString("OperationLitigiousValue");
                        }
                        return "";
                    }
                    case 2: {
                        return Util.getSimpleDateFormatter().format(l_rowAItem.getDate());
                    }
                    case 3: {
                        return Util.getUserFriendlyCategoryString(l_rowAItem.getCategory());
                    }
                    case 4: {
                        return l_rowAItem.getPayee();
                    }
                    case 5: {
                        return l_rowAItem.getMemo();
                    }
                    case 6: {
                        return l_rowAItem.getAmountString();
                    }
                    case 7: {
                        if (!DisplayedAccount.getDisplayedAccount().balanceEnabled) {
                            return "N/A";
                        }
                        return l_rowAItem.getBalanceString();
                    }
                }
                return "";
            }

            @Override
            public int getRowCount() {
                if (DisplayedAccount.getDisplayedAccount() == null) {
                    return 0;
                }
                return DisplayedAccount.getDisplayedAccount().getItemListSize();
            }

            @Override
            public int getColumnCount() {
                return columnNames.length;
            }

            @Override
            public String getColumnName(int col) {
                return columnNames[col];
            }

            public Class getColumnClass(int col) {
                return String.class;
            }

            @Override
            public void setValueAt(Object value, int row, int col) {
                Logger.verbose(TAG, "TableModel.setValueAt: row=" + row + ", col=" + col + ", value=" + value);
                boolean l_updateViewPort = true;
                String l_oldValue = (String)this.getValueAt(row, col);
                if (Util.safeEquals(l_oldValue, value)) {
                    Logger.verbose(TAG, "TableModel.setValueAt: row=" + row + ", col=" + col + ", value=" + value + " - No changes - skipping");
                    return;
                }
                AItem l_rowAItem = DisplayedAccount.getDisplayedAccount().getItem(row);
                switch (col) {
                    case 0: {
                        DisplayedAccount.getDisplayedAccount().getItem(row).setNum((String)value);
                        break;
                    }
                    case 1: {
                        if (value == null) {
                            l_rowAItem.setCleared(false);
                            l_rowAItem.setReconciled(false);
                            l_rowAItem.setLitigious(false);
                            break;
                        }
                        if (value.equals(Messages.getString("OperationClearedValue"))) {
                            l_rowAItem.setCleared(true);
                            l_rowAItem.setReconciled(false);
                            l_rowAItem.setLitigious(false);
                            break;
                        }
                        if (value == Messages.getString("OperationReconciledValue")) {
                            l_rowAItem.setCleared(false);
                            l_rowAItem.setReconciled(true);
                            l_rowAItem.setLitigious(false);
                            break;
                        }
                        if (value != Messages.getString("OperationLitigiousValue")) break;
                        l_rowAItem.setCleared(false);
                        l_rowAItem.setReconciled(false);
                        l_rowAItem.setLitigious(true);
                        break;
                    }
                    case 2: {
                        try {
                            Date l_nd = Util.parseDate((String)value, Util.getDateDayFirst());
                            l_rowAItem.setDate(l_nd);
                        }
                        catch (Exception l_nd) {}
                        break;
                    }
                    case 3: {
                        l_rowAItem.setCategory((String)value, DisplayedAccount.getDisplayedAccount());
                        l_rowAItem.setCategoryOnceSet(true);
                        if (DisplayedAccount.getDisplayedAccount().guessCategoryForImportedItems() <= 0) break;
                        break;
                    }
                    case 4: {
                        l_rowAItem.setPayee((String)value);
                        break;
                    }
                    case 5: {
                        l_rowAItem.setMemo((String)value);
                        break;
                    }
                    case 6: {
                        try {
                            long l_amount = Util.stringAmountToLong((String)value);
                            l_rowAItem.setLongAmount(l_amount);
                            DisplayedAccount.getDisplayedAccount().calculateBalance();
                            break;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                this.fireTableRowsUpdated(row, row);
                if (l_updateViewPort) {
                    AItemTable.this.updateViewPort(l_rowAItem, col);
                }
                MainWindow.itemsMainPanel.updateGraph(null);
            }
        };
        return tableModel;
    }

    public void updateViewPort(AItem aItem, int col) {
        this.lastRow = this.getSelectedRow();
        this.lastColumn = this.getSelectedColumn();
        if (col == this.selectedColumn || col == 6) {
            this.clickOnColumnHeader(this.selectedColumn, DisplayedAccount.getDisplayedAccount(), false);
        }
        int l_rowSel = DisplayedAccount.getDisplayedAccount().indexOf(aItem);
        GuiUtil.showTableElementInViewPort(this, l_rowSel, col);
    }

    public int getAItemComparatorSortTypeForColumn(int column) {
        switch (column) {
            case 0: {
                return 4;
            }
            case 1: {
                return 7;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 6;
            }
            case 6: {
                return 3;
            }
            case 7: {
                return 5;
            }
        }
        return 0;
    }

    public void updateWithLastSort() {
        this.clickOnColumnHeader(this.selectedColumn, DisplayedAccount.getDisplayedAccount(), false);
    }

    public void clickOnColumnHeader(int col, Account account, boolean invertOrder) {
        Logger.verbose(TAG, "clickOnColumnHeader: col=" + col);
        if (invertOrder && this.selectedColumn == col) {
            this.columnSortOrder[this.selectedColumn] = !this.columnSortOrder[this.selectedColumn];
        }
        this.selectedColumn = col;
        account.calculateBalance();
        int l_sortType = this.getAItemComparatorSortTypeForColumn(this.selectedColumn);
        account.sort(l_sortType, this.columnSortOrder[this.selectedColumn]);
        JTableHeader th = this.getTableHeader();
        TableColumnModel tcm = th.getColumnModel();
        for (int i = 0; i < columnNames.length; ++i) {
            TableColumn tc = tcm.getColumn(i);
            if (this.selectedColumn == i) {
                tc.setHeaderValue("<html>" + columnNames[i] + (this.columnSortOrder[this.selectedColumn] ? " &#9660;" : " &#9650;") + "</html>");
                continue;
            }
            tc.setHeaderValue(columnNames[i]);
        }
        th.repaint();
        this.getTableModel().fireTableDataChanged();
    }

    public void setColWidth(int availableWidth) {
        TableColumn column = null;
        for (int i = 0; i < columnNames.length; ++i) {
            column = this.getColumnModel().getColumn(i);
            column.setPreferredWidth(availableWidth * this.columnWidth[i] / 100);
        }
        MainWindow.adjustColumnWidth();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        super.tableChanged(e);
        if (e.getFirstRow() == -1 || e.getLastRow() == -1 || e.getColumn() == -1 || e.getFirstRow() >= this.lastRow && e.getLastRow() <= this.lastRow && e.getColumn() == this.lastColumn) {
            this.lastRow = -1;
            this.lastColumn = -1;
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.setColWidth(this.getWidth());
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    static {
        AItemTable.columnNames[0] = Messages.getString("columnNamesAccount_1");
        AItemTable.columnNames[1] = Messages.getString("columnNamesAccount_2");
        AItemTable.columnNames[2] = Messages.getString("columnNamesAccount_3");
        AItemTable.columnNames[3] = Messages.getString("columnNamesAccount_4");
        AItemTable.columnNames[4] = Messages.getString("columnNamesAccount_5");
        AItemTable.columnNames[5] = Messages.getString("columnNamesAccount_6");
        AItemTable.columnNames[6] = Messages.getString("columnNamesAccount_7");
        AItemTable.columnNames[7] = Messages.getString("columnNamesAccount_8");
    }
}

