/*
 * Decompiled with CFR 0.152.
 */
package moneyview.gui;

import java.awt.KeyEventDispatcher;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Date;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import moneyview.Logger;
import moneyview.data.APlannedItem;
import moneyview.data.Util;
import moneyview.gui.GuiUtil;
import moneyview.gui.IKeyboardListener;
import moneyview.gui.MainWindow;
import moneyview.messages.Messages;

public class APlannedItemTable
extends JTable
implements ComponentListener,
IKeyboardListener {
    private static final String TAG = APlannedItemTable.class.getSimpleName();
    private static final long serialVersionUID = 1969L;
    private static AbstractTableModel tableModel = null;
    public static final int PLANNED_COLUMN_INDEX_PAYEE = 0;
    public static final int PLANNED_COLUMN_INDEX_ACCOUNT = 1;
    public static final int PLANNED_COLUMN_INDEX_DU_DATE = 2;
    public static final int PLANNED_COLUMN_INDEX_PERIODICITY = 3;
    public static final int PLANNED_COLUMN_INDEX_CATEGORY = 4;
    public static final int PLANNED_COLUMN_INDEX_MEMO = 5;
    public static final int PLANNED_COLUMN_INDEX_AMOUNT = 6;
    public static final int ROW_HEIGHT = 22;
    public static final int ROW_WITH_COMMENT_HEIGHT = 34;
    int lastRow = -1;
    int lastColumn = -1;
    static String[] columnNames = new String[7];
    KeyEventDispatcher keyEventDispatcher;
    int[] columnWidth = new int[]{25, 10, 7, 10, 20, 20, 8};
    int selectedColumn = 2;

    public APlannedItemTable() {
        this.setRowHeight(22);
    }

    @Override
    public void escapeKeyTyped() {
        if (this.isEditing()) {
            this.getCellEditor().cancelCellEditing();
        }
    }

    @Override
    public void enterKeyTyped() {
        if (this.isEditing()) {
            this.getCellEditor().stopCellEditing();
        }
    }

    @Override
    public void deleteKeyTyped() {
        int l_row = MainWindow.aPlannedItemTable.getSelectedRow();
        if (l_row < 0 || this.isEditing()) {
            return;
        }
        this.removeRow(l_row, true);
    }

    public boolean removeRow(int row, boolean confirmRemove) {
        int l_res;
        if (confirmRemove && (l_res = JOptionPane.showConfirmDialog(null, Messages.getString("APlannedItemTable.7"), "", 2)) != 0) {
            return false;
        }
        APlannedItem.removeItem(row);
        MainWindow.aPlannedItemTable.getTableModel().fireTableRowsDeleted(row, row);
        MainWindow.plannedItemsMainPanel.updateGraph();
        this.lastRow = -1;
        this.lastColumn = -1;
        return true;
    }

    public AbstractTableModel getTableModel() {
        return tableModel;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        boolean l_res = false;
        switch (col) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                if (this.lastRow == row && this.lastColumn == col) {
                    l_res = true;
                    break;
                }
            }
            default: {
                l_res = false;
            }
        }
        this.lastRow = row;
        this.lastColumn = col;
        Logger.debug(TAG, "isCellEditable: returns " + l_res);
        return l_res;
    }

    @Override
    public void setModel(TableModel tableModel) {
        super.setModel(tableModel);
        this.lastRow = -1;
        this.lastColumn = -1;
    }

    public AbstractTableModel getNewCustomTableModel() {
        tableModel = new AbstractTableModel(){

            @Override
            public Object getValueAt(int row, int col) {
                APlannedItem l_rowAPlannedItem = APlannedItem.getItem(row);
                switch (col) {
                    case 0: {
                        return l_rowAPlannedItem.getPayee();
                    }
                    case 1: {
                        return l_rowAPlannedItem.getAccountName();
                    }
                    case 2: {
                        return Util.getSimpleDateFormatter().format(l_rowAPlannedItem.getDate());
                    }
                    case 3: {
                        return APlannedItem.getPeriodicityLabel(l_rowAPlannedItem.getPeriodicity());
                    }
                    case 4: {
                        return Util.getUserFriendlyCategoryString(l_rowAPlannedItem.getCategory());
                    }
                    case 5: {
                        return l_rowAPlannedItem.getMemo();
                    }
                    case 6: {
                        return l_rowAPlannedItem.getAmountString();
                    }
                }
                return "";
            }

            @Override
            public int getRowCount() {
                return APlannedItem.getItemListSize();
            }

            @Override
            public int getColumnCount() {
                return columnNames.length;
            }

            @Override
            public String getColumnName(int col) {
                return columnNames[col];
            }

            public Class getColumnClass(int col) {
                return String.class;
            }

            @Override
            public void setValueAt(Object value, int row, int col) {
                Logger.debug(TAG, "TableModel.setValueAt: row=" + row + ", col=" + col + ", value=" + value);
                String l_oldValue = (String)this.getValueAt(row, col);
                if (Util.safeEquals(l_oldValue, value)) {
                    Logger.verbose(TAG, "TableModel.setValueAt: row=" + row + ", col=" + col + ", value=" + value + "  !! SAME INPUT VALUE AS MODEL DETECTED !! ");
                    return;
                }
                APlannedItem l_rowAPlannedItem = APlannedItem.getItem(row);
                switch (col) {
                    case 0: {
                        l_rowAPlannedItem.setPayee((String)value);
                        break;
                    }
                    case 1: {
                        l_rowAPlannedItem.setAccountName((String)value);
                        break;
                    }
                    case 3: {
                        l_rowAPlannedItem.setPeriodicity(APlannedItem.getPeriodicityFromLabel((String)value));
                        break;
                    }
                    case 2: {
                        try {
                            Date l_nd = Util.parseDate((String)value, Util.getDateDayFirst());
                            l_rowAPlannedItem.setDate(l_nd);
                        }
                        catch (Exception l_nd) {}
                        break;
                    }
                    case 4: {
                        l_rowAPlannedItem.setCategory((String)value);
                        break;
                    }
                    case 5: {
                        l_rowAPlannedItem.setMemo((String)value);
                        break;
                    }
                    case 6: {
                        try {
                            long l_amount = Util.stringAmountToLong((String)value);
                            l_rowAPlannedItem.setLongAmount(l_amount);
                            break;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                this.fireTableRowsUpdated(row, row);
                APlannedItemTable.this.updateViewPort(l_rowAPlannedItem, col, true);
                MainWindow.plannedItemsMainPanel.updateGraph();
            }
        };
        return tableModel;
    }

    public void updateViewPort(APlannedItem aItem, int col, boolean scroll) {
        this.lastRow = this.getSelectedRow();
        this.lastColumn = this.getSelectedColumn();
        int l_rowSel = APlannedItem.indexOf(aItem);
        GuiUtil.showTableElementInViewPort(this, l_rowSel, col);
        MainWindow.mntmPlannedItems.doClick();
    }

    public void setColWidth(int availableWidth) {
        TableColumn column = null;
        for (int i = 0; i < columnNames.length; ++i) {
            column = this.getColumnModel().getColumn(i);
            column.setPreferredWidth(availableWidth * this.columnWidth[i] / 100);
        }
        MainWindow.adjustColumnWidth();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.setColWidth(this.getWidth());
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    static {
        APlannedItemTable.columnNames[0] = Messages.getString("columnNamesPlanned_1");
        APlannedItemTable.columnNames[1] = Messages.getString("columnNamesPlanned_2");
        APlannedItemTable.columnNames[2] = Messages.getString("columnNamesPlanned_3");
        APlannedItemTable.columnNames[3] = Messages.getString("columnNamesPlanned_4");
        APlannedItemTable.columnNames[4] = Messages.getString("columnNamesPlanned_5");
        APlannedItemTable.columnNames[5] = Messages.getString("columnNamesPlanned_6");
        APlannedItemTable.columnNames[6] = Messages.getString("columnNamesPlanned_7");
    }
}

