/*
 * Decompiled with CFR 0.152.
 */
package moneyview.gui;

import java.awt.Color;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.List;
import java.util.UUID;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import moneyview.Logger;
import moneyview.data.AItem;
import moneyview.data.APlannedItem;
import moneyview.data.Account;
import moneyview.data.Util;
import moneyview.gui.AItemTableSelectionListener;
import moneyview.gui.Constants;
import moneyview.gui.DisplayedAccount;
import moneyview.gui.GuiUtil;
import moneyview.gui.MainWindow;
import moneyview.gui.NewPlannedOperationDialog;
import moneyview.gui.TransferOperationToAccountDialog;
import moneyview.messages.Messages;
import moneyview.properties.HMProperties;

class ItemTablePopupListener
extends MouseAdapter {
    private static final String TAG = ItemTablePopupListener.class.getSimpleName();
    private static final String ATTACHEMENTS_SAVE_SUBDIR = "docsAttached";
    static JMenuItem mnuIDelete = null;
    static JMenuItem mnuIDuplicateTo = null;
    static JMenuItem mnuITransferTo = null;
    static JMenu mnuPlannedOccurrenceFromItemMenu = null;
    static JMenuItem mnuIPlannedFromItem = null;
    static JMenuItem mnuIAttachDocumentItem = null;
    static JMenuItem mnuIOpenDocumentMenu = null;
    static JMenuItem mnuIRemoveDocumentMenu = null;
    static JMenu mnuSearch = null;
    static JMenuItem mnuSearchPayee = null;
    static JMenuItem mnuSearchSubCategory = null;
    static JMenuItem mnuSearchCategory = null;
    static JMenu mnuMarkAs = null;
    static JMenuItem mnuICRL_RAZ = null;
    static JMenuItem mnuICRL_C = null;
    static JMenuItem mnuICRL_R = null;
    static JMenuItem mnuICRL_L = null;
    private static ActionListener popupItemMenuActionListener = new ActionListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            String l_action = e.getActionCommand();
            Logger.info(TAG, "popupItemMenuActionListener.actionPerformed : action=" + l_action);
            int l_row = MainWindow.aItemTable.getSelectedRow();
            if (l_row < 0) {
                return;
            }
            AItem l_ai = DisplayedAccount.getDisplayedAccount().getItem(l_row);
            try {
                if (e.getSource().equals(mnuIDelete)) {
                    MainWindow.aItemTable.removeRow(l_row, true);
                    return;
                }
                if (e.getSource().equals(mnuIDuplicateTo)) {
                    TransferOperationToAccountDialog l_tota = new TransferOperationToAccountDialog(MainWindow.getFrame(), Messages.getString("ItemTablePopupListener.21"), true, l_ai);
                    l_tota.setVisible(true);
                    if (!l_tota.okSelected) {
                        return;
                    }
                    Account l_targetAccount = Account.getAccountByName(l_tota.selectedAccount);
                    if (l_targetAccount != null) {
                        AItem l_aiSrc = l_ai;
                        AItem l_aiCopy = new AItem(l_aiSrc, false);
                        l_aiCopy.setNewUuid();
                        l_targetAccount.addItem(l_aiCopy);
                        l_aiCopy.setCategory(l_aiSrc.getCategory(), l_targetAccount);
                    }
                    if (DisplayedAccount.getDisplayedAccount().accountName != null && DisplayedAccount.getDisplayedAccount().accountName.equals(l_targetAccount.accountName)) {
                        MainWindow.aItemTable.updateWithLastSort();
                    }
                    return;
                }
                if (e.getSource().equals(mnuITransferTo)) {
                    TransferOperationToAccountDialog l_tota = new TransferOperationToAccountDialog(MainWindow.getFrame(), Messages.getString("ItemTablePopupListener.22"), false, l_ai);
                    l_tota.setVisible(true);
                    if (!l_tota.okSelected) {
                        return;
                    }
                    Account l_targetAccount = Account.getAccountByName(l_tota.selectedAccount);
                    if (l_targetAccount != null) {
                        String l_cat = l_ai.getCategory();
                        MainWindow.aItemTable.removeRow(l_row, false);
                        l_targetAccount.addItem(l_ai);
                        l_ai.setCategory(l_cat, l_targetAccount);
                    }
                    return;
                }
                if (e.getSource().equals(mnuIPlannedFromItem)) {
                    NewPlannedOperationDialog l_newOpDlg = new NewPlannedOperationDialog(MainWindow.getFrame(), Messages.getString("ItemTablePopupListener.27"), true, l_ai, DisplayedAccount.getDisplayedAccount().accountName);
                    l_newOpDlg.setVisible(true);
                    if (!l_newOpDlg.okSelected) {
                        return;
                    }
                    APlannedItem.addItem(l_newOpDlg.aPlannedItem);
                    APlannedItem.sort(0, true);
                    MainWindow.aPlannedItemTable.getTableModel().fireTableDataChanged();
                    int l_rowSel = APlannedItem.indexOf(l_newOpDlg.aPlannedItem);
                    GuiUtil.showTableElementInViewPort(MainWindow.aPlannedItemTable, l_rowSel, 0);
                    return;
                }
                if (e.getSource().equals(mnuIAttachDocumentItem)) {
                    JFileChooser l_jfc = new JFileChooser();
                    l_jfc.setFileSelectionMode(0);
                    int l_jfRes = l_jfc.showDialog(null, Messages.getString("ItemTablePopupListener.28"));
                    if (l_jfRes == 0) {
                        File l_outFile;
                        File l_inFile = l_jfc.getSelectedFile();
                        String l_inName = l_inFile.getName();
                        Logger.debug(TAG, "actionPerformed: input document file is: " + l_inName + " (" + l_inFile.getPath() + ")");
                        int l_dotIndex = l_inName.lastIndexOf(".");
                        if (l_dotIndex < 1) {
                            JOptionPane.showMessageDialog(null, Messages.getString("ItemTablePopupListener.33") + l_inName, Messages.getString("WINDOW_TITLE_ERROR"), 2, null);
                            return;
                        }
                        File l_hmoneyAttachDocsDir = new File(HMProperties.getSaveLocation() + File.separator + ItemTablePopupListener.ATTACHEMENTS_SAVE_SUBDIR);
                        if (!l_hmoneyAttachDocsDir.exists()) {
                            l_hmoneyAttachDocsDir.mkdir();
                        }
                        if ((l_outFile = new File(HMProperties.getSaveLocation() + File.separator + ItemTablePopupListener.ATTACHEMENTS_SAVE_SUBDIR + File.separator + l_inName)).exists()) {
                            String l_fileExt = l_inName.substring(l_dotIndex);
                            String l_outName = l_inName.substring(0, l_dotIndex) + "-" + UUID.randomUUID() + l_fileExt;
                            l_outFile = new File(HMProperties.getSaveLocation() + File.separator + ItemTablePopupListener.ATTACHEMENTS_SAVE_SUBDIR + File.separator + l_outName);
                        }
                        Logger.debug(TAG, "actionPerformed: output document file is: " + l_outFile.getPath());
                        try {
                            Util.copyFile(l_inFile, l_outFile);
                            l_ai.addDocument(l_outFile.getName());
                        }
                        catch (Exception e3) {
                            JOptionPane.showMessageDialog(null, Messages.getString("ItemTablePopupListener.37") + l_inName, Messages.getString("WINDOW_TITLE_ERROR"), 2, null);
                            MainWindow.aItemTable.getTableModel().fireTableRowsUpdated(l_row, l_row);
                            MainWindow.aItemTable.updateViewPort(l_ai, MainWindow.aItemTable.getSelectedColumn());
                            MainWindow.itemsMainPanel.updateGraph(null);
                            return;
                        }
                    }
                }
                if (e.getSource().equals(mnuICRL_R)) {
                    l_ai.setLitigious(false);
                    l_ai.setReconciled(true);
                    return;
                }
                if (e.getSource().equals(mnuICRL_C)) {
                    l_ai.setLitigious(false);
                    l_ai.setReconciled(false);
                    l_ai.setCleared(true);
                    return;
                }
                if (e.getSource().equals(mnuICRL_L)) {
                    l_ai.setCleared(false);
                    l_ai.setReconciled(false);
                    l_ai.setLitigious(true);
                    return;
                }
                if (e.getSource().equals(mnuICRL_RAZ)) {
                    l_ai.setCleared(false);
                    l_ai.setReconciled(false);
                    l_ai.setLitigious(false);
                    return;
                }
                if (e.getSource().equals(mnuSearchPayee)) {
                    MainWindow.searchOperations(l_ai.getPayee(), 1);
                    return;
                }
                if (e.getSource().equals(mnuSearchSubCategory)) {
                    MainWindow.searchOperations(l_ai.getCategory(), 2);
                    return;
                }
                if (e.getSource().equals(mnuSearchCategory)) {
                    MainWindow.searchOperations(GuiUtil.getParentCategory(l_ai.getCategory()), 2);
                    return;
                }
            }
            finally {
                MainWindow.aItemTable.getTableModel().fireTableRowsUpdated(l_row, l_row);
                MainWindow.aItemTable.updateViewPort(l_ai, MainWindow.aItemTable.getSelectedColumn());
                MainWindow.itemsMainPanel.updateGraph(null);
            }
        }
    };

    ItemTablePopupListener() {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (MainWindow.aItemTable.getSelectedRow() != -1) {
            this.maybeShowPopup(e);
        }
    }

    private void maybeShowPopup(MouseEvent e) {
        if (!AItemTableSelectionListener.lessThanTwoCellsSelected()) {
            return;
        }
        if (e.isPopupTrigger()) {
            int l_row = MainWindow.aItemTable.rowAtPoint(e.getPoint());
            int l_col = MainWindow.aItemTable.columnAtPoint(e.getPoint());
            if (MainWindow.aItemTable.isRowSelected(l_row) && MainWindow.aItemTable.isColumnSelected(l_col)) {
                ItemTablePopupListener.getItemMenuPopup(l_row, l_col).show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    public static JPopupMenu getItemMenuPopup(int row, int column) {
        JMenuItem l_mi;
        int i;
        Logger.debug(TAG, "getItemMenuPopup()");
        final AItem l_ai = DisplayedAccount.getDisplayedAccount().getItem(row);
        final int l_row = row;
        JPopupMenu popup = new JPopupMenu();
        mnuMarkAs = new JMenu(Messages.getString("ItemTablePopupListener.2"));
        mnuMarkAs.addActionListener(popupItemMenuActionListener);
        popup.add(mnuMarkAs);
        mnuICRL_RAZ = new JMenuItem(Messages.getString("ItemTablePopupListener.3"));
        mnuICRL_RAZ.addActionListener(popupItemMenuActionListener);
        mnuMarkAs.add(mnuICRL_RAZ);
        mnuICRL_C = new JMenuItem(Messages.getString("ItemTablePopupListener.4"));
        mnuICRL_C.addActionListener(popupItemMenuActionListener);
        mnuMarkAs.add(mnuICRL_C);
        mnuICRL_R = new JMenuItem(Messages.getString("ItemTablePopupListener.5"));
        mnuICRL_R.addActionListener(popupItemMenuActionListener);
        mnuMarkAs.add(mnuICRL_R);
        mnuICRL_L = new JMenuItem(Messages.getString("ItemTablePopupListener.8"));
        mnuICRL_L.addActionListener(popupItemMenuActionListener);
        mnuICRL_L.setForeground(Constants.litigiousColor);
        mnuMarkAs.add(mnuICRL_L);
        if (l_ai != null && (l_ai.getPayee() != null || Util.isValidCategory(l_ai.getCategory()))) {
            popup.addSeparator();
            mnuSearch = new JMenu(Messages.getString("ItemTablePopupListener.6"));
            mnuSearch.addActionListener(popupItemMenuActionListener);
            popup.add(mnuSearch);
            if (l_ai.getPayee() != null && l_ai.getPayee().trim().length() > 0) {
                mnuSearchPayee = new JMenuItem(Messages.getString("ItemTablePopupListener.7") + l_ai.getPayee() + "'");
                mnuSearchPayee.addActionListener(popupItemMenuActionListener);
                mnuSearch.add(mnuSearchPayee);
            }
            if (Util.isValidCategory(l_ai.getCategory())) {
                mnuSearchSubCategory = new JMenuItem(Messages.getString("ItemTablePopupListener.9") + l_ai.getCategory());
                mnuSearchSubCategory.addActionListener(popupItemMenuActionListener);
                mnuSearch.add(mnuSearchSubCategory);
                mnuSearchCategory = new JMenuItem(Messages.getString("ItemTablePopupListener.10") + GuiUtil.getParentCategory(l_ai.getCategory()));
                mnuSearchCategory.addActionListener(popupItemMenuActionListener);
                mnuSearch.add(mnuSearchCategory);
            }
        }
        popup.addSeparator();
        List<APlannedItem> l_plannedItemListForAccount = APlannedItem.getNextOccurrencesOnAccount(DisplayedAccount.getDisplayedAccount().accountName, l_ai.getLongAmount(), l_ai.getDate());
        mnuPlannedOccurrenceFromItemMenu = new JMenu(Messages.getString("ItemTablePopupListener.11"));
        mnuPlannedOccurrenceFromItemMenu.setForeground(Constants.plannedTableFontColor);
        mnuPlannedOccurrenceFromItemMenu.setBackground(Constants.plannedOddRowColor);
        if (l_plannedItemListForAccount.size() < 1) {
            mnuPlannedOccurrenceFromItemMenu.setEnabled(false);
        } else {
            i = 0;
            for (APlannedItem l_api : l_plannedItemListForAccount) {
                JMenuItem l_mi2 = new JMenuItem("" + l_api.getPayee() + " , " + Util.longAmountToString(l_api.getLongAmount()) + " , " + Util.getSimpleDateFormatter().format(l_api.getDate()));
                l_mi2.setForeground(Constants.plannedTableFontColor);
                if (++i % 2 > 0) {
                    l_mi2.setBackground(Constants.plannedOddRowColor);
                } else {
                    l_mi2.setBackground(Color.white);
                }
                final APlannedItem l_finalAPlannedItem = l_api;
                l_mi2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            l_finalAPlannedItem.ignoreNextOccurrence();
                            l_ai.setCategory(l_finalAPlannedItem.getCategory(), DisplayedAccount.getDisplayedAccount());
                            l_ai.setReconciliatedWithPlanned(true);
                        }
                        finally {
                            MainWindow.aItemTable.getTableModel().fireTableRowsUpdated(l_row, l_row);
                            MainWindow.aItemTable.updateViewPort(l_ai, MainWindow.aItemTable.getSelectedColumn());
                            MainWindow.itemsMainPanel.updateGraph(null);
                        }
                    }
                });
                mnuPlannedOccurrenceFromItemMenu.add(l_mi2);
            }
            JMenuItem l_mi3 = new JMenuItem(Messages.getString("ItemTablePopupListener.14"));
            l_mi3.setForeground(Constants.plannedTableFontColor);
            if (++i % 2 > 0) {
                l_mi3.setBackground(Constants.plannedOddRowColor);
            } else {
                l_mi3.setBackground(Color.white);
            }
            l_mi3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        l_ai.setReconciliatedWithPlanned(true);
                    }
                    finally {
                        MainWindow.aItemTable.getTableModel().fireTableRowsUpdated(l_row, l_row);
                        MainWindow.aItemTable.updateViewPort(l_ai, MainWindow.aItemTable.getSelectedColumn());
                        MainWindow.itemsMainPanel.updateGraph(null);
                    }
                }
            });
            mnuPlannedOccurrenceFromItemMenu.add(l_mi3);
        }
        popup.add(mnuPlannedOccurrenceFromItemMenu);
        mnuIPlannedFromItem = new JMenuItem(Messages.getString("ItemTablePopupListener.15"));
        mnuIPlannedFromItem.addActionListener(popupItemMenuActionListener);
        popup.add(mnuIPlannedFromItem);
        mnuIOpenDocumentMenu = new JMenu(Messages.getString("ItemTablePopupListener.16"));
        mnuIOpenDocumentMenu.addActionListener(popupItemMenuActionListener);
        popup.add(mnuIOpenDocumentMenu);
        mnuIOpenDocumentMenu.setEnabled(false);
        if (l_ai.getDocuments() != null) {
            for (i = 0; i < l_ai.getDocuments().length; ++i) {
                mnuIOpenDocumentMenu.setEnabled(true);
                final int l_finalI = i;
                l_mi = new JMenuItem("" + l_ai.getDocuments()[i]);
                l_mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            Desktop.getDesktop().open(new File(HMProperties.getSaveLocation() + File.separator + ItemTablePopupListener.ATTACHEMENTS_SAVE_SUBDIR + File.separator + l_ai.getDocuments()[l_finalI]));
                        }
                        catch (Exception e2) {
                            JOptionPane.showMessageDialog(null, Messages.getString("ItemTablePopupListener.17") + l_ai.getDocuments()[0], Messages.getString("WINDOW_TITLE_ERROR"), 2, null);
                        }
                    }
                });
                mnuIOpenDocumentMenu.add(l_mi);
            }
        }
        mnuIRemoveDocumentMenu = new JMenu(Messages.getString("ItemTablePopupListener.19"));
        mnuIRemoveDocumentMenu.addActionListener(popupItemMenuActionListener);
        popup.add(mnuIRemoveDocumentMenu);
        mnuIRemoveDocumentMenu.setEnabled(false);
        if (l_ai.getDocuments() != null) {
            for (i = 0; i < l_ai.getDocuments().length; ++i) {
                mnuIRemoveDocumentMenu.setEnabled(true);
                final int l_finalI = i;
                l_mi = new JMenuItem("" + l_ai.getDocuments()[i]);
                l_mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (l_ai.getDocuments() != null && l_finalI < l_ai.getDocuments().length) {
                            File l_removeFile = new File(HMProperties.getSaveLocation() + File.separator + ItemTablePopupListener.ATTACHEMENTS_SAVE_SUBDIR + File.separator + l_ai.getDocuments()[l_finalI]);
                            if (l_removeFile.exists()) {
                                l_removeFile.delete();
                            }
                            l_ai.removeDocument(l_ai.getDocuments()[l_finalI]);
                        }
                    }
                });
                mnuIRemoveDocumentMenu.add(l_mi);
            }
        }
        mnuIAttachDocumentItem = new JMenuItem(Messages.getString("ItemTablePopupListener.20"));
        mnuIAttachDocumentItem.addActionListener(popupItemMenuActionListener);
        popup.add(mnuIAttachDocumentItem);
        popup.addSeparator();
        mnuIDuplicateTo = new JMenuItem(Messages.getString("ItemTablePopupListener.21"));
        mnuIDuplicateTo.addActionListener(popupItemMenuActionListener);
        mnuIDuplicateTo.setEnabled(true);
        popup.add(mnuIDuplicateTo);
        mnuITransferTo = new JMenuItem(Messages.getString("ItemTablePopupListener.22"));
        mnuITransferTo.addActionListener(popupItemMenuActionListener);
        mnuITransferTo.setEnabled(true);
        popup.add(mnuITransferTo);
        mnuIDelete = new JMenuItem(Messages.getString("ItemTablePopupListener.23"));
        mnuIDelete.addActionListener(popupItemMenuActionListener);
        popup.add(mnuIDelete);
        return popup;
    }
}

