/*
 * Decompiled with CFR 0.152.
 */
package moneyview.gui;

import com.formdev.flatlaf.FlatDarculaLaf;
import com.formdev.flatlaf.FlatDarkLaf;
import com.formdev.flatlaf.FlatIntelliJLaf;
import com.formdev.flatlaf.FlatLightLaf;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Frame;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.ColorUIResource;
import moneyview.Logger;
import moneyview.data.ACategory;
import moneyview.data.AItem;
import moneyview.data.APlannedItem;
import moneyview.data.Account;
import moneyview.data.DayAndMonthInvertedException;
import moneyview.data.OfxImport;
import moneyview.data.OfxSaxImporter;
import moneyview.data.QifImportExport;
import moneyview.data.Util;
import moneyview.gui.AItemTable;
import moneyview.gui.AItemTableCellEditor;
import moneyview.gui.AItemTableCellRenderer;
import moneyview.gui.AItemTableSelectionListener;
import moneyview.gui.APlannedItemTable;
import moneyview.gui.APlannedItemTableCellEditor;
import moneyview.gui.APlannedItemTableCellRenderer;
import moneyview.gui.AccountDialog;
import moneyview.gui.CategoriesDialog;
import moneyview.gui.Constants;
import moneyview.gui.DisplayedAccount;
import moneyview.gui.GuiUtil;
import moneyview.gui.HMFrameListener;
import moneyview.gui.ItemTablePopupListener;
import moneyview.gui.ItemsPanel;
import moneyview.gui.MenuManager;
import moneyview.gui.PlannedItemTablePopupListener;
import moneyview.gui.PlannedItemsPanel;
import moneyview.gui.ReportsHtmlPanel;
import moneyview.gui.SummaryHtmlPanel;
import moneyview.gui.custom.DateFormatCheckboxAccessory;
import moneyview.gui.custom.KeyboardMainListener;
import moneyview.gui.custom.NewPasswordInputDialog;
import moneyview.gui.custom.PasswordInputDialog;
import moneyview.gui.custom.SwingUtils;
import moneyview.messages.Messages;
import moneyview.properties.HMProperties;
import moneyview.zip.Unzip;
import moneyview.zip.ZipMaker;

public class MainWindow {
    private static final String TAG = MainWindow.class.getSimpleName();
    private static JFrame frame;
    public static JPanel contentPanel;
    static SummaryHtmlPanel summaryHtmlPanel;
    static ReportsHtmlPanel reportsHtmlPanel;
    static ItemsPanel itemsMainPanel;
    static PlannedItemsPanel plannedItemsMainPanel;
    public static String encryptionPassword;
    protected static AItemTable aItemTable;
    protected static APlannedItemTable aPlannedItemTable;
    private static final Font tableHeaderFont;
    static List<JMenuItem> accountMenuItems;
    protected static JMenuBar menuBar;
    protected static JMenu mnAccountsMenu;
    protected static JMenu mnAccountPropertiesMenu;
    protected static JMenu mnBillsGraphAccountsMenu;
    protected static JMenu mnReportsMenu;
    protected static JMenuItem mntmMainExpensesAndIncomes;
    protected static int mnBillsGraphAccountsMenuAccountsIndexGap;
    protected static JCheckBoxMenuItem mn30DaysGraphMenu;
    protected static JCheckBoxMenuItem mn90DaysGraphMenu;
    protected static JCheckBoxMenuItem mn6MonthsGraphMenu;
    protected static JCheckBoxMenuItem mn1YearGraphMenu;
    protected static JCheckBoxMenuItem mn30DaysReportsMenu;
    protected static JCheckBoxMenuItem mn90DaysReportsMenu;
    protected static JCheckBoxMenuItem mn6MonthsReportsMenu;
    protected static JCheckBoxMenuItem mn1YearReportsMenu;
    protected static JCheckBoxMenuItem mn2YearsReportsMenu;
    protected static JCheckBoxMenuItem mn5YearsReportsMenu;
    protected static JCheckBoxMenuItem mn10YearsReportsMenu;
    protected static JMenu mnOptionsMenu;
    protected static JMenu selectStateLocationMenu;
    protected static JCheckBoxMenuItem historyStateLocationMenuItem;
    protected static JMenuItem mnHomeMenu;
    protected static JMenuItem newAccountMenuItem;
    protected static JMenuItem deleteAccountMenuItem;
    protected static JMenuItem qifFileImportMenuItem;
    protected static JMenuItem ofxFileImportMenuItem;
    protected static JMenuItem csvFileExportMenuItem;
    protected static JMenuItem csvFileImportMenuItem;
    protected static JMenuItem saveArchiveFileMenuItem;
    protected static JMenuItem loadArchiveFileMenuItem;
    protected static JMenu msMoneyMenu;
    protected static JMenuItem msMoneyImportMenuItem;
    protected static JMenuItem mnSave;
    protected static JMenuItem mntmExit;
    protected static JMenuItem mntmExitWithoutSaving;
    protected static JMenuItem mntmAdjustColWidth;
    protected static JMenuItem categoryDlgMenuItem;
    protected static JMenuItem markAllClearedMenuItem;
    protected static JMenuItem markAllValidatedMenuItem;
    protected static JMenuItem aboutMenuItem;
    protected static JMenuItem mntmSearchSimple;
    protected static JMenuItem mntmSearchFull;
    protected static JMenuItem mntmClearSearch;
    protected static JMenuItem mntmCalc;
    protected static JMenuItem mntmPlannedItems;
    private static final int GRAPH_DAYS_30 = 30;
    private static final int GRAPH_DAYS_90 = 90;
    private static final int GRAPH_DAYS_182 = 182;
    private static final int GRAPH_DAYS_365 = 365;
    private static final int REPORTS_DAYS_30 = 30;
    private static final int REPORTS_DAYS_90 = 90;
    private static final int REPORTS_DAYS_182 = 182;
    private static final int REPORTS_DAYS_365 = 365;
    private static final int REPORTS_DAYS_2YEARS = 730;
    private static final int REPORTS_DAYS_5YEARS = 1826;
    private static final int REPORTS_DAYS_10YEARS = 3652;
    private static long lastAdjustColumnWidthTS;

    public static JFrame getFrame() {
        return frame;
    }

    public MainWindow() {
        try {
            UIManager.installLookAndFeel("Flat Light", FlatLightLaf.class.getName());
            UIManager.installLookAndFeel("Flat Dark", FlatDarkLaf.class.getName());
            UIManager.installLookAndFeel("Flat IntelliJ", FlatIntelliJLaf.class.getName());
            UIManager.installLookAndFeel("Flat Darcula", FlatDarculaLaf.class.getName());
            String l_lafName = HMProperties.getStringProperty("frame.laf");
            if (l_lafName == null) {
                l_lafName = "Nimbus";
            }
            try {
                GuiUtil.setLaf(l_lafName);
            }
            catch (Exception ex) {
                Logger.error(TAG, "ERROR setting LaF UIManager.setLookAndFeel to " + l_lafName + ", Exception=" + ex.toString());
                for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                    if (!"Nimbus".equals(info.getName())) continue;
                    UIManager.setLookAndFeel(info.getClassName());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initialize();
    }

    private void initialize() {
        KeyboardMainListener.init();
        UIManager.put("ComboBox.selectionBackground", new ColorUIResource(Constants.selectedCellBgColor));
        UIManager.put("ComboBox.background", new ColorUIResource(Constants.oddRowColor));
        frame = new JFrame();
        frame.setBounds(HMProperties.getIntProperty("frame.left"), HMProperties.getIntProperty("frame.top"), HMProperties.getIntProperty("frame.width"), HMProperties.getIntProperty("frame.height"));
        frame.setDefaultCloseOperation(2);
        frame.getContentPane().setLayout(new BorderLayout(0, 0));
        frame.setIconImage(GuiUtil.getImageIcon("hmicon.png").getImage());
        frame.setTitle(Messages.getString("MainWindow.0") + 2 + "." + 4 + "." + 0);
        frame.setExtendedState(HMProperties.getIntProperty("frame.state"));
        HMFrameListener l_frameListener = new HMFrameListener();
        frame.addWindowListener(l_frameListener);
        frame.addWindowStateListener(l_frameListener);
        frame.addComponentListener(l_frameListener);
        GuiUtil.displayBusyCursor();
        summaryHtmlPanel = new SummaryHtmlPanel(this);
        reportsHtmlPanel = new ReportsHtmlPanel(this);
        contentPanel = new JPanel();
        frame.getContentPane().add(contentPanel);
        contentPanel.setLayout(new BorderLayout(0, 0));
        contentPanel.add(summaryHtmlPanel);
        aItemTable = new AItemTable();
        aItemTable.setShowGrid(false);
        aItemTable.setModel(aItemTable.getNewCustomTableModel());
        AItemTableCellRenderer l_aitcr = new AItemTableCellRenderer();
        aItemTable.setDefaultRenderer(Integer.class, l_aitcr);
        aItemTable.setDefaultRenderer(String.class, l_aitcr);
        AItemTableCellEditor l_aitce = new AItemTableCellEditor();
        aItemTable.setDefaultEditor(String.class, l_aitce);
        aItemTable.setBackground(Color.white);
        aItemTable.getTableHeader().setReorderingAllowed(false);
        aItemTable.getTableHeader().setFont(tableHeaderFont);
        aItemTable.getTableHeader().setBackground(Constants.tableHeaderBgColor);
        aItemTable.getTableHeader().setForeground(Constants.tableFontColor);
        aItemTable.getTableHeader().setToolTipText(Messages.getString("MainWindow.9"));
        aItemTable.addComponentListener(aItemTable);
        aItemTable.addMouseListener(new ItemTablePopupListener());
        aItemTable.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int col = aItemTable.columnAtPoint(e.getPoint());
                String name = aItemTable.getColumnName(col);
                aItemTable.clickOnColumnHeader(col, DisplayedAccount.getDisplayedAccount(), true);
                MainWindow.refreshTableViewPort();
            }
        });
        itemsMainPanel = new ItemsPanel(aItemTable);
        aItemTable.setSelectionMode(2);
        ListSelectionModel listSelectionModel = aItemTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AItemTableSelectionListener());
        aItemTable.setSelectionModel(listSelectionModel);
        aPlannedItemTable = new APlannedItemTable();
        aPlannedItemTable.setShowGrid(false);
        aPlannedItemTable.setModel(aPlannedItemTable.getNewCustomTableModel());
        APlannedItemTableCellRenderer l_apitcr = new APlannedItemTableCellRenderer();
        aPlannedItemTable.setDefaultRenderer(Integer.class, l_apitcr);
        aPlannedItemTable.setDefaultRenderer(String.class, l_apitcr);
        APlannedItemTableCellEditor l_apitce = new APlannedItemTableCellEditor();
        aPlannedItemTable.setDefaultEditor(String.class, l_apitce);
        aPlannedItemTable.setSelectionMode(0);
        aPlannedItemTable.setBackground(Color.white);
        aPlannedItemTable.getTableHeader().setReorderingAllowed(false);
        aPlannedItemTable.getTableHeader().setFont(tableHeaderFont);
        aPlannedItemTable.getTableHeader().setBackground(Constants.plannedTableHeaderBgColor);
        aPlannedItemTable.getTableHeader().setForeground(Constants.tableFontColor);
        aPlannedItemTable.addComponentListener(aPlannedItemTable);
        aPlannedItemTable.addMouseListener(new PlannedItemTablePopupListener());
        plannedItemsMainPanel = new PlannedItemsPanel(aPlannedItemTable);
        menuBar = new JMenuBar();
        menuBar.setAlignmentX(0.0f);
        frame.getContentPane().add((Component)menuBar, "North");
        JMenu mnFileMenu = new JMenu(Messages.getString("MainWindow.10"));
        menuBar.add(mnFileMenu);
        mnFileMenu.setHorizontalAlignment(2);
        mnHomeMenu = new JMenuItem(Messages.getString("MainWindow.8"));
        mnFileMenu.add(mnHomeMenu);
        mnHomeMenu.setHorizontalAlignment(2);
        mnHomeMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiUtil.displayBusyCursor();
                try {
                    if (DisplayedAccount.isThereAStackedAccount()) {
                        mntmClearSearch.doClick();
                    }
                    contentPanel.removeAll();
                    contentPanel.add(summaryHtmlPanel);
                    MenuManager.inHomePage();
                    KeyboardMainListener.flush();
                    summaryHtmlPanel.displayAccounts();
                }
                finally {
                    GuiUtil.displayNormalCursor();
                }
            }
        });
        mnFileMenu.addSeparator();
        final String l_newAccountText = Messages.getString("MainWindow.11");
        newAccountMenuItem = new JMenuItem(l_newAccountText);
        newAccountMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AccountDialog l_naDlg = new AccountDialog((Frame)frame, l_newAccountText, null);
                l_naDlg.setVisible(true);
                if (l_naDlg.okSelected) {
                    try {
                        MainWindow.this.addAccount(true, l_naDlg.accountName.getText().trim(), Account.getAccountTypeFromLabel(l_naDlg.accountTypeChoice.getSelectedItem().toString()), l_naDlg.initialAmount.getText(), l_naDlg.txtOpeningDate.getText());
                        if (summaryHtmlPanel.isShowing()) {
                            summaryHtmlPanel.displayAccounts();
                        }
                    }
                    catch (Exception e2) {
                        Logger.error(TAG, "newAccountMenuItem: actionPerformed: " + e2);
                    }
                }
            }
        });
        mnFileMenu.add(newAccountMenuItem);
        deleteAccountMenuItem = new JMenuItem(Messages.getString("MainWindow.13"));
        deleteAccountMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] l_choiceValues = new String[Account.openAccounts.size()];
                int i1 = 0;
                for (Account l_a : Account.openAccounts) {
                    l_choiceValues[i1++] = l_a.accountName;
                }
                String l_delAccount = (String)JOptionPane.showInputDialog(null, Messages.getString("MainWindow.14"), Messages.getString("WINDOW_TITLE_SELECT"), 3, null, l_choiceValues, l_choiceValues[0]);
                if (l_delAccount == null) {
                    return;
                }
                int l_res = JOptionPane.showConfirmDialog(null, Messages.getString("MainWindow.16") + l_delAccount + "'", Messages.getString("WINDOW_TITLE_WARNING"), 2);
                if (l_res != 0) {
                    return;
                }
                Account.removeAccount(l_delAccount);
                HMProperties.updateAccountList();
                for (int i = 0; i < accountMenuItems.size(); ++i) {
                    JMenuItem l_mi = accountMenuItems.get(i);
                    if (!l_mi.getText().equals(l_delAccount)) continue;
                    accountMenuItems.remove(l_mi);
                    mnAccountsMenu.remove(l_mi);
                    mnBillsGraphAccountsMenu.remove(i + mnBillsGraphAccountsMenuAccountsIndexGap);
                    mnAccountPropertiesMenu.remove(i);
                    break;
                }
                if (summaryHtmlPanel.isShowing()) {
                    summaryHtmlPanel.displayAccounts();
                }
                if (DisplayedAccount.getDisplayedAccount() != null && DisplayedAccount.getDisplayedAccount().accountName.equals(l_delAccount)) {
                    MainWindow.itemsMainPanel.homepageButton.doClick();
                }
            }
        });
        mnFileMenu.add(deleteAccountMenuItem);
        mnAccountPropertiesMenu = new JMenu(Messages.getString("MainWindow.19"));
        mnFileMenu.add(mnAccountPropertiesMenu);
        mnFileMenu.addSeparator();
        qifFileImportMenuItem = new JMenuItem(Messages.getString("MainWindow.20"));
        qifFileImportMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int l_jfRes;
                JFileChooser l_jfc = new JFileChooser();
                l_jfc.setFileSelectionMode(0);
                l_jfc.setCurrentDirectory(new File(HMProperties.getOpenDirLocation()));
                l_jfc.setAccessory(new DateFormatCheckboxAccessory(l_jfc));
                l_jfc.setFileFilter(new FileFilter(){

                    @Override
                    public String getDescription() {
                        return Messages.getString("MainWindow.21");
                    }

                    @Override
                    public boolean accept(File f) {
                        return f.isDirectory() || f.getName().toLowerCase().endsWith(".qif");
                    }
                });
                Action details = l_jfc.getActionMap().get("viewTypeDetails");
                details.actionPerformed(null);
                JTable table = SwingUtils.getDescendantsOfType(JTable.class, l_jfc).get(0);
                for (int l_sortIndex = 3; l_sortIndex >= 0; --l_sortIndex) {
                    try {
                        table.getRowSorter().toggleSortOrder(l_sortIndex);
                        table.getRowSorter().toggleSortOrder(l_sortIndex);
                        break;
                    }
                    catch (Exception et) {
                        Logger.error(TAG, "table.getRowSorter().toggleSortOrder(" + l_sortIndex + ") -> " + et.toString());
                        continue;
                    }
                }
                if ((l_jfRes = l_jfc.showDialog(frame, Messages.getString("MainWindow.23"))) == 0) {
                    boolean l_invertDayAndMonthDateReadFormat = ((DateFormatCheckboxAccessory)l_jfc.getAccessory()).isSelected();
                    File file = l_jfc.getSelectedFile();
                    String sfilename = file.getPath();
                    HMProperties.setOpenDirLocation(file.getParent());
                    Logger.debug(TAG, "initialize: mnfileChooseFolder.actionPerformed: chosen file is: " + sfilename + " ,  l_invertDayAndMonthDateReadFormat=" + l_invertDayAndMonthDateReadFormat);
                    MainWindow.this.importFile(true, sfilename, l_invertDayAndMonthDateReadFormat, false);
                }
            }
        });
        mnFileMenu.add(qifFileImportMenuItem);
        ofxFileImportMenuItem = new JMenuItem(Messages.getString("MainWindow.30"));
        ofxFileImportMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int l_jfRes;
                JFileChooser l_jfc = new JFileChooser();
                l_jfc.setFileSelectionMode(0);
                l_jfc.setCurrentDirectory(new File(HMProperties.getOpenDirLocation()));
                l_jfc.setFileFilter(new FileFilter(){

                    @Override
                    public String getDescription() {
                        return Messages.getString("MainWindow.31");
                    }

                    @Override
                    public boolean accept(File f) {
                        return f.isDirectory() || f.getName().toLowerCase().endsWith(".ofx");
                    }
                });
                Action details = l_jfc.getActionMap().get("viewTypeDetails");
                details.actionPerformed(null);
                JTable table = SwingUtils.getDescendantsOfType(JTable.class, l_jfc).get(0);
                for (int l_sortIndex = 3; l_sortIndex >= 0; --l_sortIndex) {
                    try {
                        table.getRowSorter().toggleSortOrder(l_sortIndex);
                        table.getRowSorter().toggleSortOrder(l_sortIndex);
                        break;
                    }
                    catch (Exception et) {
                        Logger.error(TAG, "table.getRowSorter().toggleSortOrder(" + l_sortIndex + ") -> " + et.toString());
                        continue;
                    }
                }
                if ((l_jfRes = l_jfc.showDialog(frame, Messages.getString("MainWindow.33"))) == 0) {
                    File file = l_jfc.getSelectedFile();
                    String sfilename = file.getPath();
                    HMProperties.setOpenDirLocation(file.getParent());
                    Logger.debug(TAG, "initialize: mnfileChooseFolder.actionPerformed: chosen file is: " + sfilename);
                    MainWindow.this.importFile(false, sfilename, false, false);
                }
            }
        });
        mnFileMenu.add(ofxFileImportMenuItem);
        csvFileExportMenuItem = new JMenuItem(Messages.getString("MainWindow.35"));
        csvFileExportMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DisplayedAccount.getDisplayedAccount() == null) {
                    return;
                }
                JFileChooser l_jfc = new JFileChooser();
                l_jfc.setCurrentDirectory(new File(HMProperties.getOpenDirLocation()));
                SimpleDateFormat l_sdf = new SimpleDateFormat("yyyyMMdd-HHmm");
                Date l_date = new Date();
                l_jfc.setSelectedFile(new File(HMProperties.getOpenDirLocation() + File.separator + DisplayedAccount.getDisplayedAccount().accountName + "-" + l_sdf.format(l_date) + ".csv"));
                int l_jfRes = l_jfc.showSaveDialog(frame);
                if (l_jfRes == 0) {
                    try {
                        File l_file = l_jfc.getSelectedFile();
                        String l_csvFileName = l_file.getAbsoluteFile().toString();
                        if (l_csvFileName != null && !l_csvFileName.endsWith(".csv")) {
                            l_csvFileName = l_csvFileName + ".csv";
                        }
                        GuiUtil.displayBusyCursor();
                        DisplayedAccount.getDisplayedAccount().exportCsvData(new File(l_csvFileName));
                        GuiUtil.displayNormalCursor();
                    }
                    catch (Exception ex) {
                        Logger.error(TAG, "Error exporting archive : " + ex);
                    }
                }
            }
        });
        mnFileMenu.add(csvFileExportMenuItem);
        mnFileMenu.addSeparator();
        msMoneyMenu = new JMenu(Messages.getString("MainWindow.39"));
        msMoneyImportMenuItem = new JMenuItem(Messages.getString("MainWindow.40"));
        msMoneyImportMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int l_res = JOptionPane.showConfirmDialog(MainWindow.getFrame(), Messages.getString("MainWindow.41") + Messages.getString("MainWindow.42") + Messages.getString("MainWindow.43") + Messages.getString("MainWindow.44") + Messages.getString("MainWindow.45"), Messages.getString("MainWindow.46"), 2);
                if (l_res != 0) {
                    return;
                }
                JFileChooser l_jfc = new JFileChooser();
                l_jfc.setFileSelectionMode(0);
                l_jfc.setCurrentDirectory(new File(HMProperties.getOpenDirLocation()));
                l_jfc.setAccessory(new DateFormatCheckboxAccessory(l_jfc));
                l_jfc.setFileFilter(new FileFilter(){

                    @Override
                    public String getDescription() {
                        return Messages.getString("MainWindow.47");
                    }

                    @Override
                    public boolean accept(File f) {
                        return f.isDirectory() || f.getName().toLowerCase().endsWith(".qif");
                    }
                });
                Action details = l_jfc.getActionMap().get("viewTypeDetails");
                details.actionPerformed(null);
                int l_jfRes = l_jfc.showDialog(frame, Messages.getString("MainWindow.49"));
                if (l_jfRes == 0) {
                    boolean l_invertDayAndMonthDateReadFormat = ((DateFormatCheckboxAccessory)l_jfc.getAccessory()).isSelected();
                    File file = l_jfc.getSelectedFile();
                    String sfilename = file.getPath();
                    HMProperties.setOpenDirLocation(file.getParent());
                    Logger.debug(TAG, "initialize: mnfileChooseFolder.actionPerformed: chosen file is: " + sfilename + " ,  l_invertDayAndMonthDateReadFormat=" + l_invertDayAndMonthDateReadFormat);
                    MainWindow.this.importFile(true, sfilename, l_invertDayAndMonthDateReadFormat, true);
                }
            }
        });
        msMoneyMenu.add(msMoneyImportMenuItem);
        mnFileMenu.add(msMoneyMenu);
        mnFileMenu.addSeparator();
        saveArchiveFileMenuItem = new JMenuItem(Messages.getString("MainWindow.59"));
        saveArchiveFileMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser l_jfc = new JFileChooser();
                l_jfc.setCurrentDirectory(new File(HMProperties.getOpenDirLocation()));
                SimpleDateFormat l_sdf = new SimpleDateFormat("yyyyMMdd-HHmm");
                Date l_date = new Date();
                l_jfc.setSelectedFile(new File(HMProperties.getOpenDirLocation() + File.separator + "MoneyView_archive_" + l_sdf.format(l_date) + ".zip"));
                int l_jfRes = l_jfc.showSaveDialog(frame);
                if (l_jfRes == 0) {
                    try {
                        int l_res;
                        File l_file = l_jfc.getSelectedFile();
                        if (l_file.exists() && (l_res = JOptionPane.showConfirmDialog(null, Messages.getString("MainWindow.63"), Messages.getString("WINDOW_TITLE_WARNING"), 2)) != 0) {
                            return;
                        }
                        String l_archiveFileName = l_file.getAbsoluteFile().toString();
                        if (l_archiveFileName != null && !l_archiveFileName.endsWith(".zip")) {
                            l_archiveFileName = l_archiveFileName + ".zip";
                        }
                        GuiUtil.displayBusyCursor();
                        MainWindow.this.save(true);
                        ZipMaker l_zm = new ZipMaker();
                        l_zm.copyDirectoryToZipFile(new File(HMProperties.getSaveLocation()), new File(l_archiveFileName));
                        GuiUtil.displayNormalCursor();
                    }
                    catch (Exception ex) {
                        Logger.error(TAG, "Error exporting archive : " + ex);
                    }
                }
            }
        });
        mnFileMenu.add(saveArchiveFileMenuItem);
        loadArchiveFileMenuItem = new JMenuItem(Messages.getString("MainWindow.68"));
        loadArchiveFileMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser l_jfc = new JFileChooser();
                l_jfc.setFileSelectionMode(0);
                l_jfc.setCurrentDirectory(new File(HMProperties.getOpenDirLocation()));
                l_jfc.setFileFilter(new FileFilter(){

                    @Override
                    public String getDescription() {
                        return Messages.getString("MainWindow.69");
                    }

                    @Override
                    public boolean accept(File f) {
                        return f.isDirectory() || f.getName().toLowerCase().endsWith(".zip");
                    }
                });
                int l_jfRes = l_jfc.showDialog(frame, Messages.getString("MainWindow.71"));
                if (l_jfRes == 0) {
                    int l_res = JOptionPane.showConfirmDialog(null, Messages.getString("MainWindow.72"), Messages.getString("WINDOW_TITLE_WARNING"), 2);
                    if (l_res != 0) {
                        return;
                    }
                    File file = l_jfc.getSelectedFile();
                    String sfilename = file.getPath();
                    HMProperties.setOpenDirLocation(file.getParent());
                    Logger.debug(TAG, "initialize: loadArchiveFileMenuItem.actionPerformed: chosen file is: " + sfilename);
                    GuiUtil.displayBusyCursor();
                    try {
                        Unzip.archiveToDir(new File(sfilename), new File(HMProperties.getSaveLocation()));
                        JOptionPane.showMessageDialog(MainWindow.getFrame(), Messages.getString("MainWindow.75") + Messages.getString("MainWindow.76"), Messages.getString("MainWindow.77"), 2);
                        System.exit(0);
                    }
                    catch (Exception ex) {
                        Logger.error(TAG, "Error importing archive : " + ex);
                    }
                    GuiUtil.displayNormalCursor();
                }
            }
        });
        mnFileMenu.add(loadArchiveFileMenuItem);
        mnFileMenu.addSeparator();
        mntmExitWithoutSaving = new JMenuItem(Messages.getString("MainWindow.56"));
        mntmExitWithoutSaving.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int l_res = JOptionPane.showConfirmDialog(null, Messages.getString("MainWindow.57"), Messages.getString("WINDOW_TITLE_WARNING"), 2);
                if (l_res != 0) {
                    return;
                }
                System.exit(0);
            }
        });
        mnFileMenu.add(mntmExitWithoutSaving);
        mnFileMenu.addSeparator();
        mnSave = new JMenuItem(Messages.getString("MainWindow.79"));
        mnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiUtil.displayBusyCursor();
                MainWindow.this.save(true);
                GuiUtil.displayNormalCursor();
            }
        });
        mnFileMenu.add(mnSave);
        mntmExit = new JMenuItem(Messages.getString("MainWindow.80"));
        mntmExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Util.saveAll(false);
                frame.dispose();
            }
        });
        mnFileMenu.add(mntmExit);
        JMenu mnEditMenu = new JMenu(Messages.getString("MainWindow.81"));
        menuBar.add(mnEditMenu);
        mntmSearchSimple = new JMenuItem(Messages.getString("MainWindow.82"));
        mntmSearchSimple.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String l_searchString = JOptionPane.showInputDialog(null, Messages.getString("MainWindow.83"), Messages.getString("MainWindow.84"), 3);
                if (l_searchString == null) {
                    return;
                }
                MainWindow.searchOperations(l_searchString, 0);
                itemsMainPanel.updateGraph(null);
            }
        });
        mnEditMenu.add(mntmSearchSimple);
        mntmSearchFull = new JMenuItem(Messages.getString("MainWindow.85"));
        mntmSearchFull.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String l_searchString = JOptionPane.showInputDialog(null, Messages.getString("MainWindow.86"), Messages.getString("MainWindow.87"), 3);
                if (l_searchString == null) {
                    return;
                }
                Account l_resAccount = new Account("searchResults", false);
                for (Account l_a : Account.openAccounts) {
                    List<AItem> l_il = l_a.searchOperations(l_searchString, 0);
                    l_resAccount.addOperations(l_il);
                }
                DisplayedAccount.pushAccount(l_resAccount, mntmSearchFull);
                if (DisplayedAccount.getDisplayedAccount() != null) {
                    aItemTable.clickOnColumnHeader(2, DisplayedAccount.getDisplayedAccount(), false);
                }
                MainWindow.refreshTableViewPort();
                itemsMainPanel.updateGraph(null);
            }
        });
        mnEditMenu.add(mntmSearchFull);
        mntmClearSearch = new JMenuItem(Messages.getString("MainWindow.89"));
        mntmClearSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DisplayedAccount.popAccount();
                MainWindow.refreshTableViewPort();
                itemsMainPanel.updateGraph(null);
            }
        });
        mnEditMenu.add(mntmClearSearch);
        mntmClearSearch.setEnabled(false);
        mnEditMenu.addSeparator();
        mntmAdjustColWidth = new JMenuItem(Messages.getString("MainWindow.90"));
        mntmAdjustColWidth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                aItemTable.setColWidth(aItemTable.getWidth());
            }
        });
        mnEditMenu.add(mntmAdjustColWidth);
        mnEditMenu.addSeparator();
        final String l_catMenuItemText = Messages.getString("MainWindow.91");
        categoryDlgMenuItem = new JMenuItem(l_catMenuItemText);
        categoryDlgMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CategoriesDialog l_catDlg = new CategoriesDialog((Frame)frame, l_catMenuItemText);
                l_catDlg.setVisible(true);
                if (!ACategory.getSaved()) {
                    Util.saveAll(false);
                }
            }
        });
        mnEditMenu.add(categoryDlgMenuItem);
        JMenuItem addDefaultCategoriesMenuItem = new JMenuItem(Messages.getString("MainWindow.114"));
        addDefaultCategoriesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int l_res = JOptionPane.showConfirmDialog(null, Messages.getString("MainWindow.115"), Messages.getString("WINDOW_TITLE_WARNING"), 2);
                if (l_res != 0) {
                    return;
                }
                GuiUtil.displayBusyCursor();
                ACategory.addDefaultCategories(HMProperties.getStringProperty("hmy.locale"));
                GuiUtil.displayNormalCursor();
            }
        });
        mnEditMenu.add(addDefaultCategoriesMenuItem);
        JMenuItem removeUnusedDefaultCategoriesMenuItem = new JMenuItem(Messages.getString("MainWindow.113"));
        removeUnusedDefaultCategoriesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int l_res = JOptionPane.showConfirmDialog(null, Messages.getString("MainWindow.116"), Messages.getString("WINDOW_TITLE_WARNING"), 2);
                if (l_res != 0) {
                    return;
                }
                GuiUtil.displayBusyCursor();
                try {
                    ACategory.removeUnusedDefaultCategories(HMProperties.getStringProperty("hmy.locale"));
                }
                catch (Exception er) {
                    Logger.error(TAG, "removeUnusedDefaultCategoriesMenuItem.actionPerformed(): " + er);
                }
                GuiUtil.displayNormalCursor();
            }
        });
        mnEditMenu.add(removeUnusedDefaultCategoriesMenuItem);
        mnEditMenu.addSeparator();
        markAllValidatedMenuItem = new JMenuItem(Messages.getString("MainWindow.92"));
        markAllValidatedMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int l_res = JOptionPane.showConfirmDialog(null, Messages.getString("MainWindow.93"), Messages.getString("WINDOW_TITLE_WARNING"), 2);
                if (l_res != 0) {
                    return;
                }
                for (int i = 0; i < DisplayedAccount.getDisplayedAccount().getItemListSize(); ++i) {
                    AItem l_ai = DisplayedAccount.getDisplayedAccount().getItem(i);
                    if (l_ai.isUserValidated()) continue;
                    l_ai.setUserValidated(true, DisplayedAccount.getDisplayedAccount());
                }
                MainWindow.refreshTableViewPort();
            }
        });
        mnEditMenu.add(markAllValidatedMenuItem);
        markAllClearedMenuItem = new JMenuItem(Messages.getString("MainWindow.95"));
        markAllClearedMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int l_res = JOptionPane.showConfirmDialog(null, Messages.getString("MainWindow.96"), Messages.getString("WINDOW_TITLE_WARNING"), 2);
                if (l_res != 0) {
                    return;
                }
                for (int i = 0; i < DisplayedAccount.getDisplayedAccount().getItemListSize(); ++i) {
                    AItem l_ai = DisplayedAccount.getDisplayedAccount().getItem(i);
                    if (l_ai.isCleared()) continue;
                    l_ai.setCleared(true);
                }
                MainWindow.refreshTableViewPort();
            }
        });
        mnEditMenu.add(markAllClearedMenuItem);
        mnAccountsMenu = new JMenu(Messages.getString("MainWindow.98"));
        menuBar.add(mnAccountsMenu);
        mnReportsMenu = new JMenu(Messages.getString("MainWindow.192"));
        menuBar.add(mnReportsMenu);
        mntmMainExpensesAndIncomes = new JMenuItem(Messages.getString("MainWindow.193"));
        mntmMainExpensesAndIncomes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiUtil.displayBusyCursor();
                try {
                    if (DisplayedAccount.isThereAStackedAccount()) {
                        mntmClearSearch.doClick();
                    }
                    KeyboardMainListener.flush();
                    MenuManager.inReports();
                    contentPanel.removeAll();
                    contentPanel.add(reportsHtmlPanel);
                    reportsHtmlPanel.displayMainExpensesAndIncomes(HMProperties.getIntProperty("hmy.reports_days"));
                    contentPanel.validate();
                    contentPanel.repaint();
                }
                finally {
                    GuiUtil.displayNormalCursor();
                }
            }
        });
        mnReportsMenu.add(mntmMainExpensesAndIncomes);
        mnReportsMenu.addSeparator();
        mnReportsMenu.addSeparator();
        mn30DaysReportsMenu = new JCheckBoxMenuItem(Messages.getString("MainWindow.194"));
        mn30DaysReportsMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.setReportsDays(30);
            }
        });
        mnReportsMenu.add(mn30DaysReportsMenu);
        mn90DaysReportsMenu = new JCheckBoxMenuItem(Messages.getString("MainWindow.195"));
        mn90DaysReportsMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.setReportsDays(90);
            }
        });
        mnReportsMenu.add(mn90DaysReportsMenu);
        mn6MonthsReportsMenu = new JCheckBoxMenuItem(Messages.getString("MainWindow.196"));
        mn6MonthsReportsMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.setReportsDays(182);
            }
        });
        mnReportsMenu.add(mn6MonthsReportsMenu);
        mn1YearReportsMenu = new JCheckBoxMenuItem(Messages.getString("MainWindow.197"));
        mn1YearReportsMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.setReportsDays(365);
            }
        });
        mnReportsMenu.add(mn1YearReportsMenu);
        mn2YearsReportsMenu = new JCheckBoxMenuItem(Messages.getString("MainWindow.198"));
        mn2YearsReportsMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.setReportsDays(730);
            }
        });
        mnReportsMenu.add(mn2YearsReportsMenu);
        mn5YearsReportsMenu = new JCheckBoxMenuItem(Messages.getString("MainWindow.199"));
        mn5YearsReportsMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.setReportsDays(1826);
            }
        });
        mnReportsMenu.add(mn5YearsReportsMenu);
        mn10YearsReportsMenu = new JCheckBoxMenuItem(Messages.getString("MainWindow.200"));
        mn10YearsReportsMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.setReportsDays(3652);
            }
        });
        mnReportsMenu.add(mn10YearsReportsMenu);
        mnBillsGraphAccountsMenu = new JMenu(Messages.getString("MainWindow.99"));
        menuBar.add(mnBillsGraphAccountsMenu);
        mntmPlannedItems = new JMenuItem(Messages.getString("MainWindow.100"));
        mntmPlannedItems.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiUtil.displayBusyCursor();
                try {
                    MenuManager.inBills();
                    contentPanel.removeAll();
                    contentPanel.add(plannedItemsMainPanel);
                    KeyboardMainListener.flush();
                    KeyboardMainListener.addCurrentListener(aPlannedItemTable);
                    contentPanel.validate();
                    contentPanel.repaint();
                    plannedItemsMainPanel.updateGraph();
                }
                finally {
                    GuiUtil.displayNormalCursor();
                }
            }
        });
        mnBillsGraphAccountsMenu.add(mntmPlannedItems);
        mnBillsGraphAccountsMenu.addSeparator();
        mnBillsGraphAccountsMenu.addSeparator();
        mn30DaysGraphMenu = new JCheckBoxMenuItem(Messages.getString("MainWindow.101"));
        mn30DaysGraphMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.setGraphDays(30);
            }
        });
        mnBillsGraphAccountsMenu.add(mn30DaysGraphMenu);
        mn90DaysGraphMenu = new JCheckBoxMenuItem(Messages.getString("MainWindow.102"));
        mn90DaysGraphMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.setGraphDays(90);
            }
        });
        mnBillsGraphAccountsMenu.add(mn90DaysGraphMenu);
        mn6MonthsGraphMenu = new JCheckBoxMenuItem(Messages.getString("MainWindow.103"));
        mn6MonthsGraphMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.setGraphDays(182);
            }
        });
        mnBillsGraphAccountsMenu.add(mn6MonthsGraphMenu);
        mn1YearGraphMenu = new JCheckBoxMenuItem(Messages.getString("MainWindow.104"));
        mn1YearGraphMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.setGraphDays(365);
            }
        });
        mnBillsGraphAccountsMenu.add(mn1YearGraphMenu);
        mnBillsGraphAccountsMenu.addSeparator();
        mnBillsGraphAccountsMenu.addSeparator();
        mnBillsGraphAccountsMenuAccountsIndexGap = 9;
        mnOptionsMenu = new JMenu(Messages.getString("MainWindow.105"));
        menuBar.add(mnOptionsMenu);
        selectStateLocationMenu = new JMenu(Messages.getString("MainWindow.106"));
        mnOptionsMenu.add(selectStateLocationMenu);
        MainWindow.updateSaveLocationMenu();
        JMenu selectLanguageMenu = new JMenu(Messages.getString("MainWindow.107"));
        mnOptionsMenu.add(selectLanguageMenu);
        final JCheckBoxMenuItem setEncryptionCheckboxMenuItem = new JCheckBoxMenuItem(Messages.getString("MainWindow.201"));
        mnOptionsMenu.add(setEncryptionCheckboxMenuItem);
        setEncryptionCheckboxMenuItem.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (HMProperties.getStringProperty("hmy.encrypt_files") != null && HMProperties.getStringProperty("hmy.encrypt_files").equals("true")) {
                        int l_res = JOptionPane.showConfirmDialog(null, Messages.getString("MainWindow.204"), "", 2);
                        if (l_res != 0) {
                            return;
                        }
                        encryptionPassword = null;
                        HMProperties.putProperty("hmy.encrypt_files", "false");
                        MainWindow.this.save(true);
                    } else {
                        int l_res = JOptionPane.showConfirmDialog(null, Messages.getString("MainWindow.206"), "", 2);
                        if (l_res != 0) {
                            return;
                        }
                        NewPasswordInputDialog l_dlg = new NewPasswordInputDialog(MainWindow.getFrame());
                        l_dlg.setVisible(true);
                        if (l_dlg.newPassword != null) {
                            encryptionPassword = l_dlg.newPassword;
                            HMProperties.putProperty("hmy.encrypt_files", "true");
                            MainWindow.this.save(true);
                        }
                    }
                }
                finally {
                    if (HMProperties.getStringProperty("hmy.encrypt_files") != null && HMProperties.getStringProperty("hmy.encrypt_files").equals("true")) {
                        setEncryptionCheckboxMenuItem.setSelected(true);
                    } else {
                        setEncryptionCheckboxMenuItem.setSelected(false);
                    }
                }
            }
        });
        if (HMProperties.getStringProperty("hmy.encrypt_files") != null && HMProperties.getStringProperty("hmy.encrypt_files").equals("true")) {
            setEncryptionCheckboxMenuItem.setSelected(true);
        }
        for (int i = 0; i < Messages.languages_codes.length; ++i) {
            JCheckBoxMenuItem languageMenuItem = new JCheckBoxMenuItem(Messages.languages[i] + " - " + Messages.languages_codes[i]);
            final String l_langCode = Messages.languages_codes[i];
            languageMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainWindow.this.setLanguage(l_langCode);
                }
            });
            selectLanguageMenu.add(languageMenuItem);
            if (HMProperties.getStringProperty("hmy.locale") == null || !HMProperties.getStringProperty("hmy.locale").equals(l_langCode)) continue;
            languageMenuItem.setSelected(true);
        }
        JMenu selectLaFMenu = new JMenu(Messages.getString("MainWindow.108"));
        String l_lafName = HMProperties.getStringProperty("frame.laf");
        if (l_lafName == null) {
            l_lafName = "Nimbus";
        }
        mnOptionsMenu.add(selectLaFMenu);
        ButtonGroup lafGroup = new ButtonGroup();
        String l_experimentalWarning = " (experimental)";
        for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
            String l_label = info.getName();
            if (!l_label.equals("Nimbus")) {
                l_label = l_label + " (experimental)";
            }
            JRadioButtonMenuItem mniLaf = new JRadioButtonMenuItem(l_label);
            lafGroup.add(mniLaf);
            selectLaFMenu.add(mniLaf);
            if (info.getName().equals(l_lafName)) {
                mniLaf.setSelected(true);
            }
            mniLaf.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String l_lafLabel = e.getActionCommand();
                    int l_expe = l_lafLabel.indexOf(" (experimental)");
                    if (l_expe > 0) {
                        l_lafLabel = l_lafLabel.substring(0, l_expe);
                    }
                    Logger.info(TAG, "Setting Look and Feel to '" + l_lafLabel);
                    try {
                        System.out.println("Setting LaF to " + l_lafLabel);
                        for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                            if (!l_lafLabel.equals(info.getName())) continue;
                            UIManager.setLookAndFeel(info.getClassName());
                        }
                        SwingUtilities.updateComponentTreeUI(frame);
                        HMProperties.putProperty("frame.laf", l_lafLabel);
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
                        Logger.error(TAG, "Setting Look and Feel to '" + l_lafLabel + "': " + ex);
                    }
                }
            });
        }
        mnOptionsMenu.addSeparator();
        JMenuItem webSiteMenuItem = new JMenuItem(Messages.getString("MainWindow.117"));
        webSiteMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (!Desktop.isDesktopSupported()) {
                        throw new Exception("Unsupported desktop");
                    }
                    Desktop.getDesktop().browse(new URI("http://moneyview.me/proghit"));
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, Messages.getString("MainWindow.120") + ex);
                }
            }
        });
        mnOptionsMenu.add(webSiteMenuItem);
        aboutMenuItem = new JMenuItem(Messages.getString("MainWindow.121"));
        aboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(null, Messages.getString("MainWindow.122") + 2 + "." + 4 + "." + 0 + " build " + "202102212259" + Messages.getString("MainWindow.125") + System.getProperty("java.vendor") + " " + System.getProperty("java.version") + Messages.getString("MainWindow.129") + System.getProperty("java.home") + "</font>" + Messages.getString("MainWindow.132") + Messages.getString("MainWindow.146") + Messages.getString("MainWindow.133") + Messages.getString("MainWindow.134") + Messages.getString("MainWindow.135") + Messages.getString("MainWindow.136") + Messages.getString("MainWindow.137") + Messages.getString("MainWindow.138") + Messages.getString("MainWindow.139") + Messages.getString("MainWindow.140") + Messages.getString("MainWindow.141") + Messages.getString("MainWindow.142") + Messages.getString("MainWindow.143") + Messages.getString("MainWindow.144") + Messages.getString("MainWindow.145") + "</html>", Messages.getString("MainWindow.121"), 1, GuiUtil.getImageIcon("hmicon.png"));
            }
        });
        mnOptionsMenu.add(aboutMenuItem);
        SwingUtilities.invokeLater(new Thread(){

            @Override
            public void run() {
                String l_accountFiles = HMProperties.getStringProperty("hmy.account_files");
                if (l_accountFiles != null && l_accountFiles.length() > 0) {
                    StringTokenizer l_st = new StringTokenizer(l_accountFiles, ",");
                    block4: while (true) {
                        try {
                            while (l_st.hasMoreTokens()) {
                                String l_fn = null;
                                try {
                                    l_fn = l_st.nextToken().trim();
                                    MainWindow.this.addAccount(false, l_fn, null, null, null);
                                    continue block4;
                                }
                                catch (Exception e) {
                                    Logger.error(TAG, "SwingUtilities.invokeLater.run(): addAccount('" + l_fn + "'): " + e);
                                    e.printStackTrace(System.err);
                                }
                            }
                            break;
                        }
                        catch (Exception e) {
                            JOptionPane.showMessageDialog(null, "ERROR: " + e);
                            break;
                        }
                    }
                    APlannedItem.loadItems(encryptionPassword);
                }
                MenuManager.inHomePage();
                summaryHtmlPanel.displayAccounts();
                MainWindow.setGraphDays(APlannedItem.getGraphDays());
                MainWindow.setReportsDays(HMProperties.getIntProperty("hmy.reports_days"));
                MainWindow.getFrame().toFront();
                MainWindow.getFrame().repaint();
            }
        });
        MainWindow.adjustColumnWidth();
        this.initDragAndDrop();
        GuiUtil.displayNormalCursor();
    }

    private void setLanguage(String newLocale) {
        Messages.saveLocaleSetting(newLocale);
        JOptionPane.showMessageDialog(null, Messages.getString("MainWindow.149"));
    }

    private void addAccount(boolean newAccount, String accountName, String accountType, String initialAmount, String openingDate) throws Exception {
        Logger.debug(TAG, "addAccount (" + newAccount + ", " + accountName + ", " + accountType + ", " + initialAmount + ")");
        Account l_a = new Account(!newAccount);
        if (newAccount) {
            l_a.accountType = accountType;
            l_a.accountName = accountName;
            AItem l_ai = new AItem(Util.parseAmount(initialAmount));
            l_ai.setMemo(Messages.getString("MainWindow.155"));
            l_ai.setDate(new Date());
            if (openingDate != null) {
                l_ai.setDate(Util.parseDate(openingDate, Util.getDateDayFirst()));
            }
            l_a.addItem(l_ai);
        } else if (HMProperties.getStringProperty("hmy.encrypt_files") != null && HMProperties.getStringProperty("hmy.encrypt_files").equals("true")) {
            if (encryptionPassword == null) {
                int l_try;
                for (l_try = 0; l_try < 3; ++l_try) {
                    PasswordInputDialog l_pwdInputDlg = new PasswordInputDialog(MainWindow.getFrame());
                    l_pwdInputDlg.setVisible(true);
                    encryptionPassword = l_pwdInputDlg.password;
                    if (encryptionPassword == null) continue;
                    try {
                        l_a.loadFile(accountName, encryptionPassword);
                        break;
                    }
                    catch (Exception e) {
                        Logger.error(TAG, "Loading account file '" + accountName + "': " + e);
                        encryptionPassword = null;
                        continue;
                    }
                }
                if (l_try >= 3) {
                    JOptionPane.showMessageDialog(MainWindow.getFrame(), Messages.getString("MainWindow.205"), Messages.getString("WINDOW_TITLE_ERROR"), 2);
                    System.exit(10);
                }
            } else {
                try {
                    l_a.loadFile(accountName, encryptionPassword);
                }
                catch (Exception e) {
                    Logger.error(TAG, "Loading(2) account file '" + accountName + "': " + e);
                }
            }
        } else {
            l_a.loadFile(accountName, null);
        }
        l_a.calculateBalance();
        Logger.debug(TAG, " Adding account '" + l_a.accountName + "'");
        Account.openAccounts.add(l_a);
        if (newAccount) {
            l_a.save(encryptionPassword);
        }
        HMProperties.updateAccountList();
        JMenuItem mntmAccount = new JMenuItem(accountName, new ImageIcon(GuiUtil.getAccountImageIcon(l_a.accountType).getImage().getScaledInstance(32, 32, 4)));
        accountMenuItems.add(mntmAccount);
        mntmAccount.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMenuItem l_source = (JMenuItem)e.getSource();
                String l_accountName = l_source.getText();
                MainWindow.this.displayAccount(l_accountName);
            }
        });
        mnAccountsMenu.add(mntmAccount);
        mnAccountsMenu.addSeparator();
        JCheckBoxMenuItem mntmGraphBillsForAccount = new JCheckBoxMenuItem(accountName);
        mntmGraphBillsForAccount.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMenuItem l_source = (JMenuItem)e.getSource();
                String l_accountName = l_source.getText();
                Logger.info(TAG, " Changing graph option for account '" + l_accountName + "'");
                Account l_a = Account.getAccountByName(l_accountName);
                l_a.setGraphBills(!l_a.isGraphBills());
                if (l_a.isGraphBills()) {
                    l_source.setForeground(Constants.getColor("colorMenuItemSelected"));
                } else {
                    l_source.setForeground(Constants.getColor("colorMenuItemUnselected"));
                }
                plannedItemsMainPanel.updateGraph();
            }
        });
        if (l_a.isGraphBills()) {
            mntmGraphBillsForAccount.setSelected(true);
            mntmGraphBillsForAccount.setForeground(Constants.getColor("colorMenuItemSelected"));
        } else {
            mntmGraphBillsForAccount.setForeground(Constants.getColor("colorMenuItemUnselected"));
        }
        mnBillsGraphAccountsMenu.add(mntmGraphBillsForAccount);
        JMenuItem mntmAccountProperties = new JMenuItem(accountName, new ImageIcon(GuiUtil.getAccountImageIcon(l_a.accountType).getImage().getScaledInstance(32, 32, 4)));
        mnAccountPropertiesMenu.add(mntmAccountProperties);
        mntmAccountProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMenuItem l_source = (JMenuItem)e.getSource();
                String l_accountName = l_source.getText();
                Logger.info(TAG, " Properties dialog for account '" + l_accountName + "'");
                Account l_a = Account.getAccountByName(l_accountName);
                AccountDialog l_naDlg = new AccountDialog((Frame)frame, Messages.getString("MainWindow.164") + l_a.accountName, l_a);
                l_naDlg.setVisible(true);
            }
        });
        if (newAccount) {
            mntmAccount.doClick();
        }
    }

    public void displayAccount(String account) {
        GuiUtil.displayBusyCursor();
        contentPanel.removeAll();
        contentPanel.add(itemsMainPanel);
        KeyboardMainListener.flush();
        KeyboardMainListener.addCurrentListener(aItemTable);
        contentPanel.repaint();
        Logger.info(TAG, " Displaying account '" + account + "'");
        Account l_a = Account.getAccountByName(account);
        DisplayedAccount.setDisplayedAccount(l_a);
        aItemTable.setModel(aItemTable.getNewCustomTableModel());
        DisplayedAccount.getDisplayedAccount().calculateBalance();
        aItemTable.clickOnColumnHeader(2, DisplayedAccount.getDisplayedAccount(), false);
        aItemTable.setColWidth(aItemTable.getWidth());
        MainWindow.itemsMainPanel.accountLabel.setText("  " + DisplayedAccount.getDisplayedAccount().accountName);
        MainWindow.itemsMainPanel.accountLabel.setIcon(new ImageIcon(GuiUtil.getAccountImageIcon(DisplayedAccount.getDisplayedAccount().accountType).getImage().getScaledInstance(32, 32, 4)));
        contentPanel.validate();
        contentPanel.repaint();
        MenuManager.inAccount(DisplayedAccount.getDisplayedAccount().accountName);
        itemsMainPanel.updateGraph(null);
        SwingUtilities.invokeLater(new Thread(){

            @Override
            public void run() {
                aItemTable.scrollRectToVisible(aItemTable.getCellRect(DisplayedAccount.getDisplayedAccount().getItemListSize() > 0 ? DisplayedAccount.getDisplayedAccount().getItemListSize() - 1 : 0, 0, true));
            }
        });
        GuiUtil.displayNormalCursor();
    }

    private void save(boolean forceSave) {
        GuiUtil.displayBusyCursor();
        try {
            Util.saveAll(forceSave);
        }
        catch (Exception e) {
            Logger.error(TAG, "save: " + e.toString());
            e.printStackTrace();
        }
        GuiUtil.displayNormalCursor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importFile(boolean qifImport, String fileName, boolean invertDayAndMonthDateReadFormat, boolean isMoneyMigration) {
        GuiUtil.displayBusyCursor();
        List<AItem> l_importedItems = null;
        boolean dateDayFirst = Util.getDateDayFirst();
        String l_ofxAccountID = null;
        if (invertDayAndMonthDateReadFormat) {
            dateDayFirst = !dateDayFirst;
        }
        try {
            if (qifImport) {
                try {
                    l_importedItems = new QifImportExport().loadFile(fileName, dateDayFirst, isMoneyMigration);
                }
                catch (DayAndMonthInvertedException damie) {
                    Logger.warn(TAG, "loadFile: " + damie.toString());
                    try {
                        l_importedItems = new QifImportExport().loadFile(fileName, !dateDayFirst, isMoneyMigration);
                    }
                    catch (Exception e) {
                        Logger.error(TAG, "loadFile: " + e.toString());
                        e.printStackTrace(System.err);
                    }
                }
            } else {
                try {
                    OfxSaxImporter l_ofxSaxImporter = new OfxSaxImporter();
                    l_importedItems = l_ofxSaxImporter.loadFile(fileName);
                    l_ofxAccountID = l_ofxSaxImporter.accountId;
                }
                catch (Exception e) {
                    Logger.error(TAG, "loadFile: " + e.toString());
                    try {
                        OfxImport l_ofxImport = new OfxImport();
                        l_importedItems = l_ofxImport.loadFile(fileName);
                        l_ofxAccountID = l_ofxImport.accountId;
                    }
                    catch (Exception e2) {
                        Logger.error(TAG, "loadFile: " + e.toString() + " , then " + e2.toString());
                        e2.printStackTrace(System.err);
                    }
                }
            }
            Logger.debug(TAG, "loadFile: Imported operations count=" + l_importedItems.size());
            if (l_importedItems.size() < 1) {
                return;
            }
            String l_importAccountName = MainWindow.chooseImportAccount(l_ofxAccountID);
            if (l_importAccountName == null) {
                return;
            }
            Account l_importAccount = Account.getAccountByName(l_importAccountName);
            ArrayList<AItem> l_removeAIList = new ArrayList<AItem>();
            for (int i = 0; i < l_importedItems.size(); ++i) {
                l_importedItems.get(i).setNewlyImported(true);
                AItem l_dup = l_importAccount.findDup(l_importedItems.get(i));
                if (l_dup == null) continue;
                l_dup.setDup(l_importedItems.get(i));
                l_removeAIList.add(l_importedItems.get(i));
            }
            for (AItem l_ai : l_removeAIList) {
                l_importedItems.remove(l_ai);
            }
            l_importAccount.addOperations(l_importedItems);
            if (!isMoneyMigration) {
                l_importAccount.guessCategoryForImportedItems();
            }
            l_importAccount.ofxAccountID = l_ofxAccountID;
            l_importAccount.calculateBalance();
            aItemTable.setModel(aItemTable.getNewCustomTableModel());
            if (DisplayedAccount.getDisplayedAccount() != null) {
                aItemTable.clickOnColumnHeader(2, DisplayedAccount.getDisplayedAccount(), false);
            }
            if (summaryHtmlPanel.isShowing()) {
                summaryHtmlPanel.displayAccounts();
            }
            this.displayAccount(l_importAccountName);
        }
        catch (Exception e) {
            Logger.error(TAG, "loadFile: " + e.toString());
            JOptionPane.showMessageDialog(MainWindow.getFrame(), Messages.getString("MainWindow.172") + e.getMessage(), Messages.getString("WINDOW_TITLE_ERROR"), 2);
        }
        finally {
            GuiUtil.displayNormalCursor();
        }
    }

    private static void refreshTableViewPort() {
        aItemTable.setVisible(false);
        aItemTable.setVisible(true);
        aItemTable.setFont(new Font("Serif", 1, 20));
    }

    public static void adjustColumnWidth() {
        if (System.currentTimeMillis() < lastAdjustColumnWidthTS + 20000L) {
            return;
        }
        lastAdjustColumnWidthTS = System.currentTimeMillis();
        SwingUtilities.invokeLater(new Thread(){

            @Override
            public void run() {
                aItemTable.setColWidth(aItemTable.getWidth());
            }
        });
    }

    public static void setGraphDays(int days) {
        mn30DaysGraphMenu.setSelected(false);
        mn30DaysGraphMenu.setForeground(Constants.getColor("colorMenuItemUnselected"));
        mn90DaysGraphMenu.setSelected(false);
        mn90DaysGraphMenu.setForeground(Constants.getColor("colorMenuItemUnselected"));
        mn6MonthsGraphMenu.setSelected(false);
        mn6MonthsGraphMenu.setForeground(Constants.getColor("colorMenuItemUnselected"));
        mn1YearGraphMenu.setSelected(false);
        mn1YearGraphMenu.setForeground(Constants.getColor("colorMenuItemUnselected"));
        switch (days) {
            case 30: {
                mn30DaysGraphMenu.setSelected(true);
                mn30DaysGraphMenu.setForeground(Constants.getColor("colorMenuItemSelected"));
                break;
            }
            case 90: {
                mn90DaysGraphMenu.setSelected(true);
                mn90DaysGraphMenu.setForeground(Constants.getColor("colorMenuItemSelected"));
                break;
            }
            case 182: {
                mn6MonthsGraphMenu.setSelected(true);
                mn6MonthsGraphMenu.setForeground(Constants.getColor("colorMenuItemSelected"));
                break;
            }
            case 365: {
                mn1YearGraphMenu.setSelected(true);
                mn1YearGraphMenu.setForeground(Constants.getColor("colorMenuItemSelected"));
            }
        }
        APlannedItem.setGraphDays(days);
        plannedItemsMainPanel.updateGraph();
    }

    public static void setReportsDays(int days) {
        int l_days = days;
        if (l_days == 0) {
            l_days = 90;
        }
        mn30DaysReportsMenu.setSelected(false);
        mn30DaysReportsMenu.setForeground(Constants.getColor("colorMenuItemUnselected"));
        mn90DaysReportsMenu.setSelected(false);
        mn90DaysReportsMenu.setForeground(Constants.getColor("colorMenuItemUnselected"));
        mn6MonthsReportsMenu.setSelected(false);
        mn6MonthsReportsMenu.setForeground(Constants.getColor("colorMenuItemUnselected"));
        mn1YearReportsMenu.setSelected(false);
        mn1YearReportsMenu.setForeground(Constants.getColor("colorMenuItemUnselected"));
        mn2YearsReportsMenu.setSelected(false);
        mn2YearsReportsMenu.setForeground(Constants.getColor("colorMenuItemUnselected"));
        mn5YearsReportsMenu.setSelected(false);
        mn5YearsReportsMenu.setForeground(Constants.getColor("colorMenuItemUnselected"));
        mn10YearsReportsMenu.setSelected(false);
        mn10YearsReportsMenu.setForeground(Constants.getColor("colorMenuItemUnselected"));
        switch (l_days) {
            case 30: {
                mn30DaysReportsMenu.setSelected(true);
                mn30DaysReportsMenu.setForeground(Constants.getColor("colorMenuItemSelected"));
                break;
            }
            case 90: {
                mn90DaysReportsMenu.setSelected(true);
                mn90DaysReportsMenu.setForeground(Constants.getColor("colorMenuItemSelected"));
                break;
            }
            case 182: {
                mn6MonthsReportsMenu.setSelected(true);
                mn6MonthsReportsMenu.setForeground(Constants.getColor("colorMenuItemSelected"));
                break;
            }
            case 365: {
                mn1YearReportsMenu.setSelected(true);
                mn1YearReportsMenu.setForeground(Constants.getColor("colorMenuItemSelected"));
                break;
            }
            case 730: {
                mn2YearsReportsMenu.setSelected(true);
                mn2YearsReportsMenu.setForeground(Constants.getColor("colorMenuItemSelected"));
                break;
            }
            case 1826: {
                mn5YearsReportsMenu.setSelected(true);
                mn5YearsReportsMenu.setForeground(Constants.getColor("colorMenuItemSelected"));
                break;
            }
            case 3652: {
                mn10YearsReportsMenu.setSelected(true);
                mn10YearsReportsMenu.setForeground(Constants.getColor("colorMenuItemSelected"));
            }
        }
        HMProperties.putProperty("hmy.reports_days", l_days);
        if (reportsHtmlPanel.isShowing()) {
            mntmMainExpensesAndIncomes.doClick();
        }
    }

    public static void searchOperations(String searchString, int searchType) {
        Account l_resAccount = new Account("searchResults", false);
        l_resAccount.addOperations(DisplayedAccount.getDisplayedAccount().searchOperations(searchString, searchType));
        DisplayedAccount.pushAccount(l_resAccount, mntmSearchSimple);
        MainWindow.refreshTableViewPort();
    }

    public static void updateSaveLocationMenu() {
        selectStateLocationMenu.removeAll();
        JMenuItem changeStateLocationMenuItem = new JMenuItem(Messages.getString("MainWindow.176"));
        JMenuItem deleteLocationHistoryMenuItem = new JMenuItem(Messages.getString("MainWindow.178"));
        selectStateLocationMenu.add(changeStateLocationMenuItem);
        selectStateLocationMenu.add(deleteLocationHistoryMenuItem);
        selectStateLocationMenu.addSeparator();
        changeStateLocationMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser l_jfc = new JFileChooser();
                l_jfc.setFileSelectionMode(1);
                l_jfc.setCurrentDirectory(new File(HMProperties.getOpenDirLocation()));
                int l_jfRes = l_jfc.showDialog(frame, Messages.getString("MainWindow.177"));
                if (l_jfRes == 0) {
                    File l_file = l_jfc.getSelectedFile();
                    String l_sfilename = l_file.getPath();
                    HMProperties.setOpenDirLocation(l_sfilename);
                    MainWindow.updateSaveLocationAndExit(l_sfilename);
                }
            }
        });
        deleteLocationHistoryMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HMProperties.deleteSaveLocationHistory();
                Util.saveAll(false);
                MainWindow.updateSaveLocationMenu();
            }
        });
        for (String l_dir : HMProperties.getSaveLocationHistory()) {
            historyStateLocationMenuItem = new JCheckBoxMenuItem(l_dir);
            selectStateLocationMenu.add(historyStateLocationMenuItem);
            if (l_dir != null && l_dir.equals(HMProperties.getSaveLocation())) {
                historyStateLocationMenuItem.setSelected(true);
                historyStateLocationMenuItem.setForeground(Color.getColor("colorMenuItemSelected"));
            }
            historyStateLocationMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JMenuItem l_source = (JMenuItem)e.getSource();
                    String l_dirName = l_source.getText();
                    MainWindow.updateSaveLocationAndExit(l_dirName);
                }
            });
        }
    }

    public static void updateSaveLocationAndExit(String saveDir) {
        Logger.debug(TAG, "updateSaveLocationAndExit: chosen dir is: " + saveDir);
        Util.saveAll(false);
        HMProperties.setSaveLocation(saveDir);
        MainWindow.updateSaveLocationMenu();
        JOptionPane.showMessageDialog(MainWindow.getFrame(), Messages.getString("MainWindow.179") + Messages.getString("MainWindow.180") + "<br><center>" + saveDir + "</center></html>", Messages.getString("MainWindow.183"), 2);
        MainWindow.getFrame().dispose();
    }

    private static String chooseImportAccount(String ofxAccountID) {
        Object[] l_choiceValues = new String[Account.openAccounts.size()];
        int i1 = 0;
        int l_ofxAccountIndex = 0;
        for (Account l_a : Account.openAccounts) {
            if (l_a.ofxAccountID != null && l_a.ofxAccountID.equals(ofxAccountID)) {
                l_ofxAccountIndex = i1;
            }
            l_choiceValues[i1++] = l_a.accountName;
        }
        String l_importAccount = (String)JOptionPane.showInputDialog(null, Messages.getString("MainWindow.26"), Messages.getString("WINDOW_TITLE_SELECT"), 3, null, l_choiceValues, l_choiceValues[l_ofxAccountIndex]);
        if (l_importAccount == null) {
            JOptionPane.showMessageDialog(null, Messages.getString("MainWindow.28"), Messages.getString("WINDOW_TITLE_INFO"), 1, null);
        }
        return l_importAccount;
    }

    private void initDragAndDrop() {
        frame.setDropTarget(new DropTarget(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized void drop(DropTargetDropEvent dtde) {
                try {
                    Transferable l_transfer = dtde.getTransferable();
                    if (l_transfer.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                        dtde.acceptDrop(3);
                        List objects = (List)l_transfer.getTransferData(DataFlavor.javaFileListFlavor);
                        for (Object object : objects) {
                            if (!(object instanceof File)) continue;
                            File source = (File)object;
                            String l_absFileName = source.getAbsolutePath().toLowerCase();
                            if (l_absFileName.endsWith(".ofx")) {
                                MainWindow.this.importFile(false, source.getPath(), false, false);
                                continue;
                            }
                            if (l_absFileName.endsWith(".qif")) {
                                MainWindow.this.importFile(true, source.getPath(), false, false);
                                continue;
                            }
                            JOptionPane.showMessageDialog(null, Messages.getString("MainWindow.191"), Messages.getString("WINDOW_TITLE_INFO"), 1, null);
                        }
                    } else {
                        JOptionPane.showMessageDialog(null, Messages.getString("MainWindow.190"), Messages.getString("WINDOW_TITLE_INFO"), 1, null);
                    }
                }
                catch (Exception ex) {
                    Logger.error(TAG, "drop: " + ex.getMessage());
                }
                finally {
                    dtde.dropComplete(true);
                }
            }
        });
    }

    static {
        summaryHtmlPanel = null;
        reportsHtmlPanel = null;
        plannedItemsMainPanel = null;
        encryptionPassword = null;
        tableHeaderFont = new Font("Sans Serif", 1, 14);
        accountMenuItems = new ArrayList<JMenuItem>();
        mnBillsGraphAccountsMenuAccountsIndexGap = -100;
        lastAdjustColumnWidthTS = 0L;
    }
}

